/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.preferences.gui;

import de.uni_paderborn.lib.classloader.UPBClassLoader;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ServerListParser
extends DefaultHandler {
    private static final transient Logger log;
    private static final String PLUGIN_SERVER_SYSTEM_ID = "http://www.upb.de/cs/fujaba/DTDs/PluginServer.dtd";
    private static final String PLUGIN_SERVER_SYSTEM_ID2 = "http://www.fujaba.de/DTDs/PluginServer.dtd";
    private static final String PLUGIN_SERVER_PUBLIC_ID = "-//Fujaba//Fujaba Plugin Definition//EN//1.0";
    private static final String PLUGIN_SERVER_DTD_RESOURCE = "DTDs/PluginServer.dtd";
    private static URL pluginServerDTD;
    private static final String PLUGIN_SERVER = "PluginServer";
    private static final String SERVER_URL = "URL";
    private static final int S_NONE = 0;
    private static final int S_PLUGIN_SERVER = 1;
    private static final int S_URL = 2;
    private int state = 0;
    private Vector urlVector = new Vector();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.preferences.gui.ServerListParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public Iterator getURLs(URL xmlURL) {
        if (this.parseXML(xmlURL)) {
            return this.urlVector.iterator();
        }
        return null;
    }

    public boolean parseXML(URL xmlURL) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            XMLReader xmlReader = factory.newSAXParser().getXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.setErrorHandler(this);
            xmlReader.setEntityResolver(this);
            if (xmlURL != null) {
                xmlReader.parse(new InputSource(xmlURL.openStream()));
            }
            return true;
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (PLUGIN_SERVER_PUBLIC_ID.equals(publicId) || PLUGIN_SERVER_SYSTEM_ID.equals(systemId) || PLUGIN_SERVER_SYSTEM_ID2.equals(systemId)) {
            if (pluginServerDTD == null) {
                pluginServerDTD = UPBClassLoader.get().getResource(PLUGIN_SERVER_DTD_RESOURCE);
            }
            if (pluginServerDTD != null) {
                try {
                    return new InputSource(pluginServerDTD.openStream());
                }
                catch (Exception e) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Could not solve SYSTEM or PUBLIC reference for DTD.");
                    }
                    throw new SAXException(e);
                }
            }
        }
        try {
            return super.resolveEntity(publicId, systemId);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void startElement(String uri, String name, String qName) {
        try {
            if (qName.equals(PLUGIN_SERVER)) {
                this.state = 1;
            } else if (qName.equals(SERVER_URL)) {
                this.state = 2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void characters(char[] ch, int start, int length) {
        String data = new String(ch, start, length);
        this.urlVector.add(data);
    }

    public void endElement(String uri, String name, String qName) {
        switch (this.state) {
            case 1: {
                this.state = 0;
                break;
            }
            default: {
                this.state = 0;
            }
        }
    }
}

