/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.sequencer;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.sequencer.FlowActivity;
import de.uni_paderborn.fujaba.sequencer.Rep;
import de.uni_paderborn.fujaba.sequencer.SDMParseException;
import de.uni_paderborn.fujaba.sequencer.Sel;
import de.uni_paderborn.fujaba.sequencer.Seq;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLNopActivity;
import de.uni_paderborn.fujaba.uml.UMLStopActivity;
import de.uni_paderborn.fujaba.uml.UMLTransition;
import de.uni_paderborn.fujaba.uml.UMLTransitionGuard;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.fca.FLinkedList;
import java.util.Iterator;
import java.util.ListIterator;

public class Sequencer {
    private static Sequencer theSequencer = null;
    static int level;
    static int time;

    private Sequencer() {
    }

    public static Sequencer get() {
        if (theSequencer == null) {
            theSequencer = new Sequencer();
        }
        return theSequencer;
    }

    public final Seq exploreCFG(FlowActivity startFlowActivity) {
        time = 1;
        this.dfs(startFlowActivity);
        level = 1;
        startFlowActivity.setLevel(level);
        ++level;
        FLinkedList transitionList = new FLinkedList();
        this.checkForEachStructure(startFlowActivity, transitionList);
        this.buildForEachStructure(transitionList);
        Seq seq = new Seq();
        this.explore(seq, startFlowActivity, null);
        return seq;
    }

    private final void buildForEachStructure(FLinkedList transitionList) {
        Iterator transitionsIter = transitionList.iterator();
        while (transitionsIter.hasNext()) {
            UMLTransition currentTransition = (UMLTransition)transitionsIter.next();
            currentTransition.setIsMarked(true);
            Seq seq = new Seq();
            this.explore(seq, currentTransition.getRevEntry().getFlowActivity(), currentTransition.getRevExit().getFlowActivity());
            seq.removeLastFlowActivity(currentTransition.getRevExit().getFlowActivity());
            currentTransition.getRevExit().getFlowActivity().setForEachSeq(seq);
        }
    }

    private final void checkForEachStructure(FlowActivity flowActivity, FLinkedList transitionList) {
        boolean hasEverytimesTransition = false;
        boolean hasTerminationTransition = false;
        boolean hasOtherTransitions = false;
        Iterator iter = flowActivity.getUMLActivity().iteratorOfExit();
        block4: while (iter.hasNext()) {
            UMLTransition currentUMLTransition = (UMLTransition)iter.next();
            FlowActivity nextFlowActivity = currentUMLTransition.getRevEntry().getFlowActivity();
            switch (UMLTransitionGuard.getGuardType(currentUMLTransition)) {
                case 3: {
                    if (hasEverytimesTransition) {
                        throw new SDMParseException("Activity has more than one 'each time' transition.", (FElement)currentUMLTransition);
                    }
                    hasEverytimesTransition = true;
                    if (nextFlowActivity.getLevel() != 0) {
                        throw new SDMParseException("'for each' structure error", (FElement)currentUMLTransition);
                    }
                    nextFlowActivity.setLevel(level);
                    ++level;
                    transitionList.add(currentUMLTransition);
                    this.checkForEachStructure(nextFlowActivity, transitionList);
                    break;
                }
                case 4: {
                    if (hasTerminationTransition) {
                        throw new SDMParseException("Story activity has more than one 'end' transition.", (FElement)currentUMLTransition);
                    }
                    hasTerminationTransition = true;
                }
                default: {
                    if (UMLTransitionGuard.getGuardType(currentUMLTransition) != 4) {
                        hasOtherTransitions = true;
                    }
                    if (nextFlowActivity.getLevel() == 0) {
                        nextFlowActivity.setLevel(flowActivity.getLevel());
                        this.checkForEachStructure(nextFlowActivity, transitionList);
                        break;
                    }
                    if (nextFlowActivity.getLevel() == flowActivity.getLevel()) continue block4;
                    Iterator iterExit = nextFlowActivity.getUMLActivity().iteratorOfExit();
                    FlowActivity tmpFlowActivity = null;
                    while (iterExit.hasNext() && tmpFlowActivity == null) {
                        UMLTransition tmpUMLTransition = (UMLTransition)iterExit.next();
                        if (UMLTransitionGuard.getGuardType(tmpUMLTransition) != 3) continue;
                        tmpFlowActivity = tmpUMLTransition.getRevEntry().getFlowActivity();
                    }
                    if (tmpFlowActivity != null) {
                        currentUMLTransition.setIsForwardEdge(true);
                        if (tmpFlowActivity.getLevel() == flowActivity.getLevel()) continue block4;
                        throw new SDMParseException("'for each' structure error: This transition can't end here.", (FElement)currentUMLTransition);
                    }
                    throw new SDMParseException("'for each' structure error: The 'for each' flow is not independent.", (FElement)currentUMLTransition);
                }
            }
        }
        if (flowActivity.isForEach()) {
            if (hasOtherTransitions) {
                throw new SDMParseException("'for each' structure error: A 'for each' activity can only have 'each time' and 'termination' transitions.", (FElement)flowActivity.getUMLActivity());
            }
            if (!hasTerminationTransition) {
                throw new SDMParseException("'for each' structure error: Story activity is set 'for each' but has no 'termination' transition.", (FElement)flowActivity.getUMLActivity());
            }
        } else {
            if (hasEverytimesTransition) {
                throw new SDMParseException("'for each' structure error: Story activity has an 'each time' transition, but is not set 'for each'", (FElement)flowActivity.getUMLActivity());
            }
            if (hasTerminationTransition) {
                throw new SDMParseException("'for each' structure error: Story activity has an 'termination' transition, but is not set 'for each'", (FElement)flowActivity.getUMLActivity());
            }
        }
    }

    private final void dfs(FlowActivity currentFlowActivity) {
        currentFlowActivity.setGrayTime(time);
        ++time;
        Iterator iter = currentFlowActivity.getUMLActivity().iteratorOfExit();
        while (iter.hasNext()) {
            UMLTransition currentUMLTransition = (UMLTransition)iter.next();
            currentUMLTransition.setIsMarked(false);
            FlowActivity nextFlowActivity = currentUMLTransition.getRevEntry().getFlowActivity();
            if (nextFlowActivity == null) {
                UMLActivityDiagram diagram = currentFlowActivity.getUMLActivity().getActivityDiagram();
                UMLActivity activity = currentUMLTransition.getRevEntry();
                throw new SDMParseException("UMLActivity '" + activity.getName() + "' has no FlowActivity:\nmaybe it wasn't added to UMLActivityDiagram '" + diagram.getFullName() + "'", (FElement)activity);
            }
            if (nextFlowActivity.getBlackTime() > 0) {
                currentUMLTransition.setIsForwardEdge(true);
                continue;
            }
            if (nextFlowActivity.getGrayTime() > 0) {
                currentUMLTransition.setIsForwardEdge(false);
                continue;
            }
            currentUMLTransition.setIsForwardEdge(true);
            this.dfs(nextFlowActivity);
        }
        currentFlowActivity.setBlackTime(time);
        ++time;
    }

    private final boolean isTheOnlyTransition(UMLActivity curActivity, UMLTransition curTransition) {
        Iterator iter = curActivity.iteratorOfExit();
        while (iter.hasNext()) {
            if ((UMLTransition)iter.next() == curTransition) continue;
            return false;
        }
        return true;
    }

    private final boolean isIntervalNested(FLinkedList intervalList, FLinkedList newInterval) {
        if (intervalList.isEmpty()) {
            intervalList.add(newInterval);
            return true;
        }
        int newIntegerLeft = (Integer)newInterval.get(2);
        int newIntegerRight = (Integer)newInterval.get(3);
        ListIterator iterator = intervalList.listIterator();
        int pos = 0;
        while (iterator.hasNext()) {
            FLinkedList curInterval = (FLinkedList)iterator.next();
            int curIntegerLeft = (Integer)curInterval.get(2);
            int curIntegerRight = (Integer)curInterval.get(3);
            if (curIntegerLeft < newIntegerLeft && newIntegerRight < curIntegerRight) {
                intervalList.add(iterator, (Object)newInterval);
                return true;
            }
            if (newIntegerLeft >= curIntegerLeft || curIntegerRight >= newIntegerRight) {
                return false;
            }
            ++pos;
        }
        intervalList.add(newInterval);
        return true;
    }

    private final void explore(Seq seq, FlowActivity startFlowActivity, FlowActivity endFlowActivity) {
        if (startFlowActivity.getUMLActivity() instanceof UMLStopActivity || startFlowActivity == endFlowActivity) {
            seq.add(startFlowActivity);
            return;
        }
        UMLTransition currentUMLTransition = null;
        UMLTransition backUMLTransition = null;
        FLinkedList intervalList = new FLinkedList();
        Iterator iter = startFlowActivity.getUMLActivity().iteratorOfEntry();
        while (iter.hasNext()) {
            currentUMLTransition = (UMLTransition)iter.next();
            if (currentUMLTransition.getIsMarked() || currentUMLTransition.getIsForwardEdge()) continue;
            if (this.isTheOnlyTransition(currentUMLTransition.getRevExit(), currentUMLTransition)) {
                if (backUMLTransition == null) {
                    backUMLTransition = currentUMLTransition;
                    continue;
                }
                throw new SDMParseException("Repetition error: Misplaced backward edges (1).", (FElement)currentUMLTransition);
            }
            FLinkedList interval = new FLinkedList();
            interval.add(0, (Object)null);
            interval.add(1, (Object)currentUMLTransition);
            interval.add(2, (Object)new Integer(currentUMLTransition.getRevExit().getFlowActivity().getGrayTime()));
            interval.add(3, (Object)new Integer(currentUMLTransition.getRevExit().getFlowActivity().getBlackTime()));
            if (this.isIntervalNested(intervalList, interval)) continue;
            throw new SDMParseException("Repetition error: Misplaced backward edges (2).", (FElement)currentUMLTransition);
        }
        if (!intervalList.isEmpty()) {
            backUMLTransition = (UMLTransition)((FLinkedList)intervalList.getFirst()).get(1);
        }
        if (backUMLTransition != null) {
            backUMLTransition.setIsMarked(true);
            this.exploreRepetition(seq, backUMLTransition, startFlowActivity, endFlowActivity);
        } else {
            FLinkedList list = new FLinkedList();
            Iterator iterExit = startFlowActivity.getUMLActivity().iteratorOfExit();
            while (iterExit.hasNext()) {
                currentUMLTransition = (UMLTransition)iterExit.next();
                if (currentUMLTransition.getIsMarked() || !currentUMLTransition.getIsForwardEdge() || UMLTransitionGuard.getGuardType(currentUMLTransition) == 3) continue;
                list.add(currentUMLTransition);
            }
            switch (list.size()) {
                case 0: {
                    seq.add(startFlowActivity);
                    throw new SDMParseException("Abnormal termination in control flow", (FElement)startFlowActivity.getUMLActivity());
                }
                case 1: {
                    Iterator iterUMLTransitions = list.iterator();
                    currentUMLTransition = (UMLTransition)iterUMLTransitions.next();
                    seq.add(startFlowActivity);
                    if (startFlowActivity == endFlowActivity) break;
                    currentUMLTransition.setIsMarked(true);
                    this.explore(seq, currentUMLTransition.getRevEntry().getFlowActivity(), endFlowActivity);
                    break;
                }
                case 2: {
                    Iterator iterUMLTransitions = list.iterator();
                    UMLTransition firstUMLTransition = (UMLTransition)iterUMLTransitions.next();
                    UMLTransition secondUMLTransition = (UMLTransition)iterUMLTransitions.next();
                    this.exploreSelection(seq, firstUMLTransition, secondUMLTransition, startFlowActivity, endFlowActivity);
                    break;
                }
                default: {
                    throw new SDMParseException("One Activity has 3 or more outgoing transitions. (Case structure not yet supported)", (FElement)startFlowActivity.getUMLActivity());
                }
            }
        }
    }

    private final void exploreBackwardAndCollect(FHashSet set, FlowActivity start, FlowActivity end) {
        if (start != end) {
            Iterator iter = start.getUMLActivity().iteratorOfEntry();
            while (iter.hasNext()) {
                UMLTransition transition = (UMLTransition)iter.next();
                if (transition.getIsMarked() || !set.add(transition.getRevExit().getFlowActivity())) continue;
                this.exploreBackwardAndCollect(set, transition.getRevExit().getFlowActivity(), end);
            }
        }
    }

    private final void exploreRepetition(Seq seq, UMLTransition backUMLTransition, FlowActivity start, FlowActivity end) {
        UMLTransition currentUMLTransition;
        UMLTransition leavingUMLTransition = null;
        UMLTransition nextUMLTransition = null;
        FlowActivity middle = backUMLTransition.getRevExit().getFlowActivity();
        Iterator iter = middle.getUMLActivity().iteratorOfExit();
        while (iter.hasNext()) {
            currentUMLTransition = (UMLTransition)iter.next();
            if (currentUMLTransition.getIsMarked()) continue;
            if (!currentUMLTransition.getIsForwardEdge()) {
                throw new SDMParseException("Repetition error: Last activity has more than one backward edge.", (FElement)currentUMLTransition);
            }
            if (leavingUMLTransition == null) {
                leavingUMLTransition = currentUMLTransition;
                continue;
            }
            throw new SDMParseException("Repetition error: Last activity has more than one leaving transition", (FElement)currentUMLTransition);
        }
        if (leavingUMLTransition == null) {
            FHashSet nodesInRepetition = new FHashSet();
            nodesInRepetition.add(middle);
            this.exploreBackwardAndCollect(nodesInRepetition, middle, start);
            iter = start.getUMLActivity().iteratorOfExit();
            while (iter.hasNext()) {
                currentUMLTransition = (UMLTransition)iter.next();
                if (!nodesInRepetition.contains(currentUMLTransition.getRevEntry().getFlowActivity())) {
                    if (leavingUMLTransition == null) {
                        leavingUMLTransition = currentUMLTransition;
                        continue;
                    }
                    throw new SDMParseException("Repetition error: Activity has more than one leaving transition", (FElement)currentUMLTransition);
                }
                if (nextUMLTransition == null) {
                    nextUMLTransition = currentUMLTransition;
                    continue;
                }
                throw new SDMParseException("Repetition error: Activity has more than one next transition", (FElement)currentUMLTransition);
            }
            if (leavingUMLTransition == null) {
                throw new SDMParseException("Repetition error: Repetition has no leaving transition", (FElement)start.getUMLActivity());
            }
            if (nextUMLTransition == null) {
                throw new SDMParseException("Repetition error: Repetition has no next transition", (FElement)start.getUMLActivity());
            }
            nodesInRepetition.clear();
            FHashSet nodesAfterRepetition = new FHashSet();
            nodesInRepetition.add(nextUMLTransition.getRevEntry().getFlowActivity());
            this.exploreAndCollect(nodesInRepetition, nextUMLTransition.getRevEntry().getFlowActivity(), middle);
            this.exploreAndCompare(nodesInRepetition, nodesAfterRepetition, leavingUMLTransition.getRevEntry().getFlowActivity(), end);
            if (this.intersection(nodesInRepetition, nodesAfterRepetition).size() != 0) {
                throw new SDMParseException("Repetition error: Error in structure", (FElement)start.getUMLActivity());
            }
            nodesInRepetition = null;
            nodesAfterRepetition = null;
            this.checkTransitionGuards(leavingUMLTransition.getGuard(), nextUMLTransition.getGuard());
            Seq bodySeq = new Seq();
            bodySeq.add(start);
            leavingUMLTransition.setIsMarked(true);
            nextUMLTransition.setIsMarked(true);
            this.explore(bodySeq, nextUMLTransition.getRevEntry().getFlowActivity(), middle);
            Rep rep = new Rep(bodySeq, nextUMLTransition, leavingUMLTransition, true);
            if (!(start.getUMLActivity() instanceof UMLNopActivity)) {
                rep.setHeadedByActivity(true);
            }
            seq.add(rep);
            this.explore(seq, leavingUMLTransition.getRevEntry().getFlowActivity(), end);
        } else {
            FHashSet nodesAfterRepetition = new FHashSet();
            FHashSet nodesInRepetition = new FHashSet();
            this.exploreAndCollect(nodesInRepetition, start, middle);
            this.exploreAndCompare(nodesInRepetition, nodesAfterRepetition, leavingUMLTransition.getRevEntry().getFlowActivity(), end);
            if (this.intersection(nodesInRepetition, nodesAfterRepetition).size() != 0) {
                throw new SDMParseException("Repetition error: Error in structure", (FElement)start.getUMLActivity());
            }
            this.checkTransitionGuards(leavingUMLTransition.getGuard(), backUMLTransition.getGuard());
            Seq bodySeq = new Seq();
            leavingUMLTransition.setIsMarked(true);
            this.explore(bodySeq, start, middle);
            Rep rep = new Rep(bodySeq, backUMLTransition, leavingUMLTransition, false);
            seq.add(rep);
            this.explore(seq, leavingUMLTransition.getRevEntry().getFlowActivity(), end);
        }
    }

    private final void exploreAndCompare(FHashSet leftSet, FHashSet rightSet, FlowActivity start, FlowActivity end) {
        boolean visited = !rightSet.add(start);
        boolean found = leftSet.contains(start);
        if (!visited && !found && start != end) {
            Iterator iter = start.getUMLActivity().iteratorOfExit();
            while (iter.hasNext()) {
                UMLTransition transition = (UMLTransition)iter.next();
                if (transition.getIsMarked()) continue;
                this.exploreAndCompare(leftSet, rightSet, transition.getRevEntry().getFlowActivity(), end);
            }
        }
    }

    private final void exploreAndCollect(FHashSet set, FlowActivity start, FlowActivity end) {
        if (start != end) {
            Iterator iter = start.getUMLActivity().iteratorOfExit();
            while (iter.hasNext()) {
                UMLTransition transition = (UMLTransition)iter.next();
                if (transition.getIsMarked() || !set.add(transition.getRevEntry().getFlowActivity())) continue;
                this.exploreAndCollect(set, transition.getRevEntry().getFlowActivity(), end);
            }
        }
    }

    private final void checkTransitionGuards(UMLTransitionGuard leftGuard, UMLTransitionGuard rightGuard) {
        int leftType = leftGuard == null ? 0 : leftGuard.getType();
        int rightType = rightGuard == null ? 0 : rightGuard.getType();
        switch (leftType) {
            case 1: {
                if (rightType == 2) {
                    return;
                }
                if (rightType != 5) break;
                rightGuard.setType(2);
                return;
            }
            case 2: {
                if (rightType == 1) {
                    return;
                }
                if (rightType != 5) break;
                rightGuard.setType(1);
                return;
            }
            case 6: {
                if (rightType != 5) break;
                return;
            }
            case 7: {
                if (rightType == 0) {
                    return;
                }
            }
            case 0: {
                if (rightType == 7) {
                    return;
                }
            }
            case 5: {
                if (rightType != 6) break;
                return;
            }
        }
        throw new SDMParseException("Transition guards " + rightGuard + " and " + leftGuard + " are incompatible.", (FElement)leftGuard);
    }

    private final void exploreSelection(Seq seq, UMLTransition firstUMLTransition, UMLTransition secondUMLTransition, FlowActivity start, FlowActivity end) {
        this.checkTransitionGuards(firstUMLTransition.getGuard(), secondUMLTransition.getGuard());
        FHashSet leftSet = new FHashSet();
        FHashSet rightSet = new FHashSet();
        leftSet.add(firstUMLTransition.getRevEntry().getFlowActivity());
        this.exploreAndCollect(leftSet, firstUMLTransition.getRevEntry().getFlowActivity(), end);
        this.exploreAndCompare(leftSet, rightSet, secondUMLTransition.getRevEntry().getFlowActivity(), end);
        FHashSet interSet = this.intersection(leftSet, rightSet);
        switch (interSet.size()) {
            case 0: {
                Seq firstSeq = new Seq();
                Seq secondSeq = new Seq();
                firstUMLTransition.setIsMarked(true);
                secondUMLTransition.setIsMarked(true);
                this.explore(firstSeq, firstUMLTransition.getRevEntry().getFlowActivity(), end);
                this.explore(secondSeq, secondUMLTransition.getRevEntry().getFlowActivity(), end);
                if (end == null) {
                    Sel sel = UMLTransitionGuard.getGuardType(firstUMLTransition) == 5 || UMLTransitionGuard.getGuardType(firstUMLTransition) == 2 ? new Sel(start, secondSeq, secondUMLTransition, firstSeq, firstUMLTransition) : new Sel(start, firstSeq, firstUMLTransition, secondSeq, secondUMLTransition);
                    seq.add(sel);
                    break;
                }
                if (!leftSet.contains(end)) {
                    Sel sel = new Sel(start, firstSeq, firstUMLTransition, null, secondUMLTransition);
                    seq.add(sel);
                    seq.add(secondSeq);
                    break;
                }
                Sel sel = new Sel(start, secondSeq, secondUMLTransition, null, firstUMLTransition);
                seq.add(sel);
                seq.add(firstSeq);
                break;
            }
            case 1: {
                FlowActivity firstCommonFlowActivity = (FlowActivity)interSet.iterator().next();
                interSet.clear();
                leftSet.clear();
                rightSet.clear();
                leftSet.add(firstUMLTransition.getRevEntry().getFlowActivity());
                this.exploreAndCollect(leftSet, firstUMLTransition.getRevEntry().getFlowActivity(), firstCommonFlowActivity);
                leftSet.remove(firstCommonFlowActivity);
                rightSet.add(secondUMLTransition.getRevEntry().getFlowActivity());
                this.exploreAndCollect(rightSet, secondUMLTransition.getRevEntry().getFlowActivity(), firstCommonFlowActivity);
                rightSet.remove(firstCommonFlowActivity);
                this.exploreAndCompare(leftSet, interSet, firstCommonFlowActivity, end);
                if (this.intersection(leftSet, interSet).size() != 0) {
                    throw new SDMParseException("Error in selection structure.", (FElement)firstCommonFlowActivity.getUMLActivity());
                }
                interSet = null;
                leftSet = null;
                rightSet = null;
                Iterator iter = firstCommonFlowActivity.getUMLActivity().iteratorOfExit();
                while (iter.hasNext()) {
                    UMLTransition currentUMLTransition = (UMLTransition)iter.next();
                    if (currentUMLTransition.getIsMarked() || currentUMLTransition.getIsForwardEdge()) continue;
                    throw new SDMParseException("Repetition overlaps selection", (FElement)currentUMLTransition);
                }
                Seq firstSeq = new Seq();
                Seq secondSeq = new Seq();
                firstUMLTransition.setIsMarked(true);
                secondUMLTransition.setIsMarked(true);
                this.explore(firstSeq, firstUMLTransition.getRevEntry().getFlowActivity(), firstCommonFlowActivity);
                firstSeq.removeLastFlowActivity(firstCommonFlowActivity);
                this.explore(secondSeq, secondUMLTransition.getRevEntry().getFlowActivity(), firstCommonFlowActivity);
                secondSeq.removeLastFlowActivity(firstCommonFlowActivity);
                Sel sel = UMLTransitionGuard.getGuardType(firstUMLTransition) == 5 || UMLTransitionGuard.getGuardType(firstUMLTransition) == 2 ? new Sel(start, secondSeq, secondUMLTransition, firstSeq, firstUMLTransition) : new Sel(start, firstSeq, firstUMLTransition, secondSeq, secondUMLTransition);
                seq.add(sel);
                this.explore(seq, firstCommonFlowActivity, end);
                break;
            }
            default: {
                throw new SDMParseException("Error in selection structure.", (FElement)secondUMLTransition.getRevEntry());
            }
        }
    }

    public FHashSet intersection(FHashSet setOne, FHashSet setTwo) {
        FHashSet tmpSet = new FHashSet();
        Iterator iter = setTwo.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!setOne.contains(obj)) continue;
            tmpSet.add(obj);
        }
        return tmpSet;
    }
}

