/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.gui.PEVariable;
import de.uni_paderborn.fujaba.metamodel.FAttr;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FDeclaration;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FQualifier;
import de.uni_paderborn.fujaba.metamodel.FRole;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.uml.UMLArray;
import de.uni_paderborn.fujaba.uml.UMLAttrExprPair;
import de.uni_paderborn.fujaba.uml.UMLBaseTypes;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLConstraint;
import de.uni_paderborn.fujaba.uml.UMLDeclaration;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLPackage;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLQualifier;
import de.uni_paderborn.fujaba.uml.UMLRole;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.upb.tools.fca.EnumerationForAnIterator;
import de.upb.tools.fca.FDuplicatedTreeMap;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.fca.FPropHashSet;
import de.upb.tools.fca.FPropTreeSet;
import de.upb.tools.fca.FTreeSet;
import de.upb.tools.pcs.CollectionChangeEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class UMLAttr
extends UMLDeclaration
implements FAttr {
    private static final transient Logger log;
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_UML_STATIC = "umlStatic";
    public static final String PROPERTY_ATTR_TYPE = "attrType";
    public static final int UNUSED = -1;
    public static final int CREATE_ACCESS_METHODS_YES = 0;
    public static final int CREATE_ACCESS_METHODS_NO = 1;
    public static final int CREATE_ACCESS_METHODS_DEFAULT = 2;
    private String name = null;
    private boolean pointer;
    private boolean umlStatic = false;
    private static transient boolean syncVisibilities;
    private transient int umlVisibility = -1;
    private String initialValue;
    private transient UMLClass parent;
    private transient FHashSet revQualifiedAttr;
    private UMLType attrType;
    private FTreeSet instances = new FPropTreeSet(this, "instances");
    private int createAccessMethods = 2;
    private boolean javaFinal = false;
    private boolean javaTransient = false;
    private transient UMLRole implementingAssocRole;
    private FHashSet accessMethods;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.uml.UMLAttr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        syncVisibilities = true;
    }

    public UMLAttr() {
    }

    public UMLAttr(boolean coobraPersistent) {
        super(coobraPersistent);
    }

    public UMLAttr(int visibility, String type, String name, String initialValue, boolean umlStatic, boolean javaFinal) {
        this(name, umlStatic, javaFinal, visibility, initialValue, UMLProject.get().getTypeList().getFromTypes(type), null, null);
    }

    public UMLAttr(int visibility, String type, String name, String initialValue, boolean umlStatic, boolean javaFinal, UMLClass parent) {
        this(name, umlStatic, javaFinal, visibility, initialValue, UMLProject.get().getTypeList().getFromTypes(type), parent, null);
        if (UMLProject.get().getTypeList().getFromTypes(type) == null) {
            this.setAttrType(type);
        }
    }

    public UMLAttr(String name, boolean umlStatic, boolean javaFinal, int visibility, String initialValue, UMLType attrType) {
        this(name, umlStatic, javaFinal, visibility, initialValue, attrType, null, null);
    }

    public UMLAttr(String name, boolean umlStatic, boolean javaFinal, int visibility, String initialValue, UMLType attrType, UMLClass parent, UMLConstraint constraint) {
        this.setName(name);
        this.setUmlStatic(umlStatic);
        this.setFinal(javaFinal);
        this.setVisibility(visibility);
        this.setInitialValue(initialValue);
        this.setAttrType(attrType);
        this.setParent(parent);
        this.addToConstraints(constraint);
    }

    public String getName() {
        if (this.name == null) {
            this.name = "_@" + this.getID().toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)"create a temp name for a attr");
            }
        }
        return this.name;
    }

    public void setName(String newName) {
        if (this.name == null || !this.name.equals(newName)) {
            UMLClass clazz = this.getParent();
            this.setParent(null);
            String oldName = this.name;
            this.name = newName;
            this.setParent(clazz);
            this.firePropertyChange(PROPERTY_NAME, oldName, newName);
        }
    }

    public String getNameUpdate() {
        return this.getName();
    }

    public void setNameUpdate(String value) {
        this.setName(value);
        PEVariable.handleAccessMethods(null, true, this.getVisibility(), this);
    }

    public boolean isPointer() {
        return this.pointer;
    }

    public void setPointer(boolean pointer) {
        if (this.pointer != pointer) {
            this.pointer = pointer;
            this.firePropertyChange("pointer", !pointer, pointer);
        }
    }

    public boolean isUmlStatic() {
        return this.umlStatic;
    }

    public boolean isStatic() {
        return this.isUmlStatic();
    }

    public void setUmlStatic(boolean umlStatic) {
        boolean oldValue = this.umlStatic;
        this.umlStatic = umlStatic;
        this.firePropertyChange(PROPERTY_UML_STATIC, oldValue, umlStatic);
    }

    public void setStatic(boolean umlStatic) {
        this.setUmlStatic(umlStatic);
    }

    public static void setSyncVisibilities(boolean sync) {
        if (syncVisibilities != sync) {
            if (sync) {
                UMLAttr.fixVisibilities();
            }
            syncVisibilities = sync;
        }
    }

    public static boolean isSyncVisibilities() {
        return syncVisibilities;
    }

    public int getUmlVisibility() {
        if (this.umlVisibility == -1) {
            this.setUmlVisibility(this.getVisibility());
        }
        return this.umlVisibility;
    }

    public void setUmlVisibility(int newUmlVisibility) {
        if (this.umlVisibility != newUmlVisibility) {
            int oldValue = this.umlVisibility;
            this.umlVisibility = newUmlVisibility;
            this.firePropertyChange("umlVisibility", oldValue, newUmlVisibility);
        }
        if (syncVisibilities && this.getVisibility() != newUmlVisibility) {
            this.setVisibility(newUmlVisibility);
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (syncVisibilities && this.getUmlVisibility() != visibility) {
            this.setUmlVisibility(visibility);
        }
    }

    public String getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(String initialValue) {
        String oldValue = this.initialValue;
        this.initialValue = initialValue;
        this.firePropertyChange("initialValue", oldValue, initialValue);
    }

    public boolean setParent(FClass obj) {
        boolean changed = false;
        if (this.parent != obj) {
            UMLClass oldValue = this.parent;
            if (this.parent != null) {
                this.parent = null;
                oldValue.removeFromAttrs(this);
            }
            this.parent = (UMLClass)obj;
            if (obj != null) {
                obj.addToAttrs(this);
            }
            changed = true;
            this.firePropertyChange("parent", oldValue, obj);
        }
        return changed;
    }

    public UMLClass getParent() {
        return this.parent;
    }

    public FClass getFParent() {
        return this.getParent();
    }

    public boolean hasInRevQualifiedAttr(FQualifier value) {
        return this.revQualifiedAttr != null && value != null && this.revQualifiedAttr.contains(value);
    }

    public Iterator iteratorOfRevQualifiedAttr() {
        return this.revQualifiedAttr == null ? FEmptyIterator.get() : this.revQualifiedAttr.iterator();
    }

    public int sizeOfRevQualifiedAttr() {
        return this.revQualifiedAttr == null ? 0 : this.revQualifiedAttr.size();
    }

    public boolean addToRevQualifiedAttr(FQualifier value) {
        boolean changed = false;
        if (value != null) {
            if (this.revQualifiedAttr == null) {
                this.revQualifiedAttr = new FHashSet();
            }
            if (changed = this.revQualifiedAttr.add(value)) {
                value.setQualifiedAttr(this);
            }
        }
        return changed;
    }

    public boolean removeFromRevQualifiedAttr(FQualifier value) {
        boolean changed = false;
        if (this.revQualifiedAttr != null && value != null && (changed = this.revQualifiedAttr.remove(value))) {
            value.setQualifiedAttr(null);
        }
        return changed;
    }

    public void removeAllFromRevQualifiedAttr() {
        Iterator iter = this.iteratorOfRevQualifiedAttr();
        while (iter.hasNext()) {
            UMLQualifier tmpValue = (UMLQualifier)iter.next();
            this.removeFromRevQualifiedAttr(tmpValue);
        }
    }

    public UMLType getAttrType() {
        return this.attrType;
    }

    public FType getFAttrType() {
        return this.getAttrType();
    }

    public UMLType getUMLType() {
        return this.getAttrType();
    }

    public void setAttrType(FType attrType) {
        if (this.attrType != attrType) {
            UMLType oldAttrType = this.attrType;
            if (this.attrType != null) {
                this.attrType = null;
                oldAttrType.removeFromRevAttrType(this);
            }
            this.attrType = (UMLType)attrType;
            if (attrType != null) {
                ((UMLType)attrType).addToRevAttrType(this);
            }
            this.firePropertyChange(PROPERTY_ATTR_TYPE, oldAttrType, attrType);
        }
    }

    public void setAttrType(String tmpType) {
        UMLType umlType = null;
        String type = UMLProject.getTypeOfFullQualifiedType(tmpType);
        if (UMLProject.get().getTypeList().hasKeyInTypes(type)) {
            umlType = UMLProject.get().getTypeList().getFromTypes(type);
        } else if (UMLProject.get().hasKeyInReferences(tmpType)) {
            umlType = UMLProject.get().getFromReferences(tmpType);
        } else {
            umlType = UMLProject.get().getOrNewType(this.getParent(), tmpType);
            ((UMLClass)umlType).setDisplayLevel(0);
        }
        this.setAttrType(umlType);
    }

    public boolean hasInInstances(UMLAttrExprPair elem) {
        return this.instances.contains(elem);
    }

    public Enumeration elementsOfInstances() {
        return new EnumerationForAnIterator(this.iteratorOfInstances());
    }

    public Iterator iteratorOfInstances() {
        return this.instances.iterator();
    }

    public void addToInstances(UMLAttrExprPair elem) {
        if (elem != null && !this.hasInInstances(elem)) {
            this.instances.add(elem);
            elem.setInstanceOf(this);
            this.firePropertyChange(CollectionChangeEvent.get(this, "instances", this.instances, null, elem, 1));
        }
    }

    public void removeFromInstances(UMLAttrExprPair elem) {
        if (this.hasInInstances(elem)) {
            this.instances.remove(elem);
            elem.setInstanceOf(null);
            this.firePropertyChange(CollectionChangeEvent.get(this, "instances", this.instances, elem, null, 2));
        }
    }

    public void removeAllFromInstances() {
        Iterator iter = this.iteratorOfInstances();
        while (iter.hasNext()) {
            UMLAttrExprPair item = (UMLAttrExprPair)iter.next();
            item.setInstanceOf(null);
            this.firePropertyChange(CollectionChangeEvent.get(this, "instances", this.instances, item, null, 2));
        }
    }

    public static String getVisibilityType(int visibility) {
        String visibilityType = null;
        switch (visibility) {
            case 0: {
                visibilityType = "private attribute";
                break;
            }
            case 2: {
                visibilityType = "protected attribute";
                break;
            }
            case 3: {
                visibilityType = "package attribute";
                break;
            }
            case 1: {
                visibilityType = "public attribute";
                break;
            }
            case 4: {
                visibilityType = "user attribute";
            }
        }
        return visibilityType;
    }

    public void removeYou() {
        this.setParent(null);
        this.removeAllFromRevQualifiedAttr();
        this.removeAllFromInstances();
        this.setAttrType((FType)null);
        UMLRole tmpImplementingAssocRole = this.getImplementingAssocRole();
        if (tmpImplementingAssocRole != null) {
            this.setImplementingAssocRole(null);
        }
        this.removeAllFromAccessMethods();
        super.removeYou();
    }

    public FElement getParentElement() {
        return this.getParent();
    }

    public void writeAttributes(StringBuffer data, FTreeSet setOfNeighbours) {
        super.writeAttributes(data, setOfNeighbours);
        if (this.attrType instanceof UMLBaseTypes) {
            this.writeToStringBuffer(PROPERTY_ATTR_TYPE, (UMLBaseTypes)this.attrType, setOfNeighbours);
        } else if (this.attrType instanceof UMLClass) {
            this.writeToStringBuffer(PROPERTY_ATTR_TYPE, (UMLClass)this.attrType, setOfNeighbours);
        } else {
            this.writeToStringBuffer(PROPERTY_ATTR_TYPE, (UMLArray)this.attrType, setOfNeighbours);
        }
    }

    public void readAttributes(Hashtable objects, FDuplicatedTreeMap attributes) {
        super.readAttributes(objects, attributes);
        if (this.attrType instanceof UMLBaseTypes) {
            this.setAttrType((UMLType)((Object)this.readFromStringTokenizer(PROPERTY_ATTR_TYPE, (UMLBaseTypes)this.attrType, objects, attributes)));
        } else if (this.attrType instanceof UMLClass) {
            this.setAttrType((UMLType)((Object)this.readFromStringTokenizer(PROPERTY_ATTR_TYPE, (UMLClass)this.attrType, objects, attributes)));
        } else {
            this.setAttrType((UMLType)((Object)this.readFromStringTokenizer(PROPERTY_ATTR_TYPE, (UMLArray)this.attrType, objects, attributes)));
        }
    }

    public String getText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(FDeclaration.VISIBILITY_CHAR[this.getVisibility()]);
        buffer.append(" ");
        buffer.append(this.getName());
        buffer.append(" : ");
        buffer.append(this.getAttrType() == null ? "<unknown>" : this.getAttrType().getName());
        if (this.getInitialValue() != null && !this.getInitialValue().equals("")) {
            buffer.append(" = ");
            buffer.append(this.getInitialValue());
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("UMLAttr[");
        result.append(this.getText());
        result.append("]");
        return result.toString();
    }

    public int getCreateAccessMethods() {
        return this.createAccessMethods;
    }

    public void setCreateAccessMethods(int createAccessMethods) {
        if (this.createAccessMethods != createAccessMethods) {
            int oldValue = this.createAccessMethods;
            boolean oldNoAccessMethods = this.isNoAccessMethods();
            this.createAccessMethods = createAccessMethods;
            this.firePropertyChange("createAccessMethods", oldValue, createAccessMethods);
            if (this.isNoAccessMethods() != oldNoAccessMethods) {
                this.firePropertyChange("noAccessMethods", oldNoAccessMethods, !oldNoAccessMethods);
            }
        }
    }

    public void setNoAccessMethods(boolean noAccessMethods) {
        this.setCreateAccessMethods(noAccessMethods ? 1 : 2);
    }

    public boolean isNoAccessMethods() {
        return this.getCreateAccessMethods() == 1;
    }

    public boolean isNeedsAccessMethods() {
        switch (this.getCreateAccessMethods()) {
            case 1: {
                return false;
            }
            case 2: {
                return !this.isConstant();
            }
        }
        return true;
    }

    public boolean isFinal() {
        return this.javaFinal;
    }

    public void setFinal(boolean javaFinal) {
        boolean oldValue = this.javaFinal;
        this.javaFinal = javaFinal;
        this.firePropertyChange("final", oldValue, javaFinal);
    }

    public boolean isConstant() {
        return this.isStatic() && this.isFinal();
    }

    public void setTransient(boolean javaTransient) {
        boolean oldValue = this.javaTransient;
        this.javaTransient = javaTransient;
        this.firePropertyChange("transient", oldValue, javaTransient);
    }

    public boolean isTransient() {
        return this.javaTransient;
    }

    public void setCutCopyPasteParent(FElement parent) {
        UMLAttr attr;
        if (parent instanceof UMLClass) {
            ((UMLClass)parent).addToAttrs(this);
        } else if (parent instanceof UMLAttr && (attr = (UMLAttr)parent).getParent() != null) {
            attr.getParent().addToAttrs(this);
        }
    }

    public UMLMethod findAccessMethod(int type) {
        return null;
    }

    public boolean hasAccessMethods() {
        return this.sizeOfAccessMethods() != 0;
    }

    public boolean hasAccessMethod(int type) {
        return this.findAccessMethod(type) != null;
    }

    public boolean setImplementingAssocRole(FRole value) {
        boolean changed = false;
        if (this.implementingAssocRole != value) {
            UMLRole oldValue = this.implementingAssocRole;
            if (this.implementingAssocRole != null) {
                this.implementingAssocRole = null;
                oldValue.setAssociatedAttribute(null);
            }
            this.implementingAssocRole = (UMLRole)value;
            this.firePropertyChange("implementingAssocRole", oldValue, value);
            if (value != null) {
                ((UMLRole)value).setAssociatedAttribute(this);
            }
            changed = true;
        }
        return changed;
    }

    public UMLRole getImplementingAssocRole() {
        return this.implementingAssocRole;
    }

    public FRole getFImplementingAssocRole() {
        return this.getImplementingAssocRole();
    }

    public boolean hasInAccessMethods(UMLMethod value) {
        return this.accessMethods != null && value != null && this.accessMethods.contains(value);
    }

    public Iterator iteratorOfAccessMethods() {
        return this.accessMethods == null ? FEmptyIterator.get() : this.accessMethods.iterator();
    }

    public int sizeOfAccessMethods() {
        return this.accessMethods == null ? 0 : this.accessMethods.size();
    }

    public boolean addToAccessMethods(UMLMethod value) {
        boolean changed = false;
        if (value != null) {
            if (this.accessMethods == null) {
                this.accessMethods = new FPropHashSet(this, "accessMethods");
            }
            if (changed = this.accessMethods.add(value)) {
                value.setAccessedAttribute(this);
            }
        }
        return changed;
    }

    public boolean removeFromAccessMethods(UMLMethod value) {
        boolean changed = false;
        if (this.accessMethods != null && value != null && (changed = this.accessMethods.remove(value))) {
            value.setAccessedAttribute(null);
        }
        return changed;
    }

    public void removeAllFromAccessMethods() {
        Iterator iter = this.iteratorOfAccessMethods();
        while (iter.hasNext()) {
            UMLMethod tmpValue = (UMLMethod)iter.next();
            this.removeFromAccessMethods(tmpValue);
            tmpValue.removeYou();
        }
    }

    public static void fixVisibilities() {
        UMLProject project = UMLProject.get();
        UMLAttr.fixVisibilities(project);
    }

    private static void fixVisibilities(UMLProject project) {
        UMLAttr.fixVisibilities(project.getRootPackage());
        Iterator references = project.iteratorOfReferences();
        while (references.hasNext()) {
            UMLClass umlClass = (UMLClass)references.next();
            UMLAttr.fixVisibilities(umlClass);
        }
    }

    private static void fixVisibilities(UMLPackage umlPackage) {
        Iterator classes = umlPackage.iteratorOfDeclares();
        while (classes.hasNext()) {
            UMLClass umlClass = (UMLClass)classes.next();
            UMLAttr.fixVisibilities(umlClass);
        }
        Iterator packages = umlPackage.iteratorOfPackages();
        while (packages.hasNext()) {
            UMLPackage tmpPackage = (UMLPackage)packages.next();
            UMLAttr.fixVisibilities(tmpPackage);
        }
    }

    private static void fixVisibilities(UMLClass umlClass) {
        Iterator attrs = umlClass.iteratorOfAttrs();
        while (attrs.hasNext()) {
            UMLAttr umlAttr = (UMLAttr)attrs.next();
            UMLAttr.fixVisibility(umlAttr);
        }
    }

    private static void fixVisibility(UMLAttr umlAttr) {
        int umlVisibility = umlAttr.getUmlVisibility();
        if (umlVisibility == 4) {
            umlAttr.setUmlVisibility(umlAttr.getVisibility());
        } else {
            umlAttr.setVisibility(umlAttr.getUmlVisibility());
        }
    }
}

