/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStoryActivity;
import de.uni_paderborn.fujaba.uml.UMLStoryPattern;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.upb.tools.fca.EnumerationForAnIterator;
import de.upb.tools.fca.FLinkedList;
import de.upb.tools.pcs.CollectionChangeEvent;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UMLCollabStat
extends UMLDiagramItem {
    private static final Pattern PATH_PATTERN = Pattern.compile("(\\d+)([_a-zA-Z]\\w*)?(?:\\.(.+))?");
    public static final int TYPE_CALL = 0;
    public static final int TYPE_COND = 1;
    public static final int TYPE_LOOP = 2;
    private boolean callOnElementsOfSet = false;
    private int number = 0;
    private transient String noText = null;
    private String callText = "";
    private String assignTgtText = "";
    private UMLType assignTgtType;
    private String ifCondText = "";
    private String loopVarName = "";
    private String loopStartVal = "";
    private String loopStopVal = "";
    private String whileLoopText = "";
    private String threadId = "";
    private UMLObject callTarget;
    private UMLObject callSource;
    private UMLStoryPattern myPattern;
    private UMLCollabStat fatherStat;
    private transient FLinkedList subStats = new FLinkedList();
    private UMLDiagram diag;
    private transient String text;
    private transient boolean parsing = false;
    private UMLMethod method;
    private boolean expanded = false;
    private int statType = 0;

    public UMLCollabStat() {
    }

    public UMLCollabStat(UMLCollabStat father, UMLObject src, UMLObject tgt, UMLDiagram diag) {
        this.setFatherStat(father);
        this.setCallSource(src);
        this.setCallTarget(tgt);
        this.addToDiagrams(diag);
    }

    public boolean isCallOnElementsOfSet() {
        return this.callOnElementsOfSet;
    }

    public void setCallOnElementsOfSet(boolean flag) {
        if (this.callOnElementsOfSet != flag) {
            boolean oldFlag = this.callOnElementsOfSet;
            this.callOnElementsOfSet = flag;
            this.firePropertyChange("callOnElementsOfSet", (Object)oldFlag, (Object)flag);
        }
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        if (this.number != number) {
            int oldNumber = this.number;
            this.number = number;
            this.firePropertyChange("number", oldNumber, number);
            this.createNoText();
        }
    }

    public String getNoText() {
        if (this.noText == null) {
            this.createNoText();
        }
        return this.noText;
    }

    protected void createNoText() {
        String oldNoText = this.noText;
        String newNoText = null;
        if (this.fatherStat != null) {
            String fatherText = this.fatherStat.getNoText();
            if (fatherText != null && fatherText.length() > 0) {
                StringBuffer buffer = new StringBuffer(fatherText);
                buffer.append('.');
                buffer.append(this.number);
                newNoText = buffer.toString();
            } else {
                newNoText = Integer.toString(this.number);
            }
        }
        if (oldNoText == null && newNoText != null || oldNoText != null && !oldNoText.equals(newNoText)) {
            if (this.noText == null && this.text == null) {
                this.noText = "null";
            }
            String oldFullText = this.getText();
            this.noText = newNoText;
            this.fireTextChange("noText", oldNoText, newNoText, oldFullText);
            Iterator subStats = this.iteratorOfSubStats();
            while (subStats.hasNext()) {
                UMLCollabStat subStat = (UMLCollabStat)subStats.next();
                subStat.createNoText();
            }
        }
    }

    public String setNoText(String noText) throws NumberFormatException {
        if (noText != null && !noText.equals("")) {
            UMLCollabStat master;
            int lastDot = noText.lastIndexOf(46);
            String parentPath = null;
            if (lastDot > -1) {
                parentPath = noText.substring(0, lastDot);
                noText = noText.substring(lastDot + 1);
            }
            int number = Integer.parseInt(noText);
            this.setNumber(number);
            if (!UMLProject.isLoading() && lastDot > -1 && (master = this.getRootFatherStat()) != this) {
                UMLCollabStat parent = master.findSubStat(parentPath);
                if (parent == null) {
                    parent = master.createSubStat(parentPath);
                }
                parent.addToSubStats(this);
            }
        } else {
            this.setNumber(0);
        }
        return this.getNoText();
    }

    public int getNoDepth() {
        return this.getNoDepth(0);
    }

    private int getNoDepth(int i) {
        UMLCollabStat father = this.getFatherStat();
        if (father == null) {
            return i;
        }
        return father.getNoDepth(++i);
    }

    public String getCallText() {
        return this.callText == null ? "" : this.callText;
    }

    public String setCallText(String callText) {
        if (this.callText == null || this.callText != null && !this.callText.equals(callText)) {
            String oldFullText = this.getText();
            String oldValue = this.getText();
            this.callText = callText;
            this.fireTextChange("callText", oldValue, callText, oldFullText);
        }
        return this.callText;
    }

    public String getAssignTgtText() {
        return this.assignTgtText == null ? "" : this.assignTgtText;
    }

    public String setAssignTgtText(String assignTgtText) {
        if (this.assignTgtText == null || this.assignTgtText != null && !this.assignTgtText.equals(assignTgtText)) {
            String oldFullText = this.getText();
            String oldValue = this.assignTgtText;
            this.assignTgtText = assignTgtText;
            this.fireTextChange("assignTgtText", oldValue, assignTgtText, oldFullText);
        }
        return this.assignTgtText;
    }

    public UMLType getAssignTgtType() {
        return this.assignTgtType;
    }

    public UMLType setAssignTgtType(UMLType assignTgtType) {
        if (this.assignTgtType == null || this.assignTgtType != null && !this.assignTgtType.equals(assignTgtType)) {
            String oldFullText = this.getText();
            UMLType oldValue = this.assignTgtType;
            this.assignTgtType = assignTgtType;
            this.fireTextChange("assignTgtType", oldValue, assignTgtType, oldFullText);
        }
        return this.assignTgtType;
    }

    public String getIfCondText() {
        return this.ifCondText == null ? "" : this.ifCondText;
    }

    public String setIfCondText(String ifCondText) {
        if (this.ifCondText == null || this.ifCondText != null && !this.ifCondText.equals(ifCondText)) {
            String oldFullText = this.getText();
            String oldValue = this.ifCondText;
            this.ifCondText = ifCondText;
            this.fireTextChange("ifCondText", oldValue, ifCondText, oldFullText);
        }
        this.setStatType(1);
        return this.ifCondText;
    }

    public String getLoopVarName() {
        return this.loopVarName == null ? "" : this.loopVarName;
    }

    public String setLoopVarName(String loopVarName) {
        if (this.loopVarName == null || this.loopVarName != null && !this.loopVarName.equals(loopVarName)) {
            String oldFullText = this.getText();
            String oldValue = this.loopVarName;
            this.loopVarName = loopVarName;
            this.fireTextChange("loopVarName", oldValue, loopVarName, oldFullText);
        }
        this.setStatType(2);
        return this.loopVarName;
    }

    public String getLoopStartVal() {
        return this.loopStartVal == null ? "" : this.loopStartVal;
    }

    public String setLoopStartVal(String loopStartVal) {
        if (this.loopStartVal == null || this.loopStartVal != null && !this.loopStartVal.equals(loopStartVal)) {
            String oldFullText = this.getText();
            String oldValue = this.loopStartVal;
            this.loopStartVal = loopStartVal;
            this.fireTextChange("loopStartVal", oldValue, loopStartVal, oldFullText);
        }
        this.setStatType(2);
        return this.loopStartVal;
    }

    public String getLoopStopVal() {
        return this.loopStopVal == null ? "" : this.loopStopVal;
    }

    public String setLoopStopVal(String loopStopVal) {
        if (this.loopStopVal == null || this.loopStopVal != null && !this.loopStopVal.equals(loopStopVal)) {
            String oldFullText = this.getText();
            String oldValue = this.loopStopVal;
            this.loopStopVal = loopStopVal;
            this.fireTextChange("loopStopVal", oldValue, loopStopVal, oldFullText);
        }
        return this.loopStopVal;
    }

    public String getWhileLoopText() {
        return this.whileLoopText == null ? "" : this.whileLoopText;
    }

    public String setWhileLoopText(String whileLoopText) {
        if (this.whileLoopText == null || this.whileLoopText != null && !this.whileLoopText.equals(whileLoopText)) {
            String oldFullText = this.getText();
            String oldValue = this.whileLoopText;
            this.whileLoopText = whileLoopText;
            this.fireTextChange("whileLoopText", oldValue, whileLoopText, oldFullText);
        }
        this.setStatType(2);
        return this.whileLoopText;
    }

    public String getThreadId() {
        return this.threadId == null ? "" : this.threadId;
    }

    public String setThreadId(String threadId) {
        if (this.threadId == null || this.threadId != null && !this.threadId.equals(threadId)) {
            String oldFullText = this.getText();
            String oldValue = this.threadId;
            this.threadId = threadId;
            this.fireTextChange("threadId", oldValue, threadId, oldFullText);
        }
        return this.threadId;
    }

    public UMLObject getCallTarget() {
        return this.callTarget;
    }

    public void setCallTarget(UMLObject callTarget) {
        if (this.callTarget != callTarget) {
            UMLObject oldCallTarget = this.callTarget;
            if (this.callTarget != null) {
                this.callTarget = null;
                oldCallTarget.removeFromCollabStats(this);
            }
            this.callTarget = callTarget;
            if (callTarget != null) {
                callTarget.addToCollabStats(this);
            }
            this.firePropertyChange("callTarget", oldCallTarget, callTarget);
        }
    }

    public boolean setCallSource(UMLObject value) {
        boolean changed = false;
        if (this.callSource != value) {
            if (this.callSource != null) {
                UMLObject oldValue = this.callSource;
                this.callSource = null;
                oldValue.removeFromCallSourceCollabStats(this);
            }
            this.callSource = value;
            if (value != null) {
                value.addToCallSourceCollabStats(this);
            }
            changed = true;
        }
        return changed;
    }

    public UMLObject getCallSource() {
        return this.callSource;
    }

    public UMLStoryPattern getMyPattern() {
        return this.myPattern;
    }

    public void setMyPattern(UMLStoryPattern myPattern) {
        if (this.myPattern != myPattern) {
            UMLStoryPattern oldMyPattern = this.myPattern;
            if (this.myPattern != null) {
                this.myPattern = null;
                oldMyPattern.setRevMasterCollabStat(null);
            }
            this.myPattern = myPattern;
            this.firePropertyChange("myPattern", oldMyPattern, myPattern);
            if (myPattern != null) {
                myPattern.setRevMasterCollabStat(this);
            }
        }
    }

    public UMLCollabStat getFatherStat() {
        return this.fatherStat;
    }

    public void setFatherStat(UMLCollabStat fatherStat) {
        if (this.fatherStat != fatherStat) {
            UMLCollabStat oldFatherStat = this.fatherStat;
            if (this.fatherStat != null) {
                this.fatherStat = null;
                oldFatherStat.removeFromSubStats(this);
            }
            this.fatherStat = fatherStat;
            this.firePropertyChange("fatherStat", oldFatherStat, fatherStat);
            if (fatherStat != null) {
                fatherStat.addToSubStats(this);
            }
            this.createNoText();
        }
    }

    public boolean hasInSubStats(UMLCollabStat elem) {
        return this.subStats.contains(elem);
    }

    public Enumeration elementsOfSubStats() {
        return new EnumerationForAnIterator(this.iteratorOfSubStats());
    }

    public Iterator iteratorOfSubStats() {
        return this.subStats.iterator();
    }

    public int sizeOfSubStats() {
        return this.subStats.size();
    }

    public UMLCollabStat getLastOfSubStats() {
        return this.subStats.isEmpty() ? null : (UMLCollabStat)this.subStats.getLast();
    }

    public void addToSubStats(UMLCollabStat elem) {
        if (elem != null && !this.hasInSubStats(elem)) {
            this.subStats.add(elem);
            elem.setFatherStat(this);
            this.firePropertyChange(CollectionChangeEvent.get((Object)this, "subStats", (Object)this.subStats, null, (Object)elem, this.subStats.size() - 1, 1));
        }
    }

    public void addFirstToSubStats(UMLCollabStat elem) {
        if (elem != null && !this.hasInSubStats(elem)) {
            this.subStats.addFirst(elem);
            elem.setFatherStat(this);
            this.firePropertyChange(CollectionChangeEvent.get((Object)this, "subStats", (Object)this.subStats, null, (Object)elem, 0, 1));
        }
    }

    public int indexOfSubStats(UMLCollabStat elem) {
        return this.subStats.indexOf(elem);
    }

    public void removeFromSubStats(UMLCollabStat elem) {
        int index = this.subStats.indexOf(elem);
        if (index > -1) {
            this.subStats.remove(index);
            elem.setFatherStat(null);
            this.firePropertyChange(CollectionChangeEvent.get((Object)this, "subStats", (Object)this.subStats, (Object)elem, null, index, 2));
        }
    }

    public void removeAllFromSubStats() {
        Iterator iter = this.iteratorOfSubStats();
        while (iter.hasNext()) {
            UMLCollabStat item = (UMLCollabStat)iter.next();
            item.setFatherStat(null);
            this.firePropertyChange(CollectionChangeEvent.get((Object)this, "subStats", (Object)this.subStats, (Object)item, null, 0, 2));
        }
    }

    public UMLCollabStat getPrevFromPreorderEnum() {
        UMLCollabStat prevPreorderStat = null;
        UMLCollabStat prevStat = this.getPrevCollabStat();
        if (prevStat != null) {
            prevPreorderStat = prevStat;
            while ((prevStat = prevStat.getLastOfSubStats()) != null) {
                prevPreorderStat = prevStat;
            }
        } else {
            prevPreorderStat = this.getFatherStat();
        }
        return prevPreorderStat;
    }

    public UMLCollabStat getNextFromPreorderEnum() {
        if (this.sizeOfSubStats() > 0) {
            return (UMLCollabStat)this.subStats.getFirst();
        }
        return this.getNextFromPreorderEnum(this.getNextCollabStat());
    }

    private UMLCollabStat getNextFromPreorderEnum(UMLCollabStat collabStat) {
        if (collabStat == null && (collabStat = this.getFatherStat()) != null) {
            return collabStat.getNextFromPreorderEnum(collabStat.getNextCollabStat());
        }
        return collabStat;
    }

    public UMLCollabStat getPrevCollabStat() {
        UMLCollabStat prevStat = null;
        if (this.fatherStat != null && this != this.fatherStat.subStats.getFirst()) {
            int position = this.fatherStat.subStats.indexOf(this);
            prevStat = (UMLCollabStat)this.fatherStat.subStats.get(position - 1);
        }
        return prevStat;
    }

    public UMLCollabStat getNextCollabStat() {
        UMLCollabStat nextStat = null;
        if (this.fatherStat != null && this != this.fatherStat.subStats.getLast()) {
            int position = this.fatherStat.subStats.indexOf(this);
            nextStat = (UMLCollabStat)this.fatherStat.subStats.get(position + 1);
        }
        return nextStat;
    }

    public UMLCollabStat createSubStat(String path) {
        Matcher matcher = PATH_PATTERN.matcher(path = path.trim());
        if (matcher.matches()) {
            String subPath;
            int number = Integer.parseInt(matcher.group(1));
            String thread = matcher.group(2);
            if (thread != null && thread.length() == 0) {
                thread = null;
            }
            if ((subPath = matcher.group(3)) != null && subPath.length() > 0) {
                UMLCollabStat subStat = this.findSubStat(number, thread);
                if (subStat == null) {
                    subStat = this.createSubStat(number, thread);
                }
                return subStat.createSubStat(subPath);
            }
            return this.createSubStat(number, thread);
        }
        throw new IllegalArgumentException("Malformed sequence path expression: " + path);
    }

    protected UMLCollabStat createSubStat(int number, String thread) {
        UMLCollabStat newStat = new UMLCollabStat();
        newStat.setNumber(number);
        if (thread != null) {
            newStat.setThreadId(thread);
        }
        this.addToSubStats(newStat);
        return newStat;
    }

    public UMLCollabStat findSubStat(String path) {
        if (this.sizeOfSubStats() > 0) {
            Matcher matcher = PATH_PATTERN.matcher(path = path.trim());
            if (matcher.matches()) {
                int number = Integer.parseInt(matcher.group(1));
                String thread = matcher.group(2);
                if (thread != null && thread.length() == 0) {
                    thread = null;
                }
                String subPath = matcher.group(3);
                UMLCollabStat subStat = this.findSubStat(number, thread);
                if (subPath != null && subPath.length() > 0 && subStat != null) {
                    subStat = subStat.findSubStat(subPath);
                }
                return subStat;
            }
            throw new IllegalArgumentException("Malformed sequence path expression: " + path);
        }
        return null;
    }

    public UMLCollabStat findSubStat(int number, String thread) {
        Iterator iter = this.iteratorOfSubStats();
        while (iter.hasNext()) {
            UMLCollabStat collabStat = (UMLCollabStat)iter.next();
            if (collabStat.getNumber() != number || (thread != null || collabStat.getThreadId().length() != 0) && (thread == null || !thread.equals(collabStat.getThreadId()))) continue;
            return collabStat;
        }
        return null;
    }

    public boolean setDiag(UMLDiagram value) {
        boolean changed = false;
        if (this.diag != value) {
            UMLDiagram oldValue = this.diag;
            if (this.diag != null) {
                this.diag = null;
                oldValue.setCollabStat(null);
            }
            this.diag = value;
            this.firePropertyChange("diag", oldValue, value);
            if (value != null) {
                value.setCollabStat(this);
            }
            changed = true;
        }
        return changed;
    }

    public UMLDiagram getDiag() {
        return this.diag;
    }

    public void removeYou() {
        this.setDiag(null);
        this.setCallSource(null);
        this.setCallTarget(null);
        this.setMyPattern(null);
        this.setFatherStat(null);
        this.setMethod(null);
        this.removeAllFromSubStats();
        super.removeYou();
    }

    public FElement getParentElement() {
        if (this.getMyPattern() != null) {
            return this.getMyPattern();
        }
        return this.getFatherStat();
    }

    private void fireTextChange(String name, Object oldValue, Object newValue, String oldFullText) {
        if (!this.parsing) {
            this.text = null;
            this.firePropertyChange(name, oldValue, newValue);
            this.firePropertyChange("text", oldFullText, this.getText());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setText(String text) {
        if (UMLProject.isLoading()) {
            return;
        }
        String oldtext = this.getText();
        if (oldtext != null || text == null) {
            if (oldtext == null) return;
            if (oldtext.equals(text)) return;
        }
        this.parsing = true;
        try {
            String oldNoText = this.getNoText();
            String oldIfCondText = this.getIfCondText();
            String oldWhileLoopText = this.getWhileLoopText();
            String oldLoopVarName = this.getLoopVarName();
            UMLType oldAssignTgtType = this.getAssignTgtType();
            String oldAssignTgtText = this.getAssignTgtText();
            String oldCallText = this.getCallText();
            if (text.startsWith(":")) {
                text = "1" + text;
            }
            StringTokenizer tokens = new StringTokenizer(text, "[");
            String word = null;
            this.setIfCondText("");
            this.setWhileLoopText("");
            this.setLoopVarName("");
            this.setAssignTgtType(null);
            int i = tokens.countTokens();
            if (i > 1) {
                if (tokens.hasMoreElements()) {
                    word = tokens.nextToken();
                    this.setNoText(word.trim());
                }
                if (tokens.hasMoreElements()) {
                    word = tokens.nextToken("]");
                    if ((word = word.substring(1)).startsWith("while ")) {
                        this.setWhileLoopText(word.substring(6).trim());
                        this.setStatType(2);
                    } else {
                        this.setIfCondText(word.trim());
                        this.setStatType(1);
                    }
                }
                if (tokens.hasMoreElements()) {
                    tokens.nextToken(":");
                }
            } else if (tokens.hasMoreElements()) {
                word = tokens.nextToken(":");
                this.setNoText(word.trim());
            }
            if (tokens.hasMoreElements() && (word = tokens.nextToken("=").substring(1)).endsWith(":")) {
                word = word.substring(0, word.length() - 1);
            }
            if ((i = tokens.countTokens()) > 0) {
                String assignTxt = word.trim();
                int index = assignTxt.indexOf(" ");
                if (index > 0) {
                    this.setAssignTgtType(UMLProject.get().getTypeList().getFromTypes(assignTxt.substring(0, index)));
                    if (this.getAssignTgtType() != null) {
                        assignTxt = assignTxt.substring(index + 1);
                    }
                }
                this.setAssignTgtText(assignTxt);
                if (tokens.hasMoreElements()) {
                    word = tokens.nextToken();
                    this.setCallText(word.trim());
                }
            } else {
                this.setAssignTgtText("");
                this.setCallText(word.substring(1).trim());
            }
            this.text = null;
            this.firePropertyChange("noText", oldNoText, this.getNoText());
            this.firePropertyChange("ifCondText", oldIfCondText, this.getIfCondText());
            this.firePropertyChange("whileLoopText", oldWhileLoopText, this.getWhileLoopText());
            this.firePropertyChange("loopVarName", oldLoopVarName, this.getLoopVarName());
            this.firePropertyChange("assignTgtType", oldAssignTgtType, this.getAssignTgtType());
            this.firePropertyChange("assignTgtText", oldAssignTgtText, this.getAssignTgtText());
            this.firePropertyChange("callText", oldCallText, this.getCallText());
            String tmpNewText = this.getText();
            this.firePropertyChange("text", oldtext, tmpNewText);
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            this.parsing = false;
            throw throwable;
        }
        {
            Object var15_17 = null;
            this.parsing = false;
            return;
        }
    }

    public String getText() {
        if (this.text == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getNoText());
            buffer.append(this.getThreadId());
            String tmpString = this.getIfCondText();
            if (tmpString != null && tmpString.length() != 0) {
                buffer.append(" [");
                buffer.append(tmpString);
                buffer.append("]");
            }
            if ((tmpString = this.getWhileLoopText()) != null && tmpString.length() != 0) {
                buffer.append(" [while ");
                buffer.append(tmpString);
                buffer.append("]");
            }
            if ((tmpString = this.getLoopVarName()) != null && tmpString.length() != 0) {
                buffer.append(" [");
                buffer.append(tmpString);
                buffer.append(":=");
                buffer.append(this.getLoopStartVal());
                buffer.append("..");
                buffer.append(this.getLoopStopVal());
                buffer.append("]");
            }
            buffer.append(": ");
            tmpString = this.getAssignTgtText();
            if (tmpString != null && tmpString.length() != 0) {
                UMLType tmpType = this.getAssignTgtType();
                if (tmpType != null) {
                    buffer.append(tmpType.getName());
                    buffer.append(" ");
                }
                buffer.append(tmpString);
                buffer.append(" := ");
            }
            buffer.append(this.getCallText());
            this.text = buffer.toString();
        }
        return this.text;
    }

    public String toString() {
        return this.getText();
    }

    public UMLStoryPattern findStoryPattern() {
        UMLCollabStat fatherStat = this;
        UMLCollabStat lastFatherStat = this;
        do {
            lastFatherStat = fatherStat;
        } while ((fatherStat = fatherStat.getFatherStat()) != null);
        return lastFatherStat.getMyPattern();
    }

    public UMLCollabStat getRootFatherStat() {
        if (this.fatherStat == null) {
            return this;
        }
        return this.fatherStat.getRootFatherStat();
    }

    public void setMethod(UMLMethod value) {
        if (this.method != value) {
            UMLMethod oldValue = this.method;
            this.method = value;
            this.firePropertyChange("method", oldValue, value);
        }
    }

    public UMLMethod getMethod() {
        return this.method;
    }

    public void setExpanded(boolean value) {
        this.expanded = value;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setStatType(int value) {
        if (this.statType != value) {
            int oldValue = this.statType;
            this.statType = value;
            this.firePropertyChange("statType", oldValue, value);
        }
    }

    public int getStatType() {
        return this.statType;
    }

    public void autoNumber() {
        this.autoNumber(1);
    }

    private void autoNumber(int number) {
        int kidNo = 0;
        this.setNumber(number);
        Iterator iter = this.iteratorOfSubStats();
        while (iter.hasNext()) {
            UMLCollabStat kidStat = (UMLCollabStat)iter.next();
            kidStat.autoNumber(++kidNo);
        }
    }

    public void renumberCollabStats() {
        LinkedList stats = new LinkedList(this.subStats);
        Collections.sort(stats, new CollabStatLessThan());
        Iterator statIter = stats.iterator();
        this.removeAllFromSubStats();
        int lastNumber = 0;
        int oldNumberOfPrevious = -1;
        String threadOfPrevious = null;
        while (statIter.hasNext()) {
            UMLCollabStat aCollabStat = (UMLCollabStat)statIter.next();
            String thread = aCollabStat.getThreadId();
            if (thread != null && thread.length() > 0) {
                int number = aCollabStat.getNumber();
                if (threadOfPrevious == null || oldNumberOfPrevious != number) {
                    threadOfPrevious = thread;
                    oldNumberOfPrevious = number;
                    aCollabStat.setNumber(++lastNumber);
                } else {
                    threadOfPrevious = thread;
                    aCollabStat.setNumber(lastNumber);
                }
            } else {
                threadOfPrevious = null;
                aCollabStat.setNumber(++lastNumber);
            }
            this.addToSubStats(aCollabStat);
            aCollabStat.renumberCollabStats();
        }
    }

    public void setCutCopyPasteParent(FElement parent) {
        if (parent instanceof UMLStoryActivity) {
            UMLStoryActivity activity = (UMLStoryActivity)parent;
            this.removeAllFromDiagrams();
            activity.getStoryPattern().addToElements(this);
        } else {
            super.setCutCopyPasteParent(parent);
        }
    }

    protected boolean isPersistencyChange(PropertyChangeEvent e) {
        return super.isPersistencyChange(e) && !"noText".equals(e.getPropertyName()) && !"text".equals(e.getPropertyName());
    }

    private class CollabStatLessThan
    implements Comparator {
        CollabStatLessThan() {
        }

        public int compare(Object first, Object second) {
            if (first == second) {
                return 0;
            }
            if (first == null) {
                return Integer.MIN_VALUE;
            }
            if (second == null) {
                return Integer.MAX_VALUE;
            }
            UMLCollabStat stat1 = (UMLCollabStat)first;
            UMLCollabStat stat2 = (UMLCollabStat)second;
            int depth1 = stat1.getNoDepth();
            int depth2 = stat2.getNoDepth();
            UMLCollabStat ancestor1 = stat1;
            UMLCollabStat ancestor2 = stat2;
            int i = 0;
            while (i < depth1 - depth2) {
                ancestor1 = ancestor1.getFatherStat();
                ++i;
            }
            i = 0;
            while (i < depth2 - depth1) {
                ancestor2 = ancestor2.getFatherStat();
                ++i;
            }
            if (ancestor1 == ancestor2) {
                return depth1 - depth2;
            }
            UMLCollabStat last1 = ancestor1;
            UMLCollabStat last2 = ancestor2;
            while (ancestor1 != ancestor2) {
                last1 = ancestor1;
                last2 = ancestor2;
                ancestor1 = ancestor1.getFatherStat();
                ancestor2 = ancestor2.getFatherStat();
            }
            int result = last1.getNumber() - last2.getNumber();
            if (result == 0 && (result = this.compareStr(last1.getThreadId(), last2.getThreadId())) == 0) {
                if (ancestor1 != null) {
                    int pos1 = ancestor1.indexOfSubStats(last1);
                    int pos2 = ancestor1.indexOfSubStats(last2);
                    result = pos1 - pos2;
                } else {
                    result = this.compareStr(stat1.getText(), stat2.getText());
                }
            }
            return result;
        }

        private final int compareStr(String str1, String str2) {
            if (str1 == str2) {
                return 0;
            }
            if (str1 == null) {
                return Integer.MIN_VALUE;
            }
            if (str2 == null) {
                return Integer.MAX_VALUE;
            }
            return str1.compareTo(str2);
        }
    }
}

