/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.metamodel.FConstraint;
import de.uni_paderborn.fujaba.metamodel.FModelDiagram;
import de.uni_paderborn.fujaba.packagediagrams.DiagramUsage;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLCollabStat;
import de.uni_paderborn.fujaba.uml.UMLConstraint;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.uni_paderborn.fujaba.uml.UMLTypeList;
import de.uni_paderborn.fujaba.uml.unparse.UMLUnparseGetter;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.fca.FPropTreeSet;
import de.upb.tools.fca.FTreeSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JOptionPane;

public abstract class UMLDiagram
extends ASGDiagram
implements FModelDiagram {
    public static final String ELEMENTKEY = "items";
    public static final String PROPERTY_NAME = "name";
    private String name;
    private FPropTreeSet constraints;
    private UMLCollabStat collabStat;
    private FHashSet views;

    public UMLDiagram() {
    }

    protected UMLDiagram(boolean coobraPersistent) {
        super(coobraPersistent);
    }

    public UMLDiagram(String name, UMLProject project) {
        this.setName(name);
        this.setProject(project);
    }

    protected String createUnparseModuleName() {
        return UMLUnparseGetter.getUnparseModuleName(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name == null && name != null || this.name != null && !this.name.equals(name)) {
            String oldValue = this.name;
            this.name = name;
            this.firePropertyChange(PROPERTY_NAME, oldValue, name);
            Iterator usages = this.iteratorOfUsages();
            while (usages.hasNext()) {
                DiagramUsage currentUsage = (DiagramUsage)usages.next();
                if (currentUsage == null || currentUsage.getName().equals(this.name)) continue;
                currentUsage.setName(this.name);
            }
        }
    }

    public int getSizeOfItems() {
        return this.sizeOfElements();
    }

    public int sizeOfItems() {
        return this.sizeOfElements();
    }

    public boolean hasInItems(UMLDiagramItem item) {
        return this.hasInElements(item);
    }

    public Iterator iteratorOfItems() {
        return this.iteratorOfElements();
    }

    public boolean removeFromItems(ASGElement item) {
        return this.removeFromElements(item);
    }

    public boolean addToElements(ASGElement element) {
        boolean changed = super.addToElements(element);
        if (changed) {
            if (element instanceof UMLClass && ((UMLType)((Object)element)).getName() != null && this.getProject() instanceof UMLProject) {
                UMLProject project = (UMLProject)this.getProject();
                UMLTypeList list = project.getTypeList();
                if (list == null) {
                    list = new UMLTypeList();
                    project.setTypeList(list);
                }
                list.addToTypes((UMLType)((Object)element));
            }
            Iterator iter = this.iteratorOfViews();
            while (iter.hasNext()) {
                ViewDiagram viewDiag = (ViewDiagram)iter.next();
                if (viewDiag.hasInElements(element)) continue;
                viewDiag.update();
            }
        }
        return changed;
    }

    public boolean addToItems(ASGElement item) {
        boolean changed = this.addToElements(item);
        if (changed) {
            if (item instanceof UMLClass && ((UMLType)((Object)item)).getName() != null && this.getProject() instanceof UMLProject) {
                UMLProject project = (UMLProject)this.getProject();
                UMLTypeList list = project.getTypeList();
                if (list == null) {
                    list = new UMLTypeList();
                    project.setTypeList(list);
                }
                list.addToTypes((UMLType)((Object)item));
            }
            Iterator iter = this.iteratorOfViews();
            while (iter.hasNext()) {
                ViewDiagram viewDiag = (ViewDiagram)iter.next();
                if (viewDiag.hasInElements(item)) continue;
                viewDiag.update();
            }
        }
        return changed;
    }

    public void addToElements(Map.Entry entry) {
        ASGElement item = (ASGElement)entry.getValue();
        this.addToElements(item);
    }

    protected void addToItems(Map.Entry entry) {
        UMLDiagramItem item = (UMLDiagramItem)entry.getValue();
        this.addToElements(item);
    }

    public boolean removeFromItems(UMLDiagramItem item) {
        boolean changed = this.removeFromItemsWithoutIncrementAge(item);
        return changed;
    }

    public void removeAllFromItems() {
        Iterator iter = this.iteratorOfItems();
        while (iter.hasNext()) {
            UMLDiagramItem item = (UMLDiagramItem)iter.next();
            this.removeFromElements(item);
        }
    }

    public String getElementKey() {
        return ELEMENTKEY;
    }

    public boolean removeFromItemsWithoutIncrementAge(ASGElement asgElement) {
        boolean changed = super.removeFromElements(asgElement);
        if (changed) {
            this.removeFromItemsViewSideEffects(asgElement);
        }
        return changed;
    }

    public boolean removeFromElementsWithSideEffects(ASGElement asgElement) {
        boolean changed = super.removeFromElements(asgElement);
        if (changed) {
            this.removeFromItemsViewSideEffects(asgElement);
        }
        return changed;
    }

    private void removeFromItemsViewSideEffects(ASGElement asgElement) {
        Iterator viewIter = null;
        viewIter = this.iteratorOfViews();
        while (viewIter.hasNext()) {
            ViewDiagram viewDiag = (ViewDiagram)viewIter.next();
            viewDiag.removeFromElements(asgElement);
        }
    }

    public boolean hasInConstraints(FConstraint value) {
        return this.constraints == null ? false : this.constraints.contains(value);
    }

    public Iterator iteratorOfConstraints() {
        return this.constraints == null ? FEmptyIterator.get() : this.constraints.iterator();
    }

    public int sizeOfConstraint() {
        return this.constraints == null ? 0 : this.constraints.size();
    }

    public boolean addToConstraints(FConstraint value) {
        boolean changed = false;
        if (value != null) {
            if (this.constraints == null) {
                this.constraints = new FPropTreeSet(this, "constraints");
            }
            if (changed = this.constraints.add(value)) {
                value.addToRevConstraint(this);
            }
        }
        return changed;
    }

    public boolean removeFromConstraints(FConstraint value) {
        boolean changed = false;
        if (this.constraints != null && value != null && (changed = this.constraints.remove(value))) {
            value.removeFromRevConstraint(this);
        }
        return changed;
    }

    public void removeAllFromConstraints() {
        Iterator iter = this.iteratorOfConstraints();
        while (iter.hasNext()) {
            UMLConstraint tmpValue = (UMLConstraint)iter.next();
            this.removeFromConstraints(tmpValue);
        }
    }

    public boolean setCollabStat(UMLCollabStat value) {
        boolean changed = false;
        if (this.collabStat != value) {
            if (this.collabStat != null) {
                UMLCollabStat oldValue = this.collabStat;
                this.collabStat = null;
                oldValue.setDiag(null);
            }
            this.collabStat = value;
            if (value != null) {
                value.setDiag(this);
            }
            changed = true;
        }
        return changed;
    }

    public UMLCollabStat getCollabStat() {
        return this.collabStat;
    }

    public void removeYou() {
        this.setCollabStat(null);
        this.removeAllFromViews();
        this.removeAllFromUsages();
        super.removeYou();
    }

    public boolean addToViews(ViewDiagram value) {
        boolean changed = false;
        if (value != null) {
            if (this.views == null) {
                this.views = new FHashSet();
            }
            if (changed = this.views.add(value)) {
                value.setDiagram(this);
            }
        }
        return changed;
    }

    public boolean hasInViews(ViewDiagram value) {
        return this.views != null && value != null && this.views.contains(value);
    }

    public Iterator iteratorOfViews() {
        return this.views == null ? FEmptyIterator.get() : this.views.iterator();
    }

    public int sizeOfViews() {
        return this.views == null ? 0 : this.views.size();
    }

    public boolean removeFromViews(ViewDiagram value) {
        boolean changed = false;
        if (this.views != null && value != null && (changed = this.views.remove(value))) {
            value.removeYou();
        }
        return changed;
    }

    public void removeAllFromViews() {
        Iterator iter = this.iteratorOfViews();
        while (iter.hasNext()) {
            ViewDiagram tmpValue = (ViewDiagram)iter.next();
            this.removeFromViews(tmpValue);
        }
    }

    public ViewDiagram getViewByName(String name) {
        ViewDiagram viewDiagram = null;
        if (name != null) {
            Iterator iter = this.iteratorOfViews();
            while (iter.hasNext() && viewDiagram == null) {
                ViewDiagram view = (ViewDiagram)iter.next();
                if (!name.equals(view.getName())) continue;
                viewDiagram = view;
            }
        }
        return viewDiagram;
    }

    public void delete() {
        FTreeSet itemsToDelete = new FTreeSet();
        Iterator elementsIter = null;
        elementsIter = this.iteratorOfElements();
        while (elementsIter.hasNext()) {
            Object obj = elementsIter.next();
            if (!(obj instanceof UMLDiagramItem)) continue;
            UMLDiagramItem item = (UMLDiagramItem)obj;
            Iterator diagsIter = item.iteratorOfDiagrams();
            boolean containedInOtherDiagram = false;
            while (!containedInOtherDiagram && diagsIter.hasNext()) {
                ASGDiagram tmpDiag = (ASGDiagram)diagsIter.next();
                if (tmpDiag == this || tmpDiag instanceof ViewDiagram) continue;
                containedInOtherDiagram = true;
            }
            if (containedInOtherDiagram) continue;
            itemsToDelete.add(item);
        }
        boolean deleteAnyway = true;
        int itemsToDeleteSize = itemsToDelete.size();
        if (itemsToDeleteSize > 0) {
            String itemSizeString = String.valueOf(itemsToDeleteSize);
            itemSizeString = itemsToDeleteSize == 1 ? String.valueOf(itemSizeString) + " item" : String.valueOf(itemSizeString) + " items";
            int answer = JOptionPane.showConfirmDialog(FrameMain.get(), String.valueOf(itemSizeString) + " in diagram '" + this + "' are not contained in other diagrams.\n" + "If you delete the diagram these items will be deleted from the project as well.\n" + "Before deleting the diagram, you may clean it up by selecting\n" + "'Edit Class Diagram ...' from the diagrams context-menu\n" + "\nDo you really want to delete the diagram?", "Delete diagram items", 0);
            boolean bl = deleteAnyway = answer == 0;
        }
        if (deleteAnyway) {
            Iterator itemsToDeleteIter = itemsToDelete.iterator();
            while (itemsToDeleteIter.hasNext()) {
                ((UMLDiagramItem)itemsToDeleteIter.next()).removeYou();
            }
            this.removeYou();
        }
    }
}

