/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.basic.RuntimeExceptionWithContext;
import de.uni_paderborn.fujaba.metamodel.FDiagramItem;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.Traversable;
import de.uni_paderborn.fujaba.uml.UMLAssoc;
import de.uni_paderborn.fujaba.uml.UMLCardinality;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLConnection;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.uml.UMLMultiLink;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLRole;
import de.uni_paderborn.fujaba.uml.UMLStoryActivity;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class UMLLink
extends UMLConnection
implements Traversable {
    private static final transient Logger log;
    public static final int NULL = 0;
    public static final int NEGATIVE = 1;
    public static final int OPTIONAL = 2;
    public static final int NONE = 0;
    public static final int CREATE = 2;
    public static final int DELETE = 1;
    public static final int P_CHECK = 0;
    public static final int P_TO_ONE = 1;
    public static final int P_CHECK_TO_MANY = 2;
    public static final int P_MULTILINK_CHECK = 3;
    public static final int P_MULTILINK_FIRST = 4;
    public static final int P_MULTILINK_LAST = 5;
    public static final int P_MULTILINK_BOUND_TO_UNBOUND = 6;
    public static final int P_MULTILINK_UNBOUND_TO_BOUND = 7;
    public static final int P_MULTILINK_ENTRY = 8;
    public static final int P_MULTILINK_PATH = 9;
    public static final int P_TO_MANY = 10;
    public static final int P_MULTILINK_ENTRY_OPTIONAL = 11;
    public static final int P_MULTILINK_PATH_OPTIONAL = 12;
    public static final int P_OPTIONAL = 20;
    public static final int P_OPTIONAL_CHECK = 20;
    public static final int P_OPTIONAL_TO_ONE = 21;
    public static final int P_OPTIONAL_TO_MANY = 22;
    public static final int P_SET = 40;
    public static final int P_NEGATIVE = 60;
    public static final int P_NONE = -1;
    public static final int SEARCH = 0;
    public static final int MODIFY = 1;
    public static final String VIA_ASGELEMENTREF_SUFFIX = " (via ASGElementRef)";
    private boolean isViaASGElementRef = false;
    private String name;
    private int type = 0;
    private int modifier = 0;
    private boolean totality = false;
    private String range;
    private UMLObject source;
    private UMLObject target;
    private transient UMLAssoc instanceOf;
    private UMLMultiLink revSourceLink;
    private UMLMultiLink revTargetLink;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.uml.UMLLink");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public UMLLink() {
    }

    public UMLLink(String name, int type, int modifier, String range, UMLObject source, UMLObject target, UMLAssoc instanceOf) {
        this.setName(name);
        this.setType(type);
        this.setModifier(modifier);
        this.setRange(range);
        this.setSource(source);
        this.setTarget(target);
        this.setInstanceOf(instanceOf);
    }

    public boolean getIsViaASGElementRef() {
        return this.isViaASGElementRef;
    }

    public void setIsViaASGElementRef(boolean value) {
        this.isViaASGElementRef = value;
    }

    public String getName() {
        if (this.name == null && this.instanceOf != null) {
            return this.instanceOf.getName();
        }
        return this.name;
    }

    public void setName(String name) {
        if (name == null || !name.equals(this.getName())) {
            String oldValue = this.name;
            this.name = name;
            this.firePropertyChange("name", oldValue, name);
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (type >= 0 && type <= 2) {
            int oldValue = this.type;
            this.type = type;
            this.firePropertyChange("type", oldValue, type);
        }
    }

    public int getModifier() {
        return this.modifier;
    }

    public void setModifier(int modifier) {
        int oldValue = this.modifier;
        this.modifier = modifier;
        this.firePropertyChange("modifier", oldValue, modifier);
    }

    public boolean getTotality() {
        return this.totality;
    }

    public void setTotality(boolean totality) {
        boolean oldValue = this.totality;
        this.totality = totality;
        this.firePropertyChange("totality", oldValue, totality);
    }

    public String getRange() {
        return this.range;
    }

    public void setRange(String range) {
        String oldValue = this.range;
        this.range = range;
        this.firePropertyChange("range", oldValue, range);
    }

    public UMLObject getSource() {
        return this.source;
    }

    public boolean setSource(UMLObject source) {
        boolean changed = false;
        if (this.source == null && source != null || this.source != null && !this.source.equals(source)) {
            UMLObject oldSource = this.source;
            UMLRole oldRole = this.getSourceRole();
            if (this.source != null) {
                this.source = null;
                oldSource.removeFromRevSource(this);
            }
            this.source = source;
            if (source != null) {
                source.addToRevSource(this);
            }
            this.firePropertyChange("source", oldSource, source);
            UMLRole newRole = this.getSourceRole();
            if (newRole != oldRole) {
                this.firePropertyChange("sourceRole", oldRole, newRole);
            }
            changed = true;
        }
        return changed;
    }

    public UMLObject getTarget() {
        return this.target;
    }

    public boolean setTarget(UMLObject target) {
        boolean changed = false;
        if (this.target == null && target != null || this.target != null && !this.target.equals(target)) {
            UMLObject oldTarget = this.target;
            UMLRole oldRole = this.getTargetRole();
            if (this.target != null) {
                this.target = null;
                oldTarget.removeFromRevTarget(this);
            }
            this.target = target;
            if (target != null) {
                target.addToRevTarget(this);
            }
            this.firePropertyChange("target", oldTarget, target);
            UMLRole newRole = this.getTargetRole();
            if (newRole != oldRole) {
                this.firePropertyChange("targetRole", oldRole, newRole);
            }
            changed = true;
        }
        return changed;
    }

    public void setInstanceOf(UMLAssoc instanceOf) {
        if (this.instanceOf != instanceOf) {
            UMLAssoc oldInstanceOf = this.instanceOf;
            if (this.instanceOf != null) {
                this.instanceOf = null;
                oldInstanceOf.removeFromInstances(this);
            }
            this.instanceOf = instanceOf;
            if (instanceOf != null) {
                instanceOf.addToInstances(this);
            }
            this.firePropertyChange("instanceOf", oldInstanceOf, instanceOf);
            if (instanceOf != null) {
                this.setName(null);
            }
        }
    }

    public UMLAssoc getInstanceOf() {
        return this.instanceOf;
    }

    public void setRevSourceLink(UMLMultiLink revSourceLink) {
        if (this.revSourceLink != revSourceLink) {
            UMLMultiLink oldRevSourceLink = this.revSourceLink;
            if (this.revSourceLink != null) {
                this.revSourceLink = null;
                oldRevSourceLink.setSourceLink(null);
            }
            this.revSourceLink = revSourceLink;
            if (revSourceLink != null) {
                revSourceLink.setSourceLink(this);
            }
            this.firePropertyChange("revSourceLink", oldRevSourceLink, revSourceLink);
        }
    }

    public UMLMultiLink getRevSourceLink() {
        return this.revSourceLink;
    }

    public void setRevTargetLink(UMLMultiLink revTargetLink) {
        if (this.revTargetLink != revTargetLink) {
            UMLMultiLink oldRevTargetLink = this.revTargetLink;
            if (this.revTargetLink != null) {
                this.revTargetLink = null;
                oldRevTargetLink.setTargetLink(null);
            }
            this.revTargetLink = revTargetLink;
            if (revTargetLink != null) {
                revTargetLink.setTargetLink(this);
            }
            this.firePropertyChange("revTargetLink", oldRevTargetLink, revTargetLink);
        }
    }

    public UMLMultiLink getRevTargetLink() {
        return this.revTargetLink;
    }

    public UMLLink getSuccessorLink(TreeMap objectsMap) {
        UMLLink succLink = null;
        UMLObject source = (UMLObject)objectsMap.get(this.getSource());
        UMLObject target = (UMLObject)objectsMap.get(this.getTarget());
        if (source != null && target != null && this.getModifier() != 1) {
            succLink = new UMLLink(this.getName(), this.getType(), 0, this.getRange(), source, target, this.getInstanceOf());
        }
        return succLink;
    }

    public boolean isReference() {
        UMLAssoc instOf = this.getInstanceOf();
        if (instOf != null) {
            return instOf.getLeftRole() != null && instOf.getLeftRole().getAdornment() == 3 || instOf.getRightRole() != null && instOf.getRightRole().getAdornment() == 3;
        }
        return false;
    }

    public boolean isNavigable(UMLObject source) {
        return this.getCorrespondingRole(source).getAdornment() != 3;
    }

    private int getTargetsUpperBound(UMLObject target) {
        UMLClass objectInstance = null;
        if (target != null) {
            objectInstance = target.getInstanceOf();
        }
        if (objectInstance == null) {
            throw new RuntimeExceptionWithContext("UMLObject has no UMLClass: " + target, (FElement)target);
        }
        UMLAssoc linkInstance = this.getInstanceOf();
        if (linkInstance == null) {
            throw new RuntimeExceptionWithContext("UMLLink has no UMLAssoc: " + this.getName(), (FElement)this);
        }
        UMLRole role = this.getCorrespondingRole(target);
        int card = 1;
        if (role != null && role.getCard() != null) {
            UMLCardinality cardinality = role.getCard();
            card = cardinality.getUpperBound();
        }
        return card;
    }

    public int getPriority(HashMap boundObjects, HashMap isomorphicBindings) {
        boolean targetIsoCheck;
        UMLObject sourceObject = boundObjects.get(this.getSource().getID()) == this.getSource() ? this.getSource() : this.getTarget();
        UMLObject targetObject = this.getTarget() == sourceObject ? this.getSource() : this.getTarget();
        int priority = -1;
        int type = this.getType();
        if (boundObjects.get(sourceObject.getID()) != sourceObject) {
            throw new RuntimeExceptionWithContext("The source object is not bound", (FElement)sourceObject);
        }
        if (this.isReference() && this.getSource() == targetObject && boundObjects.get(targetObject.getID()) != targetObject) {
            return -1;
        }
        boolean typeCastNeeded = !targetObject.getObjectType().equals(this.getCorrespondingRole(targetObject).getTarget().getName());
        boolean targetNegative = targetObject.isNegative();
        boolean targetBound = boundObjects.get(targetObject.getID()) != null;
        boolean boundSourceSet = sourceObject.isSet();
        int targetLinks = targetObject.sizeOfRevSource() + targetObject.sizeOfRevTarget();
        boolean targetObjectHasOutGoingLinks = targetLinks > 1;
        UMLClass targetClass = targetObject.getInstanceOf();
        String targetClassName = targetClass.getFullClassName();
        boolean bl = targetIsoCheck = !targetBound && isomorphicBindings.get(targetClassName) != null;
        if (type == 1 || targetNegative && !targetBound && !targetObject.isSet() && !targetObjectHasOutGoingLinks && !targetIsoCheck) {
            if (this.getRevSourceLink() != null || this.getRevTargetLink() != null) {
                priority = -1;
                return -1;
            }
            if (!targetBound && targetObjectHasOutGoingLinks && !targetNegative && !this.isReference()) {
                priority = -1;
                return -1;
            }
            if (!targetBound && !this.toOneAccess(this.getCorrespondingRole(targetObject)) && (targetObject.iteratorOfAttrs().hasNext() || typeCastNeeded) || boundSourceSet || boundSourceSet && targetBound) {
                if (targetNegative) {
                    priority = 22;
                    return 22;
                }
                priority = 2;
                return 2;
            }
            priority = 0;
            return 0;
        }
        if ((this.getModifier() == 2 && this.getType() != 2 || targetObject.getModifier() == 2 && targetObject.getType() != 1) && priority != 0) {
            return -1;
        }
        priority = 0;
        if (!boundObjects.containsValue(targetObject)) {
            priority = this.getTargetsUpperBound(targetObject) == 1 ? (this.getCorrespondingRole(sourceObject).getQualifier() != null && (this.getRange() == null || this.getRange().trim().equals("")) ? (priority += 10) : (!targetObject.isSet() ? ++priority : (priority += 10))) : (priority += 10);
        }
        if (targetObject.isOptional() || this.getType() == 2) {
            priority += 20;
        }
        if (targetObject.isSet() || sourceObject.isSet()) {
            priority += 40;
        }
        return priority;
    }

    public UMLObject getUnboundObject(HashMap boundObjects) {
        UMLObject source = (UMLObject)boundObjects.get(this.getSource().getID());
        UMLObject target = (UMLObject)boundObjects.get(this.getTarget().getID());
        if (source == null && target == null) {
            throw new RuntimeExceptionWithContext("Neither source nor target object is bound", (FElement)this);
        }
        if (source != null) {
            return this.getTarget();
        }
        if (target != null) {
            return this.getSource();
        }
        throw new RuntimeExceptionWithContext("This link is a checklink", (FElement)this);
    }

    public String getText() {
        return this.getName();
    }

    public int getAbsoluteModifier() {
        int result = this.getModifier() | this.getSource().getModifier() | this.getTarget().getModifier();
        if (result != 2 && result != 1 && result != 0) {
            throw new RuntimeExceptionWithContext("Error: Link " + this + " connects to a create and to a delete object", (FElement)this);
        }
        return result;
    }

    public boolean setSourceConnector(FDiagramItem incr) {
        if (!(incr instanceof UMLObject)) {
            throw new IllegalArgumentException("Argument is no UMLObject");
        }
        return this.setSource((UMLObject)incr);
    }

    public UMLDiagramItem getSourceConnector() {
        return this.getSource();
    }

    public boolean setTargetConnector(FDiagramItem incr) {
        if (!(incr instanceof UMLObject)) {
            throw new IllegalArgumentException("Argument is no UMLObject");
        }
        return this.setTarget((UMLObject)incr);
    }

    public UMLDiagramItem getTargetConnector() {
        return this.getTarget();
    }

    public boolean toOneAccess(UMLRole role) {
        return role.getCard() != null ? role.getCard().getUpperBound() == 1 && role.getPartnerRole().getQualifier() == null : true;
    }

    public boolean isLinkBetween(String firstObject, String secondObject) {
        return this.getSource().getObjectName().equals(firstObject) && this.getTarget().getObjectName().equals(secondObject) || this.getSource().getObjectName().equals(secondObject) && this.getTarget().getObjectName().equals(firstObject);
    }

    public UMLRole getCorrespondingRole(UMLObject object) {
        if (object == null || this.getSource() == null || this.getTarget() == null || this.getInstanceOf() == null) {
            return null;
        }
        UMLRole correspondingRole = null;
        UMLAssoc myAssoc = this.getInstanceOf();
        if (object == this.getSource()) {
            correspondingRole = myAssoc.getDirection() == 10 ? myAssoc.getLeftRole() : myAssoc.getRightRole();
        } else if (object == this.getTarget()) {
            if (myAssoc != null) {
                correspondingRole = myAssoc.getDirection() == 10 ? myAssoc.getRightRole() : myAssoc.getLeftRole();
            }
        } else {
            throw new IllegalArgumentException("UMLLink: UMLObject '" + object.getObjectName() + "' does not belong to UMLLink '" + this.getName() + "'");
        }
        return correspondingRole;
    }

    public UMLRole getSourceRole() {
        if (this.getSource() == null) {
            return null;
        }
        UMLRole role = null;
        try {
            role = this.getCorrespondingRole(this.getSource());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return role;
    }

    public UMLRole getTargetRole() {
        if (this.getTarget() == null) {
            return null;
        }
        UMLRole role = null;
        try {
            role = this.getCorrespondingRole(this.getTarget());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return role;
    }

    public boolean accessable(UMLObject object) {
        return !this.isReference() || this.getTarget() == object;
    }

    public static boolean checkSwap(UMLLink link) {
        boolean result = false;
        try {
            UMLAssoc assoc = link.getInstanceOf();
            if (assoc != null) {
                UMLClass assocTgtClass = assoc.getLeftRole().getTarget();
                UMLClass assocSrcClass = assoc.getRightRole().getTarget();
                UMLClass linkTgtClass = link.getTarget().getInstanceOf();
                UMLClass linkSrcClass = link.getSource().getInstanceOf();
                result = linkSrcClass.isChildOf(assocSrcClass);
                result &= linkTgtClass.isChildOf(assocTgtClass);
                result &= linkSrcClass.isChildOf(assocTgtClass);
                result &= linkTgtClass.isChildOf(assocSrcClass);
            }
        }
        catch (Exception e) {
            if (link != null) {
                log.debug((Object)"exception occured during checking swap. Link deleted.");
                e.printStackTrace();
                link.removeYou();
            }
            result = false;
        }
        return result;
    }

    public void removeYou() {
        this.setInstanceOf(null);
        this.setSource(null);
        this.setTarget(null);
        if (this.getRevSourceLink() != null) {
            this.getRevSourceLink().removeYou();
        }
        if (this.getRevTargetLink() != null) {
            this.getRevTargetLink().removeYou();
        }
        this.setRevSourceLink(null);
        this.setRevTargetLink(null);
        super.removeYou();
    }

    public boolean checkNegativeError(UMLObject sourceObject, UMLObject targetObject, int priority) {
        boolean sourceBound = sourceObject.isBound();
        boolean targetBound = targetObject.isBound();
        boolean targetOptional = targetObject.isOptional();
        boolean sourceNegative = sourceObject.isNegative();
        boolean targetNegative = targetObject.isNegative();
        boolean linkNegative = this.getType() == 1;
        boolean sourceHasUMLAttrExprPair = sourceObject.iteratorOfAttrs().hasNext();
        boolean targetHasUMLAttrExprPair = targetObject.iteratorOfAttrs().hasNext();
        boolean result = false;
        switch (priority) {
            case 0: 
            case 2: {
                if (!(sourceBound && sourceNegative && !sourceHasUMLAttrExprPair || targetBound && targetNegative && !targetHasUMLAttrExprPair || linkNegative && targetNegative && !targetBound) && (!targetOptional || !targetNegative || targetHasUMLAttrExprPair)) break;
                result = true;
                break;
            }
            case 1: 
            case 10: {
                if (!(sourceBound && sourceNegative && !sourceHasUMLAttrExprPair || targetBound && targetNegative && !targetHasUMLAttrExprPair) && !linkNegative) break;
                result = true;
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("UMLLink[name=");
        result.append(this.getName());
        result.append(",type=");
        result.append(this.getType());
        result.append(",modifier=");
        result.append(this.getModifier());
        result.append(",sourceObject=");
        result.append(this.getSource());
        result.append(",targetObject=");
        result.append(this.getTarget());
        result.append(",instanceof=");
        result.append(this.getInstanceOf());
        result.append("]");
        return result.toString();
    }

    public void setCutCopyPasteParent(FElement parent) {
        if (parent instanceof UMLStoryActivity) {
            UMLStoryActivity activity = (UMLStoryActivity)parent;
            this.removeAllFromDiagrams();
            activity.getStoryPattern().addToElements(this);
        } else {
            super.setCutCopyPasteParent(parent);
        }
    }

    protected boolean isPersistencyChange(PropertyChangeEvent e) {
        return super.isPersistencyChange(e) && !"sourceRole".equals(e.getPropertyName()) && !"targetRole".equals(e.getPropertyName());
    }
}

