/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.uml.UMLAssoc;
import de.uni_paderborn.fujaba.uml.UMLLink;
import de.uni_paderborn.fujaba.uml.UMLObject;
import java.util.TreeMap;

public class UMLLinkSet
extends UMLLink {
    public static final transient int FIRST = 0;
    public static final transient int LAST = 1;
    public static final transient int NEIGHBOUR = 2;
    public static final transient int NEXT = 3;
    public static final transient int ORDERED = 0;
    public static final transient int SORTED = 1;
    private int setType = 0;
    private UMLObject toSetObject;

    public UMLLinkSet() {
    }

    public UMLLinkSet(String name, int type, int modifier, String range, UMLObject source, UMLObject target, UMLAssoc instanceOf, int setType) {
        super(name, type, modifier, range, source, target, instanceOf);
        this.setSetType(setType);
    }

    public void setType(int type) {
        if (type >= 0 && type <= 3) {
            super.setType(type);
        }
    }

    public int getSetType() {
        return this.setType;
    }

    public void setSetType(int setType) {
        int oldValue = this.setType;
        this.setType = setType;
        this.firePropertyChange("setType", oldValue, setType);
    }

    public UMLObject getToSetObject() {
        return this.toSetObject;
    }

    public void setToSetObject(UMLObject toSetObject) {
        if (this.toSetObject != toSetObject) {
            UMLObject oldToSetObject = this.toSetObject;
            if (this.toSetObject != null) {
                this.toSetObject = null;
                oldToSetObject.removeFromRevToSetObject(this);
            }
            this.toSetObject = toSetObject;
            if (toSetObject != null) {
                toSetObject.addToRevToSetObject(this);
            }
            this.firePropertyChange("toSetObject", oldToSetObject, toSetObject);
        }
    }

    public UMLLinkSet getSuccessorLinkSet(TreeMap objectsMap) {
        UMLLinkSet succLinkSet = null;
        UMLObject source = (UMLObject)objectsMap.get(this.getSource());
        UMLObject target = (UMLObject)objectsMap.get(this.getTarget());
        UMLObject toSet = (UMLObject)objectsMap.get(this.getToSetObject());
        if (source != null && target != null && this.getModifier() != 1) {
            succLinkSet = new UMLLinkSet(this.getName(), this.getType(), 0, this.getRange(), source, target, this.getInstanceOf(), this.getSetType());
            succLinkSet.setToSetObject(toSet);
        }
        return succLinkSet;
    }

    public void removeYou() {
        this.setToSetObject(null);
        super.removeYou();
    }
}

