/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.FujabaApp;
import de.uni_paderborn.fujaba.app.Version;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.asg.ASGProject;
import de.uni_paderborn.fujaba.basic.BasicIncrement;
import de.uni_paderborn.fujaba.basic.ClassMap;
import de.uni_paderborn.fujaba.basic.FD;
import de.uni_paderborn.fujaba.basic.FileHistory;
import de.uni_paderborn.fujaba.basic.FujabaComparator;
import de.uni_paderborn.fujaba.basic.FujabaDebug;
import de.uni_paderborn.fujaba.basic.JavaFactory;
import de.uni_paderborn.fujaba.basic.KeyValuePair;
import de.uni_paderborn.fujaba.basic.RuntimeExceptionWithContext;
import de.uni_paderborn.fujaba.basic.SourceCodeFactory;
import de.uni_paderborn.fujaba.basic.TemplateManager;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FPackage;
import de.uni_paderborn.fujaba.metamodel.FProject;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.metamodel.FTypeList;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.uml.PluginData;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLBaseTypes;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLFile;
import de.uni_paderborn.fujaba.uml.UMLGeneralization;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLLink;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLPackage;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import de.uni_paderborn.fujaba.uml.UMLStoryPattern;
import de.uni_paderborn.fujaba.uml.UMLTransition;
import de.uni_paderborn.fujaba.uml.UMLTreeEnumeration;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.uni_paderborn.fujaba.uml.UMLTypeList;
import de.uni_paderborn.fujaba.uml.unparse.UMLUnparseGetter;
import de.upb.lib.plugins.PluginProperty;
import de.upb.tools.fca.FDuplicatedTreeMap;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.fca.FPropHashMap;
import de.upb.tools.fca.FPropTreeSet;
import de.upb.tools.fca.FTreeSet;
import de.upb.tools.pcs.CollectionChangeEvent;
import java.beans.PropertyChangeEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class UMLProject
extends ASGProject
implements FProject {
    private static final transient Logger log;
    public static final String PROPERTY_TYPE_LIST = "typeList";
    public static final String PROPERTY_FILES = "files";
    public static final transient int FILE_VERSION = 5;
    private static UMLProject theUMLProject;
    private File backupFile;
    private OutputStream backupStream;
    private UMLPackage rootPackage = null;
    private static transient SourceCodeFactory sourceCodeFactory;
    private transient File file = null;
    private String rootDir = "./generated";
    private String additionalClassPath = "";
    private String name = "Unnamed Project";
    private transient UMLIncrement clipboard = null;
    private FPropTreeSet files;
    private FPropHashMap references = null;
    private UMLTypeList typeList;
    private transient FrameMain gui = null;
    private transient boolean saved = true;
    private static transient boolean loading;
    private static Hashtable objectHashTable;
    private static int inconsistencyErrors;
    private UMLStereotypeManager stereotypeManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.uml.UMLProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        sourceCodeFactory = null;
        loading = false;
        objectHashTable = null;
        inconsistencyErrors = 0;
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    private UMLProject() {
        if (GeneralPreferences.get().isRecoverActivated() && FujabaChangeManager.getVMRepository() != null) {
            try {
                Date now = new Date();
                String time = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(now);
                int i = 0;
                do {
                    this.backupFile = new File("~tmp " + time + (i > 0 ? "_" + i++ : "") + ".cxri");
                } while (this.backupFile.exists());
                this.backupStream = new BufferedOutputStream(new FileOutputStream(this.backupFile));
                FujabaChangeManager.getVMRepository().store(this.backupStream, true);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isInitialized() {
        return theUMLProject != null;
    }

    public static UMLProject get() {
        if (theUMLProject == null) {
            UMLProject.setNewProject(FujabaChangeManager.getUMLProject());
            if (theUMLProject == null && !FujabaChangeManager.isInUndoRedo()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"creating a UMLProject in UMLProject.get() - should not happen!");
                }
                UMLProject.setNewProject(UMLProject.createPlainProject());
            }
        }
        return theUMLProject;
    }

    public static final void setNewProject(UMLProject newProject) {
        if (newProject != theUMLProject) {
            if (theUMLProject != null) {
                if (newProject != null) {
                    newProject.stereotypeManager = theUMLProject.getStereotypeManager();
                }
                theUMLProject.removeYou();
                theUMLProject = null;
            }
            theUMLProject = newProject;
            System.gc();
        }
    }

    public static final UMLProject createPlainProject() {
        UMLProject project = new UMLProject();
        UMLProject.setNewProject(project);
        UMLTypeList typeList = new UMLTypeList();
        project.setTypeList(typeList);
        new UMLBaseTypes("Boolean", "boolean", typeList);
        new UMLBaseTypes("Character", "char", typeList);
        new UMLBaseTypes("String", "String", typeList);
        new UMLBaseTypes("Integer", "int", typeList);
        new UMLBaseTypes("Byte", "byte", typeList);
        new UMLBaseTypes("ShortInteger", "short", typeList);
        new UMLBaseTypes("LongInteger", "long", typeList);
        new UMLBaseTypes("Float", "float", typeList);
        new UMLBaseTypes("Double", "double", typeList);
        Iterator baseTypesIter = project.getTypeList().iteratorOfTypes();
        while (baseTypesIter.hasNext()) {
            UMLBaseTypes baseType = (UMLBaseTypes)baseTypesIter.next();
            String name = baseType.getName();
            if (name.endsWith("Array")) continue;
            new UMLBaseTypes(String.valueOf(name) + "Array", String.valueOf(baseType.getProgLangType()) + "[]", typeList);
        }
        new UMLBaseTypes("Void", "void", typeList);
        new UMLBaseTypes("constructor", "", typeList);
        new UMLBaseTypes("Initializer", "", typeList);
        project.setSaved(true);
        return project;
    }

    protected String createUnparseModuleName() {
        return UMLUnparseGetter.getUnparseModuleName(this);
    }

    public ASGElement searchID(String id) {
        ASGElement item = super.searchID(id);
        if (item != null) {
            return item;
        }
        item = this.getRootPackage().searchID(id);
        if (item != null) {
            return item;
        }
        if (this.getTypeList() != null && (item = this.getTypeList().searchID(id)) != null) {
            return item;
        }
        item = UMLStereotypeManager.get().searchID(id);
        return item;
    }

    public void setRootPackage(UMLPackage rootPackage) {
        if (this.rootPackage != rootPackage) {
            UMLPackage oldValue = this.rootPackage;
            if (oldValue != null && oldValue.sizeOfPackages() > 0) {
                log.error((Object)"Removed RootPackage with subpackages from project!");
            }
            this.rootPackage = rootPackage;
            this.firePropertyChange("rootPackage", oldValue, rootPackage);
        }
    }

    public UMLPackage getRootPackage() {
        if (this.rootPackage == null) {
            this.setRootPackage(new UMLPackage("RootPackage"));
        }
        return this.rootPackage;
    }

    public boolean hasInPackages(String key) {
        return key == null ? false : this.getFromPackages(key) != null;
    }

    public UMLPackage getFromPackages(String key) {
        StringTokenizer tokenizer = new StringTokenizer(key, ".");
        UMLPackage currentPackage = this.getRootPackage();
        while (tokenizer.hasMoreElements() && currentPackage != null) {
            String currentKey = tokenizer.nextToken();
            currentPackage = currentPackage.getFromPackages(currentKey);
        }
        return currentPackage;
    }

    public UMLPackage getNewFromPackages(String fullName) {
        return this.getNewFromPackages(fullName, !ASGElement.isInTransientMode());
    }

    public UMLPackage getNewFromPackages(String fullName, boolean coobraPersistent) {
        return this.findPackage(fullName, true, coobraPersistent);
    }

    public UMLPackage findPackage(String fullName) {
        return this.findPackage(fullName, false);
    }

    public UMLPackage findPackage(String fullName, boolean create) {
        return this.findPackage(fullName, create, true);
    }

    public UMLPackage findPackage(String fullName, boolean create, boolean coobraPersistent) {
        if (fullName == null) {
            return null;
        }
        UMLPackage tmpPackage = this.getFromPackages(fullName);
        if (tmpPackage == null && create) {
            tmpPackage = new UMLPackage(coobraPersistent);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating new Package: " + fullName));
            }
            this.addToPackages(tmpPackage, fullName);
        }
        return tmpPackage;
    }

    public UMLPackage getDefaultPackage() {
        return this.getRootPackage();
    }

    public Iterator iteratorOfPackages() {
        return this.getRootPackage().iteratorOfPackages();
    }

    public static String getPackageOfFullQualifiedType(String type) {
        String result = "";
        if (type != null && !type.equals("")) {
            int theDot;
            String outerClass = UMLProject.getOutestClassOfFullQualifiedType(type);
            if ("".equals(outerClass)) {
                outerClass = type;
            }
            if ((theDot = type.lastIndexOf(46)) > 0) {
                result = type.substring(0, theDot);
            }
        }
        return result;
    }

    public static String getOutestClassOfFullQualifiedType(String type) {
        String result = UMLProject.getOuterClassOfFullQualifiedType(type);
        if (result == null || "".equals(result)) {
            return result;
        }
        int firstDollarIndex = result.indexOf("$");
        if (firstDollarIndex > -1) {
            return result.substring(0, firstDollarIndex);
        }
        return result;
    }

    public static String getOuterClassOfFullQualifiedType(String type) {
        String result = "";
        if (type != null && !type.equals("")) {
            int dollar = type.lastIndexOf(36);
            if (dollar > -1) {
                result = type.substring(0, dollar);
            } else {
                String firstSegment;
                String firstChar;
                int theDot = type.indexOf(46);
                if (theDot > -1 && theDot != 0 && (firstChar = (firstSegment = type.substring(0, theDot)).substring(0, 1)).equals(firstChar.toUpperCase())) {
                    result = firstSegment;
                }
            }
        }
        return result;
    }

    public static String getTypeOfFullQualifiedType(String type) {
        String result = UMLProject.getOuterClassOfFullQualifiedType(type);
        result = result.length() > 0 ? type.substring(result.length() + 1) : UMLProject.removePackageFromFullQualifiedType(type);
        return result;
    }

    public static String removePackageFromFullQualifiedType(String type) {
        String result = UMLProject.getPackageOfFullQualifiedType(type);
        result = result.length() > 0 ? type.substring(result.length() + 1) : type;
        return result;
    }

    public void addToPackages(UMLPackage elem, String fullName) {
        if (elem == null || fullName == null) {
            throw new RuntimeExceptionWithContext("Cannot add an Element with key = null to an OrderedMap", (FElement)elem);
        }
        if (fullName.length() != 0 && !this.hasInPackages(fullName)) {
            StringTokenizer tokenizer = new StringTokenizer(fullName, ".");
            UMLPackage currentPackage = this.getRootPackage();
            UMLPackage parentOfCurrent = null;
            String currentKey = fullName;
            while (tokenizer.hasMoreElements() && currentPackage != null) {
                parentOfCurrent = currentPackage;
                currentKey = tokenizer.nextToken();
                if ((currentPackage = parentOfCurrent.getFromPackages(currentKey)) != null || !tokenizer.hasMoreElements()) continue;
                currentPackage = new UMLPackage(currentKey);
                currentPackage.setParent(parentOfCurrent);
            }
            if (currentPackage != null) {
                parentOfCurrent.removeFromPackages(currentPackage);
            }
            elem.setName(currentKey);
            parentOfCurrent.addToPackages(elem);
            this.firePropertyChange(CollectionChangeEvent.get((Object)this, "packages", (Object)parentOfCurrent, (Object)currentPackage, (Object)elem, fullName, 3));
        }
    }

    public void addToPackages(String fullName, UMLPackage pkg) {
        this.addToPackages(pkg, fullName);
    }

    public void removeAllPackages() {
        if (this.rootPackage != null) {
            this.rootPackage.removeYou();
            this.rootPackage = null;
        }
    }

    public static SourceCodeFactory getSourceCodeFactory() {
        if (sourceCodeFactory == null) {
            sourceCodeFactory = new JavaFactory();
        }
        return sourceCodeFactory;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (this.file == null && file != null || this.file != null && !this.file.equals(file)) {
            File oldValue = this.file;
            this.file = file;
            this.firePropertyChange("file", oldValue, file);
        }
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String rootDir) {
        if (this.rootDir == null && rootDir != null || this.rootDir != null && !this.rootDir.equals(rootDir)) {
            String oldValue = this.rootDir;
            this.rootDir = rootDir;
            this.firePropertyChange("rootDir", oldValue, rootDir);
        }
    }

    public String getAdditionalClassPath() {
        return this.additionalClassPath;
    }

    public void setAdditionalClassPath(String additionalClassPath) {
        if (this.additionalClassPath == null && additionalClassPath != null || this.additionalClassPath != null && !this.additionalClassPath.equals(additionalClassPath)) {
            String oldValue = this.additionalClassPath;
            this.additionalClassPath = additionalClassPath;
            this.firePropertyChange("additionalClassPath", oldValue, additionalClassPath);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name == null && name != null || this.name != null && !this.name.equals(name)) {
            String oldValue = this.name;
            this.name = name;
            this.firePropertyChange("name", oldValue, name);
        }
    }

    public UMLIncrement getClipboard() {
        return this.clipboard;
    }

    public void setClipboard(UMLIncrement clipboard) {
        if (this.clipboard == null && clipboard != null || this.clipboard != null && !this.clipboard.equals(clipboard)) {
            UMLIncrement oldValue = this.clipboard;
            this.clipboard = clipboard;
            this.firePropertyChange("clipboard", oldValue, clipboard);
        }
    }

    public boolean hasInFiles(UMLFile value) {
        return this.files != null && value != null && this.files.contains(value);
    }

    public boolean hasInFiles(String name) {
        return this.getFromFiles(name) != null;
    }

    public UMLFile getFromFiles(String name) {
        if (name != null) {
            UMLFile file = null;
            Iterator iter = this.iteratorOfFiles();
            while (iter.hasNext()) {
                file = (UMLFile)iter.next();
                if (!name.equals(file.getName())) continue;
                return file;
            }
        }
        return null;
    }

    public Iterator findFiles(String searchName) {
        if (searchName == null) {
            return FEmptyIterator.get();
        }
        FHashSet resultSet = new FHashSet();
        Iterator iter = this.iteratorOfFiles();
        while (iter.hasNext()) {
            UMLFile aFile = (UMLFile)iter.next();
            if (!searchName.equals(aFile.getName())) continue;
            resultSet.add(aFile);
        }
        return resultSet.iterator();
    }

    public void repairFiles() {
        Iterator patternIter = UMLProject.get().findFiles("Pattern");
        while (patternIter.hasNext()) {
            UMLFile element = (UMLFile)patternIter.next();
            element.removeYouAndMyClasses();
        }
        FHashMap seenFiles = new FHashMap();
        Iterator iter = this.iteratorOfFiles();
        while (iter.hasNext()) {
            UMLFile aFile = (UMLFile)iter.next();
            if (aFile.sizeOfContains() <= 0) {
                aFile.removeYou();
                continue;
            }
            UMLClass aClass = (UMLClass)aFile.iteratorOfContains().next();
            if (!aFile.getName().equals(aClass.getName()) && log.isInfoEnabled()) {
                log.info((Object)("class and file name differ " + aFile.getName()));
            }
            if (aFile.getName().startsWith("_@")) {
                aFile.removeYouAndMyClasses();
                continue;
            }
            UMLFile oldFile = (UMLFile)seenFiles.get(aFile.getName());
            if (oldFile != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("I remove double file for reference class " + aFile.getName()));
                }
                aFile.removeYou();
                continue;
            }
            seenFiles.put(aFile.getName(), aFile);
        }
    }

    public Iterator iteratorOfFiles() {
        return this.files == null ? FEmptyIterator.get() : this.files.iterator();
    }

    public int sizeOfFiles() {
        return this.files == null ? 0 : this.files.size();
    }

    public boolean addToFiles(UMLFile value) {
        boolean changed = false;
        if (value != null && !this.hasInFiles(value)) {
            if (this.files == null) {
                this.files = new FPropTreeSet(this, PROPERTY_FILES);
            }
            if (changed = this.files.add(value)) {
                value.setProject(this);
            }
        }
        return changed;
    }

    public void addToFiles(KeyValuePair pair) {
        if (pair == null) {
            return;
        }
        UMLFile elem = (UMLFile)pair.getValue();
        String key = (String)pair.getKey();
        if (elem != null && key != null) {
            elem.setName(key);
        }
        this.addToFiles(elem);
    }

    public boolean removeFromFiles(UMLFile value) {
        boolean changed = false;
        if (this.files != null && value != null && (changed = this.files.remove(value))) {
            value.setProject(null);
        }
        return changed;
    }

    public void removeAllFromFiles() {
        Iterator iter = this.iteratorOfFiles();
        while (iter.hasNext()) {
            UMLFile tmpValue = (UMLFile)iter.next();
            this.removeFromFiles(tmpValue);
        }
    }

    public boolean hasInBaseTypes(String key) {
        return key == null ? false : this.getTypeList().getFromTypes(key) instanceof UMLBaseTypes;
    }

    public UMLBaseTypes getFromBaseTypes(String key) {
        UMLType aType = this.getTypeList().getFromTypes(key);
        if (aType instanceof UMLBaseTypes) {
            return (UMLBaseTypes)aType;
        }
        return null;
    }

    public Enumeration elementsOfClasses() {
        UMLPackage uMLPackage = this.getRootPackage();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("de.uni_paderborn.fujaba.uml.UMLClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new UMLTreeEnumeration(uMLPackage, clazz, true);
    }

    public boolean hasInClasses(String fullClassName) {
        return this.getFromClasses(fullClassName) != null;
    }

    public boolean hasInClasses(UMLClass elem) {
        return elem == null ? false : this.hasInClasses(elem.getFullClassName());
    }

    public UMLClass getFromClasses(String fullClassName) {
        if (fullClassName != null) {
            Enumeration enumeration = this.elementsOfClasses();
            UMLClass current = null;
            while (enumeration.hasMoreElements()) {
                current = (UMLClass)enumeration.nextElement();
                if (!fullClassName.equals(current.getFullClassName())) continue;
                return current;
            }
        }
        return null;
    }

    public boolean hasInReferences(UMLClass obj) {
        return this.references != null && obj != null && obj.getFullClassName() != null && this.references.get(obj.getFullClassName()) == obj;
    }

    public boolean hasKeyInReferences(String key) {
        return this.references != null && key != null && this.references.containsKey(key);
    }

    public Iterator iteratorOfReferences() {
        return this.references == null ? FEmptyIterator.get() : this.references.values().iterator();
    }

    public Iterator keysOfReferences() {
        return this.references == null ? FEmptyIterator.get() : this.references.keySet().iterator();
    }

    public Iterator entriesOfReferences() {
        return this.references == null ? FEmptyIterator.get() : this.references.entrySet().iterator();
    }

    public int sizeOfReferences() {
        return this.references == null ? 0 : this.references.size();
    }

    public UMLClass getFromReferences(String key) {
        return this.references == null || key == null ? null : (UMLClass)this.references.get(key);
    }

    public boolean addToReferences(UMLClass obj) {
        boolean changed = false;
        if (!this.hasInReferences(obj)) {
            UMLClass oldValue;
            if (this.references == null) {
                this.references = new FPropHashMap(this, "references");
            }
            if ((oldValue = (UMLClass)this.references.put(obj.getFullClassName(), obj)) != obj) {
                if (oldValue != null) {
                    oldValue.setDeclaredInReferences(null);
                }
                obj.setDeclaredInReferences(this);
                changed = true;
            }
        }
        return changed;
    }

    public boolean removeFromReferences(UMLClass obj) {
        UMLClass oldValue;
        boolean changed = false;
        if (this.hasInReferences(obj) && (oldValue = (UMLClass)this.references.get(obj.getFullClassName())) == obj) {
            this.references.remove(obj.getFullClassName());
            obj.setDeclaredInReferences(null);
            changed = true;
        }
        return changed;
    }

    public boolean removeFromReferences(String key, UMLClass obj) {
        return this.removeFromReferences(obj);
    }

    public boolean removeKeyFromReferences(String key) {
        UMLClass tmpObj;
        boolean changed = false;
        if (this.hasKeyInReferences(key) && (tmpObj = (UMLClass)this.references.get(key)) != null) {
            this.references.remove(key);
            tmpObj.setDeclaredInReferences(null);
            changed = true;
        }
        return changed;
    }

    public void removeAllFromReferences() {
        Iterator iter = this.iteratorOfReferences();
        while (iter.hasNext()) {
            UMLClass tmpObj = (UMLClass)iter.next();
            this.removeFromReferences(tmpObj);
            tmpObj.removeYou();
        }
    }

    public void addToReferences(KeyValuePair pair) {
        if (pair == null) {
            return;
        }
        UMLClass elem = (UMLClass)pair.getValue();
        String key = (String)pair.getKey();
        this.addToReferences(key, elem);
    }

    public void addToReferences(String key, UMLClass value) {
        if (value != null && key != null && !FujabaChangeManager.isInUndoRedo()) {
            value.setName(key);
        }
        this.addToReferences(value);
    }

    public UMLType getOrNewType(UMLClass context, String name) {
        return this.getOrNewType(context, name, true);
    }

    public UMLType getOrNewType(UMLClass context, String name, boolean coobraPersistent) {
        return this.findType(context, name, true, coobraPersistent);
    }

    public UMLType findType(UMLClass context, String name) {
        return this.findType(context, name, false);
    }

    public UMLType findType(UMLClass context, String name, boolean create) {
        return this.findType(context, name, create, true);
    }

    public UMLType findType(UMLClass context, String name, boolean create, boolean coobraPersistent) {
        UMLBaseTypes result;
        String className = UMLProject.getTypeOfFullQualifiedType(name);
        if (className.equals(name) && (result = this.getFromBaseTypes(className)) != null) {
            return result;
        }
        return this.findClass(context, name, create, coobraPersistent);
    }

    public UMLClass getOrNewClass(String name) {
        return this.getOrNewClass(name, true);
    }

    public UMLClass getOrNewClass(String name, boolean coobraPersistent) {
        UMLClass theClass = this.getOrNewClass(null, name, coobraPersistent);
        theClass.removeKeyFromStereotypes("reference");
        theClass.getFile();
        return theClass;
    }

    public UMLClass getOrNewClass(UMLClass context, String name) {
        return this.getOrNewClass(context, name, true);
    }

    public UMLClass getOrNewClass(UMLClass context, String name, boolean coobraPersistent) {
        return this.findClass(context, name, true, coobraPersistent);
    }

    public UMLClass findClass(UMLClass context, String name) {
        return this.findClass(context, name, false);
    }

    public UMLClass findClass(UMLClass context, String name, boolean create) {
        return this.findClass(context, name, create, true);
    }

    public UMLClass findClass(UMLClass context, String name, boolean create, boolean coobraPersistent) {
        UMLPackage tmpPkg;
        UMLClass umlClass = null;
        String tmpName = UMLProject.getTypeOfFullQualifiedType(name);
        String outerClassName = UMLProject.getOuterClassOfFullQualifiedType(name);
        String packageName = UMLProject.getPackageOfFullQualifiedType(name);
        if (!outerClassName.equals("")) {
            UMLClass outerClass = this.findClass(null, outerClassName, create, coobraPersistent);
            if (outerClass != null) {
                umlClass = outerClass.getFromDeclares(tmpName);
            }
            if (umlClass == null) {
                umlClass = this.findReference(name, create, coobraPersistent);
            }
        } else if (!packageName.equals("")) {
            tmpPkg = this.findPackage(packageName, create, coobraPersistent);
            if (tmpPkg != null) {
                umlClass = tmpPkg.getFromDeclares(tmpName);
            }
            if (umlClass == null) {
                umlClass = this.findReference(name, create, coobraPersistent);
            }
        }
        if (umlClass == null && context != null && (umlClass = this.getClassFromImports(context, name)) == null && packageName.equals("") && outerClassName.equals("")) {
            tmpPkg = context.getDeclaredInPackage();
            if (name.equals("String") || name.equals("Integer") || name.equals("Object") || name.equals("Thread") || name.equals("Class") || name.equals("Double") || name.equals("Boolean") || name.equals("Float")) {
                tmpPkg = UMLProject.get().getNewFromPackages("java.lang");
            }
            if (tmpPkg != null) {
                String pkgName = tmpPkg.getFullPackageName();
                tmpName = pkgName.length() > 0 ? String.valueOf(pkgName) + "." + tmpName : tmpName;
                umlClass = this.findReference(tmpName, create, coobraPersistent);
            }
        }
        if (umlClass == null) {
            umlClass = this.getFromClasses(name);
        }
        if (umlClass == null) {
            umlClass = this.findReference(name, false, coobraPersistent);
        }
        if (umlClass == null && create) {
            umlClass = this.createClass(name, coobraPersistent, false);
        }
        return umlClass;
    }

    public Iterator iteratorOfAllUndefinedMethods() {
        TreeMap<String, UMLMethod> methodMap = new TreeMap<String, UMLMethod>();
        UMLMethod method = null;
        Iterator methodIter = null;
        String key = null;
        Iterator iter = this.iteratorOfReferences();
        while (iter.hasNext()) {
            UMLClass theClass = (UMLClass)iter.next();
            methodIter = theClass.iteratorOfUndefinedMethods();
            while (methodIter.hasNext()) {
                method = (UMLMethod)methodIter.next();
                key = String.valueOf(theClass.getName()) + ":" + method.getName();
                methodMap.put(key, method);
            }
        }
        Enumeration enumeration = this.elementsOfClasses();
        while (enumeration.hasMoreElements()) {
            UMLClass theClass = (UMLClass)enumeration.nextElement();
            methodIter = theClass.iteratorOfUndefinedMethods();
            while (methodIter.hasNext()) {
                method = (UMLMethod)methodIter.next();
                key = String.valueOf(theClass.getName()) + ":" + method.getName();
                methodMap.put(key, method);
            }
        }
        return methodMap.values().iterator();
    }

    public UMLClass getClassFromImports(UMLClass context, String name) {
        UMLFile contextFile;
        UMLPackage contextPackage;
        if (context == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ERROR: getClassFromImports called with null context");
            }
            FujabaDebug.printStackTrace(333);
            return null;
        }
        UMLClass umlClass = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching for:" + name));
        }
        if ((contextPackage = context.getDeclaredInPackage()) != null) {
            umlClass = contextPackage.getFromDeclares(name);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("ERROR: tried to analyse class without package: " + context.getName() + "\nThat should not happen"));
        }
        if (umlClass == null && (contextFile = context.getFile()) != null) {
            umlClass = contextFile.getClassFromImports(name);
        }
        if (umlClass != null) {
            String fullName = umlClass.getFullClassName();
            String outerClassName = UMLProject.getOuterClassOfFullQualifiedType(name);
            String packageName = UMLProject.getPackageOfFullQualifiedType(name);
            if (!outerClassName.equals("") && !outerClassName.equals(UMLProject.getOuterClassOfFullQualifiedType(fullName)) || !packageName.equals("") && !packageName.equals(UMLProject.getPackageOfFullQualifiedType(fullName))) {
                umlClass = null;
            }
        }
        return umlClass;
    }

    public UMLClass getOrNewFromReferences(String name) {
        return this.getOrNewFromReferences(name, true);
    }

    public UMLClass getOrNewFromReferences(String name, boolean coobraPersistent) {
        return this.findReference(name, true, coobraPersistent);
    }

    public UMLClass findReference(String name) {
        return this.findReference(name, false);
    }

    public UMLClass findReference(String name, boolean create) {
        return this.findReference(name, create, true);
    }

    public UMLClass findReference(String name, boolean create, boolean coobraPersistent) {
        UMLClass umlClass = this.getFromReferences(name);
        if (umlClass == null) {
            umlClass = this.getFromClasses(name);
        }
        if (umlClass == null && create) {
            umlClass = this.createClass(name, coobraPersistent, true);
        }
        return umlClass;
    }

    private UMLClass createClass(String name, boolean coobraPersistent, boolean reference) {
        UMLClass umlClass = new UMLClass(coobraPersistent);
        String parentClassName = UMLProject.getOuterClassOfFullQualifiedType(name);
        String packageName = UMLProject.getPackageOfFullQualifiedType(name);
        name = UMLProject.getTypeOfFullQualifiedType(name);
        umlClass.setName(name);
        umlClass.setRevTypes(this.getTypeList());
        if (reference) {
            umlClass.addToStereotypes(UMLStereotypeManager.get().getFromStereotypes("reference"));
        }
        if (!parentClassName.equals("")) {
            UMLClass tmpClz = this.getOrNewFromReferences(parentClassName, coobraPersistent);
            umlClass.setDeclaredInClass(tmpClz);
        } else if (!packageName.equals("")) {
            UMLPackage tmpPkg = this.getNewFromPackages(packageName, coobraPersistent);
            umlClass.setDeclaredInPackage(tmpPkg);
        } else if (reference) {
            this.addToReferences(umlClass);
        } else {
            umlClass.setDeclaredInPackage(this.getDefaultPackage());
        }
        return umlClass;
    }

    public void removeAllFromDiags() {
        Iterator diagIter = this.iteratorOfDiags();
        while (diagIter.hasNext()) {
            ASGDiagram diagram = (ASGDiagram)diagIter.next();
            if (diagram instanceof UMLDiagram) {
                UMLDiagram umlDiagram = (UMLDiagram)diagram;
                Iterator itemIter = umlDiagram.iteratorOfElements();
                while (itemIter.hasNext()) {
                    ASGElement element = (ASGElement)itemIter.next();
                    element.removeYou();
                }
            }
            this.removeFromDiags(diagram);
            diagram.removeYou();
        }
    }

    public UMLDiagram getFromDiags(String name) {
        ASGDiagram diag = UMLProject.retrieveDiagramByName(name);
        if (diag instanceof UMLDiagram) {
            return (UMLDiagram)diag;
        }
        return null;
    }

    public static ASGDiagram retrieveDiagramByName(String name) {
        ASGDiagram foundDiagram = null;
        Iterator iter = UMLProject.get().iteratorOfDiags();
        while (iter.hasNext() && foundDiagram == null) {
            ASGDiagram diagram = (ASGDiagram)iter.next();
            if (diagram.getName() == null || !diagram.getName().equals(name)) continue;
            foundDiagram = diagram;
        }
        return foundDiagram;
    }

    public UMLTypeList getTypeList() {
        return this.typeList;
    }

    public void setTypeList(UMLTypeList typeList) {
        if (this.typeList == null && typeList != null || this.typeList != null && !this.typeList.equals(typeList)) {
            UMLTypeList oldTypeList = this.typeList;
            if (this.typeList != null) {
                this.typeList = null;
                oldTypeList.setProject(null);
            }
            this.typeList = typeList;
            if (typeList != null) {
                typeList.setProject(this);
            }
            this.firePropertyChange(PROPERTY_TYPE_LIST, oldTypeList, typeList);
        }
    }

    public FrameMain getGui() {
        if (this.gui == null) {
            return FrameMain.get();
        }
        return this.gui;
    }

    public void setGui(FrameMain gui) {
        if (this.gui == null && gui != null || this.gui != null && !this.gui.equals(gui)) {
            FrameMain oldGui = this.gui;
            if (this.gui != null) {
                this.gui = null;
                oldGui.setUMLProject(null);
            }
            this.gui = gui;
            if (gui != null) {
                gui.setUMLProject(this);
            }
            this.firePropertyChange("gui", oldGui, gui);
        }
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        if (this.saved != saved) {
            boolean oldValue = this.saved;
            this.saved = saved;
            this.firePropertyChange("saved", oldValue, saved);
        }
    }

    private boolean createProjectBackup(File outputFile) {
        try {
            if (outputFile.exists()) {
                File newBackupFile = new File(outputFile.getCanonicalPath());
                String backupName = outputFile.getCanonicalPath();
                File oldBackupFile = new File(backupName = String.valueOf(backupName.substring(0, backupName.lastIndexOf(".fpr"))) + ".bak.fpr");
                if (!(!oldBackupFile.exists() || oldBackupFile.canWrite() && oldBackupFile.delete())) {
                    return JOptionPane.showConfirmDialog(UMLProject.get().getGui().getFrame(), "Not able to create a new project backup. \nBackup of project " + outputFile.getName() + "\n" + "exists and is write protected! \n" + "Continue anyway?", "Save project", 0, 0) == 0;
                }
                newBackupFile.renameTo(new File(backupName));
                return true;
            }
            return true;
        }
        catch (Exception e) {
            return JOptionPane.showConfirmDialog(UMLProject.get().getGui().getFrame(), "Not able to create a new project backup. \n" + e.getMessage() + "\n\n" + "Continue anyway?", "Save project", 0, 0) == 0;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveProject(File outputFile) {
        boolean result = true;
        BufferedWriter fw = null;
        int objectTablePos = 0;
        int pluginTablePos = 0;
        StringBuffer outputData = new StringBuffer(131072);
        FTreeSet savedIncrements = new FTreeSet(FujabaComparator.getLessBasicIncr());
        if (GeneralPreferences.get().isCreateProjectBackup() && !this.createProjectBackup(outputFile)) {
            return false;
        }
        try {
            try {
                PluginProperty plugin = null;
                outputData.append("# Fujaba-Project-File (do not alter this file!!!)\n");
                outputData.append("# Filename: ").append(outputFile.getName()).append("\n");
                outputData.append("# Date    : ").append(new Date(System.currentTimeMillis()).toString()).append("\n");
                outputData.append("-;FileVersion;").append(Integer.toString(5)).append("\n");
                objectTablePos = outputData.length();
                pluginTablePos = outputData.length();
                outputData.append("# Object references\n");
                this.writeClassToStringBuffer(outputData, savedIncrements);
                StringBuffer objectTable = new StringBuffer(16384);
                Iterator iter = savedIncrements.iterator();
                objectTable.append("# HashTable of this File\n");
                objectTable.append("-;HashTableLength;");
                objectTable.append(Integer.toString(savedIncrements.size())).append("\n");
                StringBuffer pluginBuffer = new StringBuffer();
                pluginBuffer.append("# Used Fujaba core\n");
                pluginBuffer.append("$;The Fujaba kernel;fujaba.core;" + Version.get().getMajor() + ";" + Version.get().getMinor() + ";" + Version.get().getRevision() + "\n");
                pluginBuffer.append("# used plug-ins\n");
                Hashtable<String, PluginProperty> pluginHashtable = new Hashtable<String, PluginProperty>();
                while (true) {
                    block18: {
                        if (iter.hasNext()) break block18;
                        outputData.insert(pluginTablePos, (Object)pluginBuffer);
                        outputData.insert(objectTablePos + pluginBuffer.length(), (Object)objectTable);
                        fw = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(outputFile))));
                        fw.write(outputData.toString(), 0, outputData.length());
                        this.setSaved(true);
                        FileHistory.get().addToHistory(outputFile);
                        FileHistory.get().updateActions();
                        break;
                    }
                    BasicIncrement incr = (BasicIncrement)iter.next();
                    ClassLoader theLoader = incr.getClass().getClassLoader();
                    if (FujabaApp.getPersistencySupport().isPluginClassLoader(theLoader)) {
                        String loaderID = FujabaApp.getPersistencySupport().getClassLoaderKey(theLoader);
                        plugin = FujabaApp.getPersistencySupport().getPluginProperty(loaderID);
                        if (plugin == null) {
                            log.error((Object)("***\nCan not extract plug-in: " + loaderID + " from plug-in list.\n***"));
                            continue;
                        }
                        if (!pluginHashtable.containsKey(plugin.getPluginID())) {
                            pluginHashtable.put(plugin.getPluginID(), plugin);
                            pluginBuffer.append("$;" + plugin.getName() + ";" + plugin.getPluginID() + ";" + plugin.getMajor() + ";" + plugin.getMinor() + ";" + plugin.getBuildNumber() + "\n");
                        }
                        objectTable.append("+;").append(incr.getID()).append(";");
                        objectTable.append(incr.getClass().getName()).append(";");
                        objectTable.append(String.valueOf(plugin.getPluginID()) + "\n");
                        continue;
                    }
                    objectTable.append("+;").append(incr.getID()).append(";");
                    objectTable.append(incr.getClass().getName()).append(";");
                    objectTable.append("fujaba.core\n");
                }
            }
            catch (Exception e) {
                result = false;
                if (log.isInfoEnabled()) {
                    log.info((Object)e.getMessage());
                }
                e.printStackTrace();
                throw new RuntimeException("An error occured while writing the file " + outputFile.getName() + "\nMessage : " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            savedIncrements = null;
            BasicIncrement.resetClassInfos();
            System.gc();
            try {
                if (fw != null) {
                    fw.flush();
                    fw.close();
                }
                boolean wasSaved = this.isSaved();
                this.setFile(outputFile);
                this.setSaved(wasSaved);
                throw throwable;
            }
            catch (Exception e) {
                result = false;
                if (log.isInfoEnabled()) {
                    log.info((Object)(String.valueOf(e.getMessage()) + "\n" + outputData));
                }
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        {
            Object var16_19 = null;
            savedIncrements = null;
        }
        BasicIncrement.resetClassInfos();
        System.gc();
        try {}
        catch (Exception e) {
            result = false;
            if (log.isInfoEnabled()) {
                log.info((Object)(String.valueOf(e.getMessage()) + "\n" + outputData));
            }
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        if (fw != null) {
            fw.flush();
            fw.close();
        }
        boolean wasSaved = this.isSaved();
        this.setFile(outputFile);
        this.setSaved(wasSaved);
        return result;
    }

    private static final StringTokenizer createLineTokenizer(String line) {
        StringTokenizer st = new StringTokenizer(line, ";");
        st.nextToken();
        return st;
    }

    public static boolean isLoading() {
        return loading;
    }

    public static void setLoading(boolean flag) {
        loading = flag;
    }

    public static final UMLProject loadProject(File inputFile) {
        try {
            BufferedReader reader;
            try {
                reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(inputFile))), 32768);
            }
            catch (IOException e) {
                reader = new BufferedReader(new FileReader(inputFile), 32768);
            }
            UMLProject.loadProject(reader, inputFile.getName());
            UMLProject.get().setFile(inputFile);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null, "Could not open file: " + inputFile.getName(), "Load", 0);
        }
        return UMLProject.get();
    }

    public static Object getFromObjectHashTable(String id) {
        if (UMLProject.isLoading() && objectHashTable != null) {
            return objectHashTable.get(id);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final UMLProject loadProject(BufferedReader reader, String fileName) {
        UMLProject.setLoading(true);
        try {
            project = new UMLProject();
            UMLProject.setNewProject(project);
            currentIncr = null;
            line = null;
            className = null;
            objectHashTableLength = 0;
            lineNum = 0;
            objCount = 0;
            plugins = new Hashtable<String, PluginData>();
            attributeHashTable = new FDuplicatedTreeMap();
            notYetWarned = true;
            maxUniqueId = "0";
            if (UMLProject.log.isDebugEnabled()) {
                UMLProject.log.debug((Object)("loading project from file " + fileName));
            }
            try {
                try {
                    line = reader.readLine();
                    ++lineNum;
                    if (!line.startsWith("# Fujaba-Project-File")) {
                        throw new Exception("This is not a Fujaba project file");
                    }
lbl23:
                    // 13 sources

                    block21: while (reader.ready()) {
                        ++lineNum;
                        line = reader.readLine();
                        if (line == null) break;
                        lineTok = UMLProject.createLineTokenizer(line);
                        switch (line.charAt(0)) {
                            case '#': {
                                ** break;
                            }
                            case '$': {
                                if (line.charAt(1) != ';') {
                                    line = "$;" + line.substring(1, line.length());
                                    line = line.replace('?', ';');
                                    line = line.replace('#', ';');
                                    line = line.replace('%', ';');
                                    line = line.replace('\u00a7', ';');
                                }
                                token = UMLProject.createLineTokenizer(line);
                                name = token.nextToken();
                                pluginID = token.nextToken();
                                majorV = token.nextToken();
                                minorV = token.nextToken();
                                revision = "0";
                                if (!"fujaba.core".equals(pluginID)) {
                                    if (token.hasMoreTokens()) {
                                        revision = token.nextToken();
                                    }
                                    plugin = new PluginData(pluginID, name, new Integer(majorV), new Integer(minorV), new Integer(revision));
                                    plugins.put(pluginID, plugin);
                                    ** break;
                                }
                                version = Version.get();
                                neededMajor = new Integer(majorV);
                                neededMinor = new Integer(minorV);
                                neededRev = 0;
                                if (token.hasMoreTokens()) {
                                    neededRev = new Integer(token.nextToken());
                                }
                                if (neededMajor > version.getMajor()) {
                                    throw new RuntimeException("\nThe project file \"" + fileName + "\" needs Fujaba core version: " + neededMajor + "." + neededMinor + "." + neededRev + "\n" + "Available Fujaba core version: " + version.getVersion() + ".\n");
                                }
                                if (neededMajor != version.getMajor() || neededMinor <= version.getMinor()) continue block21;
                                throw new RuntimeException("\nThe project file \"" + fileName + "\" needs Fujaba core version: " + neededMajor + "." + neededMinor + "." + neededRev + "\n" + "Available Fujaba core version: " + version.getVersion() + ".\n");
                            }
                            case '-': {
                                variable = lineTok.nextToken();
                                if (variable.compareTo("FileVersion") == 0) {
                                    var6_13 = new Integer(lineTok.nextToken());
                                }
                                if (variable.compareTo("HashTableLength") != 0) ** break;
                                objectHashTableLength = new Integer(lineTok.nextToken());
                                UMLProject.objectHashTable = new Hashtable<K, V>(objectHashTableLength * 2);
                                if (!UMLProject.log.isDebugEnabled()) ** break;
                                UMLProject.log.debug((Object)("Hashtable created with length = " + String.valueOf(objectHashTableLength * 2)));
                                ** break;
                            }
                            case '+': {
                                if (UMLProject.objectHashTable == null) {
                                    throw new Exception("Hashtable entry found,\nbut there is no hashtable created yet!");
                                }
                                strg = lineTok.nextToken();
                                if (!strg.endsWith("]") && UMLProject.lessUniqueId(maxUniqueId, strg)) {
                                    maxUniqueId = strg;
                                }
                                className = lineTok.nextToken();
                                o = null;
                                if (!className.endsWith("UMLProject")) ** GOTO lbl82
                                o = UMLProject.get();
                                ** GOTO lbl114
lbl82:
                                // 1 sources

                                try {
                                    if (!lineTok.hasMoreTokens()) ** GOTO lbl100
                                    loaderID = lineTok.nextToken();
                                    if ("fujaba.core".equals(loaderID)) {
                                        o = ClassMap.get().forName(className).newInstance();
                                    } else {
                                        pluginData = (PluginData)plugins.get(loaderID);
                                        pluginID = pluginData.getId();
                                        plugin = FujabaApp.getPersistencySupport().getPluginProperty(pluginID);
                                        if (plugin == null) {
                                            neededPlugin = (PluginData)plugins.get(pluginID);
                                            throw new RuntimeException("Error: \"" + className + "\" could not be instantiated.\n" + "Plug-in \"" + neededPlugin.getName() + "\" version " + neededPlugin.getMajor() + "." + neededPlugin.getMinor() + "." + neededPlugin.getBuildNumber() + " is missing.\n" + "Please download and install the plug-in to load the project file: \"" + fileName + "\"");
                                        }
                                        if (plugin.getMajor() < pluginData.getMajor()) throw new RuntimeException("Error: \"" + className + "\" could not be instantiated.\n" + "Available major version is less than needed major version\n\n" + "\tNeeded Plug-In: \t \"" + pluginData.getName() + " version " + pluginData.getMajor() + "." + pluginData.getMinor() + "." + pluginData.getBuildNumber() + "\"\n\t" + "Available Plug-In: \t \"" + plugin.getName() + " version " + plugin.getMajor() + "." + plugin.getMinor() + "." + plugin.getBuildNumber() + "\"\n");
                                        if (plugin.getMajor() != pluginData.getMajor() || plugin.getMinor() < pluginData.getMinor()) {
                                            if (plugin.getMajor() <= pluginData.getMajor()) throw new RuntimeException("Error: \"" + className + "\" could not be instantiated.\n" + "Available minor version is less than needed minor version\n\n" + "\tNeeded Plug-In: \t \"" + pluginData.getName() + " version " + pluginData.getMajor() + "." + pluginData.getMinor() + "." + pluginData.getBuildNumber() + "\"\n\t" + "Available Plug-In: \t \"" + plugin.getName() + " version " + plugin.getMajor() + "." + plugin.getMinor() + "." + plugin.getBuildNumber() + "\"\n");
                                        }
                                        pluginClassLoader = FujabaApp.getPersistencySupport().getClassLoader(pluginID);
                                        o = pluginClassLoader.loadClass(className).newInstance();
                                    }
                                    ** GOTO lbl-1000
lbl100:
                                    // 1 sources

                                    o = UMLProject.loadPluginClass(className, plugins);
                                    if (o == null) {
                                        o = ClassMap.get().forName(className).newInstance();
                                    }
                                }
                                catch (Throwable var29_33) {
                                    var28_32 = null;
                                    if (o != null) throw var29_33;
                                    if (UMLProject.log.isInfoEnabled() == false) throw var29_33;
                                    UMLProject.log.info((Object)("ERROR in line " + lineNum + ": Could not execute\n   " + "Class.forName (" + className + ").newInstance (); \n" + "Perhaps class " + className + " has no standard (parameterless) constructor?"));
                                    throw var29_33;
                                }
                            }
lbl-1000:
                            // 3 sources

                            {
                                var28_32 = null;
                            }
                            if (o == null && UMLProject.log.isInfoEnabled()) {
                                UMLProject.log.info((Object)("ERROR in line " + lineNum + ": Could not execute\n   " + "Class.forName (" + className + ").newInstance (); \n" + "Perhaps class " + className + " has no standard (parameterless) constructor?"));
                            }
lbl114:
                            // 4 sources

                            if (o == null) ** break;
                            UMLProject.objectHashTable.put(strg, o);
                            ((BasicIncrement)o).setID(strg);
                            ** break;
                            case '*': {
                                if (notYetWarned) {
                                    if (UMLProject.objectHashTable.size() != objectHashTableLength) {
                                        if (UMLProject.log.isInfoEnabled()) {
                                            UMLProject.log.info((Object)"WARNING:Object reference found,");
                                        }
                                        if (UMLProject.log.isInfoEnabled()) {
                                            UMLProject.log.info((Object)"\nbut the hashtable is not complete!");
                                        }
                                    }
                                    if (UMLProject.log.isDebugEnabled()) {
                                        UMLProject.log.debug((Object)"Objects created, start filling: ... ");
                                    }
                                    UMLProject.setUniqueId(new StringBuffer(maxUniqueId));
                                    notYetWarned = false;
                                }
                                if (currentIncr != null) {
                                    currentIncr.readAttributes(UMLProject.objectHashTable, attributeHashTable);
                                    attributeHashTable.clear();
                                    if (UMLProject.log.isDebugEnabled() && ++objCount % 1000 == 0) {
                                        UMLProject.log.debug((Object)("objCount: " + objCount));
                                    }
                                }
                                currentIncr = (BasicIncrement)UMLProject.objectHashTable.get(lineTok.nextToken());
                                ** break;
                            }
                            case '~': {
                                if (currentIncr == null) {
                                    throw new Exception("Attribute reference found in " + line + ",\nbut no current increment is set!");
                                }
                                attributeHashTable.put(lineTok.nextToken(), lineTok);
                                continue block21;
                            }
                        }
                    }
                    if (currentIncr != null) {
                        currentIncr.readAttributes(UMLProject.objectHashTable, attributeHashTable);
                    }
                    if (UMLProject.log.isDebugEnabled()) {
                        UMLProject.log.debug((Object)"mark and refresh all increments");
                    }
                    objects = UMLProject.objectHashTable.elements();
                    UMLProject.inconsistencyErrors = 0;
                    while (true) {
                        block65: {
                            if (objects.hasMoreElements()) break block65;
                            if (UMLProject.inconsistencyErrors > 0 && UMLProject.log.isDebugEnabled()) {
                                UMLProject.log.debug((Object)(String.valueOf(UMLProject.inconsistencyErrors) + " inconsistency errors found"));
                            }
                            UMLProject.get().setSaved(true);
                            if (UMLProject.log.isDebugEnabled()) {
                                UMLProject.log.debug((Object)"Loading done.");
                            }
                            break;
                        }
                        tmpObject = objects.nextElement();
                        if (!(tmpObject instanceof ASGElement)) continue;
                        tmpItem = (ASGElement)tmpObject;
                        if (tmpItem instanceof UMLFile) {
                            tmpFile = (UMLFile)tmpItem;
                            if (tmpFile.sizeOfContains() == 0) {
                                UMLProject.inconsistencyRemoveObject(tmpFile);
                            }
                        } else if (tmpItem instanceof UMLParam && (tmpParam = (UMLParam)tmpItem).getRevParam() == null) {
                            UMLProject.inconsistencyRemoveObject(tmpParam);
                        }
                        if (tmpItem instanceof UMLObject || tmpItem instanceof UMLLink || tmpItem instanceof UMLTransition) {
                            if (tmpItem.sizeOfDiagrams() == 0) {
                                UMLProject.inconsistencyRemoveObject(tmpItem);
                            }
                            if (!(tmpItem instanceof UMLLink) || (tmpLink = (UMLLink)tmpItem).getSource() != null && tmpLink.getTarget() != null) continue;
                            UMLProject.inconsistencyRemoveObject(tmpLink);
                            continue;
                        }
                        if (tmpItem instanceof UMLGeneralization) {
                            tmpGeneralisation = (UMLGeneralization)tmpItem;
                            if (tmpGeneralisation.getSuperclass() != null && tmpGeneralisation.getSubclass() != null) continue;
                            UMLProject.inconsistencyRemoveObject(tmpGeneralisation);
                            continue;
                        }
                        if (tmpItem instanceof UMLAttr) {
                            tmpAttr = (UMLAttr)tmpItem;
                            if (tmpAttr.getParent() != null) continue;
                            UMLProject.inconsistencyRemoveObject(tmpAttr);
                            continue;
                        }
                        if (tmpItem instanceof UMLMethod) {
                            tmpMethod = (UMLMethod)tmpItem;
                            if (tmpMethod.getParent() != null) continue;
                            UMLProject.inconsistencyRemoveObject(tmpMethod);
                            continue;
                        }
                        if (tmpItem instanceof UMLClassDiagram) {
                            tmpDiagram = (UMLDiagram)tmpItem;
                            if (tmpDiagram.getProject() != null) continue;
                            UMLProject.inconsistencyRemoveObject(tmpDiagram);
                            continue;
                        }
                        if (tmpItem instanceof UMLStoryPattern) {
                            tmpPattern = (UMLStoryPattern)tmpItem;
                            if (tmpPattern.getRevStoryPattern() != null) continue;
                            UMLProject.inconsistencyRemoveObject(tmpPattern);
                            continue;
                        }
                        if (!(tmpItem instanceof UMLClass) || (tmpClass = (UMLClass)tmpItem).getName() != null && (tmpClass.getName() == null || !tmpClass.getID().equals(tmpClass.getName()))) continue;
                        UMLProject.inconsistencyRemoveObject(tmpClass);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("An error occured in line " + Integer.toString(lineNum) + "=" + line + "\nwhile reading the file " + fileName + "\nMessage: " + e);
                }
            }
            catch (Throwable var31_34) {
                var30_35 = null;
                try {
                    reader.close();
                    throw var31_34;
                }
                catch (Exception e) {
                    if (UMLProject.log.isInfoEnabled()) {
                        UMLProject.log.info((Object)("ERROR in line " + lineNum + ": Perhaps I could not execute\n   " + "Class.forName (" + className + ").newInstance (); \n" + "Perhaps class " + className + " has no standard (parameterless) constructor?"));
                    }
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
            }
            {
                var30_36 = null;
            }
            try {}
            catch (Exception e) {
                if (UMLProject.log.isInfoEnabled()) {
                    UMLProject.log.info((Object)("ERROR in line " + lineNum + ": Perhaps I could not execute\n   " + "Class.forName (" + className + ").newInstance (); \n" + "Perhaps class " + className + " has no standard (parameterless) constructor?"));
                }
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            reader.close();
            if (project != UMLProject.get()) {
                project.removeYou();
            }
            reader = null;
            System.gc();
            var35_39 = UMLProject.get();
            var33_40 = null;
        }
        catch (Throwable var34_42) {
            var33_41 = null;
            UMLProject.setLoading(false);
            UMLProject.objectHashTable = null;
            throw var34_42;
        }
        UMLProject.setLoading(false);
        UMLProject.objectHashTable = null;
        return var35_39;
    }

    private static Object loadPluginClass(String className, Hashtable plugins) throws Exception {
        Object o = null;
        boolean loaded = false;
        boolean wrongVersion = false;
        PluginProperty plugin = null;
        PluginData pluginData = null;
        Iterator pluginIter = plugins.values().iterator();
        while (pluginIter.hasNext() && !loaded) {
            try {
                pluginData = (PluginData)pluginIter.next();
                plugin = FujabaApp.getPersistencySupport().getPluginProperty(pluginData.getId());
                if (plugin == null) continue;
                ClassLoader pluginClassLoader = FujabaApp.getPersistencySupport().getClassLoader(plugin.getPluginID());
                o = pluginClassLoader.loadClass(className).newInstance();
                if (plugin.getMajor() == pluginData.getMajor() && plugin.getMinor() >= pluginData.getMinor() && plugin.getBuildNumber() >= pluginData.getBuildNumber()) {
                    loaded = true;
                    continue;
                }
                wrongVersion = true;
                throw new RuntimeException("Error: \"" + className + "\" could not be instantiated.\n" + "Wrong Plug-in version is available\n\n" + "\tNeeded Plug-In: \t \"" + pluginData.getName() + " version " + pluginData.getMajor() + "." + pluginData.getMinor() + "." + pluginData.getBuildNumber() + "\"\n\t" + "Available Plug-In: \t \"" + plugin.getName() + " version " + plugin.getMajor() + "." + plugin.getMinor() + "." + plugin.getBuildNumber() + "\"\n");
            }
            catch (Exception ex) {
                loaded = false;
                if (!wrongVersion) continue;
                throw ex;
            }
        }
        return o;
    }

    private static void inconsistencyRemoveObject(BasicIncrement incr) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)("Inconsistency found! remove object " + FD.toString(incr)));
        }
        incr.removeYou();
        ++inconsistencyErrors;
    }

    public UMLDiagram getCurrentUMLDiagram() {
        ASGDiagram diag = this.getCurrentDiagram();
        if (diag instanceof UMLDiagram) {
            return (UMLDiagram)diag;
        }
        return null;
    }

    public synchronized void refreshDisplay() {
        ASGDiagram currentDiagram = this.getCurrentDiagram();
        if (currentDiagram != null) {
            Iterator iter = currentDiagram.iteratorOfFsaObjects();
            while (iter.hasNext()) {
                FSAObject fsa = (FSAObject)iter.next();
                fsa.getJComponent().invalidate();
                fsa.getJComponent().repaint();
            }
        }
    }

    public void removeYou() {
        Iterator diagIt = this.iteratorOfDiags();
        while (diagIt.hasNext()) {
            ASGDiagram asgDiagram = (ASGDiagram)diagIt.next();
            Iterator fsaIt = asgDiagram.iteratorOfFsaObjects();
            while (fsaIt.hasNext()) {
                FSAObject fsa = (FSAObject)fsaIt.next();
                fsa.removeYou();
            }
        }
        this.removeAllFromDiags();
        UMLTypeList typeList = this.getTypeList();
        if (typeList != null) {
            this.setTypeList(null);
            typeList.removeYou();
        }
        this.removeAllFromReferences();
        this.removeAllPackages();
        this.setClipboard(null);
        this.removeAllFromFiles();
        this.setGui(null);
        BasicIncrement.resetClassInfos();
        BasicIncrement.resetFieldWriteMethods();
        TemplateManager.get().resetTemplates();
        super.removeYou();
        this.deleteBackupFile();
    }

    public void deleteBackupFile() {
        if (this.backupStream != null) {
            try {
                this.backupStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.backupStream = null;
        }
        if (this.backupFile != null && !this.backupFile.delete()) {
            log.error((Object)"failed to delete temporary backup file!");
        }
    }

    public UMLStereotypeManager getStereotypeManager() {
        if (this.stereotypeManager == null) {
            this.stereotypeManager = new UMLStereotypeManager();
            if (!UMLProject.isLoading() && !FujabaChangeManager.isInUndoRedo()) {
                this.stereotypeManager.initDefaultStereotypes();
            }
        }
        return this.stereotypeManager;
    }

    public void setRootPackage(FPackage rootPackage) {
        this.setRootPackage((UMLPackage)rootPackage);
    }

    public FPackage getFRootPackage() {
        return this.getRootPackage();
    }

    public FPackage findFPackage(String fullName, boolean create) {
        return this.findPackage(fullName, create);
    }

    public FPackage findFPackage(String fullName, boolean create, boolean coobraPersistent) {
        return this.findPackage(fullName, create, coobraPersistent);
    }

    public FPackage getNewFromFPackages(String fullName) {
        return this.getNewFromPackages(fullName);
    }

    public FPackage getNewFromFPackages(String fullName, boolean coobraPersistent) {
        return this.getNewFromPackages(fullName, coobraPersistent);
    }

    public FPackage findFPackage(String fullName) {
        return this.findPackage(fullName);
    }

    public FType getFromFBaseTypes(String key) {
        return this.getFromBaseTypes(key);
    }

    public FClass getFromFReferences(String key) {
        return this.getFromReferences(key);
    }

    public FType getOrNewFType(FClass context, String name) {
        return this.getOrNewType((UMLClass)context, name);
    }

    public FType getOrNewFType(FClass context, String name, boolean coobraPersistent) {
        return this.getOrNewType((UMLClass)context, name, coobraPersistent);
    }

    public FType findFType(FClass context, String name) {
        return this.findType((UMLClass)context, name);
    }

    public FType findFType(FClass context, String name, boolean create) {
        return this.findType((UMLClass)context, name, create);
    }

    public FType findFType(FClass context, String name, boolean create, boolean coobraPersistent) {
        return this.findType((UMLClass)context, name, create, coobraPersistent);
    }

    public FClass getOrNewFromFReferences(String name) {
        return this.getOrNewFromReferences(name);
    }

    public FClass getOrNewFromFReferences(String name, boolean coobraPersistent) {
        return this.getOrNewFromReferences(name, coobraPersistent);
    }

    public FClass findFReference(String name) {
        return this.findReference(name);
    }

    public FClass findFReference(String name, boolean create) {
        return this.findReference(name, create);
    }

    public FClass findFReference(String name, boolean create, boolean coobraPersistent) {
        return this.findReference(name, create, coobraPersistent);
    }

    public FTypeList getFTypeList() {
        return this.getTypeList();
    }

    public FClass getFClassFromImports(FClass context, String name) {
        return this.getClassFromImports((UMLClass)context, name);
    }

    protected boolean isPersistencyChange(PropertyChangeEvent e) {
        return super.isPersistencyChange(e) && !"saved".equals(e.getPropertyName()) && !"gui".equals(e.getPropertyName());
    }
}

