/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.metamodel.FStereotype;
import de.uni_paderborn.fujaba.metamodel.FStereotypeManager;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStereotype;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import java.util.Iterator;
import java.util.Vector;

public class UMLStereotypeManager
implements FStereotypeManager {
    public static final String TYPE = "type";
    public static final String INTERFACE = "interface";
    public static final String REFERENCE = "reference";
    public static final String IMPORT = "import";
    public static final String IMMUTABLE = "immutable";
    public static final String SINGLETON = "singleton";
    public static final String SQLPERSISTENT = "SQL persistent";
    public static final String OQLPERSISTENT = "OQL persistent";
    public static final String DATABASE = "database";
    public static final String OODATABASE = "OO database";
    public static final String SQLDATABASE = "SQL database";
    public static final String DBVERSANT = "VersantDB";
    public static final String FSA_UNPARSE_MODULE = "unparse module (FSA)";
    public static final String NAVIGABLE = "navigable";
    public static final String DTD_PERSISTENT = "persistent (DTD)";
    public static final String DTD_CHOICE = "choice (DTD)";
    public static final String DTD_MIXED = "mixed (DTD)";
    public static final String DTD_SEQUENCE = "sequence (DTD)";
    public static final String XML_PERSISTENT = "persistent (XML)";
    public static final String XML_CHOICE = "choice (XML)";
    public static final String XML_MIXED = "mixed (XML)";
    public static final String XML_SEQUENCE = "sequence (XML)";
    public static final String CONSISTENCYRULE = "consistency rule";
    public static final String SDLBLOCK = "block";
    public static final String SDLPROCESS = "process";
    public static final String SDLACTOR = "actor";
    public static final String CONTRACT = "contract";
    public static final String COMPONENT = "component";
    public static final String JAVA_BEAN_COMPONENT = "JavaBean";
    public static final String VIRTUAL_PATH = "Virtual Path";
    private FHashMap stereotypes;

    UMLStereotypeManager() {
    }

    public static UMLStereotypeManager get() {
        if (UMLProject.get() != null) {
            return UMLProject.get().getStereotypeManager();
        }
        return null;
    }

    public void initDefaultStereotypes() {
        this.initStereotype(INTERFACE);
        this.initStereotype(REFERENCE);
        this.initStereotype(TYPE);
        this.initStereotype(IMMUTABLE);
        this.initStereotype(SINGLETON);
        this.initStereotype(IMPORT);
        this.initStereotype(SQLPERSISTENT);
        this.initStereotype(OQLPERSISTENT);
        this.initStereotype(DATABASE);
        this.initStereotype(OODATABASE);
        this.initStereotype(SQLDATABASE);
        this.initStereotype(DBVERSANT);
        this.initStereotype(FSA_UNPARSE_MODULE);
        this.initStereotype(DTD_PERSISTENT);
        this.initStereotype(DTD_CHOICE);
        this.initStereotype(DTD_MIXED);
        this.initStereotype(DTD_SEQUENCE);
        this.initStereotype(XML_PERSISTENT);
        this.initStereotype(XML_CHOICE);
        this.initStereotype(XML_MIXED);
        this.initStereotype(XML_SEQUENCE);
        this.initStereotype(CONSISTENCYRULE);
        this.initStereotype(NAVIGABLE);
        this.initStereotype(SDLBLOCK);
        this.initStereotype(SDLPROCESS);
        this.initStereotype(SDLACTOR);
        this.initStereotype(JAVA_BEAN_COMPONENT);
        this.initStereotype(VIRTUAL_PATH);
    }

    private void initStereotype(String type) {
        if (!this.hasKeyInStereotypes(type)) {
            this.addToStereotypes(new UMLStereotype(type));
        }
    }

    public Iterator entriesOfBasicStereotypes() {
        Vector<UMLStereotype> vector = new Vector<UMLStereotype>();
        vector.add(this.getFromStereotypes(INTERFACE));
        vector.add(this.getFromStereotypes(REFERENCE));
        vector.add(this.getFromStereotypes(TYPE));
        vector.add(this.getFromStereotypes(JAVA_BEAN_COMPONENT));
        return vector.iterator();
    }

    public Iterator iteratorOfBasicStereotypes() {
        return this.entriesOfBasicStereotypes();
    }

    public boolean addToStereotypes(UMLStereotype value) {
        boolean changed = false;
        if (value != null) {
            if (this.stereotypes == null) {
                this.stereotypes = new FHashMap();
            }
            if (this.stereotypes.get(value.getText()) == null) {
                Object old = this.stereotypes.put(value.getText(), value);
                if (old != value) {
                    value.setUMLStereotypeManager(this);
                }
                changed = true;
            }
        }
        return changed;
    }

    public Iterator entriesOfStereotypes() {
        return this.stereotypes == null ? FEmptyIterator.get() : this.stereotypes.entrySet().iterator();
    }

    public UMLStereotype getFromStereotypes(String key) {
        UMLStereotype result = null;
        if (key != null) {
            if (this.stereotypes != null) {
                result = (UMLStereotype)this.stereotypes.get(key);
            }
            if (result == null) {
                result = new UMLStereotype(key);
                new Exception("Stereotypes should not be created on the fly here (especially not while loading) - ensure that they are created by explicit calls!").printStackTrace();
                this.addToStereotypes(result);
            }
        }
        return result;
    }

    public FStereotype getFromFStereotypes(String key) {
        return this.getFromStereotypes(key);
    }

    public boolean hasInStereotypes(FStereotype value) {
        return this.stereotypes != null && value != null && value.getText() != null && this.stereotypes.containsKey(value.getText());
    }

    public boolean hasKeyInStereotypes(String key) {
        return this.stereotypes != null && key != null && this.stereotypes.containsKey(key);
    }

    public Iterator iteratorOfStereotypes() {
        return this.stereotypes == null ? FEmptyIterator.get() : this.stereotypes.values().iterator();
    }

    public Iterator keysOfStereotypes() {
        return this.stereotypes == null ? FEmptyIterator.get() : this.stereotypes.keySet().iterator();
    }

    public void removeAllFromStereotypes() {
        Iterator iter = this.iteratorOfStereotypes();
        while (iter.hasNext()) {
            UMLStereotype tmpValue = (UMLStereotype)iter.next();
            this.removeFromStereotypes(tmpValue);
        }
    }

    public boolean removeFromStereotypes(FStereotype value) {
        Object oldValue;
        boolean changed = false;
        if (this.stereotypes != null && value != null && value.getText() != null && (oldValue = this.stereotypes.remove(value.getText())) != null) {
            ((UMLStereotype)value).setUMLStereotypeManager(null);
            changed = true;
            value.removeYou();
        }
        return changed;
    }

    public boolean removeFromStereotypes(String key) {
        Object value;
        boolean changed = false;
        if (this.stereotypes != null && key != null && (value = this.stereotypes.remove(key)) != null) {
            changed = true;
            ((UMLStereotype)value).setUMLStereotypeManager(null);
            ((UMLStereotype)value).removeYou();
        }
        return changed;
    }

    public int sizeOfStereotypes() {
        return this.stereotypes == null ? 0 : this.stereotypes.size();
    }

    public ASGElement searchID(String id) {
        Iterator iter = this.iteratorOfStereotypes();
        ASGElement elem = null;
        while (elem == null && iter.hasNext()) {
            elem = ((ASGElement)iter.next()).searchID(id);
        }
        return elem;
    }

    public void removeYou() {
        this.removeAllFromStereotypes();
    }
}

