/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml.actions;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.basic.FujabaDebug;
import de.uni_paderborn.fujaba.basic.ProcessEvent;
import de.uni_paderborn.fujaba.basic.ProcessListener;
import de.uni_paderborn.fujaba.basic.ProcessOutputViewer;
import de.uni_paderborn.fujaba.codegen.CodeGenFactory;
import de.uni_paderborn.fujaba.parser.Parser;
import de.uni_paderborn.fujaba.parser.ParserManager;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.texteditor.TextEditor;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLCommentary;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLFile;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStoryPattern;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class EditTextAction
extends AbstractAction
implements TextEditor.BufferOwner,
ProcessListener {
    private static final transient Logger log;
    private UMLIncrement umlIncr;
    private String temporaryFileName = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.uml.actions.EditTextAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void actionPerformed(ActionEvent event) {
        this.temporaryFileName = null;
        Object source = event.getSource();
        if (source instanceof Iterator) {
            Iterator iter = (Iterator)source;
            if (iter.hasNext()) {
                source = iter.next();
            }
        } else if (source instanceof String) {
            this.temporaryFileName = (String)source;
        }
        if (source instanceof UMLAttr) {
            source = ((UMLAttr)source).getParent();
        }
        if (source instanceof UMLParam) {
            source = ((UMLParam)source).getRevParam();
        }
        if (source instanceof UMLMethod) {
            source = ((UMLMethod)source).getParent();
        }
        if (source instanceof UMLClass) {
            source = ((UMLClass)source).getFile();
        }
        if (source instanceof UMLStoryPattern) {
            source = ((UMLStoryPattern)source).getRevStoryPattern();
        }
        if (source instanceof UMLActivity) {
            source = (UMLDiagram)((UMLActivity)source).iteratorOfDiagrams().next();
        }
        if (source instanceof UMLActivityDiagram && ((UMLActivityDiagram)source).getStartActivity() != null) {
            UMLMethod tmpUmlIncr = ((UMLActivityDiagram)source).getStartActivity().getSpec();
            source = tmpUmlIncr == null ? ((UMLActivityDiagram)source).getStartActivity().getRevStartOfStateChart() : tmpUmlIncr;
        }
        UMLIncrement increment = null;
        if (source instanceof UMLIncrement) {
            this.umlIncr = increment = (UMLIncrement)source;
        }
        if (increment != null || this.temporaryFileName != null) {
            try {
                if (GeneralPreferences.get().isUseExtEditor()) {
                    this.useExternalEditor(increment);
                } else {
                    this.useTextEditor(increment);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(FrameMain.get(), ex + "\n" + FujabaDebug.getStackTrace(ex, 0, 2), "Warning", 2);
            }
        }
    }

    public TextEditor.Buffer useTextEditor(UMLIncrement umlIncr) {
        TextEditor editor = TextEditor.get();
        String text = null;
        boolean lastWasDelimiter = true;
        if (umlIncr instanceof UMLCommentary) {
            text = ((UMLCommentary)umlIncr).getText();
        } else if (umlIncr != null) {
            text = CodeGenFactory.get().generateFElement(umlIncr).toString();
        } else if (this.temporaryFileName != null) {
            text = this.openTextFile(this.temporaryFileName);
        } else if (log.isInfoEnabled()) {
            log.info((Object)"nothing to do for this object???");
        }
        if (text != null) {
            TextEditor.Buffer buffer = editor.createBuffer(this);
            buffer.setSyntaxHighlightingEnabled(!(umlIncr instanceof UMLCommentary));
            StringTokenizer tokenizer = new StringTokenizer(text, "\n", true);
            while (tokenizer.hasMoreElements()) {
                String temp = (String)tokenizer.nextElement();
                if (temp.equals("\n")) {
                    if (lastWasDelimiter) {
                        buffer.addLine("");
                        continue;
                    }
                    lastWasDelimiter = true;
                    continue;
                }
                buffer.addLine(temp);
                lastWasDelimiter = false;
            }
            buffer.setDirty(false);
            buffer.setFilename("Fujaba");
            return buffer;
        }
        return null;
    }

    private void useExternalEditor(UMLIncrement umlIncr) {
        block10: {
            GeneralPreferences options = GeneralPreferences.get();
            String temporaryPath = options.getTemporaryFolder();
            String text = null;
            if (umlIncr instanceof UMLCommentary) {
                text = ((UMLCommentary)umlIncr).getText();
            } else if (umlIncr != null) {
                text = CodeGenFactory.get().generateFElement(umlIncr).toString();
            } else if (this.temporaryFileName != null) {
                text = this.openTextFile(this.temporaryFileName);
            } else if (log.isInfoEnabled()) {
                log.info((Object)"nothing to do for this object???");
            }
            File file = new File(new File(temporaryPath), "fujaba_" + new Date().getTime() + ".java");
            this.temporaryFileName = file.getAbsolutePath();
            try {
                OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(file));
                out.write(text);
                out.close();
                ProcessOutputViewer process = new ProcessOutputViewer();
                process.executeCommand(String.valueOf(options.getExternalEditor()) + " " + this.temporaryFileName);
            }
            catch (IOException e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Could not write " + this.temporaryFileName));
                }
                if (!log.isInfoEnabled()) break block10;
                log.info((Object)"Error while executing external Editor");
            }
        }
    }

    public void processFinished(ProcessEvent event) {
        try {
            String temp;
            BufferedReader in = new BufferedReader(new FileReader(this.temporaryFileName));
            PlainDocument doc = new PlainDocument();
            do {
                if ((temp = in.readLine()) == null) continue;
                doc.insertString(doc.getLength(), String.valueOf(temp) + "\n", null);
            } while (temp != null);
            EditTextAction.doParsing(this.umlIncr, doc.getText(0, doc.getLength()));
            new File(this.temporaryFileName).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void bufferSaved(TextEditor.Buffer buffer) {
        EditTextAction.doParsing(this.umlIncr, buffer.getText());
        UMLProject.get().refreshDisplay();
    }

    public String openTextFile(String fileName) {
        BufferedReader reader;
        String theFile;
        block6: {
            theFile = "";
            reader = null;
            try {
                reader = new BufferedReader(new FileReader(fileName));
            }
            catch (FileNotFoundException e) {
                if (!log.isInfoEnabled()) break block6;
                log.info((Object)("File " + this.temporaryFileName + " not found."));
            }
        }
        if (reader != null) {
            try {
                String currentLine;
                while ((currentLine = reader.readLine()) != null) {
                    theFile = String.valueOf(theFile) + currentLine + "\n";
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return theFile;
    }

    public static void doParsing(UMLIncrement incr, String text) {
        if (incr instanceof UMLCommentary) {
            ((UMLCommentary)incr).setText(text);
        } else if (incr instanceof UMLFile) {
            Parser parser = ParserManager.get().getCurrentParser();
            UMLFile thisFile = (UMLFile)incr;
            if (parser != null) {
                parser.parseCompilationUnit(thisFile.getName(), new StringReader(text));
            } else {
                log.error((Object)"EditTextAction has got no parser from the ParserManager!");
            }
        } else if (incr instanceof UMLMethod && log.isInfoEnabled()) {
            log.info((Object)("please parse method by clicking \"Parse method\" in its context menu" + incr));
        }
    }
}

