/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml.actions;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.asg.ASGUnparseInformation;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.uml.UMLLink;
import de.uni_paderborn.fujaba.uml.UMLLinkSet;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStoryActivity;
import de.uni_paderborn.fujaba.uml.UMLStoryPattern;
import de.uni_paderborn.fujaba.uml.actions.CreateSuccessorAbstractAction;
import java.util.Iterator;
import java.util.TreeMap;

public class LogicalStoryPatternAction
extends CreateSuccessorAbstractAction {
    public UMLActivity createNewActivity() {
        return this.createNewActivity(null);
    }

    public UMLActivity createNewActivity(UMLStoryActivity newActivity) {
        try {
            UMLStoryPattern newStoryPattern;
            UMLStoryPattern storyPattern = ((UMLStoryActivity)this.activity).getStoryPattern();
            if (newActivity == null) {
                newStoryPattern = new UMLStoryPattern("Successor of " + storyPattern.getName(), UMLProject.get(), 0, null);
                newActivity = new UMLStoryActivity(((UMLStoryActivity)this.activity).isForEach(), newStoryPattern);
            } else {
                newStoryPattern = newActivity.getStoryPattern();
            }
            TreeMap<UMLObject, UMLObject> succObjectMap = new TreeMap<UMLObject, UMLObject>();
            Iterator iter = storyPattern.iteratorOfObjects();
            while (iter.hasNext()) {
                UMLObject obj = (UMLObject)iter.next();
                UMLObject succObj = obj.getSuccessorObject();
                if (succObj == null) continue;
                succObjectMap.put(obj, succObj);
                this.copyLocations(obj, succObj, storyPattern, newStoryPattern);
                newStoryPattern.addToElements(succObj);
            }
            iter = storyPattern.iteratorOfElements();
            while (iter.hasNext()) {
                ASGElement tmpElement = (ASGElement)iter.next();
                UMLLink newItem = null;
                if (tmpElement instanceof UMLLink) {
                    newItem = ((UMLLink)tmpElement).getSuccessorLink(succObjectMap);
                }
                if (tmpElement instanceof UMLLinkSet) {
                    newItem = ((UMLLinkSet)tmpElement).getSuccessorLinkSet(succObjectMap);
                }
                if (newItem == null || !(tmpElement instanceof UMLDiagramItem)) continue;
                this.copyLocations((UMLDiagramItem)tmpElement, newItem, storyPattern, newStoryPattern);
                newStoryPattern.addToElements(newItem);
            }
            UMLProject.get().refreshDisplay();
            return newActivity;
        }
        catch (RuntimeException except) {
            except.printStackTrace();
            return null;
        }
    }

    private void copyLocations(UMLDiagramItem item, UMLDiagramItem newItem, UMLStoryPattern storyPattern, UMLStoryPattern newStoryPattern) {
        Iterator locIter = item.iteratorOfKeyFromUnparseInformations();
        while (locIter.hasNext()) {
            ASGElement key = (ASGElement)locIter.next();
            ASGUnparseInformation info = item.getFromUnparseInformations(key);
            if (key == item) {
                newItem.addToUnparseInformations(newItem, new ASGUnparseInformation(info));
                continue;
            }
            if (key == storyPattern) {
                newItem.addToUnparseInformations(newStoryPattern, new ASGUnparseInformation(info));
                continue;
            }
            newItem.addToUnparseInformations(key, new ASGUnparseInformation(info));
        }
    }
}

