/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml.actions;

import de.uni_paderborn.fujaba.app.action.UpdateProjectTreeAction;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.codegen.AccessorOOHandler;
import de.uni_paderborn.fujaba.codegen.CodeGenFactory;
import de.uni_paderborn.fujaba.codegen.CodeGenStrategyHandler;
import de.uni_paderborn.fujaba.codegen.UMLStatechartOOHandler;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLRole;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;

public class RemoveGeneratedMethodsAction
extends AbstractAction {
    public void actionPerformed(ActionEvent e) {
        Iterator iter = this.findClasses();
        while (iter.hasNext()) {
            UMLClass umlClass = (UMLClass)iter.next();
            this.removeGeneratedMethods(umlClass);
        }
        iter = this.findStatecharts();
        while (iter.hasNext()) {
            UMLActivityDiagram statechart = (UMLActivityDiagram)iter.next();
            this.removeStatechartMethods(statechart);
        }
        new UpdateProjectTreeAction().actionPerformed(null);
    }

    private void removeGeneratedMethods(UMLClass umlClass) {
        this.removeRemoveYouMethod(umlClass);
        this.removeRoleAccessors(umlClass);
        this.removeAttrAccessors(umlClass);
        this.removeOldStatechartMethods(umlClass);
    }

    private void removeAttrAccessors(UMLClass umlClass) {
        AccessorOOHandler handler = null;
        Iterator attrIter = umlClass.iteratorOfAttrs();
        if (attrIter.hasNext()) {
            UMLAttr attr = (UMLAttr)attrIter.next();
            handler = this.findAccessorOOHandler(attr);
            this.removeAttrAccessors(attr, handler);
            while (attrIter.hasNext()) {
                attr = (UMLAttr)attrIter.next();
                this.removeAttrAccessors(attr, handler);
            }
        }
    }

    private void removeAttrAccessors(UMLAttr attr, AccessorOOHandler handler) {
        if (handler != null) {
            handler.removeOldAccessors(attr);
        }
        Iterator accessors = attr.iteratorOfAccessMethods();
        while (accessors.hasNext()) {
            UMLMethod method = (UMLMethod)accessors.next();
            this.removeMethod(method);
        }
    }

    private void removeMethod(UMLMethod umlMethod) {
        UMLActivityDiagram activityDiag = umlMethod.getStoryDiagram();
        umlMethod.removeYou();
        if (activityDiag != null) {
            activityDiag.removeYou();
        }
    }

    private void removeRoleAccessors(UMLClass umlClass) {
        AccessorOOHandler handler = null;
        Iterator roleIter = umlClass.iteratorOfRoles();
        if (roleIter.hasNext()) {
            UMLRole role = (UMLRole)roleIter.next();
            handler = this.findAccessorOOHandler(role);
            this.removeRoleAccessors(role, handler);
            while (roleIter.hasNext()) {
                role = (UMLRole)roleIter.next();
                this.removeRoleAccessors(role, handler);
            }
        }
    }

    private void removeRoleAccessors(UMLRole role, AccessorOOHandler handler) {
        UMLAttr attr;
        if (handler != null) {
            handler.removeOldAccessors(role);
        }
        if ((attr = role.getAssociatedAttribute()) != null) {
            Iterator accessors = attr.iteratorOfAccessMethods();
            while (accessors.hasNext()) {
                UMLMethod method = (UMLMethod)accessors.next();
                this.removeMethod(method);
            }
            attr.removeYou();
        }
    }

    private AccessorOOHandler findAccessorOOHandler(ASGElement element) {
        Iterator iter = CodeGenFactory.get().getCurrentStrategy().iteratorOfHandlerChain();
        boolean done = false;
        while (!done && iter.hasNext()) {
            CodeGenStrategyHandler nextHandler = (CodeGenStrategyHandler)iter.next();
            if (!(nextHandler instanceof AccessorOOHandler) || !nextHandler.isResponsible((FElement)element)) continue;
            return (AccessorOOHandler)nextHandler;
        }
        return null;
    }

    private void removeRemoveYouMethod(UMLClass umlClass) {
        UMLMethod removeMethod = umlClass.getFromMethodsByShortName("removeYou");
        if (removeMethod != null) {
            this.removeMethod(removeMethod);
        }
    }

    private void removeStatechartMethods(UMLActivityDiagram statechart) {
        UMLStatechartOOHandler handler = this.findStatechartOOHandler(statechart);
        if (handler != null) {
            handler.removeGeneratedElements(statechart);
        }
    }

    private void removeOldStatechartMethods(UMLClass umlClass) {
        Pattern namePattern = Pattern.compile("^(?:entryAction\\d*.+|exitAction\\\\d*.+|initState[cC]hart|action\\d+For.+From.+To.+|after\\d+|alwaysTrue|doAction\\d+.+|waitForResultForEvent|notifyMe|when\\d+|guard\\d+For.+From.+To.+)$");
        Matcher matcher = namePattern.matcher("");
        Iterator methods = umlClass.iteratorOfMethods();
        while (methods.hasNext()) {
            UMLMethod umlMethod = (UMLMethod)methods.next();
            if (!umlMethod.isGenerated() && umlMethod.getDisplayLevel() > 0) continue;
            String name = umlMethod.getName();
            matcher.reset(name);
            if (!matcher.matches()) continue;
            this.removeMethod(umlMethod);
        }
    }

    private UMLStatechartOOHandler findStatechartOOHandler(UMLActivityDiagram statechart) {
        Iterator iter = CodeGenFactory.get().getCurrentStrategy().iteratorOfHandlerChain();
        boolean done = false;
        while (!done && iter.hasNext()) {
            CodeGenStrategyHandler nextHandler = (CodeGenStrategyHandler)iter.next();
            if (!(nextHandler instanceof UMLStatechartOOHandler) || !nextHandler.isResponsible((FElement)statechart)) continue;
            return (UMLStatechartOOHandler)nextHandler;
        }
        return null;
    }

    private Iterator findClasses() {
        HashSet<ASGElement> classes = new HashSet<ASGElement>();
        Iterator diagIter = UMLProject.get().iteratorOfDiags();
        while (diagIter.hasNext()) {
            ASGDiagram diag = (ASGDiagram)diagIter.next();
            if (!(diag instanceof UMLClassDiagram)) continue;
            UMLClassDiagram classDiag = (UMLClassDiagram)diag;
            Iterator elems = classDiag.iteratorOfElements();
            while (elems.hasNext()) {
                ASGElement elem = (ASGElement)elems.next();
                if (!(elem instanceof UMLClass)) continue;
                classes.add(elem);
            }
        }
        return classes.iterator();
    }

    private Iterator findStatecharts() {
        HashSet<ASGDiagram> statecharts = new HashSet<ASGDiagram>();
        Iterator diagIter = UMLProject.get().iteratorOfDiags();
        while (diagIter.hasNext()) {
            ASGDiagram diag = (ASGDiagram)diagIter.next();
            if (!(diag instanceof UMLActivityDiagram) || !((UMLActivityDiagram)diag).isStatechart()) continue;
            statecharts.add(diag);
        }
        return statecharts.iterator();
    }
}

