/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml.actions;

import de.uni_paderborn.fujaba.uml.UMLComplexState;
import de.uni_paderborn.fujaba.uml.UMLStatechart;
import de.uni_paderborn.fujaba.uml.UMLTransition;
import de.uni_paderborn.fujaba.uml.actions.InEvent;
import de.uni_paderborn.fujaba.uml.actions.NewStateAction;
import de.uni_paderborn.fujaba.uml.actions.OutEvent;
import de.uni_paderborn.fujaba.uml.actions.TraceItem;
import java.util.Iterator;
import java.util.LinkedList;

class Trace {
    private LinkedList items = new LinkedList();

    public Trace() {
    }

    public Trace(Trace t) {
        this.items = new LinkedList(t.items);
    }

    public String toString() {
        String result = "[";
        Iterator iter = this.items.iterator();
        while (iter.hasNext()) {
            result = String.valueOf(result) + iter.next();
            if (!iter.hasNext()) continue;
            result = String.valueOf(result) + ",\n ";
        }
        result = String.valueOf(result) + "]";
        return result;
    }

    public boolean isEmpty() {
        return this.items.size() == 0;
    }

    public int getSize() {
        return this.items.size();
    }

    public Iterator iteratorOfItems() {
        return this.items.iterator();
    }

    public TraceItem first() {
        return (TraceItem)this.items.get(0);
    }

    public void removeFirst() {
        this.items.remove(0);
    }

    public void appendItem(TraceItem item) {
        this.items.add(item);
    }

    public boolean matches(UMLComplexState state) {
        return this.matchremove(state, false);
    }

    public boolean remove(UMLComplexState state) {
        return this.matchremove(state, true);
    }

    private boolean matchremove(UMLComplexState state, boolean remove) {
        boolean result = false;
        if (state.hasDoAction()) {
            if (this.first() instanceof OutEvent && ((OutEvent)this.first()).getName().equals(state.getDoAction())) {
                if (remove) {
                    this.removeFirst();
                }
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    public boolean startsWith(UMLComplexState state) {
        boolean result = false;
        String doAction = state.getDoAction();
        if (doAction == null) {
            result = true;
        } else if (doAction.equals("")) {
            result = true;
        } else {
            TraceItem traceitem = this.first();
            if (traceitem.matchesAction(doAction)) {
                result = true;
                this.removeFirst();
            }
        }
        return result;
    }

    public boolean startsWith(UMLTransition transition) {
        boolean result = false;
        String event = transition.getEvent();
        if (event == null) {
            result = true;
        } else if (event.equals("")) {
            result = true;
        } else {
            TraceItem traceitem = this.first();
            if (traceitem.matchesEvent(event)) {
                result = true;
                this.removeFirst();
            }
        }
        return result;
    }

    public UMLTransition createTransition(UMLStatechart statechart, UMLComplexState source) {
        UMLTransition newTransition = null;
        InEvent inEvent = null;
        if (this.first() instanceof InEvent) {
            if (this.getLeavingTransitionHavingNoEvent(source) == null) {
                inEvent = (InEvent)this.first();
                this.removeFirst();
                newTransition = new UMLTransition();
                newTransition.setSource(source);
                newTransition.setEvent(inEvent.getName());
                statechart.addToElements(newTransition);
            }
        } else if (!this.hasLeavingTransitions(source)) {
            newTransition = new UMLTransition();
            newTransition.setSource(source);
            newTransition.setEvent("");
            statechart.addToElements(newTransition);
        }
        return newTransition;
    }

    public UMLTransition getLeavingTransitionHavingNoEvent(UMLComplexState state) {
        UMLTransition result = null;
        Iterator iter = state.iteratorOfExit();
        while (iter.hasNext() && result == null) {
            UMLTransition transition = (UMLTransition)iter.next();
            if (transition.hasEvent()) continue;
            result = transition;
        }
        return result;
    }

    public boolean hasLeavingTransitions(UMLComplexState state) {
        return state.sizeOfExit() > 0;
    }

    public UMLComplexState createState(UMLStatechart statechart) {
        UMLComplexState newState = NewStateAction.createState(statechart, "");
        if (this.first() instanceof OutEvent) {
            OutEvent outEvent = (OutEvent)this.first();
            this.removeFirst();
            newState.setDoAction(outEvent.getName());
        }
        statechart.addToElements(newState);
        return newState;
    }
}

