/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml.dialogs;

import de.uni_paderborn.fujaba.app.PanelColumnLayout;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLGeneralization;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLRole;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class MergeClassesDialog
extends JDialog {
    private JRadioButton radio1;
    private JRadioButton radio2;
    private UMLClass class1;
    private UMLClass class2;

    public MergeClassesDialog(JFrame f, UMLClass clazz1, UMLClass clazz2) {
        super(f, "Merge two selected classes", true);
        this.class1 = clazz1;
        this.class2 = clazz2;
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        JPanel mergePane = new JPanel();
        mergePane.setBorder(new TitledBorder("Merge Two Classes"));
        mergePane.setLayout(new PanelColumnLayout());
        JLabel label = new JLabel("Please select the new merged class");
        mergePane.add(label);
        this.radio1 = new JRadioButton(this.class1.getName());
        this.radio1.setSelected(true);
        this.radio2 = new JRadioButton(this.class2.getName());
        this.radio2.setSelected(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.radio1);
        group.add(this.radio2);
        mergePane.add(this.radio1);
        mergePane.add(this.radio2);
        container.add("Center", mergePane);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        JButton ok = new JButton("Merge");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MergeClassesDialog.this.OKPressed();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MergeClassesDialog.this.CancelPressed();
            }
        });
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        container.add("South", buttonPanel);
        this.getRootPane().setDefaultButton(ok);
        this.getContentPane().add(container);
        this.pack();
        this.centerDialog();
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        int y = (screenSize.height - size.height) / 2;
        int x = (screenSize.width - size.width) / 2;
        this.setLocation(x, y);
    }

    public void OKPressed() {
        UMLGeneralization general;
        UMLClass target;
        UMLClass source;
        if (this.radio1.isSelected()) {
            source = this.class2;
            target = this.class1;
        } else {
            source = this.class1;
            target = this.class2;
        }
        Enumeration enumRoles = source.elementsOfRoles();
        Enumeration enumSuperclass = source.elementsOfRevSubclass();
        Enumeration enumSubclass = source.elementsOfRevSuperclass();
        Iterator iter = source.iteratorOfAttrs();
        while (iter.hasNext()) {
            UMLAttr attr = (UMLAttr)iter.next();
            source.removeFromAttrs(attr);
            target.addToAttrs(attr);
        }
        iter = source.iteratorOfMethods();
        while (iter.hasNext()) {
            UMLMethod method = (UMLMethod)iter.next();
            source.removeFromMethods(method);
            target.addToMethods(method);
        }
        while (enumRoles.hasMoreElements()) {
            UMLRole role = (UMLRole)enumRoles.nextElement();
            role.setTarget(target);
        }
        while (enumSubclass.hasMoreElements()) {
            general = (UMLGeneralization)enumSubclass.nextElement();
            if (general.getSubclass() == target) {
                general.removeYou();
                continue;
            }
            general.setSuperclass(target);
        }
        while (enumSuperclass.hasMoreElements()) {
            general = (UMLGeneralization)enumSuperclass.nextElement();
            if (general.getSuperclass() == target) {
                general.removeYou();
                continue;
            }
            general.setSubclass(target);
        }
        source.removeYou();
        this.setVisible(false);
    }

    public void CancelPressed() {
        this.setVisible(false);
    }
}

