/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml.unparse;

import de.uni_paderborn.fujaba.fsa.FSALabel;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLStereotype;
import de.uni_paderborn.fujaba.uml.actions.EditStereotypesAction;
import de.uni_paderborn.lib.basic.ImageResourceManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public class StereotypeLabel
extends FSALabel {
    private static final transient Logger log;
    UMLIncrement increment;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.uml.unparse.StereotypeLabel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public StereotypeLabel(UMLIncrement incr, JComponent parentComponent) {
        super(incr, "stereotypes", parentComponent);
        this.increment = incr;
        this.updateTooltip();
        incr.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                StereotypeLabel.this.updateTooltip();
            }
        });
    }

    void updateTooltip() {
        StringBuffer tooltip = new StringBuffer();
        Iterator it = this.increment.iteratorOfStereotypes();
        while (it.hasNext()) {
            UMLStereotype stereotype = (UMLStereotype)it.next();
            if (tooltip.length() > 0) {
                tooltip.append(" ");
            }
            tooltip.append("<<");
            tooltip.append(stereotype.getText());
            tooltip.append(">>");
        }
        this.getJComponent().setToolTipText(tooltip.toString());
    }

    protected JComponent createJComponent() {
        ImageIcon icon = this.findStereotypesIcon();
        JLabel label = new JLabel(icon);
        if (icon == null) {
            label.setText(" (stereotypes)");
        }
        label.setOpaque(false);
        label.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    new EditStereotypesAction().actionPerformed(new ActionEvent(StereotypeLabel.this.increment, 1001, "click"));
                }
            }
        });
        return label;
    }

    private ImageIcon findStereotypesIcon() {
        URL iconurl = this.getClass().getClassLoader().getResource("de/uni_paderborn/fujaba/uml/images/Stereotypes.gif");
        if (iconurl != null) {
            ImageIcon icon = ImageResourceManager.get().getImageIcon(iconurl);
            return icon;
        }
        log.error((Object)"stereotypes icon not found.");
        return null;
    }
}

