/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml.unparse;

import de.uni_paderborn.fujaba.basic.FontContainer;
import de.uni_paderborn.fujaba.fsa.FSABendLine;
import de.uni_paderborn.fujaba.fsa.FSADirectionIndicator;
import de.uni_paderborn.fujaba.fsa.FSAGrab;
import de.uni_paderborn.fujaba.fsa.FSALabel;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.FSAPanel;
import de.uni_paderborn.fujaba.fsa.FSAPolyLine;
import de.uni_paderborn.fujaba.fsa.FSATextFieldLabel;
import de.uni_paderborn.fujaba.fsa.listener.AscendDescendMouseHandler;
import de.uni_paderborn.fujaba.fsa.listener.DoubleClickMouseListener;
import de.uni_paderborn.fujaba.fsa.listener.ForegroundHighlighter;
import de.uni_paderborn.fujaba.fsa.listener.GrabMouseListener;
import de.uni_paderborn.fujaba.fsa.listener.SelectionListenerHelper;
import de.uni_paderborn.fujaba.fsa.listener.SelectionMouseListener;
import de.uni_paderborn.fujaba.fsa.listener.SelectionPropagationListener;
import de.uni_paderborn.fujaba.fsa.listener.VisibilityHighlighter;
import de.uni_paderborn.fujaba.fsa.swing.JBendLine;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import de.uni_paderborn.fujaba.fsa.swing.JRectangle;
import de.uni_paderborn.fujaba.fsa.swing.JTextFieldLabel;
import de.uni_paderborn.fujaba.fsa.swing.LineDecoratorConstraints;
import de.uni_paderborn.fujaba.fsa.swing.LineStyle;
import de.uni_paderborn.fujaba.fsa.swing.PanelGrabUI;
import de.uni_paderborn.fujaba.fsa.swing.RoleLayout;
import de.uni_paderborn.fujaba.fsa.swing.border.CrossBorder;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.AbstractUpdater;
import de.uni_paderborn.fujaba.fsa.update.ColorToModifierTranslator;
import de.uni_paderborn.fujaba.fsa.update.LogicFsaTranslator;
import de.uni_paderborn.fujaba.fsa.update.LogicToFsaUpdater;
import de.uni_paderborn.fujaba.fsa.update.StringToModifierTranslator;
import de.uni_paderborn.fujaba.fsa.update.VisibilityUpdater;
import de.uni_paderborn.fujaba.layout.options.LayoutPreferences;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import de.uni_paderborn.fujaba.uml.UMLLink;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLRole;
import de.uni_paderborn.fujaba.uml.unparse.UMConnection;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class UMLink
extends UMConnection {
    public FSAObject create(FSAObject parent, LogicUnparseInterface incr) {
        UMLLink link = (UMLLink)incr;
        if (link != null) {
            FSAPolyLine line = (FSAPolyLine)super.create(parent, incr);
            line.setTransientProperties(false);
            JBendLine bendLine = (JBendLine)line.getJComponent();
            JComponent grabParent = (JComponent)bendLine.getParent();
            JGrab grab = this.createGrab(link, line, grabParent, "source", link.getSource());
            bendLine.setStartBend(grab);
            grab = this.createGrab(link, line, grabParent, "target", link.getTarget());
            bendLine.setEndBend(grab);
            FSAPanel textPanel = new FSAPanel(incr, "textPanel", bendLine);
            textPanel.setLayout(new FlowLayout(0, 0, 0));
            JComponent jTextPanel = textPanel.getJComponent();
            FSADirectionIndicator arrow = new FSADirectionIndicator(link, "arrow", jTextPanel);
            AbstractUpdater updater = new LogicToFsaUpdater();
            LogicFsaTranslator translator = new LogicFsaTranslator(line, 1);
            updater.setTranslator(translator);
            updater.setLogicAttrName("target");
            updater.setFsaAttrName("target");
            updater.setLogicObject(link);
            arrow.addToUpdater(updater);
            updater = new LogicToFsaUpdater();
            updater.setTranslator(translator);
            updater.setLogicAttrName("source");
            updater.setFsaAttrName("source");
            updater.setLogicObject(link);
            arrow.addToUpdater(updater);
            updater = new LogicToFsaUpdater();
            updater.setTranslator(ColorToModifierTranslator.get());
            updater.setLogicObject(incr);
            updater.setLogicAttrName("modifier");
            updater.setFsaAttrName("foreground");
            arrow.addToUpdater(updater);
            textPanel.addToComponents(new JLabel(" "));
            FSATextFieldLabel text = new FSATextFieldLabel(incr, "modifier", bendLine);
            updater = text.createDefaultUpdater();
            updater.setTranslator(StringToModifierTranslator.get());
            text.addToUpdater(updater);
            text.addToUpdater(new VisibilityUpdater(incr, "modifier"));
            updater = text.createDefaultUpdater();
            updater.setTranslator(ColorToModifierTranslator.get());
            updater.setFsaAttrName("foreground");
            text.addToUpdater(updater);
            updater = new LogicToFsaUpdater();
            updater.setTranslator(ColorToModifierTranslator.get());
            updater.setLogicObject(incr);
            updater.setLogicAttrName("modifier");
            updater.setFsaAttrName("foreground");
            line.addToUpdater(updater);
            text.setOpaque(false);
            JTextFieldLabel field = (JTextFieldLabel)text.getJComponent();
            if (bendLine.getLayout() instanceof LayoutManager2) {
                ((LayoutManager2)bendLine.getLayout()).addLayoutComponent(field, new LineDecoratorConstraints(bendLine, 0.3, 8.0));
            }
            field.setFont(FontContainer.getFont(0, -2));
            FSATextFieldLabel nametext = new FSATextFieldLabel(incr, "name", jTextPanel);
            AbstractUpdater nameupdater = nametext.createDefaultUpdater();
            nametext.addToUpdater(nameupdater);
            nametext.addToUpdater(new VisibilityUpdater(incr, "name"));
            nametext.setOpaque(false);
            updater = new LogicToFsaUpdater();
            updater.setTranslator(ColorToModifierTranslator.get());
            updater.setLogicObject(incr);
            updater.setLogicAttrName("modifier");
            updater.setFsaAttrName("foreground");
            nametext.addToUpdater(updater);
            JLabel openingRangeBracket = new JLabel(" [");
            if (link.getRange() == null || link.getRange().equals("")) {
                openingRangeBracket.setVisible(false);
            }
            textPanel.addToComponents(openingRangeBracket);
            FSATextFieldLabel rangetext = new FSATextFieldLabel(incr, "range", jTextPanel);
            AbstractUpdater rangeupdater = rangetext.createDefaultUpdater();
            rangetext.addToUpdater(rangeupdater);
            rangetext.addToUpdater(new VisibilityUpdater(incr, "range"));
            rangetext.setOpaque(false);
            JLabel closingRangeBracket = new JLabel("]");
            if (link.getRange() == null || link.getRange().equals("")) {
                closingRangeBracket.setVisible(false);
            }
            textPanel.addToComponents(closingRangeBracket);
            UMLinkPropertyChangeListener pclListener = new UMLinkPropertyChangeListener(rangetext, openingRangeBracket, closingRangeBracket, null);
            link.addPropertyChangeListener("range", pclListener);
            JTextFieldLabel namefield = (JTextFieldLabel)nametext.getJComponent();
            if (bendLine.getLayout() instanceof LayoutManager2) {
                ((LayoutManager2)bendLine.getLayout()).addLayoutComponent(jTextPanel, new LineDecoratorConstraints(bendLine, 0.5, 8.0));
            }
            field.setFont(FontContainer.getFont(0, -1));
            if (link.getIsViaASGElementRef()) {
                FSALabel suffixLabel = new FSALabel(incr, "suffix", jTextPanel);
                suffixLabel.setText(" (via ASGElementRef)");
                suffixLabel.setOpaque(true);
            }
            pclListener = new UMLinkPropertyChangeListener(nametext, null, null, null);
            link.addPropertyChangeListener("type", pclListener);
            switch (link.getType()) {
                case 2: {
                    line.setForeground(ColorsPreferences.get().OPTIONAL);
                    bendLine.setStroke(LineStyle.DASHED);
                    arrow.setForeground(ColorsPreferences.get().OPTIONAL);
                    nametext.setForeground(ColorsPreferences.get().OPTIONAL);
                    break;
                }
                case 1: {
                    namefield.setBorder(new CrossBorder(ColorsPreferences.get().DEFAULT_FOREGROUND));
                    break;
                }
            }
            switch (link.getModifier()) {
                case 2: {
                    arrow.setForeground(ColorsPreferences.get().CREATION);
                    nametext.setForeground(ColorsPreferences.get().CREATION);
                    break;
                }
                case 1: {
                    arrow.setForeground(ColorsPreferences.get().DELETION);
                    nametext.setForeground(ColorsPreferences.get().DELETION);
                    break;
                }
            }
            if (link.getInstanceOf() == null) {
                namefield.setOpaque(true);
                namefield.setBackground(Color.RED);
            }
            return line;
        }
        return null;
    }

    private JGrab createGrab(UMLLink link, FSABendLine line, JComponent grabParent, String role, UMLObject target) {
        FSAGrab fsaGrab = new FSAGrab(link, String.valueOf(role) + "Grab", grabParent);
        LogicFsaTranslator translator = new LogicFsaTranslator(line, 1);
        LogicToFsaUpdater updater = new LogicToFsaUpdater();
        updater.setTranslator(translator);
        updater.setLogicAttrName(role);
        updater.setFsaAttrName("target");
        updater.setLogicObject(link);
        fsaGrab.addToUpdater(updater);
        PanelGrabUI ui = (PanelGrabUI)PanelGrabUI.createUI(fsaGrab.getJComponent());
        fsaGrab.setUI(ui);
        fsaGrab.getJComponent().setOpaque(false);
        JGrab grab = (JGrab)fsaGrab.getJComponent();
        JRectangle rect = new JRectangle(3, 3);
        grab.add(rect);
        SelectionListenerHelper.addSelectionListener(rect, SelectionPropagationListener.get(2));
        SelectionListenerHelper.addSelectionListener(rect, SelectionPropagationListener.get(1));
        AscendDescendMouseHandler.addMouseInputListener(rect, SelectionMouseListener.get());
        AscendDescendMouseHandler.addMouseInputListener(rect, GrabMouseListener.get());
        ui.setGrabComponent(rect);
        FSALabel nameLabel = new FSALabel(link, String.valueOf(role) + "Role", fsaGrab.getJComponent());
        nameLabel.getJComponent().setOpaque(false);
        nameLabel.getJComponent().setVisible(LayoutPreferences.get().isShowRoleNames());
        Font tmpFont = FontContainer.getFont(0, -2);
        nameLabel.setFont(tmpFont);
        SelectionListenerHelper.addSelectionListener(nameLabel.getJComponent(), ForegroundHighlighter.get());
        if (!LayoutPreferences.get().isShowRoleNames()) {
            SelectionListenerHelper.addSelectionListener(nameLabel.getJComponent(), VisibilityHighlighter.get());
        }
        JLabel roleLabel = (JLabel)nameLabel.getJComponent();
        UMLinkPropertyChangeListener pcl = new UMLinkPropertyChangeListener(null, null, null, roleLabel);
        link.addPropertyChangeListener(String.valueOf(role) + "Role", pcl);
        pcl.propertyChange(new PropertyChangeEvent(link, String.valueOf(role) + "Role", null, link.getCorrespondingRole(target)));
        RoleLayout layout = new RoleLayout(grab, rect, nameLabel.getJComponent(), null);
        grab.setLayout(layout);
        SelectionListenerHelper.addSelectionListener(grab, ForegroundHighlighter.get());
        AscendDescendMouseHandler.addMouseInputListener(grab, GrabMouseListener.get());
        AscendDescendMouseHandler.addMouseInputListener(grab, DoubleClickMouseListener.get());
        SelectionListenerHelper.addSelectionListener(grab, SelectionPropagationListener.get(2));
        return grab;
    }

    private class UMLinkPropertyChangeListener
    implements PropertyChangeListener {
        private FSATextFieldLabel textField;
        private JLabel openingRangeBracket;
        private JLabel closingRangeBracket;
        private JLabel roleLabel;

        public UMLinkPropertyChangeListener(FSATextFieldLabel textField, JLabel opening, JLabel closing, JLabel role) {
            this.textField = textField;
            this.openingRangeBracket = opening;
            this.closingRangeBracket = closing;
            this.roleLabel = role;
        }

        public void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            if ("type".equals(propertyName)) {
                boolean negative = (Integer)event.getNewValue() == 1;
                JTextFieldLabel field = (JTextFieldLabel)this.textField.getJComponent();
                if (negative) {
                    field.setBorder(new CrossBorder(Color.black));
                } else {
                    field.setBorder(null);
                }
            } else if ("range".equals(propertyName)) {
                if ("".equals(event.getNewValue())) {
                    this.openingRangeBracket.setVisible(false);
                    this.closingRangeBracket.setVisible(false);
                } else {
                    this.openingRangeBracket.setVisible(true);
                    this.closingRangeBracket.setVisible(true);
                }
            } else if ("sourceRole".equals(propertyName) || "targetRole".equals(propertyName)) {
                UMLRole oldRole = (UMLRole)event.getOldValue();
                UMLRole newRole = (UMLRole)event.getNewValue();
                if (oldRole != null) {
                    oldRole.removePropertyChangeListener("name", this);
                }
                if (newRole != null) {
                    String name = newRole.getName();
                    this.roleLabel.setText(name);
                    newRole.addPropertyChangeListener("name", this);
                }
            } else if ("name".equals(propertyName)) {
                String name = (String)event.getNewValue();
                this.roleLabel.setText(name);
            }
        }
    }
}

