/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml.update;

import de.uni_paderborn.fujaba.fsa.FSADerivePropertyMethodsCache;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.LogicToFsaUpdater;
import de.uni_paderborn.fujaba.metamodel.FIncrement;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;

public class UMLAbstractUpdater
extends LogicToFsaUpdater
implements PropertyChangeListener {
    public UMLAbstractUpdater() {
        super.setLogicAttrName("umlAbstract");
        super.setFsaAttrName("font");
    }

    public UMLAbstractUpdater(FSAObject field, LogicUnparseInterface object) {
        this();
        this.setLogicObject(object);
        this.setFsaObject(field);
    }

    public boolean setLogicObject(Object object) {
        if (object == null || object instanceof FIncrement) {
            return super.setLogicObject(object);
        }
        throw new IllegalArgumentException("Object must be of instance UMLRole");
    }

    public boolean setFsaObject(FSAObject object) {
        return super.setFsaObject(object);
    }

    public boolean setLogicAttrName(String name) {
        if ("umlAbstract".equals(name)) {
            return false;
        }
        throw new UnsupportedOperationException("Cannot change AdornmentUpdater.umlAttrName from \"adornment\"");
    }

    public Object translateLogicToFsa(Object data) {
        boolean isAbstract = false;
        if (data != null && data instanceof Boolean) {
            isAbstract = (Boolean)data;
        }
        this.getFsaObject().setItalic(isAbstract);
        return this.getFsaObject().getJComponent();
    }

    protected void addListener() {
        if (this.getLogicObject() != null && this.getLogicAttrName() != null && this.getFsaObject() != null && this.getFsaAttrName() != null) {
            if (this.getLogicListener() == null) {
                this.setLogicListener(this);
            }
            UMLIncrement incr = (UMLIncrement)this.getLogicObject();
            incr.addPropertyChangeListener(this.getLogicAttrName(), (PropertyChangeListener)this.getLogicListener());
            if (incr instanceof UMLMethod) {
                incr.addPropertyChangeListener("param", (PropertyChangeListener)this.getLogicListener());
                incr.addPropertyChangeListener("resultType", (PropertyChangeListener)this.getLogicListener());
                incr.addPropertyChangeListener("name", (PropertyChangeListener)this.getLogicListener());
            }
        }
    }

    protected void removeListener() {
        if (this.getLogicObject() != null && this.getLogicAttrName() != null && this.getFsaObject() != null && this.getFsaAttrName() != null && this.getLogicListener() != null) {
            UMLIncrement incr = (UMLIncrement)this.getLogicObject();
            incr.removePropertyChangeListener(this.getLogicAttrName(), (PropertyChangeListener)this.getLogicListener());
            if (incr instanceof UMLMethod) {
                incr.removePropertyChangeListener("param", (PropertyChangeListener)this.getLogicListener());
                incr.removePropertyChangeListener("resultType", (PropertyChangeListener)this.getLogicListener());
                incr.removePropertyChangeListener("name", (PropertyChangeListener)this.getLogicListener());
            }
        }
    }

    public void initialize() {
        if (this.getLogicObject() == null || this.getLogicAttrName() == null || this.getFsaObject() == null || this.getFsaAttrName() == null) {
            return;
        }
        Method getMethod = null;
        Method[] methods = FSADerivePropertyMethodsCache.get().getPropertyMethods(this.getLogicAttrName(), this.getLogicObject());
        getMethod = methods[0];
        try {
            Object value = getMethod.invoke(this.getLogicObject(), null);
            this.getTranslator().translateLogicToFsa(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Exception in " + this + ".initialize: " + e.getMessage());
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        Object newVal = e.getSource();
        if (newVal instanceof Boolean) {
            this.getTranslator().translateLogicToFsa(e.getNewValue());
        } else if (this.getLogicObject() instanceof UMLMethod) {
            UMLMethod method = (UMLMethod)this.getLogicObject();
            Boolean data = method.isUmlAbstract();
            this.getTranslator().translateLogicToFsa(data);
        } else if (this.getLogicObject() instanceof UMLClass) {
            UMLClass theClass = (UMLClass)this.getLogicObject();
            Boolean data = theClass.isUmlAbstract();
            this.getTranslator().translateLogicToFsa(data);
        }
    }
}

