/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.uml.utility;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.asg.ASGUtility;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLLink;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLObjectDiagram;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.utility.UMLClassDiagramUtility;
import de.upb.tools.fca.FTreeSet;
import java.util.Collection;
import java.util.Iterator;

public class UMLObjectDiagramUtility
extends ASGUtility {
    public UMLObjectDiagramUtility(ASGDiagram diagram) {
        super(diagram);
    }

    public static FTreeSet getAssociations(UMLLink link) {
        UMLClass firstClass = null;
        UMLClass secondClass = null;
        UMLObject object = link.getSource();
        if (object != null) {
            firstClass = object.getInstanceOf();
        }
        if ((object = link.getTarget()) != null) {
            secondClass = object.getInstanceOf();
        }
        return UMLClassDiagramUtility.calculatePossibleAssocs(firstClass, secondClass);
    }

    public static FTreeSet getAssociations(UMLObject srcObj, UMLObject tgtObj) {
        UMLClass firstClass = null;
        UMLClass secondClass = null;
        if (srcObj != null && tgtObj != null) {
            firstClass = srcObj.getInstanceOf();
            secondClass = tgtObj.getInstanceOf();
            return UMLClassDiagramUtility.calculatePossibleAssocs(firstClass, secondClass);
        }
        return null;
    }

    public static FTreeSet getASGElementRefAssocs(UMLObject srcObj, UMLObject tgtObj) {
        UMLClass firstClass = null;
        UMLClass secondClass = null;
        if (srcObj != null && tgtObj != null) {
            firstClass = srcObj.getInstanceOf();
            secondClass = tgtObj.getInstanceOf();
            FTreeSet assocs = new FTreeSet();
            if (UMLClassDiagramUtility.calculatePossibleAssocsViaASGElementRef(firstClass, secondClass) != null) {
                assocs.addAll((Collection)UMLClassDiagramUtility.calculatePossibleAssocsViaASGElementRef(firstClass, secondClass));
            }
            if (UMLClassDiagramUtility.calculatePossibleAssocsViaASGElementRef(secondClass, firstClass) != null) {
                assocs.addAll((Collection)UMLClassDiagramUtility.calculatePossibleAssocsViaASGElementRef(secondClass, firstClass));
            }
            if (assocs.isEmpty()) {
                return null;
            }
            return assocs;
        }
        return null;
    }

    public static UMLObject getObject(String objectName) {
        UMLObjectDiagram diagram = (UMLObjectDiagram)UMLProject.get().getCurrentUMLDiagram();
        if (diagram == null) {
            Exception ex = new Exception("No UML diagram found!");
            ex.printStackTrace();
        }
        UMLObject foundObject = null;
        Iterator iter = diagram.iteratorOfElements();
        while (iter.hasNext() && foundObject == null) {
            UMLObject object;
            ASGElement elem = (ASGElement)iter.next();
            if (!(elem instanceof UMLObject) || !(object = (UMLObject)elem).getObjectName().equals(objectName)) continue;
            foundObject = object;
        }
        return foundObject;
    }
}

