/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.views.AbstractConfigurableFilter;
import de.uni_paderborn.fujaba.views.CompositeFilterEditor;
import de.uni_paderborn.fujaba.views.Filter;
import de.uni_paderborn.fujaba.views.FilterEditor;
import de.uni_paderborn.fujaba.views.ItemSet;
import de.uni_paderborn.fujaba.views.cf.CFDiagram;
import de.uni_paderborn.fujaba.views.cf.CFFilterNode;
import de.uni_paderborn.fujaba.views.cf.CFNode;
import java.util.Iterator;
import java.util.Set;

public class CompositeFilter
extends AbstractConfigurableFilter {
    private CFDiagram cfDiagram;

    public boolean isForDiagram(UMLDiagram diag) {
        CFDiagram diagram = this.getCFDiagram();
        if (diagram == null) {
            return true;
        }
        Iterator nodeIter = diagram.iteratorOfElements();
        while (nodeIter.hasNext()) {
            Filter filter;
            CFNode node;
            ASGElement asgElement = (ASGElement)nodeIter.next();
            if (!(asgElement instanceof CFNode) || !((node = (CFNode)asgElement) instanceof CFFilterNode) || (filter = ((CFFilterNode)node).getFilter()) == null || filter.isForDiagram(diag)) continue;
            return false;
        }
        return true;
    }

    public Set grow1Context(UMLDiagram diag, UMLDiagramItem item, ItemSet context) {
        CFDiagram diagram = this.getCFDiagram();
        if (diagram == null || !diag.hasInElements(item)) {
            return null;
        }
        if (context == null) {
            context = new ItemSet();
        }
        Set newItems = diagram.getResults(diag, item);
        newItems.removeAll(context);
        context.addAll(newItems);
        return newItems;
    }

    public boolean setCFDiagram(CFDiagram value) {
        if (this.cfDiagram != value) {
            if (this.cfDiagram != null) {
                CFDiagram oldValue = this.cfDiagram;
                this.cfDiagram = null;
                oldValue.setFilter(null);
            }
            this.cfDiagram = value;
            if (value != null) {
                this.cfDiagram.setFilter(this);
            }
            return true;
        }
        return false;
    }

    public CFDiagram getCFDiagram() {
        return this.cfDiagram;
    }

    public FilterEditor getEditor() {
        return new CompositeFilterEditor(this);
    }
}

