/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views;

import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.uml.UMLGeneralization;
import de.uni_paderborn.fujaba.views.AbstractConfigurableFilter;
import de.uni_paderborn.fujaba.views.ItemSet;
import java.util.Iterator;
import java.util.Set;

public class InheritanceFilter
extends AbstractConfigurableFilter {
    private boolean includeSubclasses = true;
    private boolean includeSuperclasses = true;

    public InheritanceFilter() {
        this.setDescription("This Filter defines its 1-Context by following the inheritance hierarchy to the sub- or superclasses, depending on the current configuration");
    }

    public boolean isForDiagram(UMLDiagram diag) {
        return diag instanceof UMLClassDiagram;
    }

    public Set grow1Context(UMLDiagram diag, UMLDiagramItem item, ItemSet context) {
        UMLDiagramItem tmpItem;
        UMLGeneralization gen;
        if (item == null || !(item instanceof UMLClass) || !diag.hasInElements(item)) {
            return null;
        }
        if (context == null) {
            context = new ItemSet();
        }
        ItemSet newNodes = new ItemSet();
        if (this.includeSuperclasses) {
            Iterator superClasses = ((UMLClass)item).iteratorOfRevSubclass();
            while (superClasses.hasNext()) {
                gen = (UMLGeneralization)superClasses.next();
                tmpItem = InheritanceFilter.tryAddConnection(diag, context, gen);
                if (tmpItem == null) continue;
                newNodes.add(tmpItem);
            }
        }
        if (this.includeSubclasses) {
            Iterator subClasses = ((UMLClass)item).iteratorOfRevSuperclass();
            while (subClasses.hasNext()) {
                gen = (UMLGeneralization)subClasses.next();
                tmpItem = InheritanceFilter.tryAddConnection(diag, context, gen);
                if (tmpItem == null) continue;
                newNodes.add(tmpItem);
            }
        }
        return newNodes;
    }

    public boolean isIncludeSubclasses() {
        return this.includeSubclasses;
    }

    public void setIncludeSubclasses(boolean inc) {
        this.includeSubclasses = inc;
    }

    public boolean isIncludeSuperclasses() {
        return this.includeSuperclasses;
    }

    public void setIncludeSuperclasses(boolean inc) {
        this.includeSuperclasses = inc;
    }
}

