/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views;

import de.uni_paderborn.fujaba.basic.BasicIncrement;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.views.Filter;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class ViewDefinition
extends BasicIncrement {
    private static final transient Logger log;
    private boolean update = false;
    private String name = null;
    private int context = 0;
    private FHashSet startItems;
    private transient FHashSet items;
    private ViewDiagram diagram;
    private Filter filter;
    private transient boolean evaluating = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.views.ViewDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public boolean setUpdate(boolean update) {
        boolean changed = false;
        if (update != this.update) {
            this.update = update;
            if (update) {
                this.update();
            }
            changed = true;
        }
        return changed;
    }

    public boolean setName(String name) {
        boolean changed = false;
        if (this.name != name) {
            this.name = name;
            changed = true;
        }
        return changed;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setContext(int context) {
        if (this.context != context) {
            this.context = context;
            if (this.getDiagram() != null && this.isUpdate()) {
                this.update();
            }
        }
    }

    public int getContext() {
        return this.context;
    }

    public boolean addToStartItems(UMLDiagramItem value) {
        boolean changed = false;
        if (value != null) {
            if (this.startItems == null) {
                this.startItems = new FHashSet();
            }
            if (changed = this.startItems.add(value)) {
                value.addToViewDefinitions(this);
                if (this.getDiagram() != null && this.isUpdate()) {
                    this.update();
                }
            }
        }
        return changed;
    }

    public boolean hasInStartItems(UMLDiagramItem value) {
        return this.startItems != null && value != null && this.startItems.contains(value);
    }

    public Iterator iteratorOfStartItems() {
        return this.startItems == null ? FEmptyIterator.get() : this.startItems.iterator();
    }

    public int sizeOfStartItems() {
        return this.startItems == null ? 0 : this.startItems.size();
    }

    public boolean removeFromStartItems(UMLDiagramItem value) {
        boolean changed = false;
        if (this.startItems != null && value != null && (changed = this.startItems.remove(value))) {
            value.removeFromViewDefinitions(this);
            if (this.getDiagram() != null && this.isUpdate()) {
                this.update();
            }
        }
        return changed;
    }

    public void removeAllFromStartItems() {
        Iterator iter = this.iteratorOfStartItems();
        boolean update = this.isUpdate();
        this.setUpdate(false);
        while (iter.hasNext()) {
            UMLDiagramItem tmpValue = (UMLDiagramItem)iter.next();
            this.removeFromStartItems(tmpValue);
        }
        this.setUpdate(update);
        if (this.getDiagram() != null && update) {
            this.update();
        }
    }

    public boolean addToItems(UMLDiagramItem value) {
        boolean changed = false;
        if (value != null) {
            if (this.items == null) {
                this.items = new FHashSet();
            }
            if (changed = this.items.add(value)) {
                value.addToRevItems(this);
                if (!this.evaluating && this.getDiagram() != null) {
                    this.getDiagram().addToElements(value);
                }
            }
        }
        return changed;
    }

    public boolean addToItems(UMLDiagramItem value, UMLDiagram diag) {
        boolean changed = false;
        if (value != null) {
            if (this.items == null) {
                this.items = new FHashSet();
            }
            if (changed = this.items.add(value)) {
                value.addToRevItems(this);
                if (!this.evaluating && this.getDiagram() != null) {
                    this.getDiagram().addToItems(value, diag);
                }
            }
        }
        return changed;
    }

    public boolean hasInItems(UMLDiagramItem value) {
        return this.items != null && value != null && this.items.contains(value);
    }

    public Iterator iteratorOfItems() {
        return this.items == null ? FEmptyIterator.get() : this.items.iterator();
    }

    public int sizeOfItems() {
        return this.items == null ? 0 : this.items.size();
    }

    public boolean removeFromItems(UMLDiagramItem value) {
        boolean changed = false;
        if (this.items != null && value != null && (changed = this.items.remove(value))) {
            value.removeFromRevItems(this);
            if (!this.evaluating && this.getDiagram() != null) {
                this.getDiagram().checkAndRemoveFromItems(value, this);
            }
        }
        return changed;
    }

    public void removeAllFromItems() {
        Iterator iter = this.iteratorOfItems();
        HashSet<UMLDiagramItem> oldItems = new HashSet<UMLDiagramItem>();
        boolean wasEvaluating = this.evaluating;
        this.evaluating = true;
        while (iter.hasNext()) {
            UMLDiagramItem tmpValue = (UMLDiagramItem)iter.next();
            this.removeFromItems(tmpValue);
            oldItems.add(tmpValue);
        }
        if (!wasEvaluating && this.getDiagram() != null) {
            this.getDiagram().checkAndRemoveFromItems(oldItems, this);
        }
        this.evaluating = wasEvaluating;
    }

    protected Set getItems() {
        return this.items;
    }

    public boolean setDiagram(ViewDiagram value) {
        if (this.diagram != value) {
            if (this.diagram != null) {
                ViewDiagram oldValue = this.diagram;
                this.diagram = null;
                oldValue.removeFromViewDefinitions(this);
                oldValue.checkAndRemoveFromItems(this.items, this);
            }
            this.removeAllFromItems();
            this.diagram = value;
            if (value != null) {
                this.diagram.addToViewDefinitions(this);
                this.update();
            }
            return true;
        }
        return false;
    }

    public ViewDiagram getDiagram() {
        return this.diagram;
    }

    public boolean setFilter(Filter value) {
        if (this.filter != value) {
            if (this.filter != null) {
                Filter oldValue = this.filter;
                this.filter = null;
                oldValue.removeFromViewDefinitions(this);
            }
            this.filter = value;
            if (value != null) {
                this.filter.addToViewDefinitions(this);
                if (this.isUpdate()) {
                    this.update();
                }
            }
            return true;
        }
        return false;
    }

    public Filter getFilter() {
        return this.filter;
    }

    private Set getContextItems() {
        if (this.getFilter() == null) {
            return new FHashSet();
        }
        ViewDiagram diagram = this.getDiagram();
        if (diagram == null || diagram.getDiagram() == null) {
            return new FHashSet();
        }
        Set items = this.getFilter().getNContext(diagram.getOriginalDiagram(), this.iteratorOfStartItems(), this.getContext());
        if (items == null) {
            items = new FHashSet();
        }
        return items;
    }

    protected Set evaluate() {
        boolean alreadyEvaluating = this.evaluating;
        if (!this.update) {
            log.error((Object)("Call to evaluate() with update=false in ViewDefinition " + this.name + "[" + Integer.toHexString(this.hashCode()) + "]"));
        }
        if (alreadyEvaluating) {
            log.error((Object)("recurring call to evaluate() in ViewDefinition " + this.name + "[" + Integer.toHexString(this.hashCode()) + "]"));
        }
        this.evaluating = true;
        this.update();
        if (!alreadyEvaluating) {
            this.evaluating = false;
        }
        return this.items;
    }

    public void update() {
        Set newItems = this.getContextItems();
        if (newItems == null) {
            this.removeAllFromItems();
        } else {
            UMLDiagramItem item;
            Iterator itemIter = this.iteratorOfItems();
            while (itemIter.hasNext()) {
                item = (UMLDiagramItem)itemIter.next();
                if (newItems.contains(item)) {
                    newItems.remove(item);
                    continue;
                }
                this.removeFromItems(item);
            }
            itemIter = newItems.iterator();
            while (itemIter.hasNext()) {
                item = (UMLDiagramItem)itemIter.next();
                this.addToItems(item);
            }
        }
    }

    public void removeYou() {
        this.removeAllFromItems();
        this.setDiagram(null);
        this.setFilter(null);
        this.removeAllFromStartItems();
        super.removeYou();
    }
}

