/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views.beans;

import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.beans.PropertyEditor;
import javax.swing.JTextField;

public class BeanTextField
extends JTextField {
    private PropertyEditor propertyEditor = null;

    public BeanTextField(PropertyEditor propertyEditor) {
        super(15);
        this.setPropertyEditor(propertyEditor);
    }

    public boolean setPropertyEditor(PropertyEditor propertyEditor) {
        if (this.propertyEditor != propertyEditor) {
            this.propertyEditor = propertyEditor;
            if (propertyEditor != null) {
                this.setText(propertyEditor.getAsText());
            } else {
                this.setText("");
            }
            return true;
        }
        return false;
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    protected void fireActionPerformed() {
        this.syncPropertyText();
        super.fireActionPerformed();
    }

    protected void processFocusEvent(FocusEvent e) {
        this.syncPropertyText();
        super.processFocusEvent(e);
    }

    private void syncPropertyText() {
        PropertyEditor editor = this.getPropertyEditor();
        if (editor != null) {
            try {
                editor.setAsText(this.getText());
            }
            catch (Exception e) {
                this.setText(editor.getAsText());
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

