/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views.beans;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class NumberTextField
extends JTextField {
    static final transient Logger log;
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    NumberFormat parser;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.views.beans.NumberTextField");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public NumberTextField(int columns) {
        this(columns, NumberTextField.createDefaultParser());
    }

    public NumberTextField(int columns, NumberFormat parser) {
        super(columns);
        this.setParser(parser);
    }

    public Number getValue() {
        Number retVal = null;
        String text = this.getText();
        if (text == null || text.equals("")) {
            retVal = new Long(0L);
        } else {
            try {
                retVal = this.parser.parse(text);
            }
            catch (ParseException e) {
                this.toolkit.beep();
            }
        }
        return retVal;
    }

    public void setValue(Number value) {
        if (value != null) {
            this.setText(this.parser.format(value.doubleValue()));
        } else {
            this.setText("0");
        }
    }

    public void setParser(NumberFormat parser) {
        this.parser = parser != null ? parser : NumberTextField.createDefaultParser();
    }

    public NumberFormat getParser() {
        return this.parser;
    }

    protected static NumberFormat createDefaultParser() {
        return NumberFormat.getNumberInstance();
    }

    protected Document createDefaultModel() {
        return new NumberDocument();
    }

    protected class NumberDocument
    extends PlainDocument {
        protected NumberDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            int len = this.getLength() - offs;
            if (offs >= 0 && len >= 0) {
                String newValue = String.valueOf(this.getText(0, offs)) + str + this.getText(offs, this.getLength() - offs);
                if (newValue.equals("")) {
                    super.insertString(offs, str, a);
                } else {
                    try {
                        NumberTextField.this.parser.parse(newValue);
                        super.insertString(offs, str, a);
                    }
                    catch (ParseException e) {
                        log.error((Object)("ParseException: " + newValue));
                        e.printStackTrace();
                        NumberTextField.this.toolkit.beep();
                    }
                }
            } else {
                throw new BadLocationException("", offs);
            }
        }

        public void remove(int offs, int len) throws BadLocationException {
            int tmpLen = this.getLength() - offs - len;
            if (offs >= 0 && len >= 0 && tmpLen >= 0) {
                String newValue = String.valueOf(this.getText(0, offs)) + this.getText(offs + len, this.getLength() - len - offs);
                if (newValue.equals("")) {
                    super.remove(offs, len);
                } else {
                    try {
                        NumberTextField.this.parser.parse(newValue);
                        super.remove(offs, len);
                    }
                    catch (ParseException e) {
                        log.error((Object)("ParseException: " + newValue));
                        e.printStackTrace();
                        NumberTextField.this.toolkit.beep();
                    }
                }
            } else {
                throw new BadLocationException("", offs);
            }
        }
    }
}

