/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views.cf;

import de.uni_paderborn.fujaba.uml.UMLConnection;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.views.AbstractFilter;
import de.uni_paderborn.fujaba.views.ConfigurableFilter;
import de.uni_paderborn.fujaba.views.Filter;
import de.uni_paderborn.fujaba.views.ItemSet;
import de.uni_paderborn.fujaba.views.cf.CFOrNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CFFilterNode
extends CFOrNode {
    private int context = 0;
    private boolean computeLastStep = false;
    private Filter filter = null;

    public Object clone() {
        CFFilterNode clone = new CFFilterNode();
        clone.setContext(this.getContext());
        Filter filter = this.getFilter();
        if (filter instanceof ConfigurableFilter) {
            try {
                Filter copy;
                filter = copy = (Filter)((ConfigurableFilter)filter).clone();
            }
            catch (Exception copy) {}
        } else {
            try {
                Filter copy;
                filter = copy = (Filter)filter.getClass().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        clone.setFilter(filter);
        clone.setComputeLastStep(this.isComputeLastStep());
        return clone;
    }

    public void setContext(int context) {
        if (context != this.context) {
            int old = this.context;
            this.context = context;
            this.firePropertyChange("context", old, context);
        }
    }

    public int getContext() {
        return this.context;
    }

    public void setComputeLastStep(boolean step) {
        if (this.computeLastStep != step) {
            this.computeLastStep = step;
            this.firePropertyChange("computeLastStep", !step, step);
        }
    }

    public boolean isComputeLastStep() {
        return this.computeLastStep;
    }

    public void setFilter(Filter filter) {
        if (filter != this.filter) {
            Filter old = this.filter;
            this.filter = filter;
            this.firePropertyChange("filter", old, filter);
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    protected Set computeResult(UMLDiagram diag, UMLDiagramItem item, Collection sourceResults) {
        if (this.isComputeLastStep()) {
            return this.computeLastStepResult(diag, item, sourceResults);
        }
        return this.computeNormalResult(diag, item, sourceResults);
    }

    private Set computeNormalResult(UMLDiagram diag, UMLDiagramItem item, Collection sourceResults) {
        Filter filter = this.getFilter();
        if (filter == null) {
            return new HashSet();
        }
        Set input = super.computeResult(diag, item, sourceResults);
        if (this.getContext() == 0) {
            return input;
        }
        Set nContext = filter.getNContext(diag, input.iterator(), this.getContext());
        return nContext;
    }

    protected Set computeLastStepResult(UMLDiagram diag, UMLDiagramItem diagItem, Collection sourceResults) {
        Filter filter = this.getFilter();
        if (filter == null) {
            return new HashSet();
        }
        HashSet input = new CFOrNode().computeResult(diag, diagItem, sourceResults);
        int depth = this.getContext();
        if (depth == 0) {
            return input;
        }
        HashSet nextToLastStep = null;
        HashSet lastStep = input;
        Set lastContext = new HashSet();
        ItemSet result = new ItemSet();
        ItemSet context = null;
        Set tmpSet = null;
        Iterator items = input.iterator();
        while (items.hasNext()) {
            Object tmpObj = items.next();
            if (!(tmpObj instanceof UMLDiagramItem) || !diag.hasInElements((UMLDiagramItem)tmpObj)) continue;
            UMLDiagramItem item = (UMLDiagramItem)tmpObj;
            boolean grows = true;
            nextToLastStep = new HashSet(result);
            context = new ItemSet();
            context.add(item);
            result.add(item);
            lastStep = new HashSet(result);
            int i = depth;
            while (i != 0 && grows) {
                Iterator contextIterator = context.iterator();
                context = new ItemSet();
                while (contextIterator.hasNext()) {
                    tmpSet = this.getFilter().grow1Context(diag, (UMLDiagramItem)contextIterator.next(), result);
                    if (tmpSet == null) continue;
                    context.addAll(tmpSet);
                }
                boolean bl = grows = context != null && !context.isEmpty();
                if (grows) {
                    nextToLastStep = lastStep;
                    lastStep = new HashSet(result);
                }
                --i;
            }
            lastStep.removeAll(nextToLastStep);
            lastContext.addAll(lastStep);
        }
        if (lastStep == input) {
            lastContext = input;
        }
        Iterator iter = lastContext.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof UMLConnection) || AbstractFilter.containsConnection(lastContext, (UMLConnection)obj)) continue;
            lastContext.remove(obj);
        }
        return lastContext;
    }
}

