/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views.cf;

import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.views.cf.CFTransition;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public abstract class CFNode
extends UMLDiagramItem
implements Cloneable {
    private Set result = null;
    private FHashSet entries;
    private FHashSet exits;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Set getResults(UMLDiagram diag, UMLDiagramItem item) {
        if (this.result != null) {
            return this.result;
        }
        FHashSet uncomplete = new FHashSet();
        return this.getResults(diag, item, uncomplete);
    }

    protected Set getResults(UMLDiagram diag, UMLDiagramItem item, Set uncomplete) {
        if (this.result == null) {
            uncomplete.add(this);
            Vector<Set> sourceResults = new Vector<Set>();
            Iterator entryIter = this.iteratorOfEntries();
            while (entryIter.hasNext()) {
                CFTransition trans = (CFTransition)entryIter.next();
                CFNode node = trans.getSource();
                if (uncomplete.contains(node)) {
                    throw new RuntimeException("Loop detected: " + this + " <-> " + node);
                }
                sourceResults.add(node.getResults(diag, item, uncomplete));
            }
            this.result = this.computeResult(diag, item, sourceResults);
            uncomplete.remove(this);
        }
        return this.result;
    }

    protected void resetResults() {
        if (this.result != null) {
            this.result.clear();
            this.result = null;
        }
    }

    protected void clearResults() {
        if (this.result != null) {
            this.resetResults();
            Iterator entryIter = this.iteratorOfEntries();
            while (entryIter.hasNext()) {
                CFTransition trans = (CFTransition)entryIter.next();
                CFNode node = trans.getSource();
                node.clearResults();
            }
        }
    }

    protected abstract Set computeResult(UMLDiagram var1, UMLDiagramItem var2, Collection var3);

    public boolean addToEntries(CFTransition value) {
        boolean changed = false;
        if (value != null) {
            if (this.entries == null) {
                this.entries = new FHashSet();
            }
            if (changed = this.entries.add(value)) {
                value.setTarget(this);
            }
        }
        return changed;
    }

    public boolean hasInEntries(CFTransition value) {
        return this.entries != null && value != null && this.entries.contains(value);
    }

    public Iterator iteratorOfEntries() {
        return this.entries == null ? FEmptyIterator.get() : this.entries.iterator();
    }

    public int sizeOfEntries() {
        return this.entries == null ? 0 : this.entries.size();
    }

    public boolean removeFromEntries(CFTransition value) {
        boolean changed = false;
        if (this.entries != null && value != null && (changed = this.entries.remove(value))) {
            value.setTarget(null);
        }
        return changed;
    }

    public void removeAllFromEntries() {
        Iterator iter = this.iteratorOfEntries();
        while (iter.hasNext()) {
            CFTransition tmpValue = (CFTransition)iter.next();
            this.removeFromEntries(tmpValue);
        }
    }

    public boolean addToExits(CFTransition value) {
        boolean changed = false;
        if (value != null) {
            if (this.exits == null) {
                this.exits = new FHashSet();
            }
            if (changed = this.exits.add(value)) {
                value.setSource(this);
            }
        }
        return changed;
    }

    public boolean hasInExits(CFTransition value) {
        return this.exits != null && value != null && this.exits.contains(value);
    }

    public Iterator iteratorOfExits() {
        return this.exits == null ? FEmptyIterator.get() : this.exits.iterator();
    }

    public int sizeOfExits() {
        return this.exits == null ? 0 : this.exits.size();
    }

    public boolean removeFromExits(CFTransition value) {
        boolean changed = false;
        if (this.exits != null && value != null && (changed = this.exits.remove(value))) {
            value.setSource(null);
        }
        return changed;
    }

    public void removeAllFromExits() {
        Iterator iter = this.iteratorOfExits();
        while (iter.hasNext()) {
            CFTransition tmpValue = (CFTransition)iter.next();
            this.removeFromExits(tmpValue);
        }
    }

    public void removeYou() {
        CFTransition trans;
        if (this.result != null) {
            this.result.clear();
            this.result = null;
        }
        Iterator transitionIter = this.iteratorOfEntries();
        while (transitionIter.hasNext()) {
            trans = (CFTransition)transitionIter.next();
            trans.removeYou();
        }
        transitionIter = this.iteratorOfExits();
        while (transitionIter.hasNext()) {
            trans = (CFTransition)transitionIter.next();
            trans.removeYou();
        }
        super.removeYou();
    }
}

