/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views.gui;

import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.gui.comp.FujabaDialogPanel;
import de.uni_paderborn.fujaba.views.ConfigurableFilter;
import de.uni_paderborn.fujaba.views.Filter;
import de.uni_paderborn.fujaba.views.FilterManager;
import de.uni_paderborn.fujaba.views.gui.FilterEditorPanel;
import de.uni_paderborn.fujaba.views.gui.FilterInfoPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.BevelBorder;

public class FilterEditorDialog
extends FujabaDialog
implements WindowListener {
    private JPanel mainPanel = null;
    private JTabbedPane tabPane = null;
    private FilterInfoPanel filterTabPanel = null;
    private FilterEditorPanel editTabPanel = null;
    private Filter currentFilter = null;

    public FilterEditorDialog(JFrame parentFrame) {
        super(parentFrame);
        this.setModal(true);
        this.addWindowListener(this);
        this.guiBuild();
    }

    public FilterEditorDialog(JFrame parentFrame, String sTitle) {
        this(parentFrame);
        this.setTitle(sTitle);
    }

    public void guiBuild() {
        JPanel buttons = this.guiPanelCloseHelp();
        this.mainPanel = this.createMainPanel();
        this.mainPanel.add((Component)buttons, "South");
        this.getContentPane().add(this.mainPanel);
        this.setModel(FilterManager.get().getPrototypeListModel(null));
        this.setRenderer(FilterManager.getListCellRenderer());
        this.pack();
        this.setSize(540, 430);
        this.unparse();
    }

    public void setCurrentFilter(Filter filter) {
        if (this.currentFilter != filter) {
            this.currentFilter = filter;
            this.unparse();
        }
    }

    public Filter getCurrentFilter() {
        return this.currentFilter;
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(0, 0));
        this.tabPane = this.createTabPane();
        mainPanel.add("Center", this.tabPane);
        return mainPanel;
    }

    private JTabbedPane createTabPane() {
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.setBorder(new BevelBorder(0));
        FujabaDialogPanel[] tabs = this.createTabs();
        int i = 0;
        while (i < tabs.length) {
            tabPane.addTab(tabs[i].getName(), tabs[i]);
            ++i;
        }
        tabPane.setSelectedIndex(0);
        tabPane.setEnabledAt(tabPane.indexOfComponent(this.editTabPanel), false);
        return tabPane;
    }

    private FujabaDialogPanel[] createTabs() {
        this.filterTabPanel = new FilterInfoPanel(this);
        this.editTabPanel = new FilterEditorPanel(this);
        this.editTabPanel.setGlobalEditor(true);
        return new FujabaDialogPanel[]{this.filterTabPanel, this.editTabPanel};
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.filterTabPanel.setRenderer(renderer);
        this.editTabPanel.setRenderer(renderer);
    }

    public ListCellRenderer getRenderer() {
        return this.filterTabPanel.getRenderer();
    }

    public void setModel(ComboBoxModel model) {
        this.filterTabPanel.setModel(model);
        this.editTabPanel.setModel(model);
    }

    public ComboBoxModel getModel() {
        return this.filterTabPanel.getModel();
    }

    public void parse() {
    }

    public void unparse() {
        this.filterTabPanel.unparse();
        this.editTabPanel.unparse();
        this.tabPane.setEnabledAt(this.tabPane.indexOfComponent(this.editTabPanel), this.getCurrentFilter() instanceof ConfigurableFilter);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        ComboBoxModel model = this.getModel();
        if (model != null && model instanceof FilterManager.FMListModel) {
            this.setModel(new DefaultComboBoxModel());
            ((FilterManager.FMListModel)model).removeYou();
        }
    }
}

