/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views.gui;

import de.uni_paderborn.fujaba.gui.comp.FujabaDialogPanel;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.views.ConfigurableFilter;
import de.uni_paderborn.fujaba.views.Filter;
import de.uni_paderborn.fujaba.views.FilterEditor;
import de.uni_paderborn.fujaba.views.FilterManager;
import de.uni_paderborn.fujaba.views.ViewDefinition;
import de.uni_paderborn.fujaba.views.gui.FilterEditorDialog;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.BevelBorder;
import javax.swing.filechooser.FileFilter;

public class FilterEditorPanel
extends FujabaDialogPanel
implements ActionListener {
    private JComboBox filterComboBox = null;
    private JScrollPane editorScrollPane = null;
    private JButton setButton = null;
    private JButton saveButton = null;
    private JButton createNewButton = null;
    private JButton revertButton = null;
    private boolean globalEditor = false;
    private FilterEditorDialog hostingDialog = null;
    private Filter currentFilter = null;
    private FilterEditor editor = null;

    public FilterEditorPanel(FilterEditorDialog hostingDialog) {
        this.setHostingDialog(hostingDialog);
        this.globalEditor = false;
        this.guiBuild();
    }

    public void guiBuild() {
        this.setLayout(new BorderLayout(0, 0));
        BevelBorder loweredBorder = new BevelBorder(1);
        JPanel editorPanel = new JPanel();
        editorPanel.setBorder(loweredBorder);
        editorPanel.setLayout(new BoxLayout(editorPanel, 0));
        this.editorScrollPane = new JScrollPane();
        this.editorScrollPane.setDoubleBuffered(true);
        this.editorScrollPane.getViewport().setScrollMode(1);
        editorPanel.add(this.editorScrollPane);
        this.add("Center", editorPanel);
        JPanel editorButtonPanel = new JPanel();
        editorButtonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.setButton = new JButton();
        this.setButton.setText("Set");
        this.setButton.setActionCommand("set");
        this.setButton.addActionListener(this);
        editorButtonPanel.add(this.setButton);
        this.saveButton = new JButton();
        this.saveButton.setText("Save");
        this.saveButton.setActionCommand("save");
        this.saveButton.addActionListener(this);
        editorButtonPanel.add(this.saveButton);
        this.createNewButton = new JButton();
        this.createNewButton.setText("Create New");
        this.createNewButton.setActionCommand("createNew");
        this.createNewButton.addActionListener(this);
        editorButtonPanel.add(this.createNewButton);
        this.createNewButton.setEnabled(this.globalEditor);
        this.revertButton = new JButton();
        this.revertButton.setText("Revert");
        this.revertButton.setActionCommand("revert");
        this.revertButton.addActionListener(this);
        editorButtonPanel.add(this.revertButton);
        this.add("South", editorButtonPanel);
        JPanel filterChoosePanel = new JPanel();
        filterChoosePanel.setLayout(new FlowLayout(0, 5, 0));
        this.filterComboBox = new JComboBox();
        this.filterComboBox.setActionCommand("filter");
        this.filterComboBox.addActionListener(this);
        filterChoosePanel.add(this.filterComboBox);
        this.add("North", filterChoosePanel);
        this.filterComboBox.setVisible(this.isGlobalEditor());
        this.setName("Edit Current Filter");
    }

    public void setGlobalEditor(boolean global) {
        if (this.globalEditor != global) {
            this.globalEditor = global;
            this.unparse();
        }
    }

    public boolean isGlobalEditor() {
        return this.globalEditor;
    }

    public void unparse() {
        Filter filter = null;
        this.setEditor(null);
        if (this.getHostingDialog() != null) {
            filter = this.getHostingDialog().getCurrentFilter();
            this.setCurrentFilter(filter);
        } else {
            filter = this.getCurrentFilter();
        }
        if (filter != null) {
            this.filterComboBox.setSelectedItem(filter);
            if (filter instanceof ConfigurableFilter) {
                ConfigurableFilter cFilter = (ConfigurableFilter)filter;
                FilterEditor editor = cFilter.getEditor();
                this.setEditor(editor);
            }
        } else if (this.filterComboBox.getComponentCount() > 0) {
            this.currentFilter = (Filter)this.filterComboBox.getItemAt(0);
            this.filterComboBox.setSelectedItem(this.currentFilter);
        }
        this.filterComboBox.setVisible(this.isGlobalEditor());
        this.setButton.setEnabled(filter != null);
        this.saveButton.setEnabled(filter != null);
        this.createNewButton.setEnabled(filter != null && this.isGlobalEditor());
        this.revertButton.setEnabled(filter != null);
    }

    public void refreshDialog() {
        Filter filter = this.getCurrentFilter();
        if (this.getHostingDialog() != null) {
            this.getHostingDialog().setCurrentFilter(filter);
        }
        this.unparse();
    }

    protected void setHostingDialog(FilterEditorDialog hostingDialog) {
        this.hostingDialog = hostingDialog;
    }

    public FilterEditorDialog getHostingDialog() {
        return this.hostingDialog;
    }

    public void setModel(ComboBoxModel model) {
        this.filterComboBox.setModel(model);
    }

    public ComboBoxModel getModel() {
        return this.filterComboBox.getModel();
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.filterComboBox.setRenderer(renderer);
    }

    public ListCellRenderer getRenderer() {
        return this.filterComboBox.getRenderer();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("filter")) {
            this.filterComboBoxAction();
        } else if (command.equals("set")) {
            this.setAction();
        } else if (command.equals("save")) {
            this.saveAction();
        } else if (command.equals("createNew")) {
            this.createNewAction();
        } else if (command.equals("revert")) {
            this.revertAction();
        }
    }

    public Filter getCurrentFilter() {
        return this.currentFilter;
    }

    public void setCurrentFilter(Filter filter) {
        if (this.currentFilter != filter) {
            this.currentFilter = filter;
            this.refreshDialog();
        }
    }

    private boolean setAction() {
        Filter filter = this.getCurrentFilter();
        FilterEditor editor = this.getEditor();
        if (filter == null || !(filter instanceof ConfigurableFilter) || editor == null) {
            return false;
        }
        int result = -1;
        result = filter.sizeOfViewDefinitions() > 0 ? (this.globalEditor ? JOptionPane.showOptionDialog(this, "This Filter is in use!\nChanging it might effect some of the Views that use this Filter!\n\nIt would be safer to create a copy instead.", "Set values", 1, 2, null, new String[]{"Set anyway", "Cancel", "Create Copy"}, "Create Copy") : JOptionPane.showOptionDialog(this, "This Filter is in use!\nChanging it might effect some of the Views that use this Filter!\n\nDo you want to abort?.", "Set values", 0, 2, null, new String[]{"Set", "Abort"}, "Abort")) : (this.globalEditor ? JOptionPane.showOptionDialog(this, "This will overwrite all existing values\nin this Filter", "Set values", 1, 2, null, new String[]{"Set anyway", "Cancel", "Create Copy"}, "Create Copy") : JOptionPane.showOptionDialog(this, "This will overwrite all existing values\nin this Filter", "Set values", 0, 2, null, new String[]{"Ok", "Cancel"}, "Ok"));
        if (result == 1) {
            return false;
        }
        if (result == 2) {
            return this.createNewAction();
        }
        editor.setValues();
        Iterator defIter = filter.iteratorOfViewDefinitions();
        while (defIter.hasNext()) {
            ViewDefinition def = (ViewDefinition)defIter.next();
            if (!def.isUpdate()) continue;
            def.update();
        }
        return true;
    }

    private boolean revertAction() {
        Filter filter = this.getCurrentFilter();
        FilterEditor editor = this.getEditor();
        if (filter == null || !(filter instanceof ConfigurableFilter) || editor == null) {
            return false;
        }
        int result = JOptionPane.showConfirmDialog(this, "Really discard changes?", "Discard changes", 0, 3);
        if (result == 1) {
            return false;
        }
        editor.getValues();
        return true;
    }

    private boolean createNewAction() {
        Filter filter = this.getCurrentFilter();
        FilterEditor editor = this.getEditor();
        if (filter == null || !(filter instanceof ConfigurableFilter) || editor == null) {
            return false;
        }
        ConfigurableFilter newFilter = editor.getNewFilter();
        if (newFilter == null) {
            JOptionPane.showMessageDialog(this, "Creation of new Filter with\nthese Settings failed", "New Filter", 0);
            return false;
        }
        if (this.isGlobalEditor()) {
            if (FilterManager.get().getFilter(newFilter.getName()) != null) {
                String name = newFilter.getName();
                int counter = 1;
                while (FilterManager.get().getFilter(String.valueOf(name) + " <" + counter + ">") != null) {
                    ++counter;
                }
                name = String.valueOf(name) + "<" + counter + ">";
            }
            FilterManager.get().addToFilters(newFilter);
        }
        this.setCurrentFilter(newFilter);
        return true;
    }

    private boolean saveAction() {
        Filter filter = this.getCurrentFilter();
        if (filter == null || !(filter instanceof ConfigurableFilter)) {
            return false;
        }
        if (!this.setAction()) {
            return false;
        }
        File saveFile = FilterManager.get().getFromSettingsFiles((ConfigurableFilter)filter);
        do {
            JFileChooser fileChooser = new JFileChooser(GeneralPreferences.get().getViewFilterFolder());
            fileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".ffs.gz");
                }

                public String getDescription() {
                    return "Filter Settings (*.ffs.gz)";
                }
            });
            int ret = fileChooser.showSaveDialog(this);
            if (ret == 1 || fileChooser.getSelectedFile() == null || fileChooser.getSelectedFile().isDirectory()) {
                return false;
            }
            saveFile = fileChooser.getSelectedFile();
            if (saveFile.isDirectory()) {
                saveFile = null;
                continue;
            }
            if (saveFile.exists()) continue;
            try {
                saveFile.createNewFile();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                saveFile = null;
            }
        } while (saveFile == null);
        try {
            FilterManager.saveFilter((ConfigurableFilter)filter, saveFile);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void filterComboBoxAction() {
        Filter filter = (Filter)this.filterComboBox.getSelectedItem();
        this.setCurrentFilter(filter);
    }

    public void setEditor(FilterEditor editor) {
        if (editor == this.editor) {
            return;
        }
        this.editor = editor;
        if (editor == null) {
            this.editorScrollPane.setViewportView(null);
            return;
        }
        editor.getValues();
        JPanel panel = editor.getEditorPanel();
        if (panel != null) {
            this.editorScrollPane.setViewportView(panel);
        } else {
            this.editorScrollPane.setViewportView(null);
        }
    }

    public FilterEditor getEditor() {
        return this.editor;
    }
}

