/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views.gui;

import de.uni_paderborn.fujaba.gui.comp.FujabaDialogPanel;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.views.ConfigurableFilter;
import de.uni_paderborn.fujaba.views.Filter;
import de.uni_paderborn.fujaba.views.FilterManager;
import de.uni_paderborn.fujaba.views.gui.FilterEditorDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class FilterInfoPanel
extends FujabaDialogPanel
implements ActionListener,
ListSelectionListener {
    private JList filterList = null;
    private JEditorPane descriptionTextPane = null;
    private FilterEditorDialog hostingDialog = null;

    public FilterInfoPanel(FilterEditorDialog hostingDialog) {
        this.setHostingDialog(hostingDialog);
        this.guiBuild();
    }

    public void guiBuild() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 2;
        constraints.weightx = 0.5;
        constraints.weighty = 1.0;
        constraints.anchor = 10;
        constraints.fill = 1;
        JPanel filterPanel = new JPanel();
        filterPanel.setBorder(new TitledBorder("Available Filters"));
        filterPanel.setLayout(new GridLayout(1, 1, 0, 0));
        JScrollPane filterScrollPane = new JScrollPane();
        filterScrollPane.setBorder(new BevelBorder(1));
        this.filterList = new JList();
        this.filterList.setSelectionMode(0);
        this.filterList.addListSelectionListener(this);
        filterScrollPane.getViewport().setLayout(new GridLayout(1, 1, 0, 0));
        filterScrollPane.getViewport().setView(this.filterList);
        filterPanel.add(filterScrollPane);
        this.add((Component)filterPanel, constraints);
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setBorder(new TitledBorder("Description"));
        descriptionPanel.setLayout(new GridLayout(1, 1, 0, 0));
        JScrollPane descriptionScrollPane = new JScrollPane();
        descriptionScrollPane.setBorder(new BevelBorder(1));
        this.descriptionTextPane = new JEditorPane();
        this.descriptionTextPane.setContentType("text/html");
        this.descriptionTextPane.setText("<i>Select a Filter to see information about it</i>");
        this.descriptionTextPane.setEditable(false);
        descriptionScrollPane.getViewport().setLayout(new GridLayout(1, 1, 0, 0));
        descriptionScrollPane.getViewport().setView(this.descriptionTextPane);
        descriptionPanel.add(descriptionScrollPane);
        constraints.gridx = 3;
        this.add((Component)descriptionPanel, constraints);
        JPanel filterButtonPanel = new JPanel();
        filterButtonPanel.setLayout(new GridLayout(2, 1, 0, 0));
        JButton importButton = new JButton();
        importButton.setText("Import");
        importButton.setActionCommand("import");
        importButton.addActionListener(this);
        filterButtonPanel.add(importButton);
        JButton removeButton = new JButton();
        removeButton.setText("Remove");
        removeButton.setActionCommand("remove");
        removeButton.addActionListener(this);
        filterButtonPanel.add(removeButton);
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        this.add((Component)filterButtonPanel, constraints);
        this.setName("Available Filters");
    }

    protected void setHostingDialog(FilterEditorDialog hostingDialog) {
        this.hostingDialog = hostingDialog;
    }

    public FilterEditorDialog getHostingDialog() {
        return this.hostingDialog;
    }

    public void refreshDialog() {
        if (this.getHostingDialog() != null) {
            this.getHostingDialog().setCurrentFilter((Filter)this.filterList.getSelectedValue());
        }
        this.unparse();
    }

    public void unparse() {
        Filter filter = null;
        if (this.getHostingDialog() != null) {
            filter = this.getHostingDialog().getCurrentFilter();
        }
        if (filter != null) {
            this.filterList.setSelectedValue(filter, true);
        } else {
            this.filterList.clearSelection();
        }
        if (filter != null) {
            String className;
            int lastDot;
            String desc = filter.getDescription();
            if (desc == null || desc.length() == 0) {
                desc = "<i>No description available</i>";
            }
            if ((lastDot = (className = filter.getClass().getName()).lastIndexOf(".")) > -1) {
                className = className.substring(lastDot + 1);
            }
            className = className.replace('$', '.');
            String title = "<h3>" + filter.getName() + "<br>" + "<font size=-2>(" + className + ")</font></h3>";
            this.descriptionTextPane.setText(String.valueOf(title) + desc);
        } else {
            this.descriptionTextPane.setText("<i>Select a Filter to see<br>information about it</i>");
        }
    }

    public void setModel(ComboBoxModel model) {
        this.filterList.setModel(model);
    }

    public ComboBoxModel getModel() {
        return (ComboBoxModel)this.filterList.getModel();
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.filterList.setCellRenderer(renderer);
    }

    public ListCellRenderer getRenderer() {
        return this.filterList.getCellRenderer();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("import")) {
            this.importAction();
        } else if (command.equals("remove")) {
            this.removeAction();
        }
    }

    private boolean removeAction() {
        Filter filter = (Filter)this.filterList.getSelectedValue();
        if (filter == null) {
            return false;
        }
        int result = JOptionPane.showConfirmDialog(this, "Removing a Filter results in removing all\nthe associated files!\n\nContinue?", "Remove", 0, 3);
        if (result == 1) {
            return false;
        }
        FilterManager.get().removeFromFilters(filter);
        if (filter instanceof ConfigurableFilter) {
            File settingsFile = FilterManager.get().getFromSettingsFiles((ConfigurableFilter)filter);
            if (settingsFile != null && settingsFile.exists()) {
                settingsFile.delete();
            }
            FilterManager.get().removeKeyFromSettingsFiles((ConfigurableFilter)filter);
        } else {
            String name = filter.getClass().getName();
            String pack = null;
            int lastDot = name.lastIndexOf(".");
            if (lastDot > -1) {
                pack = name.substring(0, lastDot);
                name = name.substring(lastDot + 1);
            } else {
                pack = "";
            }
            name = name.replace('.', File.pathSeparatorChar);
            File file = new File(GeneralPreferences.get().getViewFilterFolder(), String.valueOf(name) + ".class");
            if (file.exists() && !file.isDirectory()) {
                file.delete();
            }
            if ((file = new File(file, String.valueOf(pack) + File.pathSeparatorChar + name + ".class")).exists() && file.isDirectory()) {
                file.delete();
            }
        }
        return true;
    }

    private boolean importAction() {
        File target = new File(GeneralPreferences.get().getViewFilterFolder());
        if (!this.checkDir(target)) {
            return false;
        }
        JFileChooser fileChooser = new JFileChooser(GeneralPreferences.get().getWorkspaceFolder());
        fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String name = file.getName().toLowerCase();
                return file.isDirectory() || name.endsWith(".ffs.gz") || name.endsWith(".jar") || name.endsWith(".zip") || name.endsWith(".class");
            }

            public String getDescription() {
                return "Filter Files (*.ffs.gz, *.zip, *.jar, *.class)";
            }
        });
        fileChooser.setMultiSelectionEnabled(true);
        int result = fileChooser.showOpenDialog(this);
        if (result == 1) {
            return false;
        }
        File selection = fileChooser.getSelectedFile();
        if (selection.isDirectory() || !selection.exists()) {
            return false;
        }
        File targetFile = new File(target, selection.getName());
        if (targetFile.exists() && (result = JOptionPane.showConfirmDialog(this, "File " + targetFile.getName() + " already exists in target directory!\n\nOverwrite it?", "Import", 0, 3)) == 1) {
            return false;
        }
        if (!this.copyFile(selection, targetFile)) {
            JOptionPane.showMessageDialog(this, "Unable to copy File " + targetFile.getName(), "Import", 0);
        }
        FilterManager.get().rescanDir();
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyFile(File source, File target) {
        block27: {
            block23: {
                block26: {
                    block22: {
                        if (!source.canRead()) {
                            return false;
                        }
                        in = null;
                        out = null;
                        cursor = this.getCursor();
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            try {
                                if (!target.exists()) {
                                    target.createNewFile();
                                }
                                if (!target.canWrite()) {
                                    target.delete();
                                    var8_6 = null;
                                    break block22;
                                }
                                in = new BufferedInputStream(new FileInputStream(source));
                                out = new BufferedOutputStream(new FileOutputStream(target));
                                lastRead = 0;
                                buffer = new byte[131072];
                                while (lastRead > -1) {
                                    lastRead = in.read(buffer, 0, 131072);
                                    if (lastRead <= -1) continue;
                                    out.write(buffer, 0, lastRead);
                                }
                                break block23;
                            }
                            catch (IOException e) {
                                target.delete();
                                var8_7 = null;
                                try {
                                    if (in != null) {
                                        in.close();
                                    }
                                    if (out != null) {
                                        out.flush();
                                        out.close();
                                    }
                                }
                                catch (IOException var10_11) {
                                    // empty catch block
                                }
                                this.setCursor(cursor);
                                return false;
                            }
                        }
                        catch (Throwable var9_17) {
                            block25: {
                                var8_8 = null;
                                ** try [egrp 2[TRYBLOCK] [4 : 162->188)] { 
lbl49:
                                // 1 sources

                                if (in != null) {
                                    in.close();
                                }
                                if (out != null) {
                                    out.flush();
                                    out.close();
                                }
                                break block25;
lbl55:
                                // 1 sources

                                catch (IOException var10_12) {
                                    // empty catch block
                                }
                            }
                            this.setCursor(cursor);
                            throw var9_17;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [4 : 162->188)] { 
lbl62:
                    // 1 sources

                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                    break block26;
lbl68:
                    // 1 sources

                    catch (IOException var10_10) {
                        // empty catch block
                    }
                }
                this.setCursor(cursor);
                return false;
            }
            var8_9 = null;
            ** try [egrp 2[TRYBLOCK] [4 : 162->188)] { 
lbl76:
            // 1 sources

            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.flush();
                out.close();
            }
            break block27;
lbl82:
            // 1 sources

            catch (IOException var10_13) {
                // empty catch block
            }
        }
        this.setCursor(cursor);
        return true;
    }

    private boolean checkDir(File target) {
        if (!target.exists()) {
            JOptionPane.showMessageDialog(this, "Target Directory \n   " + target.getAbsolutePath() + "\ndoes not exist!\n\nPlease create it!", "Import", 0);
            return false;
        }
        if (!target.isDirectory()) {
            JOptionPane.showMessageDialog(this, "Target Directory \n   " + target.getAbsolutePath() + "\nis no Directory!\n\nPlease change it!", "Import", 0);
            return false;
        }
        return true;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() != this.filterList) {
            return;
        }
        this.refreshDialog();
    }
}

