/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.views.gui;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.PEColumn;
import de.uni_paderborn.fujaba.gui.PECombo;
import de.uni_paderborn.fujaba.gui.PEEditPanel;
import de.uni_paderborn.fujaba.gui.PEList;
import de.uni_paderborn.fujaba.gui.PETextField;
import de.uni_paderborn.fujaba.gui.PropertyEditor;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.views.ViewDefinition;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.uni_paderborn.fujaba.views.gui.ViewDefinitionDialog;
import de.uni_paderborn.fujaba.views.gui.ViewDefinitionRenderer;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ViewEditorDialog
extends PropertyEditor
implements ActionListener,
ItemListener {
    private DefaultListModel definitionsModel = new DefaultListModel();
    private DefaultComboBoxModel viewModel = new DefaultComboBoxModel();
    private PETextField nameField = null;
    private PEList viewDefsList = null;
    private JComboBox targetComboBox = null;
    private JButton addDefButton = null;
    private JButton editDefButton = null;
    private JButton removeDefButton = null;
    private JButton addViewButton = null;
    private JButton removeViewButton = null;
    private JButton setNameButton = null;
    private ViewDiagram target = null;

    public ViewEditorDialog(JFrame frame) {
        super(frame);
        this.setTitle("Add/edit View");
        this.initPE();
    }

    public void additionalProperties(PEEditPanel panel) {
        PEColumn column = new PEColumn(this);
        column.add(this.createDiagramPanel());
        column.add(this.createDefinitionPanel());
        panel.add(column);
    }

    private JPanel createDefinitionPanel() {
        PEColumn column = new PEColumn(this);
        column.setBorder(new TitledBorder("View Definitions"));
        PEColumn main = new PEColumn(this);
        this.viewDefsList = new PEList(this, "View Definitions");
        this.viewDefsList.setStatus("Select a ViewDefinition to edit");
        this.viewDefsList.getList().setModel(this.definitionsModel);
        this.viewDefsList.getList().setCellRenderer(new ViewDefinitionRenderer());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        this.addDefButton = new JButton();
        this.addDefButton.setText("Add");
        this.addDefButton.setActionCommand("addViewDefinition");
        this.addDefButton.addActionListener(this);
        this.editDefButton = new JButton();
        this.editDefButton.setText("Edit");
        this.editDefButton.setActionCommand("editViewDefinition");
        this.editDefButton.addActionListener(this);
        this.removeDefButton = new JButton();
        this.removeDefButton.setText("Remove");
        this.removeDefButton.setActionCommand("removeViewDefinition");
        this.removeDefButton.addActionListener(this);
        buttonPanel.add(this.addDefButton);
        buttonPanel.add(this.editDefButton);
        buttonPanel.add(this.removeDefButton);
        main.add(this.viewDefsList);
        main.add(buttonPanel);
        column.add(main);
        return column;
    }

    private JPanel createDiagramPanel() {
        PEColumn column = new PEColumn(this);
        column.setBorder(new TitledBorder("Target Diagram"));
        PEColumn main = new PEColumn(this);
        PECombo targetCombo = new PECombo(this, "Select View");
        this.targetComboBox = targetCombo.getComboBox();
        this.targetComboBox.setModel(this.viewModel);
        this.targetComboBox.addItemListener(this);
        this.nameField = new PETextField(this, "Enter name for view diagram");
        this.nameField.setEnabled(false);
        this.nameField.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        this.addViewButton = new JButton();
        this.addViewButton.setText("Create New");
        this.addViewButton.setActionCommand("addView");
        this.addViewButton.addActionListener(this);
        this.removeViewButton = new JButton();
        this.removeViewButton.setText("Remove");
        this.removeViewButton.setActionCommand("removeView");
        this.removeViewButton.addActionListener(this);
        this.setNameButton = new JButton();
        this.setNameButton.setText("Apply Name");
        this.setNameButton.setActionCommand("diagramName");
        this.setNameButton.addActionListener(this);
        this.setNameButton.setEnabled(false);
        buttonPanel.add(this.addViewButton);
        buttonPanel.add(this.removeViewButton);
        buttonPanel.add(this.setNameButton);
        main.add(targetCombo);
        main.add(this.nameField);
        main.add(buttonPanel);
        column.add(main);
        return column;
    }

    public void parse() {
    }

    public void unparse() {
        ASGElement incr = this.getIncrement();
        if (incr != null && incr instanceof UMLDiagram) {
            UMLDiagram diag = (UMLDiagram)incr;
            Iterator viewIter = diag.iteratorOfViews();
            while (viewIter.hasNext()) {
                ViewDiagram view = (ViewDiagram)viewIter.next();
                this.targetComboBox.addItem(view);
            }
            if (diag instanceof ViewDiagram) {
                this.targetComboBox.addItem(diag);
                this.setTarget((ViewDiagram)diag);
            } else if (this.viewModel.getSize() > 0) {
                this.setTarget((ViewDiagram)this.viewModel.getElementAt(0));
            }
        }
    }

    public void cancel() {
    }

    private void setTarget(ViewDiagram data) {
        if (this.target != data) {
            this.target = data;
            this.targetComboBox.setSelectedItem(data);
            this.nameField.setEnabled(data != null);
            this.setNameButton.setEnabled(data != null);
            if (data != null) {
                this.nameField.setText(data.getName());
                try {
                    FrameMain.get().selectTreeItem(data);
                }
                catch (Exception exception) {}
            } else {
                this.nameField.setText("");
                try {
                    FrameMain.get().selectTreeItem(this.getIncrement());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.fillDefinitionList();
        }
    }

    private ViewDiagram getTarget() {
        return this.target;
    }

    private void fillDefinitionList() {
        ViewDiagram data = this.getTarget();
        this.definitionsModel.clear();
        if (data == null) {
            return;
        }
        Iterator iter = data.iteratorOfViewDefinitions();
        while (iter.hasNext()) {
            ViewDefinition def = (ViewDefinition)iter.next();
            this.definitionsModel.addElement(def);
        }
        if (this.definitionsModel.size() > 0) {
            this.viewDefsList.getList().setSelectedIndex(0);
        }
    }

    private String createUniqueName(ViewDiagram data) {
        Iterator iter = null;
        boolean found = false;
        UMLDiagram diag = data.getDiagram();
        if (diag != null) {
            iter = diag.iteratorOfViews();
            while (iter.hasNext() && !found) {
                ViewDiagram tmpData = (ViewDiagram)iter.next();
                if (tmpData == data || tmpData.getName() == null || !tmpData.getName().equals(data.getName())) continue;
                found = true;
            }
            if (found) {
                int counter = 0;
                String name = data.getName();
                if (name.lastIndexOf("<") > -1 && name.lastIndexOf(">") > name.lastIndexOf("<")) {
                    String numText = name.substring(name.lastIndexOf("<") + 1, name.lastIndexOf(">"));
                    try {
                        counter = Integer.parseInt(numText);
                        name = name.substring(0, name.lastIndexOf("<")).trim();
                    }
                    catch (Exception exception) {}
                }
                while (found) {
                    ++counter;
                    found = false;
                    iter = diag.iteratorOfViews();
                    while (iter.hasNext() && !found) {
                        ViewDiagram tmpData = (ViewDiagram)iter.next();
                        if (tmpData == data || tmpData.getName() == null || !tmpData.getName().equals(String.valueOf(data.getName()) + " <" + counter + ">")) continue;
                        found = true;
                    }
                }
                data.setName(String.valueOf(data.getName()) + " <" + counter + ">");
            }
        }
        return data.getName();
    }

    public void itemStateChanged(ItemEvent e) {
        this.setTarget((ViewDiagram)this.targetComboBox.getSelectedItem());
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("addViewDefinition".equals(command)) {
            this.addDefinitionAction();
        } else if ("editViewDefinition".equals(command)) {
            this.editDefinitionAction();
        } else if ("removeViewDefinition".equals(command)) {
            this.removeDefinitionAction();
        } else if ("addView".equals(command)) {
            this.addViewAction();
        } else if ("removeView".equals(command)) {
            this.removeViewAction();
        } else if ("diagramName".equals(command) || e.getSource() == this.nameField) {
            this.diagramNameAction();
        }
    }

    private void diagramNameAction() {
        ViewDiagram data = this.getTarget();
        if (data == null) {
            return;
        }
        String newName = this.nameField.getText();
        String oldName = data.getName();
        if (oldName != null) {
            oldName = oldName.trim();
        }
        if (newName != null && !newName.trim().equals(oldName)) {
            data.setName(newName.trim());
            this.createUniqueName(data);
            FrameMain.get().createNewTreeItems();
            FrameMain.get().selectTreeItem(data);
        }
    }

    private void removeViewAction() {
        ViewDiagram diag = this.getTarget();
        if (diag == null) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(this, "Really delete this View?", "Delete View", 0, 2);
        if (result == 0) {
            boolean update = false;
            UMLDiagram source = diag.getDiagram();
            if (diag == this.getIncrement()) {
                update = true;
            }
            this.targetComboBox.removeItem(diag);
            this.removeView(diag);
            if (update) {
                this.setIncrement(source);
            }
        }
    }

    private void addViewAction() {
        ViewDiagram result = null;
        UMLDiagram source = (UMLDiagram)this.getIncrement();
        if (source == null) {
            return;
        }
        String name = this.nameField.getText();
        if (name == null || name.trim().length() == 0 || this.getTarget() != null && name.equals(this.getTarget().getName())) {
            name = "Unnamed View";
        }
        result = new ViewDiagram(name, (UMLProject)source.getProject());
        result.setDiagram(source);
        this.createUniqueName(result);
        FrameMain.get().createNewTreeItems();
        FrameMain.get().selectTreeItem(result);
        this.targetComboBox.addItem(result);
        this.targetComboBox.setSelectedItem(result);
    }

    private void removeDefinitionAction() {
        Object selected = this.viewDefsList.getList().getSelectedValue();
        if (selected instanceof ViewDefinition) {
            ViewDefinition def = (ViewDefinition)selected;
            this.definitionsModel.removeElement(selected);
            def.removeYou();
            UMLProject.get().refreshDisplay();
        }
    }

    private void addDefinitionAction() {
        ViewDefinition newDef = new ViewDefinition();
        newDef.setName("<Unnamed Definition>");
        ViewDefinitionDialog dialog = new ViewDefinitionDialog(null);
        UMLDiagram source = (UMLDiagram)this.getIncrement();
        if (source != null && source == this.getTarget()) {
            source = ((ViewDiagram)source).getDiagram();
        }
        dialog.addToSourceDiagrams(source);
        dialog.setView(newDef);
        dialog.showCentered();
        if (dialog.getPressedButton() == 1) {
            if (this.getTarget() != null) {
                this.getTarget().addToViewDefinitions(newDef);
                this.definitionsModel.addElement(newDef);
                UMLProject.get().refreshDisplay();
            } else {
                newDef.removeYou();
            }
        } else {
            newDef.removeYou();
        }
    }

    public void editDefinitionAction() {
        ViewDefinition def = (ViewDefinition)this.viewDefsList.getList().getSelectedValue();
        if (def == null) {
            return;
        }
        ViewDefinitionDialog dialog = new ViewDefinitionDialog(null);
        UMLDiagram source = null;
        if (def.getDiagram() != null) {
            source = def.getDiagram();
            if (((ViewDiagram)source).getDiagram() != null) {
                source = ((ViewDiagram)source).getDiagram();
            } else if (((ViewDiagram)source).getDiagram() != null) {
                source = ((ViewDiagram)source).getDiagram();
            }
        } else {
            source = (UMLDiagram)this.getIncrement();
        }
        dialog.addToSourceDiagrams(source);
        dialog.setView(def);
        dialog.showCentered();
        this.viewDefsList.repaint();
        UMLProject.get().refreshDisplay();
    }

    private void removeView(ViewDiagram diag) {
        Iterator iter = diag.iteratorOfViews();
        while (iter.hasNext()) {
            ViewDiagram tmpDiag = (ViewDiagram)iter.next();
            this.removeSubView(tmpDiag);
        }
        UMLDiagram source = diag.getDiagram();
        diag.removeYou();
        FrameMain.get().createNewTreeItems();
        if (source == null && (source = (UMLDiagram)this.getIncrement()) == diag) {
            source = null;
        }
        if (source != null) {
            FrameMain.get().selectTreeItem(source);
        }
        System.gc();
    }

    private void removeSubView(ViewDiagram diag) {
        Iterator iter = diag.iteratorOfViews();
        while (iter.hasNext()) {
            ViewDiagram tmpDiag = (ViewDiagram)iter.next();
            this.removeSubView(tmpDiag);
        }
        diag.removeYou();
    }
}

