/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.tools.fsa;

import de.uni_paderborn.tools.fsa.FSAUtility;
import de.upb.tools.fca.FEmptyIterator;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public class FSATypeConverterCache {
    public static final String DEFAULT_CONVERTER_METHOD = "dcm";
    private static FSATypeConverterCache theInstance = null;
    private TreeMap methodCache = null;
    static /* synthetic */ Class class$0;

    private FSATypeConverterCache() {
    }

    public static FSATypeConverterCache get() {
        if (theInstance == null) {
            theInstance = new FSATypeConverterCache();
        }
        return theInstance;
    }

    private Method[] findConverterMethod(Class sourceClass, Class targetClass, String methodName) {
        Method[] converterMethods = this.getConverterMethods(sourceClass, targetClass);
        int i = 0;
        int length = converterMethods.length;
        boolean found = false;
        Method[] converter = new Method[1];
        while (i < length && !found) {
            if (converterMethods[i].getName().equals(methodName)) {
                found = true;
                converter[0] = converterMethods[i];
            }
            ++i;
        }
        return converter;
    }

    private Method[] findConverterMethods(Class sourceClass, Class targetClass) {
        Method[] classMethods;
        Object[] converterParameters = new Class[]{sourceClass};
        Object[] modifierParameters = new Class[]{sourceClass, targetClass};
        Method[] converter = null;
        Vector<Method> converterMethods = new Vector<Method>();
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.uni_paderborn.tools.fsa.FSATypeConverterMethods");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classMethods = clazz.getMethods();
        }
        catch (SecurityException exception) {
            classMethods = new Method[]{};
        }
        int i = 0;
        while (i < classMethods.length) {
            if (classMethods[i].getReturnType().equals(targetClass) && (Arrays.equals(classMethods[i].getParameterTypes(), converterParameters) || Arrays.equals(classMethods[i].getParameterTypes(), modifierParameters))) {
                converterMethods.add(classMethods[i]);
            }
            ++i;
        }
        converter = new Method[converterMethods.size()];
        i = 0;
        while (i < converterMethods.size()) {
            converter[i] = (Method)converterMethods.elementAt(i);
            ++i;
        }
        return converter;
    }

    public Method getDefaultConverterMethods(Class sourceClass, Class targetClass) {
        String key = this.createMethodCacheKey(sourceClass, targetClass, DEFAULT_CONVERTER_METHOD);
        Method[] converter = this.getFromMethodCache(key);
        if (converter == null) {
            String sourceClassName = FSAUtility.downFirstChar(FSAUtility.getClassName(sourceClass.getName()));
            String targetClassName = FSAUtility.getClassName(targetClass.getName());
            String methodName = String.valueOf(sourceClassName) + "To" + targetClassName;
            converter = this.findConverterMethod(sourceClass, targetClass, methodName);
            this.addToMethodCache(key, converter);
        }
        return converter[0];
    }

    public Method[] getConverterMethods(Class sourceClass, Class targetClass) {
        String key = this.createMethodCacheKey(sourceClass, targetClass);
        Method[] converter = this.getFromMethodCache(key);
        if (converter == null) {
            converter = this.findConverterMethods(sourceClass, targetClass);
            this.addToMethodCache(key, converter);
        }
        return converter;
    }

    public String createMethodCacheKey(Class sourceClass, Class targetClass, String methodName) {
        return String.valueOf(sourceClass.getName()) + ":" + targetClass.getName() + ":" + methodName;
    }

    public String createMethodCacheKey(Class sourceClass, Class targetClass) {
        return String.valueOf(sourceClass.getName()) + ":" + targetClass.getName();
    }

    private boolean hasKeyInMethodCache(String key) {
        if (this.methodCache == null) {
            return false;
        }
        return this.methodCache.containsKey(key);
    }

    private Iterator iteratorOfMethodCache() {
        if (this.methodCache == null) {
            return FEmptyIterator.get();
        }
        return this.methodCache.values().iterator();
    }

    private Iterator keysOfMethodCache() {
        if (this.methodCache == null) {
            return FEmptyIterator.get();
        }
        return this.methodCache.keySet().iterator();
    }

    private Iterator entriesOfMethodCache() {
        if (this.methodCache == null) {
            return FEmptyIterator.get();
        }
        return this.methodCache.entrySet().iterator();
    }

    private Method[] getFromMethodCache(String key) {
        Method[] elem = this.hasKeyInMethodCache(key) ? (Method[])this.methodCache.get(key) : (Method[])null;
        return elem;
    }

    private void addToMethodCache(String key, Method[] elem) {
        if (key != null && elem != null) {
            if (this.methodCache == null) {
                this.methodCache = new TreeMap();
            }
            this.methodCache.put(key, elem);
        }
    }

    private void removeKeyFromMethodCache(String key) {
        if (this.hasKeyInMethodCache(key)) {
            this.methodCache.remove(key);
        }
    }

    private void removeAllFromMethodCache() {
        Iterator iter = this.keysOfMethodCache();
        String tmpKey = null;
        while (iter.hasNext()) {
            tmpKey = (String)iter.next();
            iter.remove();
            this.removeKeyFromMethodCache(tmpKey);
        }
    }
}

