/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.tools.util;

import de.uni_paderborn.tools.util.TextUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ClassDeclaration {
    public static final String VALID_DECLARATION = "Valid declaration";
    public static final String EMPTY_DECLARATION = "Nothing defined";
    public static final String INVALID_CLASS_DECLARATION = "Invalid class declaration";
    public static final String CLASS_IS_KEYWORD = "The name of the class is a Java keyword";
    public static final String ILLEGAL_CONSTRUCTORS_DECLARATION = "Illegal declaration of constructors";
    public static final String NO_CONSTRUCTORS_ALLOWED = "Interfaces are not allowed to own constructors";
    public static final String UNPRECISE_CONSTRUCTORS_DECLARATION = "Constructor declaration unprecise; interpreted as its best";
    private String original = "";
    private String classError = "Nothing defined";
    private boolean isAbstract = false;
    private boolean isStatic = false;
    private boolean isInterface = false;
    private boolean isPersistent = false;
    private boolean isReference = false;
    private String name;
    private String packageName;
    private HashSet constructors;
    private int paramcount = 0;

    public ClassDeclaration(String declaration) {
        if (declaration == null) {
            throw new NullPointerException("Parameter declaration is null");
        }
        this.original = declaration;
        this.constructors = new HashSet();
        this.name = "";
        this.packageName = "";
        this.parse();
    }

    private void parse() {
        if (this.original.length() == 0) {
            return;
        }
        String s = this.original.trim();
        if (s.length() == 0) {
            this.classError = EMPTY_DECLARATION;
            return;
        }
        String param = "";
        StringTokenizer token = null;
        if (s.indexOf("(") == -1) {
            token = new StringTokenizer(s);
        } else {
            token = new StringTokenizer(s.substring(0, s.indexOf("(")));
            param = s.substring(s.indexOf("("));
        }
        int counter = token.countTokens();
        while (token.hasMoreTokens()) {
            String str = token.nextToken();
            if (counter == 1) {
                if (!TextUtil.isJavaSuitable(str)) {
                    if (str.lastIndexOf(".") != -1) {
                        this.packageName = str.substring(0, str.lastIndexOf("."));
                        this.name = str.substring(str.lastIndexOf(".") + 1);
                        break;
                    }
                    this.classError = INVALID_CLASS_DECLARATION;
                    this.clear();
                    return;
                }
                if (TextUtil.isJavaKeyword(str)) {
                    this.classError = CLASS_IS_KEYWORD;
                    this.clear();
                    return;
                }
                if (str.lastIndexOf(".") == -1) {
                    this.name = str;
                    break;
                }
                this.packageName = str.substring(0, str.lastIndexOf("."));
                this.name = str.substring(str.lastIndexOf(".") + 1);
                break;
            }
            if (counter == 2) {
                if (str.equalsIgnoreCase("interface") || str.equalsIgnoreCase("i")) {
                    this.isInterface = true;
                    --counter;
                    continue;
                }
                if (str.equalsIgnoreCase("new")) {
                    --counter;
                    continue;
                }
            }
            if (str.equalsIgnoreCase("static") || str.equalsIgnoreCase("s")) {
                this.isStatic = true;
            } else if (str.equalsIgnoreCase("abstract") || str.equalsIgnoreCase("a")) {
                this.isAbstract = true;
            } else if (str.equalsIgnoreCase("persistent") || str.equalsIgnoreCase("p")) {
                this.isPersistent = true;
            } else if (str.equalsIgnoreCase("reference") || str.equalsIgnoreCase("r")) {
                this.isReference = true;
            } else {
                this.classError = INVALID_CLASS_DECLARATION;
                this.clear();
                return;
            }
            --counter;
        }
        this.classError = VALID_DECLARATION;
        int b = this.parseParam(param);
        if (b == -1) {
            this.classError = ILLEGAL_CONSTRUCTORS_DECLARATION;
        } else if (b > 0) {
            this.classError = UNPRECISE_CONSTRUCTORS_DECLARATION;
        }
    }

    private int parseParam(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        if (this.isInterface) {
            this.classError = NO_CONSTRUCTORS_ALLOWED;
            return 0;
        }
        int mistakes = 0;
        int on = -1;
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '(': {
                    if (on == -1) {
                        on = i + 1;
                        break;
                    }
                    on = i + 1;
                    ++mistakes;
                    break;
                }
                case ')': {
                    if (on != -1) {
                        if (!this.putToConstructors(str.substring(on, i))) {
                            ++mistakes;
                        }
                        on = -1;
                        break;
                    }
                    ++mistakes;
                }
            }
            ++i;
        }
        return mistakes;
    }

    private boolean putToConstructors(String string) {
        if (string == null || string.trim().length() == 0) {
            Vector vector = new Vector();
            this.constructors.add(vector);
            return true;
        }
        StringTokenizer token = new StringTokenizer(string, ";,");
        if (token.countTokens() == 0) {
            return false;
        }
        Vector<String> vector = new Vector<String>();
        while (token.hasMoreTokens()) {
            String newvalue;
            String str = token.nextToken().trim();
            if (str.indexOf(":") == -1) {
                if (str.indexOf(" ") == -1) {
                    if (!TextUtil.isJavaSuitable(str)) {
                        return false;
                    }
                    String newvalue2 = "p" + this.paramcount;
                    while (vector.contains(newvalue2)) {
                        ++this.paramcount;
                        newvalue2 = "p" + this.paramcount;
                    }
                    vector.add(TextUtil.makeFujabaSuitable(str));
                    vector.add(newvalue2);
                    continue;
                }
                String param = str.substring(0, str.indexOf(" ")).trim();
                String value = str.substring(str.indexOf(" ")).trim();
                if (!TextUtil.isJavaSuitable(param) || !TextUtil.isJavaSuitable(value)) {
                    return false;
                }
                newvalue = value;
                while (vector.contains(newvalue)) {
                    ++this.paramcount;
                    newvalue = String.valueOf(value) + this.paramcount;
                }
                vector.add(TextUtil.makeFujabaSuitable(param));
                vector.add(newvalue);
                continue;
            }
            String value = str.substring(0, str.indexOf(":")).trim();
            String param = str.substring(str.indexOf(":") + 1).trim();
            if (!TextUtil.isJavaSuitable(param) || !TextUtil.isJavaSuitable(value) || param.length() == 0) {
                return false;
            }
            newvalue = value;
            if (newvalue.length() == 0) {
                newvalue = "p" + this.paramcount;
            }
            while (vector.contains(newvalue)) {
                ++this.paramcount;
                newvalue = String.valueOf(value) + this.paramcount;
            }
            vector.add(TextUtil.makeFujabaSuitable(param));
            vector.add(newvalue);
        }
        this.constructors.add(vector);
        return true;
    }

    public HashSet getConstructors() {
        return this.constructors;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        StringBuffer buff = new StringBuffer();
        buff.append("Name: ");
        if (this.name.length() == 0) {
            buff.append("<<empty>>");
        } else {
            if (this.packageName.length() > 0) {
                buff.append(this.packageName).append(".");
            }
            buff.append(this.name);
        }
        buff.append("\n\n");
        buff.append("Type:\n");
        if (this.isEmpty()) {
            buff.append("EMPTY").append("\n");
        } else if (this.isInterface()) {
            buff.append("Interface --").append(this.getClassError()).append("\n");
        } else {
            buff.append("Class -- ").append(this.getClassError()).append("\n");
        }
        buff.append("\n");
        if (this.isStatic) {
            buff.append("static\n");
        }
        if (this.isAbstract) {
            buff.append("abstract\n");
        }
        if (this.isPersistent) {
            buff.append("persistent\n");
        }
        if (this.isReference) {
            buff.append("reference\n");
        }
        buff.append("\n\nConstructors:\n");
        boolean empty = true;
        Iterator iter = this.getConstructors().iterator();
        while (iter.hasNext()) {
            empty = false;
            Vector vector = (Vector)iter.next();
            buff.append(this.name).append(" (");
            int i = 0;
            while (i < vector.size()) {
                String key = (String)vector.get(i);
                String value = (String)vector.get(i + 1);
                buff.append(value).append(":").append(key);
                if (i < vector.size() - 2) {
                    buff.append(", ");
                }
                i += 2;
            }
            buff.append(")");
        }
        if (empty && this.isInterface()) {
            buff.append("<<not possible>>");
        } else if (empty) {
            buff.append("<<none>>");
        }
        return buff.toString();
    }

    public void showStatus() {
        JOptionPane.showMessageDialog(null, this.getStatus());
    }

    public String getClassError() {
        if (this.classError == EMPTY_DECLARATION) {
            return EMPTY_DECLARATION;
        }
        return this.classError;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public boolean isEmpty() {
        return this.classError == EMPTY_DECLARATION;
    }

    public boolean isValid() {
        return this.classError != EMPTY_DECLARATION && this.classError != INVALID_CLASS_DECLARATION && this.classError != CLASS_IS_KEYWORD;
    }

    public String getPackage() {
        return this.packageName;
    }

    public void clear() {
        this.isAbstract = false;
        this.isStatic = false;
        this.isInterface = false;
        this.isPersistent = true;
        this.isReference = true;
    }
}

