/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.tools.util;

import java.util.HashSet;

public final class TextUtil {
    private static HashSet set = new HashSet();

    static {
        set.add("abstract");
        set.add("boolean");
        set.add("break");
        set.add("byte");
        set.add("case");
        set.add("catch");
        set.add("char");
        set.add("class");
        set.add("const");
        set.add("continue");
        set.add("default");
        set.add("do");
        set.add("double");
        set.add("else");
        set.add("extends");
        set.add("final");
        set.add("finally");
        set.add("float");
        set.add("for");
        set.add("goto");
        set.add("if");
        set.add("implements");
        set.add("import");
        set.add("instanceof");
        set.add("int");
        set.add("interface");
        set.add("long");
        set.add("native");
        set.add("new");
        set.add("package");
        set.add("private");
        set.add("protected");
        set.add("public");
        set.add("return");
        set.add("short");
        set.add("static");
        set.add("strictfp");
        set.add("super");
        set.add("switch");
        set.add("synchronized");
        set.add("this");
        set.add("throw");
        set.add("throws");
        set.add("transient");
        set.add("try");
        set.add("void");
        set.add("volatile");
        set.add("while");
    }

    private TextUtil() {
    }

    public static boolean isJavaKeyword(String str) {
        return TextUtil.isJavaKeyword(str, true, true);
    }

    public static boolean isJavaKeyword(String str, boolean literalsIncluded) {
        return TextUtil.isJavaKeyword(str, literalsIncluded, true);
    }

    public static boolean isJavaKeyword(String str, boolean literalsIncluded, boolean trim) {
        if (str == null) {
            return false;
        }
        return set.contains(str = str.trim()) || literalsIncluded && (str.equals("true") || str.equals("false") || str.equals("null"));
    }

    public static boolean isJavaIdentifier(String string) {
        return TextUtil.isJavaIdentifier(string, true);
    }

    public static boolean isJavaSuitable(String string) {
        return TextUtil.isJavaIdentifier(string, true);
    }

    public static boolean isJavaIdentifier(String string, boolean considerStartLetter) {
        int j;
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return true;
        }
        if (considerStartLetter) {
            if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                return false;
            }
            j = 1;
        } else {
            j = 0;
        }
        int i = j;
        while (i < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isJavaSuitable(String string, boolean considerStartLetter) {
        return TextUtil.isJavaIdentifier(string, considerStartLetter);
    }

    public static String makeFujabaSuitable(String s) {
        String rType = s;
        if (rType.equals("void")) {
            rType = "Void";
        } else if (rType.equals("boolean")) {
            rType = "Boolean";
        } else if (rType.equals("boolean[]")) {
            rType = "BooleanArray";
        } else if (rType.equals("byte")) {
            rType = "Byte";
        } else if (rType.equals("byte[]")) {
            rType = "ByteArray";
        } else if (rType.equals("char")) {
            rType = "Character";
        } else if (rType.equals("char[]")) {
            rType = "CharacterArray";
        } else if (rType.equals("double")) {
            rType = "Double";
        } else if (rType.equals("double[]")) {
            rType = "DoubleArray";
        } else if (rType.equals("float")) {
            rType = "Float";
        } else if (rType.equals("float[]")) {
            rType = "FloatArray";
        } else if (rType.equals("int")) {
            rType = "Integer";
        } else if (rType.equals("int[]")) {
            rType = "IntegerArray";
        } else if (rType.equals("long")) {
            rType = "LongInteger";
        } else if (rType.equals("long[]")) {
            rType = "LongIntegerArray";
        } else if (rType.equals("short")) {
            rType = "ShortInteger";
        } else if (rType.equals("short[]")) {
            rType = "ShortIntegerArray";
        } else if (rType.equals("String[]")) {
            rType = "StringArray";
        }
        return rType;
    }

    public static String getNameWithoutPackage(String className) {
        if (className == null) {
            return "";
        }
        int iIndex = className.lastIndexOf(".");
        if (iIndex != -1) {
            return className.substring(iIndex + 1);
        }
        return className;
    }

    public static String getPackageWithoutName(String className) {
        if (className == null) {
            return "";
        }
        int iIndex = className.lastIndexOf(".");
        if (iIndex != -1) {
            return className.substring(0, iIndex);
        }
        return "";
    }
}

