/*
 * Decompiled with CFR 0.152.
 */
package de.upb.javaast.methodast;

import de.upb.javaast.methodast.ExpressionNode;
import de.upb.javaast.methodast.PrimaryExpressionNode;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FLinkedList;
import java.util.Iterator;

public class MethodCallNode
extends PrimaryExpressionNode {
    private FLinkedList arguments;

    public MethodCallNode() {
        this.setLeftParenthesis("(");
        this.setRightParenthesis(")");
    }

    public boolean addToArguments(ExpressionNode value) {
        boolean changed = false;
        if (value != null && !this.hasInArguments(value)) {
            if (this.arguments == null) {
                this.arguments = new FLinkedList();
            }
            if (changed = this.arguments.add((Object)value)) {
                value.setMethod(this);
            }
        }
        return changed;
    }

    public boolean hasInArguments(ExpressionNode value) {
        return this.arguments != null && value != null && this.arguments.contains((Object)value);
    }

    public ExpressionNode getFirstOfArguments() {
        if (this.arguments == null) {
            return null;
        }
        if (this.arguments.size() == 0) {
            return null;
        }
        return (ExpressionNode)((Object)this.arguments.getFirst());
    }

    public Iterator iteratorOfArguments() {
        return this.arguments == null ? FEmptyIterator.get() : this.arguments.iterator();
    }

    public void removeAllFromArguments() {
        Iterator iter = this.iteratorOfArguments();
        while (iter.hasNext()) {
            ExpressionNode tmpValue = (ExpressionNode)((Object)iter.next());
            this.removeFromArguments(tmpValue);
        }
    }

    public boolean removeFromArguments(ExpressionNode value) {
        boolean changed = false;
        if (this.arguments != null && value != null && (changed = this.arguments.remove((Object)value))) {
            value.setMethod(null);
        }
        return changed;
    }

    public int sizeOfArguments() {
        return this.arguments == null ? 0 : this.arguments.size();
    }

    public StringBuffer getSourceCode() {
        StringBuffer buffer = new StringBuffer();
        if (this.getText() != null) {
            buffer.append(this.getText());
        }
        buffer.append(this.getIdentifier().getSourceCode());
        buffer.append(this.getLeftParenthesis());
        Iterator iter = this.iteratorOfArguments();
        while (iter.hasNext()) {
            ExpressionNode expressionNode = (ExpressionNode)((Object)iter.next());
            buffer.append(expressionNode.getSourceCode());
        }
        buffer.append(this.getRightParenthesis());
        if (this.getNextPrimaryExpression() != null) {
            buffer.append(this.getNextPrimaryExpression().getSourceCode());
        }
        return buffer;
    }

    public void removeYou() {
        this.removeAllFromArguments();
        super.removeYou();
    }
}

