/*
 * Decompiled with CFR 0.152.
 */
package de.upb.javaast.methodast;

import de.upb.javaast.methodast.CaseNode;
import de.upb.javaast.methodast.ExpressionNode;
import de.upb.javaast.methodast.StatementNode;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FLinkedList;
import java.util.Iterator;

public class SwitchNode
extends StatementNode {
    private String switchText;
    private String leftBrace;
    private String rightBrace;
    private String leftParenthesis;
    private String rightParenthesis;
    private FLinkedList caseStatements;
    private ExpressionNode switchExpression;

    public String getSwitchText() {
        return this.switchText;
    }

    public void setSwitchText(String value) {
        this.switchText = value;
    }

    public String getLeftBrace() {
        return this.leftBrace;
    }

    public void setLeftBrace(String value) {
        this.leftBrace = value;
    }

    public String getRightBrace() {
        return this.rightBrace;
    }

    public void setRightBrace(String value) {
        this.rightBrace = value;
    }

    public String getLeftParenthesis() {
        return this.leftParenthesis;
    }

    public void setLeftParenthesis(String value) {
        this.leftParenthesis = value;
    }

    public String getRightParenthesis() {
        return this.rightParenthesis;
    }

    public void setRightParenthesis(String value) {
        this.rightParenthesis = value;
    }

    public boolean addToCaseStatements(CaseNode value) {
        boolean changed = false;
        if (value != null && !this.hasInCaseStatements(value)) {
            if (this.caseStatements == null) {
                this.caseStatements = new FLinkedList();
            }
            if (changed = this.caseStatements.add((Object)value)) {
                value.setSwitchStatement(this);
            }
        }
        return changed;
    }

    public boolean hasInCaseStatements(CaseNode value) {
        return this.caseStatements != null && value != null && this.caseStatements.contains((Object)value);
    }

    public Iterator iteratorOfCaseStatements() {
        return this.caseStatements == null ? FEmptyIterator.get() : this.caseStatements.iterator();
    }

    public void removeAllFromCaseStatements() {
        Iterator iter = this.iteratorOfCaseStatements();
        while (iter.hasNext()) {
            CaseNode tmpValue = (CaseNode)((Object)iter.next());
            this.removeFromCaseStatements(tmpValue);
        }
    }

    public boolean removeFromCaseStatements(CaseNode value) {
        boolean changed = false;
        if (this.caseStatements != null && value != null && (changed = this.caseStatements.remove((Object)value))) {
            value.setSwitchStatement(null);
        }
        return changed;
    }

    public int sizeOfCaseStatements() {
        return this.caseStatements == null ? 0 : this.caseStatements.size();
    }

    public ExpressionNode getSwitchExpression() {
        return this.switchExpression;
    }

    public boolean setSwitchExpression(ExpressionNode value) {
        boolean changed = false;
        if (this.switchExpression != value) {
            if (this.switchExpression != null) {
                ExpressionNode oldValue = this.switchExpression;
                this.switchExpression = null;
                oldValue.setSwitchStatement(null);
            }
            this.switchExpression = value;
            if (value != null) {
                value.setSwitchStatement(this);
            }
            changed = true;
        }
        return changed;
    }

    public StringBuffer getSourceCode() {
        StringBuffer buffer = new StringBuffer(this.getSwitchText());
        buffer.append(this.getLeftParenthesis());
        buffer.append(this.getSwitchExpression().getSourceCode());
        buffer.append(this.getRightParenthesis());
        buffer.append(this.getLeftBrace());
        Iterator iter = this.iteratorOfCaseStatements();
        while (iter.hasNext()) {
            CaseNode caseNode = (CaseNode)((Object)iter.next());
            buffer.append(caseNode.getSourceCode());
        }
        buffer.append(this.getRightBrace());
        return buffer;
    }

    public void removeYou() {
        this.removeAllFromCaseStatements();
        ExpressionNode tmpSwitchExpression = this.getSwitchExpression();
        if (tmpSwitchExpression != null) {
            this.setSwitchExpression(null);
        }
        super.removeYou();
    }
}

