/*
 * Decompiled with CFR 0.152.
 */
package de.upb.javaast.methodast.visitors;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLNopActivity;
import de.uni_paderborn.fujaba.uml.UMLStartActivity;
import de.uni_paderborn.fujaba.uml.UMLStatement;
import de.uni_paderborn.fujaba.uml.UMLStatementActivity;
import de.uni_paderborn.fujaba.uml.UMLStopActivity;
import de.uni_paderborn.fujaba.uml.UMLTransition;
import de.uni_paderborn.fujaba.uml.UMLTransitionGuard;
import de.upb.javaast.methodast.CaseNode;
import de.upb.javaast.methodast.DoNode;
import de.upb.javaast.methodast.ForNode;
import de.upb.javaast.methodast.IfNode;
import de.upb.javaast.methodast.ReturnNode;
import de.upb.javaast.methodast.RootBlockNode;
import de.upb.javaast.methodast.StatementExpressionNode;
import de.upb.javaast.methodast.StatementNode;
import de.upb.javaast.methodast.SwitchNode;
import de.upb.javaast.methodast.VariableDeclarationNode;
import de.upb.javaast.methodast.WhileNode;
import de.upb.javaast.methodast.visitors.MethodASTVisitor;
import java.util.Iterator;

public class UMLActivityDiagramGenerator
extends MethodASTVisitor {
    private static final byte STATEMENTS_BEGIN = 0;
    private static final byte STATEMENTS = 1;
    private static final byte STATEMENTS_END = 2;
    private byte state;
    private final UMLActivityDiagram activityDiagram;
    private UMLMethod umlMethod;
    private UMLActivity lastActivity;
    private UMLStatementActivity currentStatementActivity;
    private StringBuffer statementBuffer;

    public UMLActivityDiagramGenerator(UMLActivityDiagram activityDiagram) {
        this.umlMethod = activityDiagram.getStartActivity().getSpec();
        this.activityDiagram = activityDiagram;
        this.state = 0;
    }

    public void visitUMLMethod(UMLMethod method) {
        Iterator iter = this.activityDiagram.iteratorOfElements();
        while (iter.hasNext()) {
            UMLActivity activity = (UMLActivity)iter.next();
            activity.removeYou();
        }
        super.visitUMLMethod(method);
        this.state = (byte)2;
        this.endStatementBlock();
        this.appendStopActivity(null);
    }

    public void visitStatementExpressionNode(StatementExpressionNode statementExpressionNode) {
        this.appendStatementNode(statementExpressionNode);
        super.visitStatementExpressionNode(statementExpressionNode);
    }

    public void visitVariableDeclarationNode(VariableDeclarationNode variableDeclarationNode) {
        this.appendStatementNode(variableDeclarationNode);
        super.visitVariableDeclarationNode(variableDeclarationNode);
    }

    public void visitRootBlockNode(RootBlockNode rootBlockNode) {
        System.out.println("visitRootBlockNode");
        UMLStartActivity startActivity = new UMLStartActivity(this.umlMethod);
        this.activityDiagram.addToElements((ASGElement)startActivity);
        this.lastActivity = startActivity;
        this.state = 0;
        super.visitRootBlockNode(rootBlockNode);
    }

    public void visitIfNode(IfNode ifNode) {
    }

    public void visitForNode(ForNode forNode) {
    }

    public void visitWhileNode(WhileNode whileNode) {
        this.state = (byte)2;
        this.endStatementBlock();
        UMLNopActivity startNopActivity = new UMLNopActivity();
        this.activityDiagram.addToElements((ASGElement)startNopActivity);
        UMLTransition transition = this.createTransition(this.lastActivity, (UMLActivity)startNopActivity, 0);
        this.activityDiagram.addToElements((ASGElement)transition);
        UMLNopActivity endNopActivity = new UMLNopActivity();
        this.activityDiagram.addToElements((ASGElement)endNopActivity);
        transition = this.createTransition((UMLActivity)startNopActivity, (UMLActivity)endNopActivity, 5);
        this.activityDiagram.addToElements((ASGElement)transition);
        this.startStatementBlock();
        super.visitWhileNode(whileNode);
        this.endStatementBlock();
        transition = this.createTransition((UMLActivity)startNopActivity, (UMLActivity)this.currentStatementActivity, 6);
        transition.getGuard().setBoolExpr(whileNode.getLoopExpression().toString());
        this.activityDiagram.addToElements((ASGElement)transition);
        this.lastActivity = endNopActivity;
    }

    public void visitDoNode(DoNode doNode) {
    }

    public void visitSwitchNode(SwitchNode switchNode) {
    }

    public void visitCaseNode(CaseNode caseNode) {
    }

    public void visitReturnNode(ReturnNode returnNode) {
        System.out.println("visitReturnNode");
        this.state = (byte)2;
        UMLStopActivity umlStopActivity = new UMLStopActivity();
        umlStopActivity.setReturnValue(returnNode.getReturnExpression().toString());
    }

    private void appendStatementNode(StatementNode statementNode) {
        switch (this.state) {
            case 0: {
                this.startStatementBlock();
                this.statementBuffer.append(statementNode.getSourceCode());
                break;
            }
            case 1: {
                this.statementBuffer.append(statementNode.getSourceCode());
                break;
            }
            case 2: {
                this.endStatementBlock();
            }
        }
    }

    private void startStatementBlock() {
        this.currentStatementActivity = new UMLStatementActivity();
        this.activityDiagram.addToElements((ASGElement)this.currentStatementActivity);
        this.statementBuffer = new StringBuffer();
        this.state = 1;
    }

    private void endStatementBlock() {
        if (this.statementBuffer != null) {
            UMLStatement statement = new UMLStatement();
            statement.setActivity(this.currentStatementActivity);
            statement.setStatement(this.statementBuffer.toString());
            UMLTransition transition = this.createTransition(this.lastActivity, (UMLActivity)this.currentStatementActivity, 0);
            this.activityDiagram.addToElements((ASGElement)transition);
            this.state = 0;
            this.lastActivity = this.currentStatementActivity;
            this.currentStatementActivity = null;
            this.statementBuffer = null;
        }
    }

    private void appendStopActivity(String returnText) {
        UMLStopActivity stopActivity = new UMLStopActivity();
        stopActivity.setReturnValue(returnText);
        this.activityDiagram.addToElements((ASGElement)stopActivity);
        UMLTransition transition = this.createTransition(this.lastActivity, (UMLActivity)stopActivity, 0);
        this.activityDiagram.addToElements((ASGElement)transition);
    }

    private UMLTransition createTransition(UMLActivity sourceActivity, UMLActivity targetActivity, int type) {
        UMLTransitionGuard guard = new UMLTransitionGuard(type, null, null);
        return new UMLTransition(sourceActivity, targetActivity, guard);
    }
}

