/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.actions;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.upb.inferenceengine.InferenceEngine;
import de.upb.inferenceengine.RuleCatalog;
import de.upb.inferenceengine.output.AnnotationsFileWriter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class WriteAnnotationsToFileAction
extends AbstractAction {
    public void actionPerformed(ActionEvent e) {
        RuleCatalog ruleCatalog = InferenceEngine.get().getCurrentCatalog();
        if (ruleCatalog != null && ruleCatalog.getGfrn() != null && ruleCatalog.getGfrn().sizeOfResults() != 0) {
            AnnotationsFileWriter writer = new AnnotationsFileWriter(ruleCatalog.getGfrn());
            File file = this.getFile();
            if (file != null) {
                writer.save(file);
            }
        }
    }

    private File getFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Save Annotations");
        fileChooser.setDialogType(1);
        File file = null;
        while (file == null) {
            int state = fileChooser.showSaveDialog((Component)FrameMain.get());
            if (state == 0) {
                int option;
                file = fileChooser.getSelectedFile();
                String path = file.getPath();
                if (!path.toLowerCase().endsWith(".xml")) {
                    path = String.valueOf(path) + ".xml";
                    file = new File(path);
                }
                if (!file.exists() || (option = JOptionPane.showConfirmDialog((Component)FrameMain.get(), "Overwrite the existing file\n" + file.getAbsolutePath() + "?", "The catalog already exists!", 0, 3)) != 1) continue;
                file = null;
                continue;
            }
            if (state != 1) continue;
            return null;
        }
        return file;
    }
}

