/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.dialogs;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.AbstractDialog;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.upb.inferenceengine.engines.GFRNAnnotation;
import de.upb.inferenceengine.uml.UMLAnnotation;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class AddAnnotationDialog
extends AbstractDialog {
    private UMLClassDiagram classDiagram;
    private JTextField nameTextField;
    private JTextField fuzzyValueTextField;
    private JComboBox classificationComboBox;
    JComboBox elementsComboBox;
    JTextField qualifierTextField;
    ElementQualifierPairsListModel listModel;

    public AddAnnotationDialog(JFrame parent, UMLClassDiagram classDiagram) {
        super(parent, true);
        this.classDiagram = classDiagram;
        this.setTitle("Create Annotation");
        this.createUserInterface();
        this.initialize();
    }

    protected JPanel createMainPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(gridBag);
        panel.setBorder(new TitledBorder("Properties"));
        JLabel nameLabel = new JLabel("Name:");
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.insets = new Insets(4, 3, 0, 3);
        constraints.weightx = 1.0;
        panel.add((Component)nameLabel, constraints);
        this.nameTextField = new JTextField();
        constraints.insets = new Insets(0, 3, 0, 3);
        panel.add((Component)this.nameTextField, constraints);
        JLabel fuzzyValueLabel = new JLabel("Fuzzy Value:");
        constraints.insets = new Insets(3, 3, 0, 3);
        panel.add((Component)fuzzyValueLabel, constraints);
        this.fuzzyValueTextField = new JTextField();
        constraints.insets = new Insets(0, 3, 0, 3);
        panel.add((Component)this.fuzzyValueTextField, constraints);
        JLabel classificationLabel = new JLabel("classification:");
        constraints.insets = new Insets(3, 3, 0, 3);
        panel.add((Component)classificationLabel, constraints);
        this.classificationComboBox = new JComboBox();
        constraints.insets = new Insets(0, 3, 0, 3);
        this.classificationComboBox.addItem("\u00abneutral\u00bb");
        this.classificationComboBox.addItem("\u00abdesign pattern\u00bb");
        this.classificationComboBox.addItem("\u00abanti pattern\u00bb");
        panel.add(this.classificationComboBox);
        JLabel elementsLabel = new JLabel("ASG elements:");
        constraints.insets = new Insets(3, 3, 0, 3);
        panel.add((Component)elementsLabel, constraints);
        this.elementsComboBox = new JComboBox();
        constraints.insets = new Insets(0, 3, 0, 3);
        panel.add((Component)this.elementsComboBox, constraints);
        JLabel qualifierLabel = new JLabel("Qualifier:");
        constraints.insets = new Insets(3, 3, 0, 3);
        panel.add((Component)qualifierLabel, constraints);
        this.qualifierTextField = new JTextField();
        constraints.insets = new Insets(0, 3, 0, 3);
        panel.add((Component)this.qualifierTextField, constraints);
        JLabel annotatedElementsLabel = new JLabel("Annotated elements:");
        constraints.insets = new Insets(3, 3, 0, 3);
        panel.add((Component)annotatedElementsLabel, constraints);
        JList annotatedElementsList = new JList();
        this.listModel = new ElementQualifierPairsListModel();
        annotatedElementsList.setModel(this.listModel);
        JScrollPane scrollPane = new JScrollPane(annotatedElementsList);
        constraints.insets = new Insets(0, 3, 0, 3);
        panel.add((Component)scrollPane, constraints);
        JPanel buttonPanel = this.createAddRemoveButtonPanel();
        constraints.insets = new Insets(3, 3, 0, 3);
        panel.add((Component)buttonPanel, constraints);
        return panel;
    }

    private JPanel createAddRemoveButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1));
        JButton addButton = new JButton("Add");
        addButton.addActionListener(new AddButtonListener());
        panel.add(addButton);
        JButton removeButton = new JButton("Remove");
        panel.add(removeButton);
        return panel;
    }

    protected void unparse() {
        Iterator iter = this.classDiagram.iteratorOfElements();
        while (iter.hasNext()) {
            ASGElement diagramItem = (ASGElement)iter.next();
            if (!(diagramItem instanceof UMLClass)) continue;
            this.elementsComboBox.addItem(diagramItem);
        }
    }

    protected void parse() {
        GFRNAnnotation annotation = new GFRNAnnotation();
        annotation.setName(this.nameTextField.getText());
        annotation.setPosBelief(Integer.valueOf(this.fuzzyValueTextField.getText()));
        annotation.setClassification(GFRNAnnotation.getClassificationKey((String)this.classificationComboBox.getSelectedItem()));
        Iterator iter = this.listModel.iterator();
        while (iter.hasNext()) {
            ElementQualifierPair pair = (ElementQualifierPair)iter.next();
            annotation.addToElements(pair.qualifier, (FElement)pair.asgElement);
        }
        UMLAnnotation umlAnnotation = new UMLAnnotation();
        annotation.setSpecialAnnotation(umlAnnotation);
        this.classDiagram.addToElements((ASGElement)umlAnnotation);
    }

    private class AddButtonListener
    implements ActionListener {
        AddButtonListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            ASGElement element = (ASGElement)AddAnnotationDialog.this.elementsComboBox.getSelectedItem();
            String qualifier = AddAnnotationDialog.this.qualifierTextField.getText();
            ElementQualifierPair pair = new ElementQualifierPair(element, qualifier);
            AddAnnotationDialog.this.listModel.addElementQualifierPair(pair);
        }
    }

    private static class ElementQualifierPair {
        public ASGElement asgElement;
        public String qualifier;

        public ElementQualifierPair(ASGElement asgElement, String qualifier) {
            this.asgElement = asgElement;
            this.qualifier = qualifier;
        }

        public String toString() {
            return String.valueOf(this.qualifier) + "->" + this.asgElement.getName();
        }
    }

    private static class ElementQualifierPairsListModel
    extends AbstractListModel {
        private Vector annotatedElements = new Vector();

        public Object getElementAt(int index) {
            String result = null;
            if (index >= 0 && index < this.annotatedElements.size()) {
                result = ((ElementQualifierPair)this.annotatedElements.elementAt(index)).toString();
            }
            return result;
        }

        public void addElementQualifierPair(ElementQualifierPair newPair) {
            if (!this.annotatedElements.contains(newPair)) {
                this.annotatedElements.addElement(newPair);
                this.fireContentsChanged(this, this.annotatedElements.size() - 1, this.annotatedElements.size());
            }
        }

        public Iterator iterator() {
            return this.annotatedElements.iterator();
        }

        public int getSize() {
            return this.annotatedElements.size();
        }
    }
}

