/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.dialogs;

import de.uni_paderborn.fujaba.gui.AbstractDialog;
import de.uni_paderborn.lib.classloader.UPBClassLoader;
import de.upb.inferenceengine.InferenceEngine;
import de.upb.inferenceengine.RuleCatalog;
import de.upb.inferenceengine.preferences.InferenceEnginePreferences;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class SelectCatalogDialog
extends AbstractDialog {
    public static final String CATALOGS_SUFFIX = ".jar";
    private JComboBox catalogComboBox;
    static /* synthetic */ Class class$0;

    public SelectCatalogDialog(JFrame parent) {
        super(parent, true);
        this.setTitle("Choose Rule Catalog");
        this.createUserInterface();
        this.initialize();
    }

    protected JPanel createMainPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(gridBag);
        panel.setBorder(new TitledBorder("Catalogs"));
        this.catalogComboBox = new JComboBox();
        constraints.gridwidth = -1;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(4, 4, 4, 4);
        gridBag.setConstraints(this.catalogComboBox, constraints);
        panel.add(this.catalogComboBox);
        JButton browseButton = new JButton("Browse");
        browseButton.addActionListener(new BrowseButtonListener());
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.weightx = 0.0;
        gridBag.setConstraints(browseButton, constraints);
        panel.add(browseButton);
        return panel;
    }

    protected void unparse() {
        Iterator catalogIter = InferenceEngine.get().iteratorOfCatalogs();
        while (catalogIter.hasNext()) {
            RuleCatalog ruleCatalog = (RuleCatalog)catalogIter.next();
            this.catalogComboBox.addItem(ruleCatalog);
        }
        this.scanCatalogFolder();
        this.getOkButton().setText("Start Pattern Recognition");
    }

    protected void parse() {
        RuleCatalog selectedCatalog = (RuleCatalog)this.catalogComboBox.getSelectedItem();
        InferenceEngine inferenceEngine = InferenceEngine.get();
        if (!inferenceEngine.hasKeyInCatalogs(selectedCatalog.getName())) {
            inferenceEngine.addToCatalogs(selectedCatalog);
        }
        inferenceEngine.setCurrentCatalog(selectedCatalog);
    }

    protected boolean checkConstraints() {
        boolean result = true;
        if (this.catalogComboBox.getSelectedItem() == null) {
            result = false;
            JOptionPane.showMessageDialog((Component)((Object)this), "Choose a rule catalog!", "No Rule Catalog", 0);
        }
        return result;
    }

    private void scanCatalogFolder() {
        String catalogFolderName = InferenceEnginePreferences.get().getCatalogsFolder();
        File catalogFolder = new File(catalogFolderName);
        File[] catalogFiles = catalogFolder.listFiles(new CatalogFileFilter());
        if (catalogFiles != null) {
            int i = 0;
            while (i < catalogFiles.length) {
                this.addRuleCatalog(catalogFiles[i]);
                ++i;
            }
        }
    }

    void addRuleCatalog(File catalogFile) {
        boolean found = false;
        ComboBoxModel model = this.catalogComboBox.getModel();
        int i = 0;
        while (i < model.getSize() && !found) {
            RuleCatalog currentCatalog = (RuleCatalog)model.getElementAt(i);
            if (currentCatalog.getCatalogFile().getAbsolutePath().equals(catalogFile.getAbsolutePath())) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.upb.inferenceengine.InferencePlugin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            RuleCatalog ruleCatalog = new RuleCatalog(catalogFile, UPBClassLoader.get((String)clazz.getName()));
            this.catalogComboBox.addItem(ruleCatalog);
            this.catalogComboBox.setSelectedItem(ruleCatalog);
        }
    }

    public static class CatalogFileFilter
    extends javax.swing.filechooser.FileFilter
    implements FileFilter {
        public boolean accept(File file) {
            return file.getName().endsWith(SelectCatalogDialog.CATALOGS_SUFFIX) || file.isDirectory();
        }

        public String getDescription() {
            return "Pattern Rules Catalog";
        }
    }

    private class BrowseButtonListener
    implements ActionListener {
        BrowseButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String catalogFolder = InferenceEnginePreferences.get().getCatalogsFolder();
            JFileChooser fileChooser = new JFileChooser(catalogFolder);
            fileChooser.setDialogTitle("Choose Rule Catalog");
            fileChooser.setDialogType(0);
            fileChooser.setFileFilter(new CatalogFileFilter());
            int state = fileChooser.showOpenDialog((Component)((Object)SelectCatalogDialog.this));
            if (state == 0) {
                File catalogFile = fileChooser.getSelectedFile();
                SelectCatalogDialog.this.addRuleCatalog(catalogFile);
            }
        }
    }
}

