/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.engines;

import de.uni_paderborn.fujaba.asg.ASGAnnotation;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.upb.inferenceengine.fpn.Place;
import de.upb.inferenceengine.gfrn.GFRN;
import de.upb.inferenceengine.preferences.InferenceEnginePreferences;
import de.upb.inferenceengine.uml.UMLAnnotation;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import de.upb.tools.fca.FHashSet;
import java.util.Iterator;
import java.util.Map;

public class GFRNAnnotation
extends ASGAnnotation {
    public static final String ANNOTATION_SUFFIX = "Annotation";
    public static final int CLASSIFICATION_NEUTRAL = 0;
    public static final int CLASSIFICATION_DESIGN_PATTERN = 1;
    public static final int CLASSIFICATION_ANTI_PATTERN = 2;
    public static final String CLASSIFICATION_STRING_NEUTRAL = "\u00abneutral\u00bb";
    public static final String CLASSIFICATION_STRING_DESIGN_PATTERN = "\u00abdesign pattern\u00bb";
    public static final String CLASSIFICATION_STRING_ANTI_PATTERN = "\u00abanti pattern\u00bb";
    private int posBelief;
    private int negBelief;
    private int classification;
    private FHashMap boundObjects;
    private FHashSet antecedentAnnos;
    private FHashSet consequentAnnos;
    private Place place;
    private GFRN gfrn;
    private UMLAnnotation specialAnnotation;

    public static int getClassificationKey(String classification) {
        if (CLASSIFICATION_STRING_DESIGN_PATTERN.equals(classification)) {
            return 1;
        }
        if (CLASSIFICATION_STRING_ANTI_PATTERN.equals(classification)) {
            return 2;
        }
        return 0;
    }

    public static String getClassificationString(int classification) {
        switch (classification) {
            case 0: {
                return CLASSIFICATION_STRING_NEUTRAL;
            }
            case 1: {
                return CLASSIFICATION_STRING_DESIGN_PATTERN;
            }
            case 2: {
                return CLASSIFICATION_STRING_ANTI_PATTERN;
            }
        }
        return "";
    }

    public GFRNAnnotation() {
        String className = ((Object)((Object)this)).getClass().getName();
        int lastIndexOfDot = className.lastIndexOf(".");
        int lenghtOfSuffix = ANNOTATION_SUFFIX.length();
        this.setName(className.substring(lastIndexOfDot + 1, className.length() - lenghtOfSuffix));
    }

    public int getPosBelief() {
        return this.posBelief;
    }

    public void setPosBelief(int value) {
        if (this.posBelief != value) {
            int oldValue = this.posBelief;
            this.posBelief = value;
            this.firePropertyChange("posBelief", oldValue, this.posBelief);
        }
    }

    public int getNegBelief() {
        return this.negBelief;
    }

    public void setNegBelief(int value) {
        if (this.negBelief != value) {
            int oldValue = this.negBelief;
            this.negBelief = value;
            this.firePropertyChange("negBelief", oldValue, this.negBelief);
        }
    }

    public int getClassification() {
        return this.classification;
    }

    public void setClassification(int classification) {
        if (this.classification != classification) {
            int oldValue = this.classification;
            this.classification = classification;
            this.firePropertyChange("classification", oldValue, this.classification);
        }
    }

    public boolean addToBoundObjects(Map.Entry entry) {
        return this.addToBoundObjects((String)entry.getKey(), (FElement)entry.getValue());
    }

    public boolean addToBoundObjects(String key, FElement value) {
        boolean changed = false;
        if (key != null) {
            FElement oldValue;
            if (this.boundObjects == null) {
                this.boundObjects = new FHashMap();
            }
            if ((oldValue = (FElement)this.boundObjects.put((Object)key, (Object)value)) != value) {
                changed = true;
            }
        }
        return changed;
    }

    public Iterator entriesOfBoundObjects() {
        return this.boundObjects == null ? FEmptyIterator.get() : this.boundObjects.entrySet().iterator();
    }

    public FElement getFromBoundObjects(String key) {
        return this.boundObjects == null || key == null ? null : (FElement)this.boundObjects.get((Object)key);
    }

    public boolean hasInBoundObjects(String key, FElement value) {
        return this.boundObjects != null && (value != null || this.boundObjects.containsKey((Object)key)) && key != null && this.boundObjects.get((Object)key) == value;
    }

    public boolean hasInBoundObjects(FElement value) {
        return this.boundObjects != null && this.boundObjects.containsValue((Object)value);
    }

    public boolean hasKeyInBoundObjects(String key) {
        return this.boundObjects != null && key != null && this.boundObjects.containsKey((Object)key);
    }

    public Iterator iteratorOfBoundObjects() {
        return this.boundObjects == null ? FEmptyIterator.get() : this.boundObjects.values().iterator();
    }

    public Iterator keysOfBoundObjects() {
        return this.boundObjects == null ? FEmptyIterator.get() : this.boundObjects.keySet().iterator();
    }

    public void removeAllFromBoundObjects() {
        Iterator iter = this.entriesOfBoundObjects();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            this.removeFromBoundObjects((String)entry.getKey(), (FElement)entry.getValue());
        }
    }

    public boolean removeFromBoundObjects(String key, FElement value) {
        FElement oldValue;
        boolean changed = false;
        if (this.boundObjects != null && key != null && (oldValue = (FElement)this.boundObjects.get((Object)key)) == value && (oldValue != null || this.boundObjects.containsKey((Object)key))) {
            this.boundObjects.remove((Object)key);
            changed = true;
        }
        return changed;
    }

    public boolean removeFromBoundObjects(FElement value) {
        boolean changed = false;
        if (this.boundObjects != null) {
            Iterator iter = this.entriesOfBoundObjects();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (entry.getValue() != value || !this.removeFromBoundObjects((String)entry.getKey(), value)) continue;
                changed = true;
            }
        }
        return changed;
    }

    public boolean removeKeyFromBoundObjects(String key) {
        boolean changed = false;
        if (this.boundObjects != null && key != null && (changed = this.boundObjects.containsKey((Object)key))) {
            this.boundObjects.remove((Object)key);
        }
        return changed;
    }

    public int sizeOfBoundObjects() {
        return this.boundObjects == null ? 0 : this.boundObjects.size();
    }

    public boolean addToAntecedentAnnos(GFRNAnnotation value) {
        boolean changed = false;
        if (value != null) {
            if (this.antecedentAnnos == null) {
                this.antecedentAnnos = new FHashSet();
            }
            if (changed = this.antecedentAnnos.add((Object)value)) {
                value.addToConsequentAnnos(this);
            }
        }
        return changed;
    }

    public boolean hasInAntecedentAnnos(GFRNAnnotation value) {
        return this.antecedentAnnos != null && value != null && this.antecedentAnnos.contains((Object)value);
    }

    public Iterator iteratorOfAntecedentAnnos() {
        return this.antecedentAnnos == null ? FEmptyIterator.get() : this.antecedentAnnos.iterator();
    }

    public void removeAllFromAntecedentAnnos() {
        Iterator iter = this.iteratorOfAntecedentAnnos();
        while (iter.hasNext()) {
            GFRNAnnotation tmpValue = (GFRNAnnotation)((Object)iter.next());
            this.removeFromAntecedentAnnos(tmpValue);
        }
    }

    public boolean removeFromAntecedentAnnos(GFRNAnnotation value) {
        boolean changed = false;
        if (this.antecedentAnnos != null && value != null && (changed = this.antecedentAnnos.remove((Object)value))) {
            value.removeFromConsequentAnnos(this);
        }
        return changed;
    }

    public int sizeOfAntecedentAnnos() {
        return this.antecedentAnnos == null ? 0 : this.antecedentAnnos.size();
    }

    public boolean addToConsequentAnnos(GFRNAnnotation value) {
        boolean changed = false;
        if (value != null) {
            if (this.consequentAnnos == null) {
                this.consequentAnnos = new FHashSet();
            }
            if (changed = this.consequentAnnos.add((Object)value)) {
                value.addToAntecedentAnnos(this);
            }
        }
        return changed;
    }

    public boolean hasInConsequentAnnos(GFRNAnnotation value) {
        return this.consequentAnnos != null && value != null && this.consequentAnnos.contains((Object)value);
    }

    public Iterator iteratorOfConsequentAnnos() {
        return this.consequentAnnos == null ? FEmptyIterator.get() : this.consequentAnnos.iterator();
    }

    public void removeAllFromConsequentAnnos() {
        Iterator iter = this.iteratorOfConsequentAnnos();
        while (iter.hasNext()) {
            GFRNAnnotation tmpValue = (GFRNAnnotation)((Object)iter.next());
            this.removeFromConsequentAnnos(tmpValue);
        }
    }

    public boolean removeFromConsequentAnnos(GFRNAnnotation value) {
        boolean changed = false;
        if (this.consequentAnnos != null && value != null && (changed = this.consequentAnnos.remove((Object)value))) {
            value.removeFromAntecedentAnnos(this);
        }
        return changed;
    }

    public int sizeOfConsequentAnnos() {
        return this.consequentAnnos == null ? 0 : this.consequentAnnos.size();
    }

    public Place getPlace() {
        return this.place;
    }

    public boolean setPlace(Place value) {
        boolean changed = false;
        if (this.place != value) {
            if (this.place != null) {
                Place oldValue = this.place;
                this.place = null;
                oldValue.setAnnotation(null);
            }
            this.place = value;
            if (value != null) {
                value.setAnnotation(this);
            }
            changed = true;
        }
        return changed;
    }

    public GFRN getGfrn() {
        return this.gfrn;
    }

    public boolean setGfrn(GFRN value) {
        boolean changed = false;
        if (this.gfrn != value) {
            if (this.gfrn != null) {
                GFRN oldValue = this.gfrn;
                this.gfrn = null;
                oldValue.removeFromResults(this);
            }
            this.gfrn = value;
            if (value != null) {
                value.addToResults(this);
            }
            changed = true;
        }
        return changed;
    }

    public UMLAnnotation getSpecialAnnotation() {
        return this.specialAnnotation;
    }

    public boolean setSpecialAnnotation(UMLAnnotation value) {
        boolean changed = false;
        if (this.specialAnnotation != value) {
            if (this.specialAnnotation != null) {
                UMLAnnotation oldValue = this.specialAnnotation;
                this.specialAnnotation = null;
                oldValue.setGfrnAnnotation(null);
            }
            this.specialAnnotation = value;
            if (value != null) {
                value.setGfrnAnnotation(this);
            }
            changed = true;
        }
        return changed;
    }

    public boolean isVisible() {
        boolean visible = false;
        InferenceEnginePreferences options = InferenceEnginePreferences.get();
        if (options.isHideAllAnnotations()) {
            visible = false;
        } else if (options.isShowAllAnnotations()) {
            visible = true;
        } else if (options.isShowSelAnnotations() && options.isAnnotationVisible(this.getName())) {
            visible = true;
        }
        if (visible) {
            visible = this.getPosBelief() >= options.getShowBeliefValue(this.getName());
        }
        return visible;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append(" [");
        Iterator iter = this.keysOfElements();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            buffer.append(key);
            buffer.append("=");
            Iterator annotatedElements = this.iteratorOfElements(key);
            while (annotatedElements.hasNext()) {
                ASGElement asgElement = (ASGElement)annotatedElements.next();
                buffer.append(asgElement.getName());
                if (!annotatedElements.hasNext()) continue;
                buffer.append(", ");
            }
            if (!iter.hasNext()) continue;
            buffer.append("; ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public void removeYou() {
        Place tmpPlace;
        this.removeAllFromBoundObjects();
        this.removeAllFromAntecedentAnnos();
        this.removeAllFromConsequentAnnos();
        UMLAnnotation tmpSpecialAnnotation = this.getSpecialAnnotation();
        if (tmpSpecialAnnotation != null) {
            this.setSpecialAnnotation(null);
            tmpSpecialAnnotation.removeYou();
        }
        if ((tmpPlace = this.getPlace()) != null) {
            this.setPlace(null);
        }
        super.removeYou();
    }
}

