/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.fpn;

import de.upb.inferenceengine.fpn.FPN;
import de.upb.inferenceengine.fpn.FPNEdge;
import de.upb.inferenceengine.fpn.FTTStrategy;
import de.upb.inferenceengine.fpn.Place;
import de.upb.inferenceengine.fpn.PlaceToTransitionEdge;
import de.upb.inferenceengine.fpn.TransitionToPlaceEdge;
import de.upb.inferenceengine.gfrn.Implication;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import java.util.Iterator;

public class Transition {
    private int confidence;
    private int fuzzyTruthToken;
    private FHashSet antecedentEdges;
    private FHashSet consequentEdges;
    private FPN fpn;
    private Implication implication;

    public Transition(int confidence) {
        this.setConfidence(confidence);
    }

    public int getConfidence() {
        return this.confidence;
    }

    public int setConfidence(int confidence) {
        if (this.confidence != confidence) {
            this.confidence = confidence;
        }
        return this.confidence;
    }

    public int getFuzzyTruthToken() {
        return this.fuzzyTruthToken;
    }

    public int setFuzzyTruthToken(int fuzzyTruthToken) {
        if (this.fuzzyTruthToken != fuzzyTruthToken) {
            this.fuzzyTruthToken = fuzzyTruthToken;
        }
        return this.fuzzyTruthToken;
    }

    public void calculateFTT() {
        FTTStrategy strategy = this.getFpn().getFttStrategy();
        this.setFuzzyTruthToken(strategy.calculateFTT(this));
    }

    public boolean hasInAntecedentEdges(PlaceToTransitionEdge value) {
        return this.antecedentEdges != null && value != null && this.antecedentEdges.contains((Object)value);
    }

    public Iterator iteratorOfAntecedentEdges() {
        return this.antecedentEdges == null ? FEmptyIterator.get() : this.antecedentEdges.iterator();
    }

    public int sizeOfAntecedentEdges() {
        return this.antecedentEdges == null ? 0 : this.antecedentEdges.size();
    }

    public boolean addToAntecedentEdges(PlaceToTransitionEdge value) {
        boolean changed = false;
        if (value != null) {
            if (this.antecedentEdges == null) {
                this.antecedentEdges = new FHashSet();
            }
            if (changed = this.antecedentEdges.add((Object)value)) {
                value.setTransition(this);
            }
        }
        return changed;
    }

    public boolean removeFromAntecedentEdges(PlaceToTransitionEdge value) {
        boolean changed = false;
        if (this.antecedentEdges != null && value != null && (changed = this.antecedentEdges.remove((Object)value))) {
            value.setTransition(null);
        }
        return changed;
    }

    public void removeAllFromAntecedentEdges() {
        Iterator iter = this.iteratorOfAntecedentEdges();
        while (iter.hasNext()) {
            PlaceToTransitionEdge tmpValue = (PlaceToTransitionEdge)iter.next();
            this.removeFromAntecedentEdges(tmpValue);
        }
    }

    public boolean hasInConsequentEdges(TransitionToPlaceEdge value) {
        return this.consequentEdges != null && value != null && this.consequentEdges.contains((Object)value);
    }

    public Iterator iteratorOfConsequentEdges() {
        return this.consequentEdges == null ? FEmptyIterator.get() : this.consequentEdges.iterator();
    }

    public int sizeOfConsequentEdges() {
        return this.consequentEdges == null ? 0 : this.consequentEdges.size();
    }

    public boolean addToConsequentEdges(TransitionToPlaceEdge value) {
        boolean changed = false;
        if (value != null) {
            if (this.consequentEdges == null) {
                this.consequentEdges = new FHashSet();
            }
            if (changed = this.consequentEdges.add((Object)value)) {
                value.setTransition(this);
            }
        }
        return changed;
    }

    public boolean removeFromConsequentEdges(TransitionToPlaceEdge value) {
        boolean changed = false;
        if (this.consequentEdges != null && value != null && (changed = this.consequentEdges.remove((Object)value))) {
            value.setTransition(null);
        }
        return changed;
    }

    public void removeAllFromConsequentEdges() {
        Iterator iter = this.iteratorOfConsequentEdges();
        while (iter.hasNext()) {
            TransitionToPlaceEdge tmpValue = (TransitionToPlaceEdge)iter.next();
            this.removeFromConsequentEdges(tmpValue);
        }
    }

    public boolean setFpn(FPN value) {
        boolean changed = false;
        if (this.fpn != value) {
            if (this.fpn != null) {
                FPN oldValue = this.fpn;
                this.fpn = null;
                oldValue.removeFromTransitions(this);
            }
            this.fpn = value;
            if (value != null) {
                value.addToTransitions(this);
            }
            changed = true;
        }
        return changed;
    }

    public FPN getFpn() {
        return this.fpn;
    }

    public boolean setImplication(Place key, Implication value) {
        boolean changed = false;
        if (this.implication != value) {
            if (this.implication != null) {
                Implication oldValue = this.implication;
                this.implication = null;
                oldValue.removeFromTransitions(key, this);
            }
            this.implication = value;
            if (value != null) {
                value.addToTransitions(key, this);
            }
            changed = true;
        }
        return changed;
    }

    public Implication getImplication() {
        return this.implication;
    }

    public void removeYou() {
        FPNEdge edge;
        Iterator iter = this.iteratorOfAntecedentEdges();
        while (iter.hasNext()) {
            edge = (PlaceToTransitionEdge)iter.next();
            ((PlaceToTransitionEdge)edge).removeYou();
        }
        iter = this.iteratorOfConsequentEdges();
        while (iter.hasNext()) {
            edge = (TransitionToPlaceEdge)iter.next();
            ((TransitionToPlaceEdge)edge).removeYou();
        }
        this.setFpn(null);
        this.setImplication(null, null);
    }
}

