/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.gfrn;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.basic.FujabaDebug;
import de.uni_paderborn.fujaba.uml.ASTNode;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.upb.inferenceengine.RuleCatalog;
import de.upb.inferenceengine.engines.GFRNAnnotation;
import de.upb.inferenceengine.gfrn.Implication;
import de.upb.inferenceengine.gfrn.PredToImplEdge;
import de.upb.inferenceengine.gfrn.Predicate;
import de.upb.inferenceengine.uml.UMLAnnotation;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import de.upb.tools.fca.FHashSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class GFRN {
    private RuleCatalog catalog;
    private HashMap axiomsByTypeMap = new HashMap();
    private FHashMap predicates;
    private FHashSet implications;
    private FHashSet results;
    private StringBuffer validationErrors = new StringBuffer();

    public RuleCatalog getCatalog() {
        return this.catalog;
    }

    public boolean setCatalog(RuleCatalog value) {
        boolean changed = false;
        if (this.catalog != value) {
            if (this.catalog != null) {
                RuleCatalog oldValue = this.catalog;
                this.catalog = null;
                oldValue.setGfrn(null);
            }
            this.catalog = value;
            if (value != null) {
                value.setGfrn(this);
            }
            changed = true;
        }
        return changed;
    }

    public Iterator getAxiomsForType(Class type) {
        if (this.axiomsByTypeMap.containsKey(type)) {
            HashSet axioms = (HashSet)this.axiomsByTypeMap.get(type);
            return axioms.iterator();
        }
        HashSet<Predicate> axioms = new HashSet<Predicate>();
        this.axiomsByTypeMap.put(type, axioms);
        Iterator iter = this.iteratorOfPredicates();
        while (iter.hasNext()) {
            Class axiomClass;
            Predicate predicate = (Predicate)iter.next();
            if (!predicate.isAxiom() || (axiomClass = (Class)this.catalog.getAxiomClasses().get(predicate.getClassName())) == null || !axiomClass.isAssignableFrom(type)) continue;
            axioms.add(predicate);
        }
        return axioms.iterator();
    }

    public boolean hasInPredicates(Predicate value) {
        return this.predicates != null && value != null && value.getName() != null && this.predicates.get((Object)value.getName()) == value;
    }

    public boolean hasKeyInPredicates(String key) {
        return this.predicates != null && key != null && this.predicates.containsKey((Object)key);
    }

    public Iterator iteratorOfPredicates() {
        return this.predicates == null ? FEmptyIterator.get() : this.predicates.values().iterator();
    }

    public Iterator keysOfPredicates() {
        return this.predicates == null ? FEmptyIterator.get() : this.predicates.keySet().iterator();
    }

    public Iterator entriesOfPredicates() {
        return this.predicates == null ? FEmptyIterator.get() : this.predicates.entrySet().iterator();
    }

    public int sizeOfPredicates() {
        return this.predicates == null ? 0 : this.predicates.size();
    }

    public Predicate getFromPredicates(String key) {
        return this.predicates == null || key == null ? null : (Predicate)this.predicates.get((Object)key);
    }

    public boolean addToPredicates(Predicate value) {
        boolean changed = false;
        if (value != null && value.getName() != null) {
            Predicate oldValue;
            if (this.predicates == null) {
                this.predicates = new FHashMap();
            }
            if ((oldValue = (Predicate)this.predicates.put((Object)value.getName(), (Object)value)) != value) {
                if (oldValue != null) {
                    oldValue.setGfrn(null);
                }
                value.setGfrn(this);
                changed = true;
            }
        }
        return changed;
    }

    public boolean removeFromPredicates(Predicate value) {
        Predicate oldValue;
        boolean changed = false;
        if (this.predicates != null && value != null && value.getName() != null && (oldValue = (Predicate)this.predicates.get((Object)value.getName())) == value) {
            this.predicates.remove((Object)value.getName());
            value.setGfrn(null);
            changed = true;
        }
        return changed;
    }

    public boolean removeKeyFromPredicates(String key) {
        Predicate tmpValue;
        boolean changed = false;
        if (this.predicates != null && key != null && (tmpValue = (Predicate)this.predicates.get((Object)key)) != null) {
            this.predicates.remove((Object)key);
            tmpValue.setGfrn(null);
            changed = true;
        }
        return changed;
    }

    public void removeAllFromPredicates() {
        Iterator iter = this.iteratorOfPredicates();
        while (iter.hasNext()) {
            Predicate tmpValue = (Predicate)iter.next();
            this.removeFromPredicates(tmpValue);
        }
    }

    public boolean hasInImplications(Implication value) {
        return this.implications != null && value != null && this.implications.contains((Object)value);
    }

    public Iterator iteratorOfImplications() {
        return this.implications == null ? FEmptyIterator.get() : this.implications.iterator();
    }

    public int sizeOfImplications() {
        return this.implications == null ? 0 : this.implications.size();
    }

    public boolean addToImplications(Implication value) {
        boolean changed = false;
        if (value != null) {
            if (this.implications == null) {
                this.implications = new FHashSet();
            }
            if (changed = this.implications.add((Object)value)) {
                value.setGfrn(this);
            }
        }
        return changed;
    }

    public boolean removeFromImplications(Implication value) {
        boolean changed = false;
        if (this.implications != null && value != null && (changed = this.implications.remove((Object)value))) {
            value.setGfrn(null);
        }
        return changed;
    }

    public void removeAllFromImplications() {
        Iterator iter = this.iteratorOfImplications();
        while (iter.hasNext()) {
            Implication tmpValue = (Implication)iter.next();
            this.removeFromImplications(tmpValue);
        }
    }

    public Predicate providePredicate(String name) {
        if (name == null) {
            FujabaDebug.printStackTrace((int)5);
            throw new IllegalArgumentException("Attribute name must not be null!");
        }
        Predicate predicate = this.getFromPredicates(name);
        if (predicate == null) {
            predicate = new Predicate(name);
            this.addToPredicates(predicate);
        }
        return predicate;
    }

    public PredToImplEdge providePredToImplEdge(Predicate predicate, Implication implication) {
        PredToImplEdge predToImplEdge = null;
        boolean found = false;
        Iterator iter = predicate.iteratorOfConsequentEdges();
        while (iter.hasNext() && !found) {
            PredToImplEdge current = (PredToImplEdge)iter.next();
            if (current.getImplication() != implication) continue;
            found = true;
            predToImplEdge = current;
        }
        if (predToImplEdge == null) {
            predToImplEdge = new PredToImplEdge(predicate, implication);
        }
        return predToImplEdge;
    }

    public boolean addToResults(GFRNAnnotation value) {
        boolean changed = false;
        if (value != null) {
            if (this.results == null) {
                this.results = new FHashSet();
            }
            if (changed = this.results.add((Object)value)) {
                value.setGfrn(this);
            }
        }
        return changed;
    }

    public boolean hasInResults(GFRNAnnotation value) {
        return this.results != null && value != null && this.results.contains((Object)value);
    }

    public Iterator iteratorOfResults() {
        return this.results == null ? FEmptyIterator.get() : this.results.iterator();
    }

    public void removeAllFromResults() {
        Iterator iter = this.iteratorOfResults();
        while (iter.hasNext()) {
            GFRNAnnotation tmpValue = (GFRNAnnotation)((Object)iter.next());
            this.removeFromResults(tmpValue);
        }
    }

    public boolean removeFromResults(GFRNAnnotation value) {
        boolean changed = false;
        if (this.results != null && value != null && (changed = this.results.remove((Object)value))) {
            value.setGfrn(null);
        }
        return changed;
    }

    public int sizeOfResults() {
        return this.results == null ? 0 : this.results.size();
    }

    public String getValidationErrors() {
        return this.validationErrors.toString();
    }

    public boolean isValid() {
        boolean result = true;
        Iterator predIter = this.iteratorOfPredicates();
        while (predIter.hasNext()) {
            Predicate pred = (Predicate)predIter.next();
            if (pred.isAbstract() || pred.getClassName() != null && !"".equals(pred.getClassName())) continue;
            this.validationErrors.append("Predicate " + pred.getName() + " is missing engine class name\n");
            result = false;
        }
        return result;
    }

    public void addResultsToDiagrams() {
        boolean modified = true;
        while (modified) {
            modified = false;
            Iterator resultIter = this.iteratorOfResults();
            block1: while (resultIter.hasNext()) {
                GFRNAnnotation annotation = (GFRNAnnotation)((Object)resultIter.next());
                if (annotation.getSpecialAnnotation() != null) continue;
                ASGElement annotatedElement = null;
                Iterator annoIter = annotation.iteratorOfElements();
                while (annoIter.hasNext()) {
                    annotatedElement = (ASGElement)annoIter.next();
                    if (annotatedElement instanceof ASTNode) continue;
                    UMLDiagram umlDiagram = this.determineUMLDiagram(annotatedElement);
                    if (umlDiagram == null) continue block1;
                    UMLAnnotation umlAnnotation = new UMLAnnotation();
                    annotation.setSpecialAnnotation(umlAnnotation);
                    umlDiagram.addToElements((ASGElement)umlAnnotation);
                    modified = true;
                    continue block1;
                }
            }
        }
    }

    private UMLDiagram determineUMLDiagram(ASGElement annotatedElement) {
        ASGDiagram asgDiagram;
        Object containingElement = null;
        if (annotatedElement instanceof UMLAttr) {
            containingElement = ((UMLAttr)annotatedElement).getParent();
        } else if (annotatedElement instanceof UMLMethod) {
            containingElement = ((UMLMethod)annotatedElement).getParent();
        } else if (annotatedElement instanceof UMLParam) {
            containingElement = ((UMLParam)annotatedElement).getRevParam().getParent();
        } else if (annotatedElement instanceof GFRNAnnotation) {
            UMLAnnotation umlAnno = ((GFRNAnnotation)annotatedElement).getSpecialAnnotation();
            containingElement = umlAnno != null ? umlAnno : annotatedElement;
        } else if (annotatedElement instanceof UMLClass) {
            containingElement = (UMLClass)annotatedElement;
        }
        UMLDiagram umlDiagram = null;
        Iterator diagramIter = containingElement.iteratorOfDiagrams();
        if (diagramIter.hasNext() && (asgDiagram = (ASGDiagram)diagramIter.next()) instanceof UMLDiagram) {
            umlDiagram = (UMLDiagram)asgDiagram;
        }
        return umlDiagram;
    }

    public String generateXMLDocument() {
        StringBuffer xmlStream = new StringBuffer();
        xmlStream.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n");
        xmlStream.append("<!DOCTYPE GFRN [\n");
        xmlStream.append("  <!ELEMENT GFRN (Predicate+, Implication+)>\n");
        xmlStream.append("  <!ELEMENT Predicate EMPTY>\n");
        xmlStream.append("  <!ELEMENT Implication (PredToImplEdge+, ImplToPredEdge+)>\n");
        xmlStream.append("  <!ELEMENT PredToImplEdge EMPTY>\n");
        xmlStream.append("  <!ELEMENT ImplToPredEdge EMPTY>\n\n");
        xmlStream.append("  <!ATTLIST Predicate id    ID           #REQUIRED\n");
        xmlStream.append("                      axiom (true|false) #REQUIRED\n");
        xmlStream.append("                      abstract (true|false) #REQUIRED\n");
        xmlStream.append("                      name  CDATA        #REQUIRED\n");
        xmlStream.append("                      class CDATA        #IMPLIED\n");
        xmlStream.append("                      genId IDREF        #IMPLIED>\n\n");
        xmlStream.append("  <!ATTLIST Implication confidence CDATA #REQUIRED>\n\n");
        xmlStream.append("  <!ATTLIST PredToImplEdge positive   (true|false) #REQUIRED\n");
        xmlStream.append("                           trigger    (true|false) #REQUIRED\n");
        xmlStream.append("                           optional   (true|false) #REQUIRED\n");
        xmlStream.append("                           set        (true|false) #REQUIRED\n");
        xmlStream.append("                           confidence CDATA        #IMPLIED\n");
        xmlStream.append("                           predId     IDREF        #REQUIRED>\n\n");
        xmlStream.append("  <!ATTLIST ImplToPredEdge positive (true|false) #REQUIRED\n");
        xmlStream.append("                           predId   IDREF        #REQUIRED>\n");
        xmlStream.append("]>\n\n");
        xmlStream.append("<GFRN>\n\n");
        Iterator iter = this.iteratorOfPredicates();
        while (iter.hasNext()) {
            Predicate predicate = (Predicate)iter.next();
            predicate.generateXMLTag(xmlStream);
        }
        xmlStream.append("\n");
        iter = this.iteratorOfImplications();
        while (iter.hasNext()) {
            Implication implication = (Implication)iter.next();
            implication.generateXMLTag(xmlStream);
        }
        xmlStream.append("</GFRN>\n");
        return xmlStream.toString();
    }

    public void removeYou() {
        RuleCatalog tmpCatalog = this.getCatalog();
        if (tmpCatalog != null) {
            this.setCatalog(null);
        }
        this.removeAllFromPredicates();
        this.removeAllFromImplications();
    }
}

