/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.gfrn;

import de.upb.inferenceengine.gfrn.GFRN;
import de.upb.inferenceengine.gfrn.ImplToPredEdge;
import de.upb.inferenceengine.gfrn.Implication;
import de.upb.inferenceengine.gfrn.PredToImplEdge;
import de.upb.inferenceengine.gfrn.Predicate;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class GFRNSaxHandler
extends DefaultHandler {
    private GFRN gfrn;
    private Implication currentImplication;
    private HashMap predicates;

    GFRNSaxHandler() {
    }

    public GFRN getGFRN() {
        return this.gfrn;
    }

    public void startDocument() {
        this.predicates = new HashMap();
    }

    public void endDocument() {
        this.predicates = null;
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (name.equals("GFRN")) {
            this.gfrn = new GFRN();
        } else if (name.equals("Predicate")) {
            this.createPredicate(atts);
        } else if (name.equals("Implication")) {
            this.currentImplication = this.createImplication(atts);
        } else if (name.equals("PredToImplEdge")) {
            this.createPredToImplEdge(atts);
        } else if (name.equals("ImplToPredEdge")) {
            this.createImplToPredEdge(atts);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (name.equals("Implication")) {
            this.currentImplication = null;
        }
    }

    public void error(SAXParseException exception) {
        System.err.println("XML Parse Error in line " + exception.getLineNumber() + ":");
        System.err.println("  " + exception.getMessage());
    }

    public void fatalError(SAXParseException exception) {
        System.err.println("Fatal XML Parse Error in line " + exception.getLineNumber() + ":");
        System.err.println("  " + exception.getMessage());
    }

    public void warning(SAXParseException exception) {
        System.err.println("XML Parse warning in line " + exception.getLineNumber() + ":");
        System.err.println("  " + exception.getMessage());
    }

    private Predicate getPredicate(String id) {
        Predicate predicate = (Predicate)this.predicates.get(id);
        if (predicate == null) {
            predicate = new Predicate();
            predicate.setId(Integer.parseInt(id.substring(4)));
            this.predicates.put(id, predicate);
        }
        return predicate;
    }

    private void createPredicate(Attributes attrs) {
        Predicate predicate = this.getPredicate(attrs.getValue("id"));
        predicate.setAxiom(Boolean.valueOf(attrs.getValue("axiom")));
        predicate.setAbstract(Boolean.valueOf(attrs.getValue("abstract")));
        predicate.setName(attrs.getValue("name"));
        predicate.setClassName(attrs.getValue("class"));
        String genIdString = attrs.getValue("genId");
        if (genIdString != null) {
            Predicate generalization = this.getPredicate(genIdString);
            predicate.setGeneralization(generalization);
        }
        this.gfrn.addToPredicates(predicate);
    }

    private Implication createImplication(Attributes attrs) {
        Implication implication = new Implication();
        implication.setConfidence(Integer.parseInt(attrs.getValue("confidence")));
        this.gfrn.addToImplications(implication);
        return implication;
    }

    private void createPredToImplEdge(Attributes attrs) {
        Predicate predicate = (Predicate)this.predicates.get(attrs.getValue("predId"));
        PredToImplEdge predToImplEdge = new PredToImplEdge(predicate, this.currentImplication);
        predToImplEdge.setPositive(Boolean.valueOf(attrs.getValue("positive")));
        predToImplEdge.setTrigger(Boolean.valueOf(attrs.getValue("trigger")));
        predToImplEdge.setOptional(Boolean.valueOf(attrs.getValue("optional")));
        predToImplEdge.setSet(Boolean.valueOf(attrs.getValue("set")));
        if (predToImplEdge.isOptional()) {
            predToImplEdge.setConfidence(Integer.parseInt(attrs.getValue("confidence")));
        }
    }

    private void createImplToPredEdge(Attributes attrs) {
        Predicate predicate = (Predicate)this.predicates.get(attrs.getValue("predId"));
        ImplToPredEdge implToPredEdge = new ImplToPredEdge(this.currentImplication, predicate);
        implToPredEdge.setPositive(Boolean.valueOf(attrs.getValue("positive")));
    }
}

