/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.gfrn;

import de.upb.inferenceengine.gfrn.GFRNEdge;
import de.upb.inferenceengine.gfrn.Implication;
import de.upb.inferenceengine.gfrn.Predicate;

public class ImplToPredEdge
extends GFRNEdge {
    private Predicate predicate;
    private Implication implication;

    public ImplToPredEdge() {
    }

    public ImplToPredEdge(Implication implication, Predicate predicate) {
        this.setImplication(implication);
        this.setPredicate(predicate);
    }

    public boolean setPredicate(Predicate value) {
        boolean changed = false;
        if (this.predicate != value) {
            if (this.predicate != null) {
                Predicate oldValue = this.predicate;
                this.predicate = null;
                oldValue.removeFromAntecedentEdges(this);
            }
            this.predicate = value;
            if (value != null) {
                value.addToAntecedentEdges(this);
            }
            changed = true;
        }
        return changed;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public boolean setImplication(Implication value) {
        boolean changed = false;
        if (this.implication != value) {
            if (this.implication != null) {
                Implication oldValue = this.implication;
                this.implication = null;
                oldValue.removeFromConsequentEdges(this);
            }
            this.implication = value;
            if (value != null) {
                value.addToConsequentEdges(this);
            }
            changed = true;
        }
        return changed;
    }

    public Implication getImplication() {
        return this.implication;
    }

    public void generateXMLTag(StringBuffer xmlStream) {
        xmlStream.append("    <ImplToPredEdge positive=\"").append(this.isPositive());
        xmlStream.append("\" predId=\"pred").append(this.getPredicate().getId());
        xmlStream.append("\"/>\n");
    }

    public void removeYou() {
        Implication tmpImplication;
        Predicate tmpPredicate = this.getPredicate();
        if (tmpPredicate != null) {
            this.setPredicate(null);
        }
        if ((tmpImplication = this.getImplication()) != null) {
            this.setImplication(null);
        }
    }
}

