/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.gfrn;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.inferenceengine.engines.GFRNEngine;
import de.upb.inferenceengine.fpn.FPN;
import de.upb.inferenceengine.fpn.Place;
import de.upb.inferenceengine.fpn.Transition;
import de.upb.inferenceengine.gfrn.GFRN;
import de.upb.inferenceengine.gfrn.GFRNNode;
import de.upb.inferenceengine.gfrn.ImplToPredEdge;
import de.upb.inferenceengine.gfrn.PredToImplEdge;
import de.upb.inferenceengine.gfrn.Predicate;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import de.upb.tools.fca.FHashSet;
import java.util.Iterator;
import java.util.Map;

public class Implication
implements GFRNNode {
    private int confidence;
    private GFRN gfrn;
    private FHashMap transitions;
    private FHashSet antecedentEdges;
    private FHashSet consequentEdges;

    public int getConfidence() {
        return this.confidence;
    }

    public int setConfidence(int confidence) {
        if (this.confidence != confidence) {
            this.confidence = confidence;
            Iterator transIter = this.iteratorOfTransitions();
            while (transIter.hasNext()) {
                Transition transition = (Transition)transIter.next();
                transition.setConfidence(confidence);
            }
        }
        return this.confidence;
    }

    public void setThreshold(int threshold) {
    }

    public boolean setGfrn(GFRN value) {
        boolean changed = false;
        if (this.gfrn != value) {
            if (this.gfrn != null) {
                GFRN oldValue = this.gfrn;
                this.gfrn = null;
                oldValue.removeFromImplications(this);
            }
            this.gfrn = value;
            if (value != null) {
                value.addToImplications(this);
            }
            changed = true;
        }
        return changed;
    }

    public GFRN getGfrn() {
        return this.gfrn;
    }

    public boolean hasInTransitions(Transition value) {
        return this.transitions != null && value != null && this.transitions.containsValue((Object)value);
    }

    public boolean hasInTransitions(Place key, Transition value) {
        return this.transitions != null && value != null && key != null && this.transitions.get((Object)key) == value;
    }

    public boolean hasKeyInTransitions(Place key) {
        return this.transitions != null && key != null && this.transitions.containsKey((Object)key);
    }

    public Iterator iteratorOfTransitions() {
        return this.transitions == null ? FEmptyIterator.get() : this.transitions.values().iterator();
    }

    public Iterator keysOfTransitions() {
        return this.transitions == null ? FEmptyIterator.get() : this.transitions.keySet().iterator();
    }

    public Iterator entriesOfTransitions() {
        return this.transitions == null ? FEmptyIterator.get() : this.transitions.entrySet().iterator();
    }

    public int sizeOfTransitions() {
        return this.transitions == null ? 0 : this.transitions.size();
    }

    public Transition getFromTransitions(Place key) {
        return this.transitions == null || key == null ? null : (Transition)this.transitions.get((Object)key);
    }

    public boolean addToTransitions(Place key, Transition value) {
        boolean changed = false;
        if (value != null && key != null) {
            Transition oldValue;
            if (this.transitions == null) {
                this.transitions = new FHashMap();
            }
            if ((oldValue = (Transition)this.transitions.put((Object)key, (Object)value)) != value) {
                if (oldValue != null) {
                    oldValue.setImplication(null, null);
                }
                value.setImplication(key, this);
                changed = true;
            }
        }
        return changed;
    }

    public boolean addToTransitions(Map.Entry entry) {
        return this.addToTransitions((Place)entry.getKey(), (Transition)entry.getValue());
    }

    public boolean removeFromTransitions(Transition value) {
        boolean changed = false;
        if (this.transitions != null && value != null) {
            Iterator iter = this.entriesOfTransitions();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (entry.getValue() != value) continue;
                boolean bl = changed = changed || this.removeFromTransitions((Place)entry.getKey(), value);
            }
        }
        return changed;
    }

    public boolean removeFromTransitions(Place key, Transition value) {
        Transition oldValue;
        boolean changed = false;
        if (this.transitions != null && value != null && key != null && (oldValue = (Transition)this.transitions.get((Object)key)) == value) {
            this.transitions.remove((Object)key);
            value.setImplication(null, null);
            changed = true;
        }
        return changed;
    }

    public boolean removeKeyFromTransitions(Place key) {
        Transition tmpValue;
        boolean changed = false;
        if (this.transitions != null && key != null && (tmpValue = (Transition)this.transitions.get((Object)key)) != null) {
            this.transitions.remove((Object)key);
            tmpValue.setImplication(null, null);
            changed = true;
        }
        return changed;
    }

    public void removeAllFromTransitions() {
        Iterator iter = this.entriesOfTransitions();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            this.removeFromTransitions((Place)entry.getKey(), (Transition)entry.getValue());
        }
    }

    public Transition getTransition(Place consequentPlace) {
        Transition transition = this.getFromTransitions(consequentPlace);
        if (transition == null) {
            FPN fpn = this.getGfrn().getCatalog().getFpn();
            transition = fpn.createTransition(this.getConfidence());
            this.addToTransitions(consequentPlace, transition);
        }
        return transition;
    }

    public boolean hasInAntecedentEdges(PredToImplEdge value) {
        return this.antecedentEdges != null && value != null && this.antecedentEdges.contains((Object)value);
    }

    public Iterator iteratorOfAntecedentEdges() {
        return this.antecedentEdges == null ? FEmptyIterator.get() : this.antecedentEdges.iterator();
    }

    public int sizeOfAntecedentEdges() {
        return this.antecedentEdges == null ? 0 : this.antecedentEdges.size();
    }

    public boolean addToAntecedentEdges(PredToImplEdge value) {
        boolean changed = false;
        if (value != null) {
            if (this.antecedentEdges == null) {
                this.antecedentEdges = new FHashSet();
            }
            if (changed = this.antecedentEdges.add((Object)value)) {
                value.setImplication(this);
            }
        }
        return changed;
    }

    public boolean removeFromAntecedentEdges(PredToImplEdge value) {
        boolean changed = false;
        if (this.antecedentEdges != null && value != null && (changed = this.antecedentEdges.remove((Object)value))) {
            value.setImplication(null);
        }
        return changed;
    }

    public void removeAllFromAntecedentEdges() {
        Iterator iter = this.iteratorOfAntecedentEdges();
        while (iter.hasNext()) {
            PredToImplEdge tmpValue = (PredToImplEdge)iter.next();
            this.removeFromAntecedentEdges(tmpValue);
        }
    }

    public boolean hasInConsequentEdges(ImplToPredEdge value) {
        return this.consequentEdges != null && value != null && this.consequentEdges.contains((Object)value);
    }

    public Iterator iteratorOfConsequentEdges() {
        return this.consequentEdges == null ? FEmptyIterator.get() : this.consequentEdges.iterator();
    }

    public int sizeOfConsequentEdges() {
        return this.consequentEdges == null ? 0 : this.consequentEdges.size();
    }

    public boolean addToConsequentEdges(ImplToPredEdge value) {
        boolean changed = false;
        if (value != null) {
            if (this.consequentEdges == null) {
                this.consequentEdges = new FHashSet();
            }
            if (changed = this.consequentEdges.add((Object)value)) {
                value.setImplication(this);
            }
        }
        return changed;
    }

    public boolean removeFromConsequentEdges(ImplToPredEdge value) {
        boolean changed = false;
        if (this.consequentEdges != null && value != null && (changed = this.consequentEdges.remove((Object)value))) {
            value.setImplication(null);
        }
        return changed;
    }

    public void removeAllFromConsequentEdges() {
        Iterator iter = this.iteratorOfConsequentEdges();
        while (iter.hasNext()) {
            ImplToPredEdge tmpValue = (ImplToPredEdge)iter.next();
            this.removeFromConsequentEdges(tmpValue);
        }
    }

    public void evaluate(ASGElement incr, boolean bottomUp, GFRNEngine engine, String indent) {
        if (bottomUp) {
            Iterator consEdgesIter = this.iteratorOfConsequentEdges();
            while (consEdgesIter.hasNext()) {
                ImplToPredEdge implToPredEdge = (ImplToPredEdge)consEdgesIter.next();
                Predicate consPredicate = implToPredEdge.getPredicate();
                consPredicate.evaluate(incr, bottomUp, false, this, null, indent);
            }
        } else {
            Iterator antEdgesIter = this.iteratorOfAntecedentEdges();
            while (antEdgesIter.hasNext()) {
                PredToImplEdge predToImplEdge = (PredToImplEdge)antEdgesIter.next();
                Predicate antPredicate = predToImplEdge.getPredicate();
                if (antPredicate.isAxiom()) continue;
                Iterator triggerIter = engine.getTrigger(incr, antPredicate.getName());
                while (triggerIter.hasNext()) {
                    ASGElement trigger = (ASGElement)triggerIter.next();
                    antPredicate.evaluate(trigger, false, predToImplEdge.isSet(), this, engine.getName(), indent);
                }
            }
        }
    }

    public void generateXMLTag(StringBuffer xmlStream) {
        xmlStream.append("  <Implication confidence=\"");
        xmlStream.append(this.getConfidence()).append("\">\n");
        Iterator iter = this.iteratorOfAntecedentEdges();
        while (iter.hasNext()) {
            PredToImplEdge predToImplEdge = (PredToImplEdge)iter.next();
            predToImplEdge.generateXMLTag(xmlStream);
        }
        iter = this.iteratorOfConsequentEdges();
        while (iter.hasNext()) {
            ImplToPredEdge implToPredEdge = (ImplToPredEdge)iter.next();
            implToPredEdge.generateXMLTag(xmlStream);
        }
        xmlStream.append("  </Implication>\n\n");
    }

    public void removeYou() {
        GFRN tmpGfrn = this.getGfrn();
        if (tmpGfrn != null) {
            this.setGfrn(null);
        }
        this.removeAllFromConsequentEdges();
        this.removeAllFromAntecedentEdges();
        this.removeAllFromTransitions();
    }
}

