/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.gfrn;

import de.upb.inferenceengine.gfrn.GFRNEdge;
import de.upb.inferenceengine.gfrn.Implication;
import de.upb.inferenceengine.gfrn.Predicate;

public class PredToImplEdge
extends GFRNEdge {
    private int confidence;
    private boolean optional = false;
    private boolean set = false;
    private boolean trigger = false;
    private Predicate predicate;
    private Implication implication;

    public PredToImplEdge() {
    }

    public PredToImplEdge(Predicate predicate, Implication implication) {
        this.setPredicate(predicate);
        this.setImplication(implication);
    }

    public int getConfidence() {
        return this.confidence;
    }

    public int setConfidence(int confidence) {
        if (this.confidence != confidence) {
            this.confidence = confidence;
        }
        return this.confidence;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean setOptional(boolean optional) {
        this.optional = optional;
        return this.optional;
    }

    public boolean isSet() {
        return this.set;
    }

    public boolean setSet(boolean set) {
        this.set = set;
        return this.set;
    }

    public boolean isTrigger() {
        return this.trigger;
    }

    public boolean setTrigger(boolean trigger) {
        this.trigger = trigger;
        return this.trigger;
    }

    public boolean setPredicate(Predicate value) {
        boolean changed = false;
        if (this.predicate != value) {
            if (this.predicate != null) {
                Predicate oldValue = this.predicate;
                this.predicate = null;
                oldValue.removeFromConsequentEdges(this);
            }
            this.predicate = value;
            if (value != null) {
                value.addToConsequentEdges(this);
            }
            changed = true;
        }
        return changed;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public boolean setImplication(Implication value) {
        boolean changed = false;
        if (this.implication != value) {
            if (this.implication != null) {
                Implication oldValue = this.implication;
                this.implication = null;
                oldValue.removeFromAntecedentEdges(this);
            }
            this.implication = value;
            if (value != null) {
                value.addToAntecedentEdges(this);
            }
            changed = true;
        }
        return changed;
    }

    public Implication getImplication() {
        return this.implication;
    }

    public void generateXMLTag(StringBuffer xmlStream) {
        xmlStream.append("    <PredToImplEdge positive=\"").append(this.isPositive()).append("\" ");
        xmlStream.append("trigger=\"").append(this.isTrigger()).append("\" ");
        xmlStream.append("optional=\"").append(this.isOptional()).append("\" ");
        xmlStream.append("set=\"").append(this.isSet()).append("\" ");
        if (this.isOptional()) {
            xmlStream.append("confidence=\"").append(this.getConfidence()).append("\" ");
        }
        xmlStream.append("predId=\"pred").append(this.getPredicate().getId()).append("\"");
        xmlStream.append("/>\n");
    }

    public void removeYou() {
        Implication tmpImplication;
        Predicate tmpPredicate = this.getPredicate();
        if (tmpPredicate != null) {
            this.setPredicate(null);
        }
        if ((tmpImplication = this.getImplication()) != null) {
            this.setImplication(null);
        }
    }
}

