/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.gfrn;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.inferenceengine.InferenceEngine;
import de.upb.inferenceengine.engines.GFRNAnnotation;
import de.upb.inferenceengine.engines.GFRNEngine;
import de.upb.inferenceengine.fpn.FPN;
import de.upb.inferenceengine.fpn.Place;
import de.upb.inferenceengine.fpn.Transition;
import de.upb.inferenceengine.gfrn.GFRN;
import de.upb.inferenceengine.gfrn.GFRNNode;
import de.upb.inferenceengine.gfrn.ImplToPredEdge;
import de.upb.inferenceengine.gfrn.Implication;
import de.upb.inferenceengine.gfrn.PredToImplEdge;
import de.upb.inferenceengine.preferences.InferenceEnginePreferences;
import de.upb.inferenceengine.statistics.StatisticRecord;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import java.util.Iterator;

public class Predicate
implements GFRNNode {
    private static int idCounter = 0;
    private int id;
    private int rank = 0;
    private boolean axiom = false;
    private boolean abstractPredicate = false;
    private String name;
    private String className;
    private GFRN gfrn;
    private FHashSet places;
    private FHashSet consequentEdges;
    private FHashSet antecedentEdges;
    private Predicate generalization;
    private FHashSet specializations;
    private int requiresTopDownApplication = 0;

    public Predicate() {
        this.setId(idCounter++);
    }

    public Predicate(String name) {
        this();
        this.setName(name);
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int newRank) {
        this.rank = newRank;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isAxiom() {
        return this.axiom;
    }

    public boolean setAxiom(boolean axiom) {
        if (this.axiom != axiom) {
            this.axiom = axiom;
        }
        return this.axiom;
    }

    public boolean isTopLevel() {
        Predicate pred;
        boolean result;
        boolean bl = result = this.sizeOfConsequentEdges() == 0;
        if (result && (pred = this.getGeneralization()) != null) {
            result = pred.isTopLevel();
        }
        return result;
    }

    public boolean isAbstract() {
        return this.abstractPredicate;
    }

    public boolean setAbstract(boolean newAbstract) {
        if (this.abstractPredicate != newAbstract) {
            this.abstractPredicate = newAbstract;
        }
        return this.abstractPredicate;
    }

    public String getName() {
        return this.name;
    }

    public String setName(String name) {
        if (name == null || !name.equals(this.name)) {
            this.name = name;
        }
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String setClassName(String className) {
        if (className == null || !className.equals(this.className)) {
            this.className = className;
        }
        return this.className;
    }

    public boolean setGfrn(GFRN value) {
        boolean changed = false;
        if (this.gfrn != value) {
            if (this.gfrn != null) {
                GFRN oldValue = this.gfrn;
                this.gfrn = null;
                oldValue.removeFromPredicates(this);
            }
            this.gfrn = value;
            if (value != null) {
                value.addToPredicates(this);
            }
            changed = true;
        }
        return changed;
    }

    public GFRN getGfrn() {
        return this.gfrn;
    }

    public boolean hasInPlaces(Place value) {
        return this.places != null && value != null && this.places.contains((Object)value);
    }

    public Iterator iteratorOfPlaces() {
        return this.places == null ? FEmptyIterator.get() : this.places.iterator();
    }

    public int sizeOfPlaces() {
        return this.places == null ? 0 : this.places.size();
    }

    public boolean addToPlaces(Place value) {
        boolean changed = false;
        if (value != null) {
            if (this.places == null) {
                this.places = new FHashSet();
            }
            if (changed = this.places.add((Object)value)) {
                value.setPredicate(this);
            }
        }
        return changed;
    }

    public boolean removeFromPlaces(Place value) {
        boolean changed = false;
        if (this.places != null && value != null && (changed = this.places.remove((Object)value))) {
            value.setPredicate(null);
        }
        return changed;
    }

    public void removeAllFromPlaces() {
        Iterator iter = this.iteratorOfPlaces();
        while (iter.hasNext()) {
            Place tmpValue = (Place)iter.next();
            this.removeFromPlaces(tmpValue);
        }
    }

    public boolean hasInConsequentEdges(PredToImplEdge value) {
        return this.consequentEdges != null && value != null && this.consequentEdges.contains((Object)value);
    }

    public Iterator iteratorOfConsequentEdges() {
        return this.consequentEdges == null ? FEmptyIterator.get() : this.consequentEdges.iterator();
    }

    public int sizeOfConsequentEdges() {
        return this.consequentEdges == null ? 0 : this.consequentEdges.size();
    }

    public boolean addToConsequentEdges(PredToImplEdge value) {
        boolean changed = false;
        if (value != null) {
            if (this.consequentEdges == null) {
                this.consequentEdges = new FHashSet();
            }
            if (changed = this.consequentEdges.add((Object)value)) {
                value.setPredicate(this);
            }
        }
        return changed;
    }

    public boolean removeFromConsequentEdges(PredToImplEdge value) {
        boolean changed = false;
        if (this.consequentEdges != null && value != null && (changed = this.consequentEdges.remove((Object)value))) {
            value.setPredicate(null);
        }
        return changed;
    }

    public void removeAllFromConsequentEdges() {
        Iterator iter = this.iteratorOfConsequentEdges();
        while (iter.hasNext()) {
            PredToImplEdge tmpValue = (PredToImplEdge)iter.next();
            this.removeFromConsequentEdges(tmpValue);
        }
    }

    public Iterator iteratorOfConsequentPredicates() {
        return new ConsequentPredicatesIterator();
    }

    public Iterator iteratorOfTriggeredPredicates() {
        return new TriggeredPredicatesIterator();
    }

    public boolean hasInAntecedentEdges(ImplToPredEdge value) {
        return this.antecedentEdges != null && value != null && this.antecedentEdges.contains((Object)value);
    }

    public Iterator iteratorOfAntecedentEdges() {
        return this.antecedentEdges == null ? FEmptyIterator.get() : this.antecedentEdges.iterator();
    }

    public int sizeOfAntecedentEdges() {
        return this.antecedentEdges == null ? 0 : this.antecedentEdges.size();
    }

    public boolean addToAntecedentEdges(ImplToPredEdge value) {
        boolean changed = false;
        if (value != null) {
            if (this.antecedentEdges == null) {
                this.antecedentEdges = new FHashSet();
            }
            if (changed = this.antecedentEdges.add((Object)value)) {
                value.setPredicate(this);
            }
        }
        return changed;
    }

    public boolean removeFromAntecedentEdges(ImplToPredEdge value) {
        boolean changed = false;
        if (this.antecedentEdges != null && value != null && (changed = this.antecedentEdges.remove((Object)value))) {
            value.setPredicate(null);
        }
        return changed;
    }

    public void removeAllFromAntecedentEdges() {
        Iterator iter = this.iteratorOfAntecedentEdges();
        while (iter.hasNext()) {
            ImplToPredEdge tmpValue = (ImplToPredEdge)iter.next();
            this.removeFromAntecedentEdges(tmpValue);
        }
    }

    public Iterator iteratorOfAntecedentPredicates() {
        return new AntecedentPredicatesIterator();
    }

    public boolean setGeneralization(Predicate value) {
        if (this.generalization != value) {
            if (this.generalization != null) {
                Predicate oldValue = this.generalization;
                this.generalization = null;
                oldValue.removeFromSpecializations(this);
            }
            this.generalization = value;
            if (value != null) {
                this.generalization.addToSpecializations(this);
            }
            return true;
        }
        return false;
    }

    public Predicate getGeneralization() {
        return this.generalization;
    }

    public boolean addToSpecializations(Predicate value) {
        boolean changed = false;
        if (value != null) {
            if (this.specializations == null) {
                this.specializations = new FHashSet();
            }
            if (changed = this.specializations.add((Object)value)) {
                value.setGeneralization(this);
            }
        }
        return changed;
    }

    public boolean hasInSpecializations(Predicate value) {
        return this.specializations != null && value != null && this.specializations.contains((Object)value);
    }

    public Iterator iteratorOfSpecializations() {
        return this.specializations == null ? FEmptyIterator.get() : this.specializations.iterator();
    }

    public int sizeOfSpecializations() {
        return this.specializations == null ? 0 : this.specializations.size();
    }

    public boolean removeFromSpecializations(Predicate value) {
        boolean changed = false;
        if (this.specializations != null && value != null && (changed = this.specializations.remove((Object)value))) {
            value.setGeneralization(null);
        }
        return changed;
    }

    public void removeAllFromSpecializations() {
        Iterator iter = this.iteratorOfSpecializations();
        while (iter.hasNext()) {
            Predicate tmpValue = (Predicate)iter.next();
            this.removeFromSpecializations(tmpValue);
        }
    }

    public void evaluate(ASGElement incr, boolean bottomUp, boolean iterate, Implication implication, String trigger, String indent) {
        GFRNAnnotation annotation = null;
        if (InferenceEnginePreferences.get().isDebugMode()) {
            if (this.isAxiom()) {
                InferenceEngine.appendToProtocol(String.valueOf(indent) + "Axiom: '" + this.getName() + "', Parameter: '" + incr + "'\n");
            } else if (bottomUp) {
                InferenceEngine.appendToProtocol(String.valueOf(indent) + "Consequent predicate: '" + this.getName() + "', Parameter: '" + incr + "'\n");
            } else {
                InferenceEngine.appendToProtocol(String.valueOf(indent) + "Antecedent predicate: '" + this.getName() + "', Parameter: '" + incr + "'\n");
            }
        }
        if (this.isAxiom()) {
            Iterator consEdgeIter = this.iteratorOfConsequentEdges();
            while (consEdgeIter.hasNext()) {
                PredToImplEdge predToImplEdge = (PredToImplEdge)consEdgeIter.next();
                Implication consImplication = predToImplEdge.getImplication();
                consImplication.evaluate(incr, bottomUp, null, String.valueOf(indent) + "  ");
            }
        } else if (this.isAbstract()) {
            this.evaluateSpecializations(incr, bottomUp, iterate, implication, indent);
        } else {
            GFRNEngine engine = this.getGfrn().getCatalog().getFromEngines(this.getName());
            if (!engine.applicationAlreadyFailed(incr)) {
                if (bottomUp) {
                    if (incr instanceof GFRNAnnotation) {
                        trigger = incr.getName();
                    } else {
                        String className = incr.getClass().getName();
                        trigger = className.substring(className.lastIndexOf(46) + 1);
                    }
                }
                if (!this.requiresTopDownApplication()) {
                    if (InferenceEnginePreferences.get().isDebugMode()) {
                        InferenceEngine.appendToProtocol(String.valueOf(indent) + "Calling engine '" + this.getName() + "' before top down mode\n");
                    }
                    this.createStatisticRecord(engine, trigger, bottomUp, (annotation = engine.annotate(incr)) != null, this.getGfrn().hasInResults(annotation));
                }
                if (annotation == null) {
                    this.evaluateAntecedentPredicates(incr, engine, indent);
                    if (InferenceEnginePreferences.get().isDebugMode()) {
                        InferenceEngine.appendToProtocol(String.valueOf(indent) + "Calling engine '" + this.getName() + "' after top down mode\n");
                    }
                    engine.removeFromFailedApplications(incr);
                    annotation = engine.annotate(incr);
                    this.createStatisticRecord(engine, trigger, bottomUp, annotation != null, this.getGfrn().hasInResults(annotation));
                }
                if (annotation != null) {
                    boolean added = this.addResult(annotation, indent);
                    if (added) {
                        this.createFPNNodes(annotation, implication, bottomUp);
                        this.evaluateConsequentPredicates((ASGElement)annotation, indent);
                    }
                    if (iterate) {
                        do {
                            if ((annotation = engine.annotate(incr)) == null) {
                                added = false;
                                continue;
                            }
                            added = this.addResult(annotation, indent);
                            this.createStatisticRecord(engine, trigger, bottomUp, true, !added);
                            if (!added) continue;
                            this.createFPNNodes(annotation, implication, bottomUp);
                            this.evaluateConsequentPredicates((ASGElement)annotation, indent);
                        } while (added);
                    }
                } else if (InferenceEnginePreferences.get().isDebugMode()) {
                    InferenceEngine.appendToProtocol(String.valueOf(indent) + "Failure, no '" + this.getName() + "' pattern found!\n\n");
                }
                if (annotation == null && !bottomUp) {
                    this.evaluateSpecializations(incr, bottomUp, iterate, implication, indent);
                }
            } else if (InferenceEnginePreferences.get().isDebugMode()) {
                InferenceEngine.appendToProtocol(String.valueOf(indent) + "Application of " + this.getName() + " on '" + incr + "' already failed!\n\n");
            }
        }
    }

    public boolean requiresTopDownApplication() {
        if (this.requiresTopDownApplication == 0) {
            boolean result = false;
            Iterator implToPredIter = this.iteratorOfAntecedentEdges();
            while (!result && implToPredIter.hasNext()) {
                ImplToPredEdge implEdge = (ImplToPredEdge)implToPredIter.next();
                Implication impl = implEdge.getImplication();
                Iterator predToImplIter = impl.iteratorOfAntecedentEdges();
                while (!result && predToImplIter.hasNext()) {
                    PredToImplEdge edge = (PredToImplEdge)predToImplIter.next();
                    boolean bl = result = edge.isSet() || !edge.isPositive();
                }
            }
            this.requiresTopDownApplication = result ? 1 : 2;
        }
        return this.requiresTopDownApplication == 1;
    }

    private boolean addResult(GFRNAnnotation annotation, String indent) {
        boolean added = false;
        if (!this.getGfrn().hasInResults(annotation)) {
            this.getGfrn().addToResults(annotation);
            added = true;
            if (InferenceEnginePreferences.get().isDebugMode()) {
                InferenceEngine.appendToProtocol(String.valueOf(indent) + "Success, '" + annotation.getName() + "' pattern found!" + "\n");
                InferenceEngine.appendToProtocol(annotation, indent);
            }
            InferenceEngine.appendToOutput(annotation);
        } else if (InferenceEnginePreferences.get().isDebugMode()) {
            InferenceEngine.appendToProtocol(String.valueOf(indent) + "Pattern '" + this.getName() + "' already found!\n\n");
        }
        return added;
    }

    private void evaluateSpecializations(ASGElement incr, boolean bottomUp, boolean iterate, Implication implication, String indent) {
        Iterator iter = this.iteratorOfSpecializations();
        while (iter.hasNext()) {
            Predicate specialization = (Predicate)iter.next();
            specialization.evaluate(incr, bottomUp, iterate, implication, this.getName(), indent);
        }
    }

    private void evaluateAntecedentPredicates(ASGElement incr, GFRNEngine engine, String indent) {
        Iterator antEdgesIter = this.iteratorOfAntecedentEdges();
        while (antEdgesIter.hasNext()) {
            ImplToPredEdge implToPredEdge = (ImplToPredEdge)antEdgesIter.next();
            Implication antImplication = implToPredEdge.getImplication();
            antImplication.evaluate(incr, false, engine, String.valueOf(indent) + "  ");
        }
    }

    private void createFPNNodes(GFRNAnnotation annotation, Implication implication, boolean bottomUp) {
        FPN fpn = this.getGfrn().getCatalog().getFpn();
        Place consequentPlace = annotation.getPlace();
        if (consequentPlace == null) {
            consequentPlace = fpn.createPlace(0, 0);
            consequentPlace.setAnnotation(annotation);
            consequentPlace.setPredicate(this);
        }
        if (bottomUp) {
            Transition transition = null;
            Iterator annosIter = annotation.iteratorOfAntecedentAnnos();
            if (annosIter.hasNext()) {
                transition = implication.getTransition(consequentPlace);
                fpn.createEdge(transition, consequentPlace, true);
            }
            while (annosIter.hasNext()) {
                GFRNAnnotation currentAntAnno = (GFRNAnnotation)((Object)annosIter.next());
                Place currentAntPlace = currentAntAnno.getPlace();
                fpn.createEdge(currentAntPlace, transition, true);
            }
        }
    }

    public void evaluateConsequentPredicates(ASGElement incr, String indent) {
        Iterator consEdgeIter = this.iteratorOfConsequentEdges();
        while (consEdgeIter.hasNext()) {
            PredToImplEdge predToImplEdge = (PredToImplEdge)consEdgeIter.next();
            if (!predToImplEdge.isTrigger()) continue;
            Implication consImplication = predToImplEdge.getImplication();
            consImplication.evaluate(incr, true, null, String.valueOf(indent) + "  ");
        }
        Predicate generalizationPredicate = this.getGeneralization();
        if (generalizationPredicate != null) {
            if (InferenceEnginePreferences.get().isDebugMode()) {
                InferenceEngine.appendToProtocol(String.valueOf(indent) + "Evaluating consequences of generalization '" + generalizationPredicate.getName() + "'\n\n");
            }
            generalizationPredicate.evaluateConsequentPredicates(incr, indent);
        }
    }

    private void createStatisticRecord(GFRNEngine engine, String trigger, boolean bottomUp, boolean found, boolean alreadyFound) {
        StatisticRecord statisticRecord = new StatisticRecord(engine, trigger, bottomUp, found, alreadyFound);
        engine.addToStatisticRecords(statisticRecord);
    }

    public void generateXMLTag(StringBuffer xmlStream) {
        xmlStream.append("  <Predicate ");
        xmlStream.append("id=\"pred").append(this.getId()).append("\" ");
        xmlStream.append("axiom=\"").append(this.isAxiom()).append("\" ");
        xmlStream.append("abstract=\"").append(this.isAbstract()).append("\" ");
        xmlStream.append("name=\"").append(this.getName()).append("\" ");
        if (!this.isAbstract()) {
            xmlStream.append("class=\"").append(this.getClassName()).append("\" ");
        }
        if (this.getGeneralization() != null) {
            xmlStream.append("genId=\"pred").append(this.getGeneralization().getId()).append("\"");
        }
        xmlStream.append("/>\n\n");
    }

    public void removeYou() {
        this.setGfrn(null);
        this.setGeneralization(null);
        this.removeAllFromConsequentEdges();
        this.removeAllFromAntecedentEdges();
        this.removeAllFromPlaces();
        this.removeAllFromSpecializations();
    }

    public String toString() {
        String result = this.isAxiom() ? "[Axiom: " : "[Rule: ";
        result = String.valueOf(result) + this.getName() + ", rank=" + this.getRank() + "]";
        return result;
    }

    private class ConsequentPredicatesIterator
    implements Iterator {
        private Iterator consequentPredToImplEdgesIterator;
        private Iterator consequentImplToPredEdgesIterator;

        ConsequentPredicatesIterator() {
            this.consequentPredToImplEdgesIterator = Predicate.this.iteratorOfConsequentEdges();
            if (this.consequentPredToImplEdgesIterator.hasNext()) {
                PredToImplEdge edge = (PredToImplEdge)this.consequentPredToImplEdgesIterator.next();
                this.consequentImplToPredEdgesIterator = edge.getImplication().iteratorOfConsequentEdges();
            }
        }

        public boolean hasNext() {
            if (this.consequentImplToPredEdgesIterator == null) {
                return false;
            }
            if (this.consequentImplToPredEdgesIterator.hasNext()) {
                return true;
            }
            if (this.consequentPredToImplEdgesIterator.hasNext()) {
                PredToImplEdge edge = (PredToImplEdge)this.consequentPredToImplEdgesIterator.next();
                this.consequentImplToPredEdgesIterator = edge.getImplication().iteratorOfConsequentEdges();
                return this.hasNext();
            }
            return false;
        }

        public Object next() {
            if (this.consequentImplToPredEdgesIterator == null) {
                return null;
            }
            ImplToPredEdge edge = (ImplToPredEdge)this.consequentImplToPredEdgesIterator.next();
            return edge.getPredicate();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class TriggeredPredicatesIterator
    implements Iterator {
        private Iterator predToImplEdgesIterator;
        private Iterator implToPredEdgesIterator;

        TriggeredPredicatesIterator() {
            this.predToImplEdgesIterator = Predicate.this.iteratorOfConsequentEdges();
            while (this.implToPredEdgesIterator == null && this.predToImplEdgesIterator.hasNext()) {
                PredToImplEdge edge = (PredToImplEdge)this.predToImplEdgesIterator.next();
                if (!edge.isTrigger()) continue;
                this.implToPredEdgesIterator = edge.getImplication().iteratorOfConsequentEdges();
            }
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.implToPredEdgesIterator == null) {
                return false;
            }
            if (!this.implToPredEdgesIterator.hasNext()) ** GOTO lbl9
            return true;
lbl-1000:
            // 1 sources

            {
                edge = (PredToImplEdge)this.predToImplEdgesIterator.next();
                if (!edge.isTrigger()) continue;
                this.implToPredEdgesIterator = edge.getImplication().iteratorOfConsequentEdges();
                return this.hasNext();
lbl9:
                // 2 sources

                ** while (this.predToImplEdgesIterator.hasNext())
            }
lbl10:
            // 1 sources

            return false;
        }

        public Object next() {
            if (this.implToPredEdgesIterator == null) {
                return null;
            }
            ImplToPredEdge edge = (ImplToPredEdge)this.implToPredEdgesIterator.next();
            return edge.getPredicate();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class AntecedentPredicatesIterator
    implements Iterator {
        private Iterator antecedentPredToImplEdgesIterator;
        private Iterator antecedentImplToPredEdgesIterator;

        AntecedentPredicatesIterator() {
            this.antecedentImplToPredEdgesIterator = Predicate.this.iteratorOfAntecedentEdges();
            if (this.antecedentImplToPredEdgesIterator.hasNext()) {
                ImplToPredEdge edge = (ImplToPredEdge)this.antecedentImplToPredEdgesIterator.next();
                this.antecedentPredToImplEdgesIterator = edge.getImplication().iteratorOfAntecedentEdges();
            }
        }

        public boolean hasNext() {
            if (this.antecedentPredToImplEdgesIterator == null) {
                return false;
            }
            if (this.antecedentPredToImplEdgesIterator.hasNext()) {
                return true;
            }
            if (this.antecedentImplToPredEdgesIterator.hasNext()) {
                ImplToPredEdge edge = (ImplToPredEdge)this.antecedentImplToPredEdgesIterator.next();
                this.antecedentPredToImplEdgesIterator = edge.getImplication().iteratorOfAntecedentEdges();
                return this.hasNext();
            }
            return false;
        }

        public Object next() {
            if (this.antecedentPredToImplEdgesIterator == null) {
                return null;
            }
            PredToImplEdge edge = (PredToImplEdge)this.antecedentPredToImplEdgesIterator.next();
            return edge.getPredicate();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

