/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.gfrn.strategies;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.inferenceengine.IProgressDialog;
import de.upb.inferenceengine.InferenceEngine;
import de.upb.inferenceengine.RuleCatalog;
import de.upb.inferenceengine.gfrn.GFRN;
import de.upb.inferenceengine.gfrn.Predicate;
import de.upb.inferenceengine.gfrn.strategies.AbstractInferenceStrategy;
import de.upb.inferenceengine.gfrn.strategies.ContextRulePair;
import de.upb.inferenceengine.gfrn.strategies.PriorityQueue;
import de.upb.inferenceengine.gfrn.strategies.RuleRankDeterminationStrategy;
import de.upb.inferenceengine.preferences.InferenceEnginePreferences;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractIterativeStrategy
extends AbstractInferenceStrategy {
    private PriorityQueue bottomUpContainer = new PriorityQueue(true);
    private PriorityQueue topDownContainer = new PriorityQueue(false);
    private RuleRankDeterminationStrategy ruleRankDeterminationStrategy = new RuleRankDeterminationStrategy();

    public AbstractIterativeStrategy(RuleCatalog initializedRuleCatalog) {
        super(initializedRuleCatalog);
    }

    protected PriorityQueue getBottomUpContainer() {
        return this.bottomUpContainer;
    }

    protected PriorityQueue getTopDownContainer() {
        return this.topDownContainer;
    }

    protected RuleRankDeterminationStrategy getRuleRankDeterminationStrategy() {
        return this.ruleRankDeterminationStrategy;
    }

    protected void prepareInference(List axiomElements, GFRN gfrn) {
        this.clear();
        this.getRuleRankDeterminationStrategy().calculateAndSetRuleRanks(gfrn);
        int i = 0;
        while (i < axiomElements.size()) {
            ASGElement context = (ASGElement)axiomElements.get(i);
            Iterator axiomIter = gfrn.getAxiomsForType(context.getClass());
            while (axiomIter.hasNext()) {
                Predicate rule = (Predicate)axiomIter.next();
                if (InferenceEnginePreferences.get().isDebugMode()) {
                    InferenceEngine.appendToProtocol("Searching for rules that are successors of axiom " + rule.getName() + " and context " + context + ".\n");
                }
                Iterator consequentPredImpl = rule.iteratorOfConsequentPredicates();
                while (consequentPredImpl.hasNext()) {
                    Predicate level0Rule = (Predicate)consequentPredImpl.next();
                    ContextRulePair entry = new ContextRulePair(context, level0Rule);
                    if (InferenceEnginePreferences.get().isDebugMode()) {
                        InferenceEngine.appendToProtocol("Adding (" + context + ", " + level0Rule + ") to bottom-up container.\n");
                    }
                    this.getBottomUpContainer().enqueue(entry);
                }
            }
            ++i;
        }
    }

    protected void clear() {
        this.bottomUpContainer.clear();
        this.topDownContainer.clear();
        this.clearResults();
    }

    protected void runInferenceOnContextRulePair(ContextRulePair contextRulePair) {
        this.proceedBottomUp(contextRulePair);
    }

    protected abstract void proceedBottomUp(ContextRulePair var1);

    protected abstract void proceedTopDown(ContextRulePair var1);

    public void runInference(List axiomElements) {
        IProgressDialog progressDialog = InferenceEngine.get().getProgressDialog();
        GFRN gfrn = this.getRuleCatalog().getGfrn();
        if (InferenceEngine.get().isShowProgress() && progressDialog != null) {
            progressDialog.setMaximum(axiomElements.size());
        }
        this.prepareInference(axiomElements, gfrn);
        if (InferenceEnginePreferences.get().isDebugMode()) {
            InferenceEngine.appendToProtocol("\n=================================================================\n");
        }
        while (!this.getBottomUpContainer().isEmpty() && !InferenceEngine.isAborted()) {
            if (!InferenceEngine.isHalted()) {
                while (!(this.getBottomUpContainer().isEmpty() || InferenceEngine.isHalted() || InferenceEngine.isAborted())) {
                    ContextRulePair contextRulePair = this.getBottomUpContainer().dequeue();
                    if (InferenceEngine.get().isShowProgress() && progressDialog != null) {
                        progressDialog.increment();
                        progressDialog.setMaximum(progressDialog.getProgress() + this.getBottomUpContainer().getElementCount());
                    }
                    if (InferenceEnginePreferences.get().isDebugMode()) {
                        InferenceEngine.appendToProtocol("Start inference on (" + contextRulePair.getContext() + ", " + contextRulePair.getRule() + ").\n\n");
                    }
                    this.runInferenceOnContextRulePair(contextRulePair);
                }
                if (this.getBottomUpContainer().isEmpty() || !InferenceEngine.isHalted()) continue;
                InferenceEngine.get().evaluateFPN(gfrn, this.getRuleCatalog());
                UMLProject.get().refreshDisplay();
                if (!InferenceEngine.get().isShowProgress() || progressDialog == null) continue;
                progressDialog.suspended();
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

