/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.gfrn.strategies;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.inferenceengine.IProgressDialog;
import de.upb.inferenceengine.InferenceEngine;
import de.upb.inferenceengine.RuleCatalog;
import de.upb.inferenceengine.gfrn.GFRN;
import de.upb.inferenceengine.gfrn.Predicate;
import de.upb.inferenceengine.gfrn.strategies.AbstractInferenceStrategy;
import de.upb.inferenceengine.preferences.InferenceEnginePreferences;
import java.util.Iterator;
import java.util.List;

public class RecursiveStrategy
extends AbstractInferenceStrategy {
    public RecursiveStrategy(RuleCatalog initializedRuleCatalog) {
        super(initializedRuleCatalog);
    }

    public void runInference(List axiomElements) {
        IProgressDialog progressDialog = InferenceEngine.get().getProgressDialog();
        GFRN gfrn = this.getRuleCatalog().getGfrn();
        if (InferenceEngine.get().isShowProgress() && progressDialog != null) {
            progressDialog.setMaximum(axiomElements.size());
        }
        int index = 0;
        boolean done = false;
        while (!done && !InferenceEngine.isAborted()) {
            if (!InferenceEngine.isHalted()) {
                while (index < axiomElements.size() && !InferenceEngine.isHalted() && !InferenceEngine.isAborted()) {
                    ASGElement incr = (ASGElement)axiomElements.get(index);
                    if (InferenceEngine.get().isShowProgress() && progressDialog != null) {
                        progressDialog.increment();
                    }
                    Iterator axiomIter = gfrn.getAxiomsForType(incr.getClass());
                    while (axiomIter.hasNext()) {
                        Predicate predicate = (Predicate)axiomIter.next();
                        if (InferenceEnginePreferences.get().isDebugMode()) {
                            InferenceEngine.appendToProtocol("\n=================================================================\n");
                        }
                        predicate.evaluate(incr, true, false, null, null, "");
                    }
                    ++index;
                }
                if (index == axiomElements.size()) {
                    done = true;
                    continue;
                }
                if (!InferenceEngine.isHalted()) continue;
                InferenceEngine.get().evaluateFPN(gfrn, this.getRuleCatalog());
                UMLProject.get().refreshDisplay();
                if (!InferenceEngine.get().isShowProgress() || progressDialog == null) continue;
                progressDialog.suspended();
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static String getName() {
        return "Recursive strategy of Lothar Wendehals";
    }
}

