/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.gfrn.strategies;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.inferenceengine.InferenceEngine;
import de.upb.inferenceengine.RuleCatalog;
import de.upb.inferenceengine.engines.GFRNAnnotation;
import de.upb.inferenceengine.engines.GFRNEngine;
import de.upb.inferenceengine.fpn.FPN;
import de.upb.inferenceengine.fpn.Place;
import de.upb.inferenceengine.gfrn.GFRN;
import de.upb.inferenceengine.gfrn.Predicate;
import de.upb.inferenceengine.gfrn.strategies.AbstractIterativeStrategy;
import de.upb.inferenceengine.gfrn.strategies.ContextRulePair;
import de.upb.inferenceengine.gfrn.strategies.ContextRulePairList;
import de.upb.inferenceengine.gfrn.strategies.ContextRulePairSet;
import de.upb.inferenceengine.preferences.InferenceEnginePreferences;
import java.util.HashSet;
import java.util.Iterator;

public class SimpleIterativeStrategy
extends AbstractIterativeStrategy {
    private HashSet foundAnnotations = new HashSet();
    private ContextRulePairSet visitedContextRulePairs = new ContextRulePairSet();

    public SimpleIterativeStrategy(RuleCatalog initializedRuleCatalog) {
        super(initializedRuleCatalog);
    }

    protected void clear() {
        this.foundAnnotations.clear();
        this.visitedContextRulePairs.clear();
        super.clear();
    }

    private void addToVisited(ContextRulePair pair) {
        this.visitedContextRulePairs.add(pair);
    }

    private boolean hasInVisited(ContextRulePair pair) {
        return this.visitedContextRulePairs.contains(pair);
    }

    private boolean addResult(GFRNAnnotation annotation, Predicate rule) {
        this.foundAnnotations.add(annotation);
        boolean added = false;
        GFRN gfrn = this.getRuleCatalog().getGfrn();
        if (!gfrn.hasInResults(annotation)) {
            gfrn.addToResults(annotation);
            added = true;
        }
        if (added) {
            FPN fpn = gfrn.getCatalog().getFpn();
            Place consequentPlace = annotation.getPlace();
            if (consequentPlace == null) {
                consequentPlace = fpn.createPlace(0, 0);
                consequentPlace.setAnnotation(annotation);
                consequentPlace.setPredicate(rule);
            }
        }
        return added;
    }

    protected void proceedBottomUp(ContextRulePair contextRulePair) {
        if (!this.hasInVisited(contextRulePair)) {
            boolean annotationFound = false;
            GFRNEngine engine = this.getRuleCatalog().getFromEngines(contextRulePair.getRule().getName());
            if (!contextRulePair.getRule().requiresTopDownApplication()) {
                if (InferenceEnginePreferences.get().isDebugMode()) {
                    InferenceEngine.appendToProtocol("Running in bottom-up mode starting on (" + contextRulePair.getContext() + ", " + contextRulePair.getRule() + ")\n\n");
                }
                annotationFound = this.annotate(engine, contextRulePair);
            }
            if (!annotationFound) {
                this.fillTopDownContainerWithNewContextRulePairs(contextRulePair);
                while (!this.getTopDownContainer().isEmpty()) {
                    ContextRulePair pair = this.getTopDownContainer().dequeue();
                    this.proceedTopDown(pair);
                }
                engine.removeFromFailedApplications(contextRulePair.getContext());
                this.annotate(engine, contextRulePair);
            }
            this.addToVisited(contextRulePair);
        } else if (InferenceEnginePreferences.get().isDebugMode()) {
            InferenceEngine.appendToProtocol("Skipping (" + contextRulePair.getContext() + ", " + contextRulePair.getRule() + ") which has already been visited\n\n");
        }
    }

    protected void fillBottomUpContainerWithNewContextRulePairs(Predicate rule, GFRNAnnotation annotation) {
        this.addConsequentRules(rule, annotation);
        this.addGeneralizationRules(rule, annotation);
    }

    protected Iterator determineConsequentPredicates(Predicate pred) {
        return pred.iteratorOfConsequentPredicates();
    }

    private void addConsequentRules(Predicate rule, GFRNAnnotation annotation) {
        if (InferenceEnginePreferences.get().isDebugMode()) {
            InferenceEngine.appendToProtocol("Adding successors of rule '" + rule.getName() + "' to bottom-up container. BEGIN\n");
        }
        Iterator consequentPredIter = this.determineConsequentPredicates(rule);
        while (consequentPredIter.hasNext()) {
            Predicate consequentRule = (Predicate)consequentPredIter.next();
            if (consequentRule.isAbstract()) {
                this.addSpecializationRules(consequentRule, annotation);
                continue;
            }
            if (InferenceEnginePreferences.get().isDebugMode()) {
                InferenceEngine.appendToProtocol("Adding (" + (Object)((Object)annotation) + ", " + consequentRule + ") to bottom-up container.\n");
            }
            this.getBottomUpContainer().enqueue(new ContextRulePair((ASGElement)annotation, consequentRule));
        }
        if (InferenceEnginePreferences.get().isDebugMode()) {
            InferenceEngine.appendToProtocol("Adding successors of rule '" + rule.getName() + "' to bottom-up container. END\n");
        }
    }

    private void addSpecializationRules(Predicate rule, GFRNAnnotation annotation) {
        if (InferenceEnginePreferences.get().isDebugMode()) {
            InferenceEngine.appendToProtocol("Adding specializations for abstract rule " + rule + ") to bottom-up container.\n");
        }
        Iterator specializationIter = rule.iteratorOfSpecializations();
        while (specializationIter.hasNext()) {
            Predicate specialization = (Predicate)specializationIter.next();
            if (specialization.isAbstract()) {
                this.addSpecializationRules(specialization, annotation);
                continue;
            }
            if (InferenceEnginePreferences.get().isDebugMode()) {
                InferenceEngine.appendToProtocol("Adding (" + (Object)((Object)annotation) + ", " + specialization + ") to bottom-up container.\n");
            }
            this.getBottomUpContainer().enqueue(new ContextRulePair((ASGElement)annotation, specialization));
        }
    }

    private void addGeneralizationRules(Predicate rule, GFRNAnnotation annotation) {
        if (InferenceEnginePreferences.get().isDebugMode()) {
            InferenceEngine.appendToProtocol("Adding generalizations of rule '" + rule.getName() + "' to bottom-up container. BEGIN\n");
        }
        Predicate currentRule = rule;
        while (currentRule.getGeneralization() != null) {
            currentRule = currentRule.getGeneralization();
            if (InferenceEnginePreferences.get().isDebugMode()) {
                InferenceEngine.appendToProtocol("Adding (" + (Object)((Object)annotation) + ", " + currentRule + ") to bottom-up container.\n");
            }
            this.addConsequentRules(currentRule, annotation);
        }
        if (InferenceEnginePreferences.get().isDebugMode()) {
            InferenceEngine.appendToProtocol("Adding generalizations of rule '" + rule.getName() + "' to bottom-up container. END\n");
        }
    }

    protected void proceedTopDown(ContextRulePair contextRulePair) {
        if (!this.hasInVisited(contextRulePair)) {
            if (InferenceEnginePreferences.get().isDebugMode()) {
                InferenceEngine.appendToProtocol("Running in top-down mode starting on (" + contextRulePair.getContext() + ", " + contextRulePair.getRule().getName() + ")\n\n");
            }
            GFRNEngine engine = this.getRuleCatalog().getFromEngines(contextRulePair.getRule().getName());
            this.annotate(engine, contextRulePair);
            this.addToVisited(contextRulePair);
        } else if (InferenceEnginePreferences.get().isDebugMode()) {
            InferenceEngine.appendToProtocol("Skipping (" + contextRulePair.getContext() + ", " + contextRulePair.getRule() + ") which has already been visited\n\n");
        }
    }

    private boolean annotate(GFRNEngine engine, ContextRulePair contextRulePair) {
        boolean result = false;
        boolean added = false;
        GFRNAnnotation annotation = null;
        do {
            added = false;
            annotation = engine.annotate(contextRulePair.getContext());
            if (annotation == null) {
                if (!InferenceEnginePreferences.get().isDebugMode()) continue;
                InferenceEngine.appendToProtocol("No annotation found for (" + contextRulePair.getContext() + ", " + contextRulePair.getRule() + ")\n\n");
                continue;
            }
            if (!this.foundAnnotations.contains((Object)annotation)) {
                if (InferenceEnginePreferences.get().isDebugMode()) {
                    InferenceEngine.appendToProtocol("Success! Annotation '" + annotation.getName() + "' found for (" + contextRulePair.getContext() + ", " + contextRulePair.getRule() + ")\n");
                    InferenceEngine.appendToProtocol(annotation, "");
                }
                InferenceEngine.appendToOutput(annotation);
                result = true;
                this.fillBottomUpContainerWithNewContextRulePairs(contextRulePair.getRule(), annotation);
                added = this.addResult(annotation, contextRulePair.getRule());
                continue;
            }
            if (InferenceEnginePreferences.get().isDebugMode()) {
                InferenceEngine.appendToProtocol("Annotation '" + annotation.getName() + "' already found for (" + contextRulePair.getContext() + ", " + contextRulePair.getRule() + ")\n\n");
            }
            result = true;
        } while (added);
        return result;
    }

    protected void fillTopDownContainerWithNewContextRulePairs(ContextRulePair contextRulePair) {
        ContextRulePairList contextRulePairQueue = new ContextRulePairList();
        contextRulePairQueue.add(contextRulePair);
        this.addPredeccessorRules(contextRulePairQueue);
    }

    private void addPredeccessorRules(ContextRulePairList contextRulePairQueue) {
        while (!contextRulePairQueue.isEmpty()) {
            ContextRulePair contextRulePair = contextRulePairQueue.getFirst();
            contextRulePairQueue.remove(contextRulePair);
            GFRNEngine engine = this.getRuleCatalog().getFromEngines(contextRulePair.getRule().getName());
            if (InferenceEnginePreferences.get().isDebugMode()) {
                InferenceEngine.appendToProtocol("Adding context rule pairs for predeccessors of (" + contextRulePair.getContext() + ", " + contextRulePair.getRule() + ") BEGIN\n");
            }
            Iterator antecedentPredIter = contextRulePair.getRule().iteratorOfAntecedentPredicates();
            while (antecedentPredIter.hasNext()) {
                Predicate antecedentRule = (Predicate)antecedentPredIter.next();
                this.addAllPossibleContextRulePairsToTopDownContainer(engine, contextRulePairQueue, antecedentRule, contextRulePair.getContext());
                this.addAllSpecializationContextRulePairs(engine, contextRulePairQueue, antecedentRule, contextRulePair.getContext());
            }
            if (!InferenceEnginePreferences.get().isDebugMode()) continue;
            InferenceEngine.appendToProtocol("Adding context rule pairs for predeccessors of (" + contextRulePair.getContext() + ", " + contextRulePair.getRule() + ") END\n\n");
        }
    }

    private void addAllSpecializationContextRulePairs(GFRNEngine engine, ContextRulePairList contextRulePairQueue, Predicate rule, ASGElement context) {
        Iterator specializationsIter = rule.iteratorOfSpecializations();
        while (specializationsIter.hasNext()) {
            Predicate specialization = (Predicate)specializationsIter.next();
            if (InferenceEnginePreferences.get().isDebugMode()) {
                InferenceEngine.appendToProtocol("Adding context rule pairs for specialization of '" + rule.getName() + "': '" + specialization.getName() + "' BEGIN\n");
            }
            this.addAllPossibleContextRulePairsToTopDownContainer(engine, contextRulePairQueue, specialization, context);
            this.addAllSpecializationContextRulePairs(engine, contextRulePairQueue, specialization, context);
            if (!InferenceEnginePreferences.get().isDebugMode()) continue;
            InferenceEngine.appendToProtocol("Adding context rule pairs for specialization of '" + rule.getName() + "': '" + specialization.getName() + "' END\n");
        }
    }

    private void addAllPossibleContextRulePairsToTopDownContainer(GFRNEngine engine, ContextRulePairList contextRulePairQueue, Predicate rule, ASGElement context) {
        if (!rule.isAxiom() && !rule.isAbstract()) {
            Iterator iter = engine.getTrigger(context, rule.getName());
            while (iter.hasNext()) {
                ASGElement contextCandidate = (ASGElement)iter.next();
                ContextRulePair pair = new ContextRulePair(contextCandidate, rule);
                if (this.hasInVisited(pair) || this.getTopDownContainer().contains(pair)) continue;
                if (InferenceEnginePreferences.get().isDebugMode()) {
                    InferenceEngine.appendToProtocol("Pushing (" + pair.getContext() + ", " + pair.getRule().getName() + ") onto the top-down container.\n");
                }
                this.getTopDownContainer().enqueue(pair);
                contextRulePairQueue.add(pair);
            }
        }
    }

    public static String getName() {
        return "Iterative strategy";
    }
}

