/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.preferences;

import de.uni_paderborn.fujaba.preferences.AbstractPreferences;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;
import de.upb.inferenceengine.InferenceEngine;
import de.upb.inferenceengine.RuleCatalog;
import de.upb.inferenceengine.engines.GFRNEngine;
import de.upb.inferenceengine.gfrn.strategies.RecursiveStrategy;
import de.upb.inferenceengine.gfrn.strategies.SimpleIterativeStrategy;
import de.upb.inferenceengine.gfrn.strategies.TriggerBasedIterativeStrategy;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;

public class InferenceEnginePreferences
extends AbstractPreferences {
    public static final String PROPERTY_KEY = "de/upb/inferenceengine/InferenceEngine.properties";
    public static final String PROPERTY_NAME = "InferenceEngine.";
    public static final String SHOW_ALL_ANNO = "ShowAllAnnotations";
    public static final String HIDE_ALL_ANNO = "HideAllAnnotations";
    public static final String SHOW_SEL_ANNO = "ShowSelAnnotations";
    public static final String SHOW_BELIEF_VALUE = "ShowBeliefValue.";
    public static final String ANNOTATION_VISIBLE = "AnnotationVisible.";
    public static final String DEBUG_MODE = "DebugMode.";
    public static final String SHOW_CLASSIFICATION = "ShowClassification.";
    private static final String FTT_STRATEGY = "FTTStrategy";
    public static final String INFERENCE_STRATEGY = "InferenceStrategy";
    private static final String CATALOGS_FOLDER = "CatalogsFolder";
    private static final boolean DEF_SHOW_ALL_ANNO = true;
    private static final boolean DEF_HIDE_ALL_ANNO = false;
    private static final boolean DEF_SHOW_SEL_ANNO = false;
    private static final int DEF_SHOW_BELIEF_VALUE = 50;
    private static final boolean DEF_ANNOTATION_VISIBLE = true;
    public static final boolean DEF_DEBUG_MODE = false;
    private static final boolean DEF_SHOW_CLASSIFICATION = true;
    private static final int DEF_FTT_STRATEGY = 0;
    public static final String DEF_INFERENCE_STRATEGY;
    public static final Class[] INFERENCE_STRATEGIES;
    public static final String[] INFERENCE_STRATEGY_NAMES;
    private static final String DEF_CATALOGS_FOLDER;
    private static InferenceEnginePreferences options;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.upb.inferenceengine.gfrn.strategies.SimpleIterativeStrategy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DEF_INFERENCE_STRATEGY = clazz.getName();
        Class[] classArray = new Class[3];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("de.upb.inferenceengine.gfrn.strategies.RecursiveStrategy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("de.upb.inferenceengine.gfrn.strategies.SimpleIterativeStrategy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz3;
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("de.upb.inferenceengine.gfrn.strategies.TriggerBasedIterativeStrategy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz4;
        INFERENCE_STRATEGIES = classArray;
        INFERENCE_STRATEGY_NAMES = new String[]{RecursiveStrategy.getName(), SimpleIterativeStrategy.getName(), TriggerBasedIterativeStrategy.getName()};
        DEF_CATALOGS_FOLDER = String.valueOf(System.getProperty("user.dir")) + File.separator + "plugins" + File.separator + "InferenceEngine" + File.separator + "catalogs";
    }

    private InferenceEnginePreferences() {
    }

    public static synchronized InferenceEnginePreferences get() {
        if (options == null) {
            options = new InferenceEnginePreferences();
        }
        return options;
    }

    public void setDefaults() {
        PreferencesProperties options = PreferencesProperties.get((String)PROPERTY_KEY);
        options.putSetting("InferenceEngine.ShowAllAnnotations", true);
        options.putSetting("InferenceEngine.HideAllAnnotations", false);
        options.putSetting("InferenceEngine.FTTStrategy", 0);
        options.putSetting("InferenceEngine.InferenceStrategy", DEF_INFERENCE_STRATEGY);
        options.putSetting("InferenceEngine.CatalogsFolder", DEF_CATALOGS_FOLDER);
        Iterator catalogIter = InferenceEngine.get().iteratorOfCatalogs();
        while (catalogIter.hasNext()) {
            RuleCatalog ruleCatalog = (RuleCatalog)catalogIter.next();
            Iterator engineIter = ruleCatalog.iteratorOfEngines();
            while (engineIter.hasNext()) {
                GFRNEngine gfrnEngine = (GFRNEngine)engineIter.next();
                String key = gfrnEngine.getUniqueName();
                options.putSetting("InferenceEngine.AnnotationVisible." + key, true);
                options.putSetting("InferenceEngine.ShowBeliefValue." + key, 50);
            }
        }
    }

    public void setShowAllAnnotations(boolean showAllAnnotations) {
        PreferencesProperties options = PreferencesProperties.get((String)PROPERTY_KEY);
        if (options.getBoolSetting("InferenceEngine.ShowAllAnnotations", true) != showAllAnnotations) {
            options.putSetting("InferenceEngine.ShowAllAnnotations", showAllAnnotations);
            this.setModified(true);
        }
    }

    public boolean isShowAllAnnotations() {
        return PreferencesProperties.get((String)PROPERTY_KEY).getBoolSetting("InferenceEngine.ShowAllAnnotations", true);
    }

    public void setHideAllAnnotations(boolean hideAllAnnotations) {
        PreferencesProperties options = PreferencesProperties.get((String)PROPERTY_KEY);
        if (options.getBoolSetting("InferenceEngine.HideAllAnnotations", false) != hideAllAnnotations) {
            options.putSetting("InferenceEngine.HideAllAnnotations", hideAllAnnotations);
            this.setModified(true);
        }
    }

    public boolean isHideAllAnnotations() {
        return PreferencesProperties.get((String)PROPERTY_KEY).getBoolSetting("InferenceEngine.HideAllAnnotations", false);
    }

    public void setShowSelAnnotations(boolean showSelAnnotations) {
        PreferencesProperties options = PreferencesProperties.get((String)PROPERTY_KEY);
        if (options.getBoolSetting("InferenceEngine.ShowSelAnnotations", false) != showSelAnnotations) {
            options.putSetting("InferenceEngine.ShowSelAnnotations", showSelAnnotations);
            this.setModified(true);
        }
    }

    public boolean isShowSelAnnotations() {
        return PreferencesProperties.get((String)PROPERTY_KEY).getBoolSetting("InferenceEngine.ShowSelAnnotations", false);
    }

    public void setShowBeliefValue(String key, int newBeliefValue) {
        PreferencesProperties options = PreferencesProperties.get((String)PROPERTY_KEY);
        try {
            int value = options.getIntSetting("InferenceEngine.ShowBeliefValue." + key, 50);
            if (value != newBeliefValue) {
                options.putSetting("InferenceEngine.ShowBeliefValue." + key, newBeliefValue);
                this.setModified(true);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getShowBeliefValue(String key) {
        int showBeliefValue;
        try {
            showBeliefValue = PreferencesProperties.get((String)PROPERTY_KEY).getIntSetting("InferenceEngine.ShowBeliefValue." + key, 50);
        }
        catch (NumberFormatException e) {
            showBeliefValue = 50;
        }
        return showBeliefValue;
    }

    public void setCatalogsFolder(String catalogsFolder) {
        PreferencesProperties options = PreferencesProperties.get((String)PROPERTY_KEY);
        if (options.getSetting("InferenceEngine.CatalogsFolder", DEF_CATALOGS_FOLDER) != catalogsFolder) {
            options.putSetting("InferenceEngine.CatalogsFolder", catalogsFolder);
            this.setModified(true);
        }
    }

    public String getCatalogsFolder() {
        return PreferencesProperties.get((String)PROPERTY_KEY).getSetting("InferenceEngine.CatalogsFolder", DEF_CATALOGS_FOLDER);
    }

    public void setAnnotationVisible(String key, boolean show) {
        PreferencesProperties options = PreferencesProperties.get((String)PROPERTY_KEY);
        if (options.getBoolSetting("InferenceEngine.AnnotationVisible." + key, true) != show) {
            options.putSetting("InferenceEngine.AnnotationVisible." + key, show);
            this.setModified(true);
        }
    }

    public boolean isAnnotationVisible(String key) {
        return PreferencesProperties.get((String)PROPERTY_KEY).getBoolSetting("InferenceEngine.AnnotationVisible." + key, true);
    }

    public boolean isDebugMode() {
        return PreferencesProperties.get((String)PROPERTY_KEY).getBoolSetting("InferenceEngine.DebugMode.", false);
    }

    public void setDebugMode(boolean debugMode) {
        PreferencesProperties options = PreferencesProperties.get((String)PROPERTY_KEY);
        if (options.getBoolSetting("InferenceEngine.DebugMode.", false) != debugMode) {
            options.putSetting("InferenceEngine.DebugMode.", debugMode);
            this.setModified(true);
        }
    }

    public boolean isShowClassification() {
        return PreferencesProperties.get((String)PROPERTY_KEY).getBoolSetting("InferenceEngine.ShowClassification.", true);
    }

    public void setShowClassification(boolean showClassification) {
        PreferencesProperties options = PreferencesProperties.get((String)PROPERTY_KEY);
        if (options.getBoolSetting("InferenceEngine.ShowClassification.", true) != showClassification) {
            options.putSetting("InferenceEngine.ShowClassification.", showClassification);
            this.setModified(true);
        }
    }

    public void setFTTStrategy(int value) {
        PreferencesProperties options = PreferencesProperties.get((String)PROPERTY_KEY);
        try {
            int number = options.getIntSetting("InferenceEngine.FTTStrategy", 0);
            if (number != value) {
                options.putSetting("InferenceEngine.FTTStrategy", value);
                this.setModified(true);
            }
        }
        catch (NumberFormatException e) {
            options.putSetting("InferenceEngine.FTTStrategy", value);
            this.setModified(true);
        }
    }

    public int getFTTStrategy() {
        int number;
        try {
            number = PreferencesProperties.get((String)PROPERTY_KEY).getIntSetting("InferenceEngine.FTTStrategy", 0);
        }
        catch (NumberFormatException e) {
            number = 0;
        }
        return number;
    }

    public void setInferenceStrategy(Class inferenceStrategyClass) {
        this.setInferenceStrategy(inferenceStrategyClass.getName());
    }

    public void setInferenceStrategy(String inferenceStrategyName) {
        PreferencesProperties options = PreferencesProperties.get((String)PROPERTY_KEY);
        String strategy = options.getSetting("InferenceEngine.InferenceStrategy", DEF_INFERENCE_STRATEGY);
        if (!strategy.equals(inferenceStrategyName)) {
            options.putSetting("InferenceEngine.InferenceStrategy", inferenceStrategyName);
            this.setModified(true);
        }
    }

    public Class getInferenceStrategy() {
        Class strategy;
        PreferencesProperties options = PreferencesProperties.get((String)PROPERTY_KEY);
        String strategyName = options.getSetting("InferenceEngine.InferenceStrategy", DEF_INFERENCE_STRATEGY);
        try {
            strategy = Class.forName(strategyName);
        }
        catch (ClassNotFoundException e) {
            strategy = INFERENCE_STRATEGIES[0];
        }
        return strategy;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PreferencesProperties.get((String)PROPERTY_KEY).addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PreferencesProperties.get((String)PROPERTY_KEY).removePropertyChangeListener(propertyName, listener);
    }
}

